<?php
/*
Plugin Name: Cryout Featured Image in Post (Classic)
Plugin URI: #
Description: This plugin force-adds the posts' featured images inside the post (between title/meta and content).
Version: 0.1
Author: Cryout Creations
Author URI: http://www.cryoutcreations.eu/
License: GPLv3
*/

final class CryoutFeaturedImageinPostClassic {

	function __construct(){
		
		// Hook necessary CSS
		add_action( 'wp_head', array( $this, 'inline_css' ), 11 );
		
		// Hook output functionality in the theme's hook
		add_action( 'cryout_before_content_hook', array( $this, 'do_the_deed' ), 11 ); // before title
		//add_action( 'cryout_post_title_hook', array( $this, 'do_the_deed' ), 11 ); // after title, works only for posts

	} // __construct()

	// Frontend output
	function do_the_deed() {
		
		// Don't waste cpu cycles if no featured iamge is set
		if ( ! has_post_thumbnail() ) return; 
		
		// remove link from featured image if set - function name is dinamically generated based on theme slug
		remove_filter( 'post_thumbnail_html', get_template() . '_thumbnail_link', 10, 2 );

		?>
		<div class="custom-featured-in-post-classic">
			<?php the_post_thumbnail( 'full' ); ?>
			<div style="clear: both;"></div>
		</div>
		<?php

	} // do_the_deed()
	
	// Frontend CSS
	function inline_css() { ?>
		<style type="text/css" id="custom-featured-in-post-classic">
			.custom-featured-in-post-classic { max-width: 100%; line-height: 1; }
			.custom-featured-in-post-classic img { max-width: 100%; height: auto; }
		</style> 
		<?php
	}

} // class CryoutFeaturedImageinPostClassic

new CryoutFeaturedImageinPostClassic;

// FIN