<?php
/*
Plugin Name: Cryout Featured Image in Post
Plugin URI: #
Description: This plugin force-adds the posts' featured images inside the post (between title/meta and content).
Version: 0.1
Author: Cryout Creations
Author URI: http://www.cryoutcreations.eu/
License: GPLv3
*/

final class CryoutFeaturedImageinPost {

	function __construct(){
		
		// Hook output functionality in the theme's hook
		add_action( 'cryout_singular_before_inner_hook', array( $this, 'do_the_deed' ) ); 

	} // __construct()

	// Frontend output
	function do_the_deed() {
		
		// Don't waste cpu cycles if no featured iamge is set
		if ( ! has_post_thumbnail() ) return; 

		?>
		<div class="custom-featured-in-post">
			<?php the_post_thumbnail( 'full' ); ?>
			<div style="clear: both;"></div>
		</div>
		<?php

	} // do_the_deed()

} // class CryoutFeaturedImageinPost

new CryoutFeaturedImageinPost;

// FIN