<?php
/*
Plugin Name: Cryout Custom Featured Image Info
Plugin URI: #none
Description: This plugin displays the image's library information in the header image location
Version: 0.1
Author: Cryout Creations
Author URI: http://www.cryoutcreations.eu/
License: GPLv3
*/

final class CryoutCustomFeaturedImageInfo {
	
	// configure theme slug (used in options retrieval and hook identifiers)
	var $theme_slug = 'anima'; 
	
	// configure which attributes to display
	var $config = array(
		'caption' => true,
		'description' => true,
		'title' => false,
	);
	
	// ! remember to apply the custom styling on the site !

	public function __construct(){

		// Hook the output into the theme's header hook
		add_action( 'cryout_headerimage_hook', array( $this, 'header_output' ), 11 );

	} // __construct()
	
	function header_output() {
		$image = $this->header_image_data();
		if ( is_front_page() && function_exists( 'the_custom_header_markup' ) && has_header_video() ) {
			// skip if video is displayed
		} elseif ( ! empty( $image ) ) { 
				// we have a header image, let's display info 
				?>
				<div class="featured-image-description">
					<?php if ( $this->config['title'] ) { ?> <span class="title"><?php echo $image['title'] ?> </span> <?php } ?>
					<?php if ( $this->config['caption'] ) { ?> <span class="caption"><?php echo $image['caption'] ?> </span> <?php } ?>
					<?php if ( $this->config['description'] ) { ?> <span class="description"><?php echo $image['description'] ?> </span> <?php } ?>
				</div>
		<?php }
	} // header_output()
	
	// this function is a derivate of the theme's header_image_url() function which also returns additional information
	function header_image_data() {
		global $post;
		
		$featured_image = cryout_get_option( $this->theme_slug . '_fheader' );
		
		if ( is_singular() && has_post_thumbnail( $post->ID ) && $featured_image && ( $image_id = get_post_thumbnail_id( $post->ID ) ) ) {
			
				$attachment = get_post($image_id);
				return array(
					//'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
					'caption' => $attachment->post_excerpt,
					'description' => $attachment->post_content,
					//'href' => get_permalink($attachment->ID),
					//'src' => $attachment->guid,
					'title' => $attachment->post_title
				);
				
		};

		// failsafe
		return false;
	} //header_image_data()


} // class CryoutCustomFeaturedImageInfo

new CryoutCustomFeaturedImageInfo;

// FIN