<?php
/*
Plugin Name: Cryout First Image Debug
Plugin URI: #none-yet
Description: This plugin adds a meta box with debug information about the first post/page associated media file. 
Version: 0.1
Author: Cryout Creations
Author URI: http://www.cryoutcreations.eu/
License: none
*/

final class CryoutFirstImageDebug {

	public function __construct(){

		// Hook meta boxes into 'add_meta_boxes'
		add_action( 'add_meta_boxes', array( $this, 'meta_add' ) );

	} // __construct()

	// Appearance meta init
	function meta_add( $post ) {
		global $wp_meta_boxes;

		// add appearance meta to posts & pages
		add_meta_box(
			'cryout_first_image_debug_meta',
			__( 'Attached Image Debug Info', 'cryout' ),
			array( $this, 'meta_form' ),
			array( 'page', 'post' ),
			'normal',
			'default'
		);

	} // meta_add()

	// Appearance meta HTML
	function meta_form( $post ) {

		// get attached image info
		$args = array(
			'numberposts' 	=> 6,
			'orderby'		=> 'ID',
			'order'			=> 'ASC',
			'post_mime_type'=> 'image',
			'post_parent' 	=> get_the_ID(),
			'post_status'	=> 'any',
			'post_type'		=> 'any'
		);

		$attachments = get_children( $args );
		//var_dump($attachments);
		
		?>
		<div id="cryout-image-debug" class="">
		<?php

		if ($attachments) {
			foreach($attachments as $attachment) {
				$image_attributes = wp_get_attachment_image_src( $attachment->ID, 'thumbnail' );
				$image_attributes['id'] = $attachment->ID;
				$image_attributes['title'] = $attachment->post_title;
				//var_dump($image_attributes);
				?>	
				<div style="width: 32%; margin-right: 1%; float: left;">
					<p>Post ID: <?php echo $image_attributes['id'] ?><br>
					Title: <?php echo $image_attributes['title'] ?><br>
					<img src="<?php echo $image_attributes[0] ?>"> </p>
				</div>
				<?php 
			}
		} else { ?>
			<p>No attachments found.</p>
		<?php } ?>
		<div style="clear: both;"></div>
		</div>
		<?php

	} // meta_form()

} // class CryoutFirstImageDebug

new CryoutFirstImageDebug;

// FIN