<?php
/*
Plugin Name: Cryout Readonly Commments
Plugin URI: #none
Description: This plugin blocks the submission of comments. It is useful on demo sites where the comment form is desired to remain available while comments should not be accepted to prevent spam. 
Version: 0.1
Author: Cryout Creations
Author URI: http://www.cryoutcreations.eu/
License: GPLv3
*/

final class CryoutReadonlyComments {
	
	public function __construct(){
		
		// main action hook
		add_action( 'pre_comment_approved', array( $this, 'pre_comment_on_post' ), 99 );
		
	} // __construct()
	
	public function pre_comment_on_post( $comment_id ) {
		
		return new WP_Error( 'comments_readonly', __( 'Sorry, comments are not accepted on this site at this time.', 'cryout-readonly-comments' ), 409 );
		
	} // pre_comment_on_post()	

} // class CryoutReadonlyComments

new CryoutReadonlyComments;

// FIN