<?php

/**
 * Returns a link to the current site 
 * No attributes 
 */

function cryout_shortcodes_site_link_fn() {
	if (isset($attr['text'])) $text = $attr['text'];
	                     else $text = get_bloginfo('name'); 
    return '<a class="site-link" href="'.esc_url( home_url() ) .'" title="'.esc_attr(get_bloginfo('name')).'" rel="home">'.$text.'</a>';
}
/**
 * Returns current user information
 * Example of use:
 * [cryout-author display='attr'] where attr can be author / description / login / first-name / last-name / nickname / id / url / link / aim / yim / posts / posts-url
 * Attributes:
 * "display" - optional
 */
function cryout_shortcodes_the_author_fn($attr) {
    $id = get_the_author_meta('ID');
    if ($id) {
	    if (isset($attr['display'])) {
		    $display = $attr['display'];
		    switch ($display) {
		        case 'author':
		            return get_the_author();
		        case 'description':
		            return get_the_author_meta('description', $id);
		        case 'login':
		            return get_the_author_meta('user_login', $id);
		        case 'first-name':
		            return get_the_author_meta('first_name', $id);
		        case 'last-name':
		            return get_the_author_meta('last_name', $id);
		        case 'nickname':
		            return get_the_author_meta('nickname', $id);
		        case 'id':
		            return $id;
		        case 'url':
		            return get_the_author_meta('user_url', $id);
		        case 'email':
		            return get_the_author_meta('user_email', $id);
		        case 'link':
		            if (get_the_author_meta('user_url', $id)) {
		                return '<a href="'.get_the_author_meta('user_url', $id).'" title="'.esc_attr(get_the_author()).'" rel="external">'.get_the_author().'</a>';
		            }
		            else {
		                return get_the_author();
		            }
		        case 'aim':
		            return get_the_author_meta('aim', $id);
		        case 'yim':
		            return get_the_author_meta('yim', $id);
		        case 'posts':
		            return get_the_author_posts();
		        case 'posts-url':
		            return get_author_posts_url(get_the_author_meta('ID'));
		    }
		    
	    }
        else {
            return get_the_author();
        }
    }
}


/**
 * Echos a tag could
 * Example of use:
 * [cryout-tag-cloud min=10 max=15 number=5] where min and max are the minimum and the maximum font sizes and count is the number of tags to show in the cloud
 * Attributes:
 * "min" - optional
 * "max" - optional
 * "count" - optional
 */
function cryout_shortcodes_tag_cloud_fn($attr) {
	if (isset($attr['min'])) $attr['min'] = (int)$attr['min'];
	if (isset($attr['max'])) $attr['max'] = (int)$attr['max'];
	if (isset($attr['count'])) $attr['count'] = (int)$attr['count'];
	$attr['echo'] = false;
	return wp_tag_cloud($attr);
}

