/**
 * Adding buttons to the the mce menu for the main shortcodes
 * @package cryout-shortcodes
 * 
 */
function cryout_shortcode_default(param) {
   if ( param != '' ) return param
                 else return 'Text';
} 
 
(function() {  
	// Load plugin specific language pack
	//tinymce.PluginManager.requireLangPack('cryoutshortcodes');

	tinymce.create('tinymce.plugins.cryoutshortcodes', {  
		init : function(ed, url) {  
					
			ed.addButton('button-light', {  
				title : ed.getLang('cryoutshortcodes.buttonlighttitle', 'Add a light button'),  
				image : url+'/buttons/button-light.png',  
				onclick : function() {  
					 ed.selection.setContent('[cryout-button-light url="#"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-button-light]');  
				}  
			});
			
			ed.addButton('button-dark', {  
				title : ed.getLang('cryoutshortcodes.buttondarktitle', 'Add a dark button'),  
				image : url+'/buttons/button-dark.png',  
				onclick : function() {  
					 ed.selection.setContent('[cryout-button-dark url="#"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-button-dark]');  
				}  
			});
			
			ed.addButton('button-color', {  
				title : ed.getLang('cryoutshortcodes.buttoncolortitle', 'Add a color button'),  
				image : url+'/buttons/button-color.png',  
				onclick : function() {  
					 ed.selection.setContent('[cryout-button-color url="#" color="#47AFFF"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-button-color]');  
				}  
			});
			
			ed.addButton('pullquote', {  
				title : ed.getLang('cryoutshortcodes.pullquotetitle', 'Add a pullquote'), 
				image : url + '/buttons/pullquote.png',
				onclick : function() {  
					 ed.selection.setContent('[cryout-pullquote align="left|center|right" textalign="left|center|right" width="33%"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-pullquote]');  
				}  
			});
			
						ed.addButton('multi-column', {  
				title : ed.getLang('cryoutshortcodes.multicolumntitle', 'Add multiple columns'), 
				image : url + '/buttons/multi-column.png',
				onclick : function() {  
					 ed.selection.setContent('[cryout-multi][cryout-column width="1/4"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-column][cryout-column width="1/2"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-column][cryout-column width="1/4"]' + cryout_shortcode_default(ed.selection.getContent()) + '[/cryout-column][/cryout-multi]');  
				}  
			});
			
		},  
		createControl : function(n, cm) {  
			return null;  
		},  
	});  
	tinymce.PluginManager.add('cryoutshortcodes', tinymce.plugins.cryoutshortcodes);  
})();