<?php

/**
 * Pullquotes
 * Uses [cryout-pullquote] to create pullquotes
 * Attributes:
 * "align" - optional - alignment of the pullquote itself - values: left / center /right
 * "width" - optional - whatever you want it to be in percenatage (ex:50%)
 * "textalign" - optional - alignment of text inside the pullquote - values: left / center / right
 * Example of use:
 * [cryout-pullquote align="right" width="40%" textalign="center"] Look at this beautiful text right here [/cryout-pullquote]
  */

function cryout_shortcodes_pullquote_fn( $atts, $content = NULL, $code = '' ) {
	if ( ! $content ) return;
	
	$style = array();
	
	$class = array( 'pullquote', 'cryout-pullquote', 'align' => 'alignleft' );
	
	if ( $atts ) {
		if ( array_key_exists( 'align', $atts ) ) {
			if ( in_array( $atts['align'], array( 'left', 'center', 'right' ) ) )
				$class['align'] = 'align' . $atts['align'];
			if ( $atts['align'] == 'center' ) $style['text-align'] = 'center';
		}
		
		if ( array_key_exists( 'width', $atts ) ) {
			if ( $atts['width'] ) $style['width'] = trim( $atts['width'] );
		}
		
		if ( array_key_exists( 'textalign', $atts ) ) {
			if ( in_array( $atts['textalign'], array( 'left', 'center', 'right' ) ) )
				$style['text-align'] = $atts['textalign'];
		}
	}
	
	$style_attr = '';
	if ( $style ) {
		foreach ( $style as $prop => $val ) {
			$style_attr .= $prop . ':' . $val . ';';
		}
		if ( $style_attr ) $style_attr = ' style="' . $style_attr . '"';
	}
	
	$attr = 'class="' . implode( ' ', $class ) . '"' . $style_attr;
	
    return '<div ' . $attr . '>' . wpautop( do_shortcode( $content ) ) . '</div>';
}
