<?php
ob_start();
class Cryout_Shortcodes_Settings {

	public static function initialize() {
		add_action( 'admin_menu', array( __CLASS__, 'register_menu_page' ) );
		add_filter( 'plugin_action_links_' . plugin_basename(__FILE__) , array( __CLASS__, 'settings_link' ) );
	}


	public static function register_menu_page() {

		/* add_menu_page(
			'Cryout Shortcodes',
			'Cryout Shortcodes',
			'options-general.php',
			'cryout-shortcodes',
			array(
				__CLASS__,
				'settings_page',
			),
			'dashicons-awards',
			'80.0215'
		); */
		
		add_submenu_page(
			'themes.php', 
			'Cryout Shortcodes', 
			'Cryout Shortcodes', 
			'manage_options', 
			'cryout-shortcodes',
			array(
				__CLASS__,
				'settings_page'
			)
			);

	}
	
	public static function settings_link($links) { 
		$settings_link = '<a href="themes.php?page=cryout-shortcodes">Settings</a>'; 
		array_unshift($links, $settings_link); 
		return $links; 
	}

	public static function settings_page() {

		$cryout_shortcodes_options = get_option( 'cryout_shortcodes_options' ); 
		$shortcode_compat = isset( $cryout_shortcodes_options['shortcode_compat'] ) ? $cryout_shortcodes_options['shortcode_compat'] : Cryout_Shortcodes_Core::get_default('shortcode_compat');

		// call to save the setting options
		self::save_options();
		?>
		<style>
			input[type='text'], textarea, select {
				width: 600px;
			}
		</style>
		<div class="wrap">

		<div id="icon-options-general" class="icon32"></div>
		<h2>Cryout Shortcodes</h2>

		<p></p>

		<?php
		if ( isset( $_GET['settings-updated'] ) && ( $_GET['settings-updated'] ) ) {
			echo '<div id="message" class="updated"><p><strong>Settings saved. </strong></p></div>';
		}
		?>
		<div id="poststuff">

		<div id="post-body" class="metabox-holder columns-2">

		<!-- main content -->
		<div id="post-body-content">

		<div class="meta-box-sortables ui-sortable">

		<form method="post">

		<div class="postbox">

			<div title="Click to toggle" class="handlediv"><br></div>
			<h3 class="hndle"><span><?php _e( 'Options', 'cryout-shortcodes' ); ?></span></h3>

			<div class="inside">
				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="shortcode_compat"><?php _e( 'Enable compatibility for Mantra', 'cryout-shortcodes' ); ?></label>
						</th>
						<td>
						   
							<select id="theme" name="cryout_shortcodes_options[shortcode_compat]">
								<option value="no" <?php selected( 'no', $shortcode_compat ); ?>>Disabled</option>
								<option value="yes" <?php selected( 'yes', $shortcode_compat ); ?>>Enabled</option>
							</select>							

							<p class="description">
								<?php _e( 'Enable the deprecated <strong>[mantra-...]</strong> shortcode calls. Activate only if you are using the Mantra theme and are still using the old shortcodes.', 'cryout-shortcodes' ); ?>

							</p>
						</td>
					</tr>
				</table>
				<p>
					<?php wp_nonce_field( 'Cryout_Shortcodes_settings' ); ?>
					<input class="button-primary" type="submit" name="settings_submit"
					       value="Save Settings">
				</p>
			</div>
		</div>

		<div class="postbox">

			<div class="handlediv"><br></div>
			<h3 class="hndle"><span><?php _e( 'Available Shortcodes', 'cryout-shortcodes' ); ?></span>
			</h3>

			<div class="inside">
				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="theme"><?php _e( 'Buttons', 'cryout-shortcodes' ); ?></label></th>
						<td><code>[cryout-button-light url="#" target="_blank"] Light Button [/cryout-button-light]</code><br><br>
							<code>[cryout-button-dark url="http://www.google.com/" target="_self"] Dark Button [/cryout-button-dark]</code><br><br>
							<code>[cryout-button-color url="category/some-post-or-page" color="#aabbcc"] Color Button [/cryout-button-color]</code></br><br>

							<p class="description">
								<?php _e( 'The <strong>target</strong> attribute is optional and defaults to "<em>_blank</em>". The <strong>color</strong> atribute is only valid on the color button.', 'cryout-shortcodes' ); ?>
							</p>
						</td>
					</tr>
				</table>

				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="theme"><?php _e( 'Pullquote', 'cryout-shortcodes' ); ?></label>
						</th>
						<td><code>[cryout-pullquote align="left|center|right" textalign="left|center|right" width="33%"]<br>
							Quote text<br>[/cryout-pullquote]</code><br><br>
							<p class="description">
								<?php _e( 'Insert a pull-quote into content.', 'cryout-shortcodes' ); ?>
							</p>
						</td>
					</tr>
				</table>
				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="message"><?php _e( 'Columns', 'cryout-shortcodes' ); ?></label>
						</th>
						<td><code>[cryout-multi]<br>
						[cryout-column width="1/2"] One Half [/cryout-column]<br>
						[cryout-column width="1/3"] One Third [/cryout-column]<br>
						[cryout-column width="1/4"] One Quarter [/cryout-column]<br>
						[cryout-column width="1/6"] One Sixth [/cryout-column]<br>
						[cryout-column width="2/3"] Two Thirds [/cryout-column]<br>
						[cryout-column width="3/4"] Three Quarters [/cryout-column]<br>
						[cryout-column width="5/6"] Five Sixths [/cryout-column]<br>
						[/cryout-multi]</code>

							<p class="description">
								<?php _e( 'You must keep the total on one column-multi under or equal to a whole, otherwise the columns will not fit. For example, mixing 2/3 with 1/2 exceeds 1 (7/6 > 6/6).', 'cryout-shortcodes' ); ?><br><br>
								<?php _e( 'One thing to remember is that you should try to avoid leaving spaces / breaks outside column contents (WordPress will convert these to new lines and mess up the column content layouts). You can have as many newlines inside the column content as you want, but do not leave any space between <strong>[/cryout-multi][cryout-multi]</strong> and <strong>[/cryout-column][cryout-column...]</strong>', 'cryout-shortcodes' ); ?>
							</p>
						</td>
					</tr>
				</table>
				
				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="theme"><?php _e( 'Site Link', 'cryout-shortcodes' ); ?></label>
						</th>
						<td><code>[cryout-site text="Link to homepage"]</code><br><br>
							<p class="description">
								<?php _e( 'Insert text linking to the homepage. The "text" parameter is optional and defaults to site title when empty.', 'cryout-shortcodes' ); ?>
							</p>
						</td>
					</tr>
				</table>

				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="theme"><?php _e( 'Author Information', 'cryout-shortcodes' ); ?></label>
						</th>
						<td><code>[cryout-author display="author|description|login|first-name|last-name|nickname|<br>id|url|email|link|aim|yim|posts|posts-url"]</code><br><br>
							<p class="description">
								<?php _e( 'The "display" parameter is optional and defaults to "author" (name).', 'cryout-shortcodes' ); ?>
							</p>
						</td>
					</tr>
				</table>		
				<table class="form-table">
					<tr>
						<th scope="row"><label
								for="theme"><?php _e( 'Tag Cloud', 'cryout-shortcodes' ); ?></label>
						</th>
						<td><code>[cryout-tag-cloud]</code><br><br>
							<p class="description">
								<?php _e( 'Insert a tag cloud into the content.', 'cryout-shortcodes' ); ?>
							</p>
						</td>
					</tr>
				</table>					
			</div>
		</div>
		</form>
		</div>
		</div>
		<div id="postbox-container-1" class="postbox-container">

			<div class="meta-box-sortables">

				<div class="postbox">
					<div class="handlediv"><br></div>
					<h3 class="hndle" style="text-align: center;">
						<span><strong>Cryout Shortcodes</strong></span>
					</h3>

					<div class="inside">
						<div style="text-align: center; margin: auto">
							<strong>version: <?php echo CRYOUT_SHORTCODES_VERSION; ?></strong><br>
							by Cryout Creations<br>
							<a href="http://www.cryoutcreations.eu/" target="_blank">www.cryoutcreations.eu</a>
						</div>
					</div>
				</div>

				<div class="postbox">
					<div class="handlediv"><br></div>
					<h3 class="hndle" style="text-align: center;">
						<span><?php _e( 'Support', 'cryout-shortcodes' ); ?></span>
					</h3><div class="inside">
						<div style="text-align: center; margin: auto">
							For support questions,<br>
							please use <a href="http://www.cryoutcreations.eu/forum" target="_blank">our forums</a>. 
						</div>
					</div>
				</div>
			</div>
		</div>
		</div>
		<br class="clear">
		</div>
		</div>
	<?php
	}


	public static function save_options() {
		if ( isset( $_POST['settings_submit'] ) && check_admin_referer( 'Cryout_Shortcodes_settings', '_wpnonce' ) ) {

			$saved_options = $_POST['cryout_shortcodes_options'];
			
			foreach ($saved_options as $option => $value):
				$saved_options[$option] = wp_kses_data($value);
			endforeach;

			update_option( 'cryout_shortcodes_options', $saved_options );

			wp_redirect( '?page=cryout-shortcodes&settings-updated=true' );
		}
	}
}