<?php


class Cryout_Shortcodes_Core {

	static protected $shortcode_compat;
	
	static protected $plugin_options;
	
	static protected $default_options = array(
			'shortcode_compat' => 'no',
			);
			
	public static function initialize() {

		self::$plugin_options = get_option( 'cryout_shortcodes_options', self::$default_options );
		//self::$shortcode_compat = self::$plugin_options['shortcode_compat'];
		
		add_action( 'plugins_loaded', array( __CLASS__, 'load_plugin_textdomain' ) );
		
		if ( is_admin() ):
			// admin side of things
			add_action( 'init', array( __CLASS__, 'editor_buttons' ) );
		
		endif;		
		if (! is_admin() ):
		
			// stuff that goes on the frontend
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'shortcodes_style' ) );
			
			// enable [cryout-... shortcodes] 
			add_shortcode( 'cryout-multi', 'cryout_shortcodes_multi_column_fn' );
			add_shortcode( 'cryout-column', 'cryout_shortcodes_column_fn' );
			add_shortcode( 'cryout-pullquote', 'cryout_shortcodes_pullquote_fn' );
			add_shortcode( 'cryout-button-light', 'cryout_shortcodes_button_light_fn' );
			add_shortcode( 'cryout-button-dark', 'cryout_shortcodes_button_dark_fn' );
			add_shortcode( 'cryout-button-color', 'cryout_shortcodes_button_color_fn' );
			add_shortcode( 'cryout-site', 'cryout_shortcodes_site_link_fn' ); 
			add_shortcode( 'cryout-author', 'cryout_shortcodes_the_author_fn' );
			add_shortcode( 'cryout-tag-cloud', 'cryout_shortcodes_tag_cloud_fn' );
			
			// initialize if login is activated
			if ( ( isset( self::$plugin_options['shortcode_compat'] ) && self::$plugin_options['shortcode_compat'] == 'yes' ) ) {

				// enable deprecated [mantra-...] shortcodes too
				add_shortcode( 'mantra-multi', 'cryout_shortcodes_multi_column_fn' );
				add_shortcode( 'mantra-column', 'cryout_shortcodes_column_fn' );
				add_shortcode( 'mantra-pullquote', 'cryout_shortcodes_pullquote_fn' );
				add_shortcode( 'mantra-button-light', 'cryout_shortcodes_button_light_fn' );
				add_shortcode( 'mantra-button-dark', 'cryout_shortcodes_button_dark_fn' );
				add_shortcode( 'mantra-button-color', 'cryout_shortcodes_button_color_fn' );
				add_shortcode( 'mantra-site', 'cryout_shortcodes_site_link_fn' ); 
				add_shortcode( 'mantra-author', 'cryout_shortcodes_the_author_fn' );
				add_shortcode( 'mantra-tag-cloud', 'cryout_shortcodes_tag_cloud_fn' );
				
			}
			
		endif;
		
	}

	public static function load_plugin_textdomain() {
		load_plugin_textdomain( 'cryout-shortcodes', false, basename( dirname( __FILE__ ) ) . '/languages/' );
	}
	
	public static function shortcodes_style() {
		wp_register_style( 'cryout-shortcodes', plugin_dir_url( __FILE__ ) . 'css/shortcodes.css' );
		wp_enqueue_style( 'cryout-shortcodes' );
	}
	
	public static function get_default($index) {
		$defaults = self::$default_options;
		return $defaults[$index]; 
	}

	public static function on_activation() {
		//global $current_user;
		/* if ( ! current_user_can( 'activate_plugins' ) ) {
			return;
		} */
		$plugin = isset( $_REQUEST['plugin'] ) ? $_REQUEST['plugin'] : '';
		check_admin_referer( "activate-plugin_{$plugin}" );

		add_option( 'cryout_shortcodes_options', self::$default_options );
	}

	public static function on_uninstall() {
		//global $current_user;
		/* if ( ! current_user_can( 'activate_plugins' ) ) {
			return;
		} */

		delete_option( 'cryout_shortcodes_options' );
	}
	
	public static function editor_buttons() {
		//global $current_user;
		//if ( current_user_can( 'edit_posts' ) &&  current_user_can( 'edit_pages' ) ) {	
			add_filter( 'mce_external_plugins', array( __CLASS__, 'editor_buttons_add_plugin' ) );  
			add_filter( 'mce_buttons_2', array( __CLASS__, 'editor_buttons_add_button' ) );  
	   //}	
	}
	
	public static function editor_buttons_add_button( $buttons ){
		array_push( $buttons, "separator", "button-light", "button-dark", "button-color", "separator", "pullquote", "separator", "multi-column");
		return $buttons;
	}
	
	public static function editor_buttons_add_plugin( $plugin_array ){
		$plugin_array['cryoutshortcodes'] = plugin_dir_url(__FILE__) . 'js/tinymce.js';
		return $plugin_array; 
	}
}