<?php
/*
Plugin Name: Cryout Shortcodes
Plugin URI: https://www.cryoutcreations.eu/cryout-shortcodes
Description: Compatibility shortcodes for Cryout Creations themes
Version: 0.5.2
Author: Cryout Creations
Author URI: https://www.cryoutcreations.eu/
License: GPL3
# Text Domain: cryout-shortcodes
# Domain Path: /languages
*/

define('CRYOUT_SHORTCODES_VERSION', '0.5.2');

require_once plugin_dir_path( __FILE__ ) . 'core.php';
require_once plugin_dir_path( __FILE__ ) . 'settings.php';
include_once plugin_dir_path( __FILE__ ) . 'includes/buttons.php';
include_once plugin_dir_path( __FILE__ ) . 'includes/columns.php';
include_once plugin_dir_path( __FILE__ ) . 'includes/pullquote.php';
include_once plugin_dir_path( __FILE__ ) . 'includes/extras.php'; 

function cryout_shortcodes_init() {
	
	register_activation_hook( __FILE__, array( 'Cryout_Shortcodes_Core', 'on_activation' ) );
	register_uninstall_hook( __FILE__, array( 'Cryout_Shortcodes_Core', 'on_uninstall' ) );
	
	Cryout_Shortcodes_Core::initialize();
	Cryout_Shortcodes_Settings::initialize();
	
} // cryout_shortcodes_init()
add_action( 'plugins_loaded', 'cryout_shortcodes_init' );

// FIN
