<?php

/**
 * Buttons
 * Uses [cryout-button-light], [cryout-button-dark] and [cryout-button-color] to create buttons.
 * Attributes:
 * "url" - optional - the link the button will send you to.
 * "color" - optional - only for the color button. The hexadecimal value of the color you need.
 * Example of use:
 * [cryout-button-light url="http://www.website.tld"] More info [/cryout-button-light]
 * Or:
 * [cryout-button-color url="http://www.website.tld" color="32F43A"] Color info [/cryout-button-color]
  */

function cryout_shortcodes_button_light_fn($attr ,$content) {
	if (!isset($attr['url']))  $attr['url'] = '#';
	if (!isset($attr['target'])) $attr['target'] = "_blank";
	 return '<a class="short-button-light" target="'.$attr['target'].'" href="'.$attr['url'].'" title="'.$content.'" >'.$content.'</a>';
}

function cryout_shortcodes_button_dark_fn($attr ,$content) {
	if (!isset($attr['url']))  $attr['url'] = '#';
	if (!isset($attr['target'])) $attr['target'] = "_blank";
	 return '<a class="short-button-dark" target="'.$attr['target'].'" href="'.$attr['url'].'" title="'.$content.'" >'.$content.'</a>';
}

function cryout_shortcodes_button_color_fn($attr ,$content) {
	if (!isset($attr['url']))  $attr['url'] = '#';
	if (!isset($attr['target'])) $attr['target'] = "_blank";
	$style="";
	if (isset($attr["color"])) { $style=' style="background-color:'.$attr["color"].'"'; }
	 return '<a class="short-button-color" target="'.$attr['target'].'"'.$style.' href="'.$attr['url'].'" title="'.$content.'" >'.$content.'</a>';
}