<?php

/**
 * Creates the container for multi-column content, corresponding to the short code [cryout-multic].
 * No attributes are used. Should always be used to incapsulate [cryout-column] tags
 * No attributes
 */
function cryout_shortcodes_multi_column_fn($attr, $content = null) {
	$content = do_shortcode($content);
	return "<div class='multi-colum'>".$content."</div>";
}

/**
 * Multiple columns
 * Uses [cryout-column] to create multiple columns
 * It should be used inside [cryout-multic] short codes.
 * Attributes:
 * "width" - can take values 1, 1/2, 1/3, 1/4, 1/6, 1/8, 2/3, 3/4, 5/6  The default value is 1.
 * "class" - optional - can be whatever you like for furter CSS editing
 * Example of use
  * [cryout-multi]
 *      [cryout-column width='1/2']This is a  half column[/cryout-column]
 *      [cryout-column width='1/2']This is another  half column[/cryout-column]
 * [/cryout-multi]
 * Or:
 * [cryout-multi]
 *      [cryout-column width='1/3']This is a one third column[/cryout-column]
 *      [cryout-column width='2/3']This is a two thirds column[/cryout-column]
 * [/cryout-multi]
 * Or:
 * [cryout-multi]
 *      [cryout-column width='1/4']This is a quarter column[/cryout-column]
 *      [cryout-column width='1/2']This is a half column [/cryout-column]
 *      [cryout-column width='1/4']And this is another quarter column[/cryout-column]
 * [/cryout-multi]
 * Make sure the widths do not go over 100% ( ex: 1/4 + 1/2 + 1/4 = 1 = 100%)
 *

 */
function cryout_shortcodes_column_fn($attr, $content = null) {
	$content = do_shortcode($content);
	$width = isset($attr['width']) ? $attr['width'] : "1";
	$class = isset($attr['class']) ? $attr['class'] : "";
	$main_class = "column-1";
	switch ($width) {

		case "1/2":
			$main_class = "column-12";
			break;
			
		case "1/3":
			$main_class = "column-13";
			break;			
			
		case "1/4":
			$main_class = "column-14";
			break;			
			
		case "1/6":
			$main_class = "column-16";
			break;

		case "2/3":
			$main_class = "column-23";
			break;

		case "3/4":
			$main_class = "column-34";
			break;
			
		case "5/6":
			$main_class = "column-56";
			break;

		case "1":
		default:
			$main_class = "column-1";
			break;
	}
	return "<div class='short-columns $main_class $class'>".$content."</div>";
}

?>