<?php
/*
Plugin Name: Cryout SysInfo
Plugin URI: http://www.cryoutcreations.eu/
Description: Provides a quick and simple way of gathering system information necessary for debugging and testing.
Author: Cryout Creations
Author URI: http://www.cryoutcreations.eu/
Version: 0.5.1
License: GPL v3 - http://www.gnu.org/licenses/gpl-3.0.html
*/

class Cryout_SysInfo {

	private $version = '0.5.1';
	private $the_page = NULL;
	private $page_url = 'tools.php?page=cryout-sysinfo';

	function __construct(){		
		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'actions_links' ), -10 );
		add_filter( 'plugin_row_meta', array( $this, 'meta_links' ), 10, 2 );
		add_action( 'admin_menu', array( $this, 'register_menu_page' ) );

		add_action( 'admin_enqueue_scripts', array($this, 'styling') );
		//add_action( 'admin_enqueue_scripts', array($this, 'scripting') );
	} // __construct()
	
	/**
	 * Register the plugin's menu page.
	 */
	public function register_menu_page() {
		$this->the_page = add_submenu_page( 
			'tools.php', 
			__('Cryout SysInfo', 'cryout-sysinfo'), 
			__('Cryout SysInfo', 'cryout-sysinfo'), 
			'manage_options', 
			'cryout-sysinfo', 
			array( &$this, 'main_page' ) 
		);
	} // register_menu_page()

	/**
	 * Plugin Page
	 */
	public function main_page() {
	?>
	<div class="wrap" id="cryout-plugin-page">
		<h2><?php _e( 'Cryout System Info', 'cryout-sysinfo' ) ?></h2>
					
		<div id="poststuff">
		<div id="post-body" class="metabox-holder columns-2">
			<div id="post-body-content">
			
				<div class="postbox">
					<div class="inner">
						<h3><?php _e( 'Debug Information', 'cryout-sysinfo' ); ?></h3>
						<p><?php _e( 'You can include this debug information when creating a support request or posting to the support forums.' , 'cryout-sysinfo' ) ?></p>
						
						<textarea readonly="readonly" onclick="this.focus();" id="cryout-sysinfo" name="cryout-sysinfo" title="" rows="20"><?php $this->sys_info() ?></textarea>
					</div> 
				</div>			
						
			</div> <!-- post-body-content-->

			<div id="postbox-container-1" class="postbox-container">

						<div class="meta-box-sortables">

							<div class="postbox">
								<h3 style="text-align: center;" class="hndle">
									<span><strong><?php _e( 'Cryout SysInfo', 'cryout-sysinfo') ?></strong></span>
								</h3>

								<div class="inside">
									<div style="text-align: center; margin: auto">
										<strong><?php printf( __('version: %s','cryout-sysinfo'), $this->version ); ?></strong><br>
										<?php _e('by','cryout-sysinfo') ?> Cryout Creations<br>
										<a target="_blank" href="http://www.cryoutcreations.eu/cryout-sysinfo/">www.cryoutcreations.eu</a>
									</div>
								</div>
							</div>

							<div class="postbox">
								<h3 style="text-align: center;" class="hndle">
									<span><?php _e('Support','cryout-serious-slider') ?></span>
								</h3><div class="inside">
									<div style="text-align: center; margin: auto">
										<?php printf ( '%1$s <a target="_blank" href="http://www.cryoutcreations.eu/forum">%2$s</a>.',
											__('For support questions please use', 'cryout-serious-slider'),
											__('our forum', 'cryout-serious-slider')
											);
										?>
									</div>
								</div>
							</div>
							
						</div>
			</div> <!-- postbox-container -->

		</div> <!-- post-body -->
		<br class="clear">
		</div> <!-- poststuff -->

	</div><!--end wrap-->
	
	<?php
	} // main_page()

	/**
	 * Action Links
	 */
	public function actions_links( $links ) {
		array_unshift( $links, '<a href="' . $this->page_url . '">' . __( 'View SysInfo', 'cryout-sysinfo' ) . '</a>' );
		return $links;
	} // actions_links()

	/**
	 * Meta Links
	 */
	public function meta_links( $links, $file ) {
		// Check plugin
		if ( $file === plugin_basename( __FILE__ ) ) {
			unset( $links[2] );
			$links[] = '<a href="http://www.cryoutcreations.eu/cryout-sysinfo" target="_blank">' . __( 'Plugin homepage', 'cryout-serious-slider' ) . '</a>';
			$links[] = '<a href="https://www.cryoutcreations.eu/forums/f/wordpress/plugins/" target="_blank">' . __( 'Support forum', 'cryout-serious-slider' ) . '</a>';
			//$links[] = '<a href="http://wordpress.org/plugins/cryout-sysinfo/#developers" target="_blank">' . __( 'Changelog', 'cryout-serious-slider' ) . '</a>';
		}
		return $links;
	} // meta_links()

	/**
	 * Main sysinfo gathering block
	 */
	function sys_info( $echo=true ) { 
		ob_start();
		?>General Information
-------------------
Website URL            : <?php echo site_url() . "\n"; ?>
Home URL               : <?php echo home_url() . "\n"; ?>
Multisite              : <?php echo ( is_multisite() ? 'Yes' : 'No' ) . "\n" ?> <?php $theme = wp_get_theme(); ?>

Theme                  : <?php printf( '%1$s v%2$s', $theme->get('Name'), $theme->get('Version') ); echo "\n"; ?>
<?php if ( $theme->parent() ) { $parent_theme = $theme->parent(); ?>
Parent Theme           : <?php printf( '%1$s v%2$s', $parent_theme->get('Name'), $parent_theme->get('Version') ); echo "\n" ?><?php }; ?>
WordPress              : <?php echo get_bloginfo( 'version' ) . "\n"; ?>
Language               : <?php echo get_bloginfo( 'language' ) . (is_RTL() ? ' (RTL)' : '') . "\n" ; ?>
<?php //jQuery                 : jQuery not detected ?>
Permalinks             : <?php echo ( (get_option( 'permalink_structure' ) ) ? get_option( 'permalink_structure' ) : '-default-' ) . "\n"; ?>
WP_DEBUG               : <?php echo defined( 'WP_DEBUG' ) ? WP_DEBUG ? 'On' . "\n" : 'Off' . "\n" : 'Undefined' . "\n" ?>

Show On Front          : <?php echo get_option( 'show_on_front' ) . "\n" ?>
Page On Front          : <?php $id = get_option( 'page_on_front' ); echo ( (get_the_title( $id )) ? get_the_title( $id ) . ' ID=' . $id : '-none-' ) . "\n" ?>
Page For Posts         : <?php $id = get_option( 'page_for_posts' ); echo ( (get_the_title( $id )) ? get_the_title( $id ) . ' ID=' . $id : '-none-' ) . "\n" ?>

PHP                    : <?php echo PHP_VERSION . "\n"; ?>
MySQL                  : <?php 
		if (function_exists('mysqli_get_server_info')) {	
			// php 5.5+ or 7+
			global $wpdb;
			$info = @mysqli_get_server_info( $wpdb->dbh );
		} elseif (function_exists('mysql_get_server_info')) {
			// php <= 5.4
			$mysql_info = @mysql_get_server_info();
		};
		if (empty($mysql_info)) {
			// unknown
			echo "Information could not be retrieved";
		} else { 
			echo $mysql_info;
		};
		echo "\n"; ?>
Server                 : <?php echo $_SERVER['SERVER_SOFTWARE'] . "\n"; ?>

WordPress Memory Limit : <?php echo WP_MEMORY_LIMIT; echo "\n"; ?>
PHP Safe Mode          : <?php echo @ini_get( 'safe_mode' ) ? "Yes" : "No\n"; ?>
PHP Memory Limit       : <?php echo @ini_get( 'memory_limit' ) . "\n"; ?>
PHP Upload Max Size    : <?php echo @ini_get( 'upload_max_filesize' ) . "\n"; ?>
PHP Post Max Size      : <?php echo @ini_get( 'post_max_size' ) . "\n"; ?>
PHP Time Limit         : <?php echo @ini_get( 'max_execution_time' ) . "\n"; ?>
PHP Max Input Vars     : <?php echo @ini_get( 'max_input_vars' ) . "\n"; ?>
PHP Allow URL FOpen    : <?php echo @ini_get( 'allow_url_fopen' ) ? "Yes\n" : "No\n"; ?>

Registered Image Sizes
----------------------
<?php
		global $_wp_additional_image_sizes;

		$sizes = array();
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
		$maxlen = 1;

		// Create the full array with sizes and crop info
		foreach( $get_intermediate_image_sizes as $_size ) {

				if ( in_array( $_size, array( 'thumbnail', 'medium', 'large' ) ) ) {

						$sizes[ $_size ]['width'] = get_option( $_size . '_size_w' );
						$sizes[ $_size ]['height'] = get_option( $_size . '_size_h' );
						$sizes[ $_size ]['crop'] = (bool) get_option( $_size . '_crop' );
				} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {

						if (strlen($_size)>$maxlen) $maxlen=strlen($_size);
						$sizes[ $_size ] = array( 
								'width' => $_wp_additional_image_sizes[ $_size ]['width'],
								'height' => $_wp_additional_image_sizes[ $_size ]['height'],
								'crop' =>  $_wp_additional_image_sizes[ $_size ]['crop']
						);
				}
		}
		
		foreach ($sizes as $name => $val) { 
			$name = str_pad( $name, $maxlen, ' ', STR_PAD_RIGHT );
			$width = str_pad( $val['width'], 6, ' ', STR_PAD_BOTH );
			$height = str_pad( $val['height'], 6, ' ', STR_PAD_BOTH );
			$crop = (is_array($val['crop']) ? implode(' ',$val['crop']) : (($val['crop'] === true)?'auto':'no crop') );
		printf('%1$s : %2$sx%3$s (%4$s)'."\n", $name, $width, $height, $crop);
} ?>

Currently active plugins
------------------------
<?php
		$plugins = get_plugins();
		$active_plugins = get_option( 'active_plugins', array() );

		foreach ( $plugins as $plugin_path => $plugin ) {
		  // If the plugin isn't active, don't show it.
		  if ( ! in_array( $plugin_path, $active_plugins ) )
			continue;

		  echo str_pad( $plugin['Name'], 22, ' ', STR_PAD_RIGHT ) . ' : ' . $plugin['Version'] ."\n";
		}

		if ( is_multisite() ) :
		$plugins = wp_get_active_network_plugins();
		$active_plugins = get_site_option( 'active_sitewide_plugins', array() );

		foreach ( $plugins as $plugin_path ) {
		  $plugin_base = plugin_basename( $plugin_path );

		  // If the plugin isn't active, don't show it.
		  if ( ! array_key_exists( $plugin_base, $active_plugins ) )
			continue;

		  $plugin = get_plugin_data( $plugin_path );

		  echo $plugin['Name'] . ' :' . $plugin['Version'] . " (multisite)\n";
		}

		endif;
	?>

-----------eof----------<?php
		$output = ob_get_contents();
		ob_end_clean();
		if ($echo) echo $output; else return $output;
	} // sys_info()

	
	/**
	 * Load CSS for the plugin.
	 */
	function styling( $hook ) {
		if ( ($hook != $this->the_page) || ! current_user_can( 'manage_options' ) ) { return; }

		$plugin_url = trailingslashit( plugin_dir_url( __FILE__ ) );

		wp_enqueue_style( 'cryout-sysinfo', $plugin_url . 'resources/style.css', 'screen', $this->version );
	} // styling()

	
	/**
	 * Load JavaScript for the plugin.
	 */
	function scripting( $hook ) {
		if ( ($hook != $this->the_page) || ! current_user_can( 'manage_options' ) ) { return; }

		$plugin_url = trailingslashit( plugin_dir_url( __FILE__ ) );

		wp_enqueue_script( 'cryout-sysinfo', $plugin_url . 'resources/code.js', array( 'jquery' ), $this->version );
	} // scripting()

} // class Cryout_ThemeSwitch

function cryout_sysinfo_init(){
	new Cryout_SysInfo;
}
if (is_admin()) {
	add_action( 'init', 'cryout_sysinfo_init' );
}

// FIN
