<?php
/**
 * The Sidebar that is normally displayed on the right side (Secondary).
 *
 * @package Anima
 */
?>

<aside id="secondary" class="widget-area sidey" role="complementary" <?php cryout_schema_microdata( 'sidebar' );?>>
	<?php cryout_before_secondary_widgets_hook(); ?>

	<?php if ( is_active_sidebar( 'widget-area-right' ) ):
				dynamic_sidebar( 'widget-area-right' );
		  else: ?>

			<section class="widget-container widget-placeholder">
				<h3 class="widget-title"><?php _e( 'Right Sidebar', 'anima' ); ?></h3>
				<p>
					<?php
						if ( current_user_can( 'edit_theme_options' ) ) {
							printf( __( 'You currently have no widgets set in the left sidebar. You can add widgets via the <a href="%s" target="_blank">Dashboard</a>.', 'anima' ), esc_url( admin_url() . "widgets.php" ) ); echo "<br/>";
							printf( __( 'To hide this sidebar, switch to a different Layout via the <a href="%s" target="_blank">Theme Customizations</a>.', 'anima' ), esc_url( admin_url() . "customize.php" ) );
						}
					?>
				</p>
			</section>

	<?php endif; ?>

	<?php cryout_after_primary_widgets_hook(); ?>
</aside>
