<?php
/**
 * Functions file - Calls all other required files
 *
 * PLEASE DO NOT EDIT ANY THEME FILES
 * unless you are prepared to lose all changes on the next update
 *
 * @package Anima
 */

// variables for theme identification - do NOT edit unless you know what you are doing
define ( "_CRYOUT_THEME_NAME", "anima" );
define ( "_CRYOUT_THEME_VERSION", "1.2.2" );

// requirements
if (!defined('_CRYOUT_THEME_REQUIRED_PHP')) define('_CRYOUT_THEME_REQUIRED_PHP', '5.3');
if (!defined('_CRYOUT_THEME_REQUIRED_WP')) define('_CRYOUT_THEME_REQUIRED_WP', '4.1');

// Check if minimum supported PHP version is used
if ( FALSE !== phpversion() && version_compare( phpversion(), _CRYOUT_THEME_REQUIRED_PHP, '<' ) ) {
	require get_template_directory() . '/cryout/back-compat-php.php';
}

// Check if minimum supported WordPress version is used
elseif ( version_compare( $GLOBALS['wp_version'], _CRYOUT_THEME_REQUIRED_WP, '<' ) ) {
	require get_template_directory() . '/cryout/back-compat.php';
} 
	
require_once( get_template_directory() . "/cryout/framework.php" );		// Framework
require_once( get_template_directory() . "/admin/defaults.php" );		// Options Defaults
require_once( get_template_directory() . "/admin/main.php" );			// Admin side

// Frontend side
require_once( get_template_directory() . "/includes/setup.php" );       // Setup and init theme
require_once( get_template_directory() . "/includes/styles.php" );      // Register and enqeue css styles and scripts
require_once( get_template_directory() . "/includes/loop.php" );        // Loop functions
require_once( get_template_directory() . "/includes/comments.php" );    // Comment functions
require_once( get_template_directory() . "/includes/core.php" );        // Core functions
require_once( get_template_directory() . "/includes/hooks.php" );       // Hooks
require_once( get_template_directory() . "/includes/meta.php" );        // Custom Post Metas
require_once( get_template_directory() . "/includes/landing-page.php" );// Landing Page outputs

// FIN