<?php
/**
 * Customizer settings and other theme related settings (fonts arrays, widget areas)
 *
 * @package Bravada
 */

/* active_callback for controls that depend on other controls' values */
function bravada_conditionals( $control ) {

	$conditionals = array(
		array(
			'id'	=> 'theme_lpsliderimage',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidertitle',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidertext',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta1text',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta1link',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta2text',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta2link',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidershortcode',
			'parent'=> 'theme_lpslider',
			'value'	=> 2,
		),
		array(
			'id'	=> 'theme_lpsliderserious',
			'parent'=> 'theme_lpslider',
			'value' => 4,
		),
		array(
			'id'	=> 'theme_lpposts',
			'parent'=> 'theme_landingpage',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpposts_more',
			'parent'=> 'theme_lpposts',
			'value'	=> 1,
		),
		array(
			'id'    => 'theme_lppostslayout',
			'parent'=> 'theme_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'theme_lppostscount',
			'parent'=> 'theme_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'theme_lppostscat',
			'parent'=> 'theme_lpposts',
			'value' => 1,
		),

	);

	foreach ($conditionals as $elem) {
		if ( $control->id == sprintf( '%1$s_settings[%2$s]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), $elem['id'] ) && $control->manager->get_setting( sprintf( '%1$s_settings[%2$s]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), $elem['parent'] ) )->value() == $elem['value'] ) return true;
	};

	if ( ($control->id == sprintf( '%1$s_settings[%2$s_landingpage_notice]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) ) && ('posts' == get_option('show_on_front')) ) return true;

    return false;

} // bravada_conditionals()

$bravada_big = array(

/************* general info ***************/

'info_sections' => array(
	'cryoutspecial-about-theme' => array(
		'title' => apply_filters( 'cryout_about_theme_name', sprintf( __( 'About %s', 'cryout' ), cryout_sanitize_tnl(_CRYOUT_THEME_NAME) ) ),
		'desc' => '<img src=" ' . get_template_directory_uri() . '/admin/images/logo-about-header.png" ><br>',
		'button' => TRUE,
		'button_label' => __( 'Get Plus', 'cryout' ),
	),
), // info_sections

'info_settings' => array(
	'plus_link' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_plus_link', sprintf( '<a class="customizer-plus-link" href="https://www.cryoutcreations.eu/wordpress-themes/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Upgrade to PLUS', 'cryout' ) ) ),
		'desc' =>  apply_filters( 'cryout_about_theme_plus_desc', sprintf( __('Find out what features you\'re missing out on and how the Plus version of %1$s can improve your site.', 'cryout'), cryout_sanitize_tnl( _CRYOUT_THEME_NAME ) ) . '<br><br><img src=" ' . get_template_directory_uri() . '/admin/images/features.png" >' ),
		'section' => 'cryoutspecial-about-theme',
	),
	'support_link_faqs' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_docs_link', sprintf( '<a href="https://www.cryoutcreations.eu/wordpress-themes/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Read the Docs', 'cryout' ) ) ),
		'desc' =>  '',
		'section' => 'cryoutspecial-about-theme',
	),
	'support_link_forum' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_forum_link', sprintf( '<a href="https://www.cryoutcreations.eu/forums/f/wordpress/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Browse the Forum', 'cryout' ) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
/*	'premium_support_link' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_support_link', sprintf( '<a href="https://www.cryoutcreations.eu/priority-support" target="_blank">%s</a>', __( 'Priority Support', 'cryout' ) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),*/
	'rating_url' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_review_link', sprintf( '<a href="https://wordpress.org/support/view/theme-reviews/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '#postform" target="_blank">%s</a>', sprintf( __( 'Rate %s on WordPress.org', 'cryout' ) , cryout_sanitize_tnl(_CRYOUT_THEME_NAME) ) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
	'management' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_manage_link', sprintf( '<a href="themes.php?page=about-' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '-theme">%s</a>', __('Manage Theme Settings', 'cryout') ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
), // info_settings

'panel_overrides' => array(
	'background' => array(
        'title' => __( 'Background', 'cryout' ),
		'desc' => __( 'Background Settings.', 'cryout' ),
		'priority' => 50,
		'section' => 'cryoutoverride-theme_siteidentity',
		'replaces' => 'background_image',
		'type' => 'section',
	),
	'theme_header_section' => array(
		'title' => __( 'Header Image', 'cryout' ),
		'desc' => __( 'Header Image Settings.', 'cryout' ),
		'priority' => 50,
		'section' => 'cryoutoverride-theme_siteidentity',
		'replaces' => 'header_image',
		'type' => 'section',
	),
	'identity' => array(
		'title' => __( 'Site Identity', 'cryout' ),
		'desc' => '',
		'priority' => 50,
		'section' => 'cryoutoverride-theme_siteidentity',
		'replaces' => 'title_tagline',
		'type' => 'section',
	),
	'colors' => array(
		'section' => 'section',
		'replaces' => 'colors',
		'type' => 'remove',
	),

), // panel_overrides

/************* panels *************/

'panels' => array(

	array('id'=>'theme_siteidentity', 'title'=>__('Site Identity','bravada'), 'callback'=>'', 'identifier'=>'cryoutoverride-' ),
	array('id'=>'theme_layout_section', 'title'=>__('Layout','bravada'), 'callback'=>'' ),
	array('id'=>'theme_header_section', 'title'=>__('Header','bravada'), 'callback'=>'' ),
	array('id'=>'theme_landingpage', 'title'=>__('Landing Page','bravada'), 'callback'=>'' ),
	array('id'=>'theme_general_section', 'title'=>__('General','bravada') , 'callback'=>'' ),
	array('id'=>'theme_colors_section', 'title'=>__('Colors','bravada'), 'callback'=>'' ),
	array('id'=>'theme_text_section', 'title'=>__('Typography','bravada'), 'callback'=>'' ),
	array('id'=>'theme_post_section', 'title'=>__('Post Information','bravada') , 'callback'=>'' ),

), // panels

/************* sections *************/

'sections' => array(

	// layout
	array('id'=>'theme_generallayout', 'title'=>__('General Layout', 'bravada'), 'callback'=>'', 'sid'=>'theme_layout_section', 'priority'=>50 ),
	array('id'=>'theme_otherlayout', 'title'=>__('Other Layouts', 'bravada'), 'callback'=>'', 'sid'=>'theme_layout_section', 'priority'=>60 ),
	// header
	//array('id'=>'theme_siteheader', 'title'=>__('Header','bravada'), 'callback'=>'', 'sid'=> '', 'priority'=>52 ),
	array('id'=>'theme_headermenu', 'title'=>__('Menu','bravada'), 'callback'=>'', 'sid'=> 'theme_header_section', 'priority'=>10 ),
	array('id'=>'theme_headercontent', 'title'=>__('Content','bravada'), 'callback'=>'', 'sid'=> 'theme_header_section', 'priority'=>12 ),
	// landing page
	array('id'=>'theme_lpgeneral', 'title'=>__('Settings','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 10),
	array('id'=>'theme_lpslider', 'title'=>__('Slider','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 20),
	array('id'=>'theme_lpblocks1', 'title'=>__('Featured Icon Blocks','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 30 ),
	array('id'=>'theme_lpboxes1', 'title'=>__('Featured Boxes','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 40),
	array('id'=>'theme_lpboxes2', 'title'=>__('Featured Boxes 2','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 50),
	array('id'=>'theme_lptexts', 'title'=>__('Text Areas','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 60),
	array('id'=>'theme_lpfcontent', 'title'=>__('Featured Content','bravada'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 70),
	// text
	array('id'=>'theme_fontfamily', 'title'=>__('General Font','bravada'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_fontheader', 'title'=>__('Header Fonts','bravada'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_fontcontent', 'title'=>__('Content Fonts','bravada'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_fontwidget', 'title'=>__('Widget Fonts','bravada'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_textformatting', 'title'=>__('Formatting','bravada'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	// general
	array('id'=>'theme_contentstructure', 'title'=>__('Structure','bravada'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_contentgraphics', 'title'=>__('Decorations','bravada'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_postimage', 'title'=>__('Content Images','bravada'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_searchbox', 'title'=>__('Search Box Locations','bravada'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_socials', 'title'=>__('Social Icons','bravada'), 'callback'=>'', 'sid'=>'theme_general_section'),
	// colors
	array('id'=>'theme_colors', 'title'=>__('Content','bravada'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	array('id'=>'theme_colors_header', 'title'=>__('Header','bravada'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	array('id'=>'theme_colors_footer', 'title'=>__('Footer','bravada'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	array('id'=>'theme_colors_lp', 'title'=>__('Landing Page','bravada'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	// post info
	array('id'=>'theme_featured', 'title'=>__('Featured Image', 'bravada'), 'callback'=>'', 'sid'=>'theme_post_section', 'priority' => 10),
	array('id'=>'theme_metas_blog', 'title'=>__('Blog Metas','bravada'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 20),
	array('id'=>'theme_metas_single', 'title'=>__('Single Metas','bravada'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 20),
	array('id'=>'theme_excerpts', 'title'=>__('Excerpts','bravada'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 30),
	array('id'=>'theme_comments', 'title'=>__('Comments','bravada'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 40),
	// misc
	array('id'=>'theme_misc', 'title'=>__('Miscellaneous','bravada'), 'callback'=>'', 'sid'=>'', 'priority' => 92 ),

	/*** developer options ***/
	//array('id'=>'theme_developer', 'title'=>__('[ Developer Options ]','bravada'), 'callback'=>'', 'sid'=>'', 'priority'=>101 ),

), // sections

/************ clone options *********/
'clones' => array (
	'theme_lpboxes' => 2,
),

/************* settings *************/

'options' => array (
	//////////////////////////////////////////////////// Layout ////////////////////////////////////////////////////
	array(
	// this option needs to always be first; its index is used in the page/post meta option !!!
	'id' => 'theme_sitelayout',
		'type' => 'radioimage',
		'label' => __('Main Layout','bravada'),
		'choices' => array(
			'1c' => array(
				'label' => __("One column (no sidebars)","bravada"),
				'url'   => '%s/admin/images/1c.png'
			),
			'2cSr' => array(
				'label' => __("Two columns, sidebar on the right","bravada"),
				'url'   => '%s/admin/images/2cSr.png'
			),
			'2cSl' => array(
				'label' => __("Two columns, sidebar on the left","bravada"),
				'url'   => '%s/admin/images/2cSl.png'
			),
			'3cSr' => array(
				'label' => __("Three columns, sidebars on the right","bravada"),
				'url'   => '%s/admin/images/3cSr.png'
			),
			'3cSl' => array(
				'label' => __("Three columns, sidebars on the left","bravada"),
				'url'   => '%s/admin/images/3cSl.png'
			),
			'3cSs' => array(
				'label' => __("Three columns, one sidebar on each side","bravada"),
				'url'   => '%s/admin/images/3cSs.png'
			),
		),
		'desc' => '',
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_layoutalign',
		'type' => 'select',
		'label' => __('Theme alignment','bravada'),
		'values' => array( 0, 1 ),
		'labels' => array( __('Wide','bravada'), __('Boxed','bravada') ),
		'desc' => "",
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_sitewidth',
		'type' => 'numberslider',
		'label' => __('Site Width','bravada'),
		'min' => 960, 'max' => 1920, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_primarysidebar',
		'type' => 'numberslider',
		'label' => __('Left Sidebar Width','bravada'),
		'min' => 200, 'max' => 600, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_secondarysidebar',
		'type' => 'numberslider',
		'label' => __('Right Sidebar Width','bravada'),
		'min' => 200, 'max' => 600, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'theme_generallayout' ),

	// the other layouts
	array(
	'id' => 'theme_magazinelayout',
		'type' => 'radioimage',
		'label' => __('Posts Layout','bravada'),
		'choices' => array(
			1 => array(
				'label' => __("One column","bravada"),
				'url'   => '%s/admin/images/magazine-1col.png'
			),
			2 => array(
				'label' => __("Two columns","bravada"),
				'url'   => '%s/admin/images/magazine-2col.png'
			),
			3 => array(
				'label' => __("Three columns","bravada"),
				'url'   => '%s/admin/images/magazine-3col.png'
			),
		),
		'desc' => '',
	'section' => 'theme_otherlayout' ),
	array(
	'id' => 'theme_elementpadding',
		'type' => 'numberslider',
		'label' => __('Post/page padding','bravada'),
		'min' => 0,
		'max' => 10,
		'step' => 1,
		'um' => '%',
		'desc' => '',
	'section' => 'theme_otherlayout' ),

	array(
	'id' => 'theme_footercols',
		'type' => 'select',
		'label' => __("Footer Widgets Columns","bravada"),
		'values' => array(0, 1, 2, 3, 4),
		'labels' => array(
			__('All in a row','bravada'),
			__('1 Column','bravada'),
			__('2 Columns','bravada'),
			__('3 Columns','bravada'),
			__('4 Columns','bravada')
		),
		'desc' => '',
	'section' => 'theme_otherlayout' ),
	array(
	'id' => 'theme_footeralign',
		'type' => 'select',
		'values' => array( 0 , 1 ),
		'labels' => array( __("Default","bravada"), __("Center","bravada") ),
		'label' => __('Footer Widgets Alignment','bravada'),
		'desc' => "",
	'section' => 'theme_otherlayout' ),

	// Header-related hint to WP's Site Identity
	array(
	'id' => 'theme_headerhints',
		'type' => 'notice',
		'label' => '',
		'desc' => __('Fine tune the visibility of these elements in the theme\'s Header options', 'bravada'),
		'input_attrs' => array( 'class' => '' ),
		'priority' => 55,
		'addon' => TRUE, // this option gets added to built-in WordPress section
	'section' => 'title_tagline' ),

	// Header
	array(
	'id' => 'theme_menustyle',
		'type' => 'toggle',
		'values' => array( 0, 1 ),
		'label' => __('Fixed Menu','bravada'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menuheight',
		'type' => 'numberslider',
		'min' => 45,
		'max' => 200,
		'step' => 1,
		'um' => 'px',
		'label' => __('Menu Height','bravada'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menuposition',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Normal","bravada"), __("Over header image","bravada") ),
		'label' => __('Menu Position','bravada'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menualignment',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Boxed","bravada"), __("Wide","bravada") ),
		'label' => __('Menu Layout','bravada'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menulayout',
		'type' => 'select',
		'values' => array( 0, 1, 2 ),
		'labels' => array( __("Left", "bravada"), __("Right","bravada"), __("Center","bravada") ),
		'label' => __('Menu Alignment','bravada'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_siteheader',
		'type' => 'select',
		'label' => __('Site Header Content','bravada'),
		'values' => array( 'title' , 'logo' , 'both' , 'empty' ),
		'labels' => array( __("Site Title","bravada"), __("Logo","bravada"), __("Logo & Site Title","bravada"), __("Empty","bravada") ),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_sitetagline',
		'type' => 'checkbox',
		'label' => __('Show Tagline','bravada'),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_identityhints',
		'type' => 'notice',
		'input_attrs' => array( 'class' => '' ),
		'label' => '',
		'desc' => __('Edit the site\'s title, tagline and logo from WordPress\' Site Identity panel.', 'bravada'),
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headercontentspacer1',
		'type' => 'spacer',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerheight',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 1200,
		'um' => 'px',
		'label' => __('Header Image Height','bravada'),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerheight_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","bravada"),
		//'active_callback' => 'bravada_conditionals',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerfullscreen',
		'type' => 'checkbox',
		'label' => __('Force fullscreen header image','bravada'),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	// array(
	// 'id' => 'theme_headerfullscreenarchives',
	// 	'type' => 'checkbox',
	// 	'label' => __('Disable for Archive pages','bravada'),
	// 	'desc' => '',
	// 'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headertitle_anim',
		'type' => 'checkbox',
		'label' => __('Title animation','bravada'),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerresponsive',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Cropped","bravada"), __("Contained","bravada") ),
		'label' => __('Header Image Behaviour','bravada'),
		'desc' => "",
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headercontentspacer2',
		'type' => 'spacer',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerwidgetwidth',
		'type' => 'select',
		'label' => __("Header Widget Width","bravada"),
		'values' => array( "100%" , "60%" , "50%" , "33%" , "25%" ),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerwidgetalign',
		'type' => 'select',
		'label' => __("Header Widget Alignment","bravada"),
		'values' => array( 'left' , 'center' , 'right' ),
		'labels' => array( __("Left","bravada"), __("Center","bravada"), __("Right","bravada") ),
		'desc' => '',
	'section' => 'theme_headercontent' ),

	//////////////////////////////////////////////////// Landing Page ////////////////////////////////////////////////////
	array(
	'id' => 'theme_landingpage',
		'type' => 'select',
		'label' => __('Landing Page','bravada'),
		'values' => array( 1, 0 ),
		'labels' => array( __("Enabled","bravada"), __("Disabled (use WordPress homepage)","bravada") ),
		'desc' => '',
	'section' => 'theme_lpgeneral' ),
	array(
	'id' => 'theme_landingpage_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => sprintf( __( "To activate the Landing Page, make sure to set the WordPress <strong>Front Page displays</strong> option to %s","bravada" ), "<a data-type='section' data-id='static_front_page' class='cryout-customizer-focus'><strong>" . __("use a static page", "bravada") . " &raquo;</strong></a>" ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpgeneral' ),
	array(
	'id' => 'theme_lpposts',
		'type' => 'select',
		'label' => __('Featured Content','bravada'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Static Page", "bravada"), __("Posts", "bravada"), __("Disabled", "bravada") ),
		'desc' => '',
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpfcontent' ),
	array(
	'id' => 'theme_lpposts_more',
		'type' => 'text',
		'label' => __( 'More Posts Label', 'bravada' ),
		'desc' => '',
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpfcontent' ),

	// slider
	array(
	'id' => 'theme_lpslider',
		'type' => 'select',
		'label' => __('Slider','bravada'),
		'values' => array( 4, 2, 1, 3, 0 ),
		'labels' => array(
			__("Serious Slider", "bravada"),
			__("Use Shortcode","bravada"),
			__("Banner Image","bravada"),
			__("Header Image","bravada"),
			__("Disabled","bravada")
		),
		'desc' => sprintf( __("To create an advanced slider, use our <a href='%s' target='_blank'>Serious Slider</a> plugin or any other slider plugin.","bravada"), 'https://wordpress.org/plugins/cryout-serious-slider/' ),
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpsliderimage',
		'type' => 'media-image',
		'label' => __('Banner Image','bravada'),
		'desc' => __('The default image can be replaced by setting a new banner image.', 'bravada'),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpsliderlink',
		'type' => 'url',
		'label' => __('Slider Link','bravada'),
		'desc' => '',
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidershortcode',
		'type' => 'text',
		'label' => __('Shortcode','bravada'),
		'desc' => __('Enter shortcode provided by slider plugin. The plugin will be responsible for the slider\'s appearance.','bravada'),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpsliderserious',
		'type' => 'select',
		'label' => __('Serious Slider','bravada'),
		'values' => cryout_serious_slides_for_customizer(1, 0),
		'labels' => cryout_serious_slides_for_customizer(2, __(' - Please install, activate or update Serious Slider plugin - ', 'bravada'), __(' - No sliders defined - ', 'bravada') ),
		'desc' => __('Select the desired slider from the list. Sliders can be administered in the dashboard.','bravada'),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidertitle',
		'type' => 'text',
		'label' => __('Caption','bravada'),
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Title', 'bravada') ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidertext',
		'type' => 'textarea',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'bravada') ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta1text',
		'type' => 'text',
		'label' => __('CTA Button','bravada') . ' #1',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'bravada') ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta1link',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Link', 'bravada') ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta2text',
		'type' => 'text',
		'label' => __('CTA Button','bravada') . ' #2',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'bravada') ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta2link',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Link', 'bravada') ),
		'active_callback' => 'bravada_conditionals',
	'section' => 'theme_lpslider' ),

	// blocks
	array(
	'id' => 'theme_lpblockmaintitle#',
		'type' => 'text',
		'label' => __('Section Title','bravada'),
		'desc' => '',
		'priority' => 10,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockmaindesc#',
		'type' => 'textarea',
		'label' => __( 'Section Description', 'bravada' ),
		'desc' => '',
		'priority' => 15,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockspacer1#',
		'type' => 'spacer',
		'priority' => 15,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockscontent#',
		'type' => 'select',
		'label' => __('Blocks Content','bravada'),
		'values' => array( -1, 0, 1, 2 ),
		'labels' => array( __("Disabled","bravada"), __("No Text","bravada"), __("Excerpt","bravada"), __("Full Content","bravada") ),
		'desc' => '',
		'priority' => 20,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblocksreadmore#',
		'type' => 'text',
		'label' => __('Read More Button','bravada'),
		'desc' => __("Configure the 'Read More' link text.","bravada"),
		'priority' => 22,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblocksclick#',
		'type' => 'checkbox',
		'label' => __('Make icons clickable (linking to their respective pages).','bravada'),
		'desc' => '',
		'priority' => 23,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockspacer2#',
		'type' => 'spacer',
		'priority' => 23,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockoneicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','bravada'), 1),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 25,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockone#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'desc' => '&nbsp;',
		'priority' => 26,
	'section' => 'theme_lpblocks#' ),

	array(
	'id' => 'theme_lpblocktwoicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','bravada'), 2),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 27,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblocktwo#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'desc' => '&nbsp;',
		'priority' => 28,
	'section' => 'theme_lpblocks#' ),

	array(
	'id' => 'theme_lpblockthreeicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','bravada'), 3),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 29,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockthree#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'desc' => '&nbsp;',
		'priority' => 30,
	'section' => 'theme_lpblocks#' ),

	array(
	'id' => 'theme_lpblockfouricon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','bravada'), 4),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 31,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockfour#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'desc' => '&nbsp;',
		'priority' => 32,
	'section' => 'theme_lpblocks#' ),


	// boxes #cloned#
	array(
	'id' => 'theme_lpboxmaintitle#',
		'type' => 'text',
		'label' => __('Section Title','bravada'),
		'desc' => '',
		'priority' => 10,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxmaindesc#',
		'type' => 'textarea',
		'label' => __( 'Section Description', 'bravada' ),
		'desc' => '',
		'priority' => 20,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxspacer1#',
		'type' => 'spacer',
		'priority' => 20,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxcat#',
		'type' => 'select',
		'label' => __('Boxes Content','bravada'),
		'values' => cryout_categories_for_customizer(1, __('All Categories', 'bravada'), sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'labels' => cryout_categories_for_customizer(2, __('All Categories', 'bravada'), sprintf( '- %s -', __('Disabled', 'bravada') ) ),
		'desc' => '',
		'priority' => 30,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxcount#',
		'type' => 'numberslider',
		'min' => 1,
		'max' => 30,
		'step' => 1,
		'input_attrs' => array(
			'min' => 1,
			'max' => 100,
		),
		'label' => __('Number of Boxes','bravada'),
		'desc' => '',
		'priority' => 40,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxrow#',
		'type' => 'select',
		'label' => __('Boxes Per Row','bravada'),
		'values' => array( 1, 2, 3, 4 ),
		'desc' => '',
		'priority' => 50,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxheight#',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 600,
		'step' => 1,
		'um' => 'px',
		'input_attrs' => array(
			'min' => 1,
			'max' => 2000,
		),
		'label' => __('Box Height','bravada'),
		'desc' => __("The width is a percentage dependent on total site width and number of columns per row.","bravada"),
		'priority' => 60,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxspacer2#',
		'type' => 'spacer',
		'priority' => 60,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxlayout#',
		'type' => 'select',
		'label' => __('Box Layout','bravada'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Full width","bravada"), __("Boxed","bravada") ),
		'desc' => '',
		'priority' => 70,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxmargins#',
		'type' => 'select',
		'label' => __('Box Stacking','bravada'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Joined","bravada"), __("Apart","bravada") ),
		'desc' => '',
		'priority' => 80,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxanimation#',
		'type' => 'select',
		'label' => __('Box Appearance','bravada'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Animated","bravada"), __("Static","bravada") ),
		'desc' => '',
		'priority' => 90,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxspacer3#',
		'type' => 'spacer',
		'priority' => 91,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxreadmore#',
		'type' => 'text',
		'label' => __('Read More Button','bravada'),
		'desc' => '',
		'priority' => 100,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxlength#',
		'type' => 'numberslider',
		'min' => 1,
		'max' => 100,
		'step' => 1,
		'label' => __('Content Length (words)','bravada'),
		'desc' => '',
		'priority' => 110,
	'section' => 'theme_lpboxes#' ),

	// texts
	array(
	'id' => 'theme_lptextone',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','bravada'), 1),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'bravada') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'bravada') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),
	array(
	'id' => 'theme_lptexttwo',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','bravada'), 2),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'bravada') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'bravada') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),
	array(
	'id' => 'theme_lptextthree',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','bravada'), 3),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'bravada') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'bravada') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),
	array(
	'id' => 'theme_lptextfour',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','bravada'), 4),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'bravada') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'bravada') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),

	array(
	'id' => 'theme_lptexthint',
		'type' => 'hint',
		'label' => '',
		'desc' => __("Page properties that will be used:<br>- page title as text title<br>- page content as text content<br>- page featured image as text area background image","bravada"),
		'priority' => 99,
	'section' => 'theme_lptexts' ),

	//////////////////////////////////////////////////// Colors ////////////////////////////////////////////////////

	array(
	'id' => 'theme_sitebackground',
		'type' => 'color',
		'label' => __('Site Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_sitetext',
		'type' => 'color',
		'label' => __('Site Text','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_titletext',
		'type' => 'color',
		'label' => __('Content Titles','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_headingstext',
		'type' => 'color',
		'label' => __('Content Headings','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_contentbackground',
		'type' => 'color',
		'label' => __('Content Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_primarybackground',
		'type' => 'color',
		'label' => __('Left Sidebar Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_secondarybackground',
		'type' => 'color',
		'label' => __('Right Sidebar Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_colorsspacer2',
		'type' => 'spacer',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_accent1',
		'type' => 'color',
		'label' => __('Primary Accent','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_accent2',
		'type' => 'color',
		'label' => __('Secondary Accent','bravada'),
		'desc' => '',
	'section' => 'theme_colors' ),

	array(
	'id' => 'theme_menubackground',
		'type' => 'color',
		'label' => __('Header Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_menutext',
		'type' => 'color',
		'label' => __('Header Text','bravada'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_submenutext',
		'type' => 'color',
		'label' => __('Side Menu Text','bravada'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_submenubackground',
		'type' => 'color',
		'label' => __('Side Menu Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_activeitemtext',
		'type' => 'color',
		'label' => __('Active Item','bravada'),
		'desc' => '',
	'section' => 'theme_colors_header' ),

	array(
	'id' => 'theme_colorsspacer1',
		'type' => 'spacer',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaycolors',
		'type' => 'hint',
		'label' => __('Overlay', 'bravada'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
		'id' => 'theme_overlaytext',
		'type' => 'color',
		'label' => __('Text','bravada'),
		'desc' => '',
		'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaybackground1',
		'type' => 'color',
		'label' => sprintf( __('Background %s','bravada'), '#1' ),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaybackgroundposition1',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'um' => '%',
		'label' => sprintf( __('Background %s Position','bravada'), '#1' ),
		'desc' => "",
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaybackground2',
		'type' => 'color',
		'label' => sprintf( __('Background %s','bravada'), '#2' ),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaybackgroundposition2',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'um' => '%',
		'label' => sprintf( __('Background %s Position','bravada'), '#2' ),
		'desc' => "",
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlayangle',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 360,
		'step' => 1,
		'um' => '&deg;',
		'label' => __('Angle','bravada'),
		'desc' => "",
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlayopacity',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'um' => '%',
		'readonly' => true,
		'label' => __('Opacity','bravada'),
		'desc' => "",
	'section' => 'theme_colors_header' ),

	array(
	'id' => 'theme_footerbackground',
		'type' => 'color',
		'label' => __('Footer Background','bravada'),
		'desc' => '',
	'section' => 'theme_colors_footer' ),
	array(
	'id' => 'theme_footertext',
		'type' => 'color',
		'label' => __('Footer Text','bravada'),
		'desc' => '',
	'section' => 'theme_colors_footer' ),

	array(
	'id' => 'theme_lpblocksbg',
		'type' => 'color',
		'label' => __('Blocks','bravada'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),
	array(
	'id' => 'theme_lpboxesbg',
		'type' => 'color',
		'label' => __('Boxes','bravada'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),
	array(
	'id' => 'theme_lptextsbg',
		'type' => 'color',
		'label' => __('Text Areas','bravada'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),
	array(
	'id' => 'theme_lppostsbg',
		'type' => 'color',
		'label' => __('Featured Content','bravada'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),

	//////////////////////////////////////////////////// Fonts ////////////////////////////////////////////////////
	// general font
	array(
	'id' => 'theme_fgeneral',
		'type' => 'font',
		'label' => __('General Font','bravada'),
		'desc' => '',
		'no_inherit' => TRUE,
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralsize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 12, 'max' => 20, 'step' => 1, 'um' => 'px',
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_lineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','bravada'),
		'min' => 1, 'max' => 3, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontfamily' ),
 	array(
	'id' => 'theme_paragraphspace',
		'type' => 'numberslider',
		'label' => __('Spacing','bravada'),
		'min' => 0, 'max' => 3, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneraldesc',
		'type' => 'description',
		'label' => '',
		'desc' => __("The fonts under the <em>Preferred Theme Fonts</em> list are recommended because they have all the font weights used throughout the theme.","bravada"),
	'section' => 'theme_fontfamily' ),

	// header fonts
	array( // site title
	'id' => 'theme_fsitetitle',
		'type' => 'font',
		'label' => __('Site Title','bravada'),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitlesize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.9, 'max' => 3.0, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitleweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitlevariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitlegoogle',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontheader' ),

	array(
	'id' => 'theme_headerspacer1',
		'type' => 'spacer',
	'section' => 'theme_fontheader' ),

	array( // menu
	'id' => 'theme_fmenu',
		'type' => 'font',
		'label' => __('Main Menu','bravada'),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenusize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.8, 'max' => 2.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenuweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenuvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenugoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontheader' ),


	// widget fonts
	array( // widget title
	'id' => 'theme_fwtitle',
		'type' => 'font',
		'label' => __('Widget Title','bravada'),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlesize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.7, 'max' => 2.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitleweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlevariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlegoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlelineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','bravada'),
		'min' => 1, 'max' => 3, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),
 	array(
	'id' => 'theme_fwtitlespace',
		'type' => 'numberslider',
		'label' => __('Spacing','bravada'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),

	array(
	'id' => 'theme_fwspacer1',
		'type' => 'spacer',
	'section' => 'theme_fontwidget' ),

	array( // widget content
	'id' => 'theme_fwcontent',
		'type' => 'font',
		'label' => __('Widget Content','bravada'),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentsize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.8, 'max' => 1.6, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentlineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','bravada'),
		'min' => 1, 'max' => 3, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),

	// content fonts
	array( // post/page
	'id' => 'theme_ftitles',
		'type' => 'font',
		'label' => __('Blog Post Titles','bravada'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlessize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 1.0, 'max' => 3.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlesweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlesvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlesgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontcontent' ),

	array(
	'id' => 'theme_fcontentspacer1',
		'type' => 'spacer',
	'section' => 'theme_fontcontent' ),

	array( // metas
	'id' => 'theme_metatitles',
		'type' => 'font',
		'label' => __('Blog Post metas','bravada'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlessize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.7, 'max' => 1.6, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlesweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlesvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlesgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontcontent' ),

	array(
	'id' => 'theme_fcontentspacer2',
		'type' => 'spacer',
	'section' => 'theme_fontcontent' ),

	array( // Single Titles
	'id' => 'theme_singletitle',
		'type' => 'font',
		'label' => __('Single Post Titles','bravada'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singletitlesize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 1.4, 'max' => 6.0, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singletitleweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singletitlevariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singletitlegoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singletitlelineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','bravada'),
		'min' => 1, 'max' => 3, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),

	array(
	'id' => 'theme_fcontentspacer3',
		'type' => 'spacer',
	'section' => 'theme_fontcontent' ),

	array( // header title meta
	'id' => 'theme_singlemeta',
		'type' => 'font',
		'label' => __('Single Post Metas','bravada'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singlemetasize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.7, 'max' => 2.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singlemetaweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singlemetavariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_singlemetagoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontcontent' ),

	array(
	'id' => 'theme_fcontentspacer4',
		'type' => 'spacer',
	'section' => 'theme_fontcontent' ),

	array( // headings
	'id' => 'theme_fheadings',
		'type' => 'font',
		'label' => __('Headings','bravada'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingssize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 80, 'max' => 200, 'step' => 10, 'um' => '%',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingsweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','bravada'), __('200 extra-light','bravada'), __('300 ligher','bravada'), __('400 regular','bravada'), __('500 medium','bravada'), __('600 semi-bold','bravada'), __('700 bold','bravada'), __('800 extra-bold','bravada'), __('900 black','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingsvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','bravada'), __('Capitalize','bravada'), __('Uppercase','bravada'), __('Lowercase','bravada') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingsgoogle',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','bravada') ),
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingslineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','bravada'),
		'min' => 1, 'max' => 3, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
 	array(
	'id' => 'theme_fheadingsspace',
		'type' => 'numberslider',
		'label' => __('Spacing','bravada'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),

	// formatting
	array(
	'id' => 'theme_textalign',
		'type' => 'select',
		'label' => __('Text Alignment','bravada'),
		'values' => array( "inherit" , "left" , "right" , "justify" , "center" ),
		'labels' => array( __("Default","bravada"), __("Left","bravada"), __("Right","bravada"), __("Justify","bravada"), __("Center","bravada") ),
		'desc' => '',
	'section' => 'theme_textformatting' ),
	array(
	'id' => 'theme_parindent',
		'type' => 'numberslider',
		'label' => __('Paragraph Indentation','bravada'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_textformatting' ),

	//////////////////////////////////////////////////// Structure ////////////////////////////////////////////////////

	array(
	'id' => 'theme_breadcrumbs',
		'type' => 'toggle',
		'label' => __('Breadcrumbs','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_pagination',
		'type' => 'toggle',
		'label' => __('Numbered Pagination','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_singlenav',
		'type' => 'select',
		'label' => __('Single Post Prev/Next Navigation','bravada'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Absolute","bravada"), __("Static", "bravada"), __("Disable","bravada") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_contenttitles',
		'type' => 'select',
		'label' => __('Page/Category Titles','bravada'),
		'values' => array( 1, 2, 3, 0 ),
		'labels' => array( __('Always Visible','bravada'), __('Hide on Pages','bravada'), __('Hide on Categories','bravada'), __('Always Hidden','bravada') ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_totop',
		'type' => 'select',
		'label' => __('Back to Top Button','bravada'),
		'values' => array( 'bravada-totop-normal', 'bravada-totop-fixed', 'bravada-totop-disabled' ),
		'labels' => array( __("Bottom of page","bravada"), __("In footer","bravada"), __("Disabled","bravada") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_tables',
		'type' => 'select',
		'label' => __('Tables Style','bravada'),
		'values' => array( 'bravada-no-table', 'bravada-clean-table', 'bravada-stripped-table', 'bravada-bordered-table' ),
		'labels' => array( __("No border","bravada"), __("Clean","bravada"), __("Stripped","bravada"), __("Bordered","bravada") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_normalizetags',
		'type' => 'select',
		'label' => __('Tags Cloud Appearance','bravada'),
		'values' => array( 0, 1 ),
		'labels' => array( __("Size Emphasis","bravada"), __("Uniform Boxes","bravada") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
		'id' => 'theme_copyright',
		'type' => 'textarea',
		'label' => __( 'Custom Footer Text', 'bravada' ),
		'desc' => __("Insert custom text or basic HTML code that will appear in your footer. <br /> You can use HTML to insert links, images and special characters.","bravada"),
		'section' => 'theme_contentstructure' ),

	//////////////////////////////////////////////////// Graphics ////////////////////////////////////////////////////

	array(
	'id' => 'theme_articleanimation',
		'type' => 'select',
		'label' => __('Article Animation on Scroll','bravada'),
		'values' => array( 'none', 'fade', 'slide', 'flipUp', 'flipDown'),
		'labels' => array( __("None","bravada"), __("Fade","bravada"), __("Slide","bravada"), __("Flip Up","bravada"), __("Flip Down","bravada") ),
		'desc' => '',
	'section' => 'theme_contentgraphics' ),

	//////////////////////////////////////////////////// Search Box ////////////////////////////////////////////////////

	array(
	'id' => 'theme_searchboxmain',
		'type' => 'checkbox',
		'label' => __('Add Search to Main Menu','bravada'),
		'desc' => '',
	'section' => 'theme_searchbox' ),
	array(
	'id' => 'theme_searchboxfooter',
		'type' => 'checkbox',
		'label' => __('Add Search to Footer Menu','bravada'),
		'desc' => '',
	'section' => 'theme_searchbox' ),

	//////////////////////////////////////////////////// Content Image ////////////////////////////////////////////////////

	array(
	'id' => 'theme_image_style',
		'type' => 'radioimage',
		'label' => __('Post Images','bravada'),
		'choices' => array(
			'bravada-image-none' => array(
				'label' => __("No Styling","bravada"),
				'url'   => '%s/admin/images/image-style-0.png'
			),
			'bravada-image-one' => array(
				'label' => sprintf( __("Style %d","bravada"), 1),
				'url'   => '%s/admin/images/image-style-1.png'
			),
			'bravada-image-two' => array(
				'label' => sprintf( __("Style %d","bravada"), 2),
				'url'   => '%s/admin/images/image-style-2.png'
			),
			'bravada-image-three' => array(
				'label' => sprintf( __("Style %d","bravada"), 3),
				'url'   => '%s/admin/images/image-style-3.png'
			),
			'bravada-image-four' => array(
				'label' => sprintf( __("Style %d","bravada"), 4),
				'url'   => '%s/admin/images/image-style-4.png'
			),
			'bravada-image-five' => array(
				'label' => sprintf( __("Style %d","bravada"), 5),
				'url'   => '%s/admin/images/image-style-5.png'
			),
		),
		'desc' => '',
	'section' => 'theme_postimage' ),
	array(
	'id' => 'theme_caption_style',
		'type' => 'select',
		'label' => __('Post Captions','bravada'),
		'values' => array( 'bravada-caption-zero', 'bravada-caption-one', 'bravada-caption-two' ),
		'labels' => array( __('Plain','bravada'), __('With Border','bravada'), __('With Background','bravada') ),
		'desc' => '',
	'section' => 'theme_postimage' ),


	//////////////////////////////////////////////////// Post Information ////////////////////////////////////////////////////

	array( // blog metas
	'id' => 'theme_meta_blog_author',
		'type' => 'checkbox',
		'label' => __("Display Author","bravada"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_date',
		'type' => 'checkbox',
		'label' => __("Display Date","bravada"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_time',
		'type' => 'checkbox',
		'label' => __("Display Time","bravada"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_category',
		'type' => 'checkbox',
		'label' => __("Display Category","bravada"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_tag',
		'type' => 'checkbox',
		'label' => __("Display Tags","bravada"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_comment',
		'type' => 'checkbox',
		'label' => __("Display Comments","bravada"),
		'desc' => __("Choose meta information to show on posts.","bravada"),
	'section' => 'theme_metas_blog' ),

	// single meta
	array(
	'id' => 'theme_meta_single_author',
		'type' => 'checkbox',
		'label' => __("Display Author","bravada"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_date',
		'type' => 'checkbox',
		'label' => __("Display Date","bravada"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_time',
		'type' => 'checkbox',
		'label' => __("Display Time","bravada"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_category',
		'type' => 'checkbox',
		'label' => __("Display Category","bravada"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_tag',
		'type' => 'checkbox',
		'label' => __("Display Tags","bravada"),
		'desc' => '',
	'section' => 'theme_metas_single' ),

	// header titles
	array(
	'id' => 'theme_meta_single_comment',
		'type' => 'checkbox',
		'label' => __("Display Comments","bravada"),
		'desc' => __("Choose meta information to show on single posts.", "bravada"),
	'section' => 'theme_metas_single' ),

	// excerpts
	array(
	'id' => 'theme_excerpthome',
		'type' => 'select',
		'label' => __( 'Standard Posts On Homepage', 'bravada' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Excerpt","bravada"), __("Full Post","bravada") ),
		'desc' => __("Post formats always display full posts.","bravada"),
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptsticky',
		'type' => 'select',
		'label' => __( 'Sticky Posts on Homepage', 'bravada' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Inherit","bravada"), __("Full Post","bravada") ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptarchive',
		'type' => 'select',
		'label' => __( 'Standard Posts in Categories/Archives', 'bravada' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Excerpt","bravada"), __("Full Post","bravada") ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptlength',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'label' => __( 'Excerpt Length (words)' , 'bravada' ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptdots',
		'type' => 'text',
		'label' => __( 'Excerpt Suffix', 'bravada' ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptcont',
		'type' => 'text',
		'label' => __( 'Continue Reading Label', 'bravada' ),
		'desc' => '',
	'section' => 'theme_excerpts' ),

	// comments
	array(
	'id' => 'theme_comclosed',
		'type' => 'select',
		'label' => __("'Comments Are Closed' Text",'bravada'),
		'values' => array( 1, 2, 3, 0 ), // "Show" , "Hide in posts", "Hide in pages", "Hide everywhere"
		'labels' => array( __("Show","bravada"), __("Hide in posts","bravada"), __("Hide in pages","bravada"), __("Hide everywhere","bravada") ),
		'desc' => '',
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comdate',
		'type' => 'select',
		'label' => __('Comment Date Format','bravada'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Specific","bravada"), __("Relative","bravada") ),
		'desc' => '',
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comlabels',
		'type' => 'select',
		'label' => __('Comment Field Label','bravada'),
		'values' => array( 1, 3, 2 ),
		'labels' => array( __("Placeholders","bravada"), __("Optimized Labels","bravada"), __("Labels","bravada") ),
		'desc' => __("Change to labels for better compatibility with comment-related plugins.","bravada"),
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comicons',
		'type' => 'checkbox',
		'label' => __("Show Icons in Comment Fields","bravada"),
		'desc' => '',
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comformwidth',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 1000,
		'step' => 10,
		'um' => 'px',
		'label' => __('Comment Form Width','bravada'),
		'desc' => '',
	'section' => 'theme_comments' ),

	//////////////////////////////////////////////////// Featured Images ////////////////////////////////////////////////////
	array(
	'id' => 'theme_fpost',
		'type' => 'toggle',
		'label' => __( 'Featured Images', 'bravada' ),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fauto',
		'type' => 'toggle',
		'label' => __( 'Auto Select Image From Content', 'bravada' ),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fheight',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 800,
		'step' => 10,
		'um' => 'px',
		'label' => __( 'Featured Image Height', 'bravada' ),
		'desc' => __( 'Set to 0 to disable image processing', 'bravada' ),
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fheight_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","bravada"),
		//'active_callback' => 'bravada_conditionals',
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fresponsive',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Cropped","bravada"), __("Contained","bravada") ),
		'label' => __('Featured Image Behaviour','bravada'),
		'desc' => __("<strong>Contained</strong> will scale depending on the viewed resolution<br><strong>Cropped</strong> will try to keep the configured height.","bravada"),
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_falign',
		'type' => 'select',
		'label' => __( 'Featured Image Crop Position', 'bravada' ),
		'values' => array( false, "left top" , "left center", "left bottom", "right top", "right center", "right bottom", "center top", "center center", "center bottom" ),
		'labels' => array( __("No Crop","bravada"), __("Left Top","bravada"), __("Left Center","bravada"), __("Left Bottom","bravada"), __("Right Top","bravada"), __("Right Center","bravada"), __("Right Bottom","bravada"), __("Center Top","bravada"), __("Center Center","bravada"), __("Center Bottom","bravada") ),
		'desc' => '',
	'section' => 'theme_featured' ),

	array(
	'id' => 'theme_falign_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","bravada"),
		//'active_callback' => 'bravada_conditionals',
	'section' => 'theme_featured' ),

	array(
	'id' => 'theme_fheader',
		'type' => 'toggle',
		'label' => __('Use Featured Images in Header','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_featured' ),

	//////////////////////////////////////////////////// Social Positions ////////////////////////////////////////////////////

	array(
	'id' => 'theme_socials_header',
		'type' => 'checkbox',
		'label' => __( 'Display in Main Menu', 'bravada' ),
		'desc' => '',
	'section' => 'theme_socials' ),
	array(
	'id' => 'theme_socials_footer',
		'type' => 'checkbox',
		'label' => __( 'Display in Footer', 'bravada' ),
		'desc' => '',
	'section' => 'theme_socials' ),
	array(
	'id' => 'theme_socials_left_sidebar',
		'type' => 'checkbox',
		'label' => __( 'Display in Left Sidebar', 'bravada' ),
		'desc' => '',
	'section' => 'theme_socials' ),
	array(
	'id' => 'theme_socials_right_sidebar',
		'type' => 'checkbox',
		'label' => __( 'Display in Right Sidebar', 'bravada' ),
		'desc' => sprintf( __( 'Select where social icons should be displayed.<br><br><strong>Social Icons are defined using the <a href="%1$s" target="_blank">socials menu</a></strong>. Read the <a href="%2$s" target="_blank">theme documentation</a> for detailed information.', 'bravada' ), 'nav-menus.php?action=locations', 'http://www.cryoutcreations.eu/wordpress-tutorials/use-new-social-menu' ),
	'section' => 'theme_socials' ),

	//////////////////////////////////////////////////// Miscellaneous ////////////////////////////////////////////////////

	array(
	'id' => 'theme_pagesmenu',
		'type' => 'toggle',
		'label' => __( 'Default Pages Menu', 'bravada' ),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_masonry',
		'type' => 'toggle',
		'label' => __('Masonry','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_defer',
		'type' => 'toggle',
		'label' => __('JS Defer loading','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'theme_misc' ),

	array(
	'id' => 'theme_autoscroll',
		'type' => 'toggle',
		'label' => __('Autoscroll','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_headerlimits',
		'type' => 'toggle',
		'label' => __('Header image size requirements','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_mobileonios',
		'type' => 'toggle',
		'label' => __( 'Force mobile menu on iOS mobile devices', 'bravada' ),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_editorstyles',
		'type' => 'toggle',
		'label' => __('Editor Styles','bravada'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_fitvids',
		'type' => 'select',
		'label' => __('FitVids','bravada'),
		'values' => array( 1, 2, 0 ),
		'labels' => array( __("Enable","bravada"), __("Enable on mobiles","bravada"), __("Disable","bravada") ),
		'desc' => '',
		'priority' => 6,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_preloader',
		'type' => 'select',
		'label' => __('Preloader','bravada'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Front Page Only","bravada"), __("Enable","bravada"), __("Disable","bravada") ),
		'desc' => __("<br>Only use these options to troubleshoot issues.","bravada"),
		'priority' => 6,
	'section' => 'theme_misc' ),
	//////////////////////////////////////////////////// !!! DEVELOPER !!! ////////////////////////////////////////////////////
	// nothing for now

), // options

/* option=array(
	type: checkbox, select, textarea, input, function
	id: field_name or custom_function_name
	values: value_0, value_1, value_2 | true/false | number
	labels: __('Label 0','context'), ... | __('Enabled','context')/... |  number/__('Once','context')/...
	desc: html to be displayed at the question mark
	section: section_id

	array(
	'id' => '',
		'type' => '',
		'label' => '',
		'values' => array(  ),
		'labels' => array(  ),
		'desc' => '',
		'input_attrs' => array(  ),
		// conditionals
		'disable_if' => 'function_name',
		'require_fn' => 'function_name',
		// extra
		'addon' => TRUE, // option gets added to core sections
		'display_width' => '?????',
	'section' => '' ),

*/

/*** fonts ***/
'fonts' => array(

	'Inherit' => array( // capitalization matters
		'Inherit General Font',
	),
	'Preferred Theme Fonts'=> array(
					"Muli/gfont",
					"Playfair Display/gfont",
					"System Fonts, -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen-Sans, Ubuntu, Cantarell, Helvetica Neue, sans-serif",
					"Great Vibes/gfont",
					"Open Sans/gfont",
					"Roboto/gfont",
					"Raleway/gfont",
					"Ubuntu/gfont",
					"Droid Sans/gfont",
					),
	'Recommended Google Fonts' => array(
					"Alegreya/gfont",
					"Alegreya Sans/gfont",
					"Arvo/gfont",
					"Cormorant/gfont",
					"Droid Sans/gfont",
					"Fira Sans/gfont",
					"Fjalla One/gfont",
					"Karla/gfont",
					"Josefin Sans/gfont",
					"Lato/gfont",
					"Lora/gfont",
					"Libre Franklin/gfont",
					"Merriweather/gfont",
					"Montserrat/gfont",
					"Muli/gfont",
					"Noto Sans/gfont",
					"Noto Serif/gfont",
					"Nunito/gfont",
					"Open Sans/gfont",
					"Open Sans Condensed/gfont",
					"Oswald/gfont",
					"Oxygen/gfont",
					"Playfair Display/gfont",
					"Poppins/gfont",
					"PT Sans/gfont",
					"PT Serif/gfont",
					"Raleway/gfont",
					"Roboto/gfont",
					"Roboto Slab/gfont",
					"Rubik/gfont",
					"Spectral/gfont",
					"Source Sans Pro/gfont",
					"Source Serif Pro/gfont",
					"Ubuntu/gfont",
					"Ubuntu Condensed/gfont",
					"Work Sans Condensed/gfont",
					"Yanone Kaffeesatz/gfont",
					),
	'Sans-Serif' => array(
					"Verdana, Geneva, sans-serif" ,
					"Geneva, sans-serif",
					"Helvetica Neue, Arial, Helvetica, sans-serif",
					"Helvetica, sans-serif" ,
					"Calibri, Arian, sans-serif",
				    	"Myriad Pro, Myriad,Arial, sans-serif",
					"Gill Sans, Calibri, Trebuchet MS, sans-serif",
					"Arial, Helvetica, sans-serif" ,
					),
	'Serif' => array(
					"Georgia, Times New Roman, Times, serif",
					"Times New Roman, Times, serif",
					"Cambria, Georgia, Times, Times New Roman, serif",
					"Palatino Linotype, Book Antiqua, Palatino, serif",
					"Palatino, serif",
				    	"Baskerville, Times New Roman, Times, serif",
					"Garamond, Times New Roman, Times, serif"
					),
	'Advanced' => array(
					"* Local Font *",
					),
	), // fonts

	/*** google font option fields ***/
	'google-font-enabled-fields' => array(
		'theme_fgeneral',
		'theme_fsitetitle',
		'theme_fmenu',
		'theme_fwtitle',
		'theme_fwcontent',
		'theme_ftitles',
		'theme_metatitles',
		'theme_fheadings',
		'theme_singletitle',
		'theme_singlemeta',
		),

	// ! The icons lists are reused in multiple locations; make sure to update all when needed !

	/*** landing page blocks icons ***/
	'block-icons' => array(
		'toggle' => 'e003',
		'layout' => 'e004',
		'lock' => 'e007',
		'unlock' => 'e008',
		'target' => 'e012',
		'disc' => 'e019',
		'microphone' => 'e048',
		'play' => 'e052',
		'cloud2' => 'e065',
		'cloud-upload' => 'e066',
		'cloud-download' => 'e067',
		'plus2' => 'e114',
		'minus2' => 'e115',
		'check2' => 'e116',
		'cross2' => 'e117',
		'users2' => 'e00a',
		'user' => 'e00b',
		'trophy' => 'e00c',
		'speedometer' => 'e00d',
		'screen-tablet' => 'e00f',
		'screen-smartphone' => 'e01a',
		'screen-desktop' => 'e01b',
		'plane' => 'e01c',
		'notebook' => 'e01d',
		'magic-wand' => 'e01e',
		'hourglass2' => 'e01f',
		'graduation' => 'e02a',
		'fire' => 'e02b',
		'eyeglass' => 'e02c',
		'energy' => 'e02d',
		'chemistry' => 'e02e',
		'bell' => 'e02f',
		'badge' => 'e03a',
		'speech' => 'e03b',
		'puzzle' => 'e03c',
		'printer' => 'e03d',
		'present' => 'e03e',
		'pin' => 'e03f',
		'picture2' => 'e04a',
		'map' => 'e04b',
		'layers' => 'e04c',
		'globe' => 'e04d',
		'globe2' => 'e04e',
		'folder' => 'e04f',
		'feed' => 'e05a',
		'drop' => 'e05b',
		'drawar' => 'e05c',
		'docs' => 'e05d',
		'directions' => 'e05e',
		'direction' => 'e05f',
		'cup2' => 'e06b',
		'compass' => 'e06c',
		'calculator' => 'e06d',
		'bubbles' => 'e06e',
		'briefcase' => 'e06f',
		'book-open' => 'e07a',
		'basket' => 'e07b',
		'bag' => 'e07c',
		'wrench' => 'e07f',
		'umbrella' => 'e08a',
		'tag' => 'e08c',
		'support' => 'e08d',
		'share' => 'e08e',
		'share2' => 'e08f',
		'rocket' => 'e09a',
		'question' => 'e09b',
		'pie-chart2' => 'e09c',
		'pencil2' => 'e09d',
		'note' => 'e09e',
		'music-tone-alt' => 'e09f',
		'list2' => 'e0a0',
		'like' => 'e0a1',
		'home2' => 'e0a2',
		'grid' => 'e0a3',
		'graph' => 'e0a4',
		'equalizer' => 'e0a5',
		'dislike' => 'e0a6',
		'calender' => 'e0a7',
		'bulb' => 'e0a8',
		'chart' => 'e0a9',
		'clock' => 'e0af',
		'envolope' => 'e0b1',
		'flag' => 'e0b3',
		'folder2' => 'e0b4',
		'heart2' => 'e0b5',
		'info' => 'e0b6',
		'link' => 'e0b7',
		'refresh' => 'e0bc',
		'reload' => 'e0bd',
		'settings' => 'e0be',
		'arrow-down' => 'e604',
		'arrow-left' => 'e605',
		'arrow-right' => 'e606',
		'arrow-up' => 'e607',
		'paypal' => 'e608',
		'home' => 'e800',
		'apartment' => 'e801',
		'data' => 'e80e',
		'cog' => 'e810',
		'star' => 'e814',
		'star-half' => 'e815',
		'star-empty' => 'e816',
		'paperclip' => 'e819',
		'eye2' => 'e81b',
		'license' => 'e822',
		'picture' => 'e827',
		'book' => 'e828',
		'bookmark' => 'e829',
		'users' => 'e82b',
		'store' => 'e82d',
		'calendar' => 'e836',
		'keyboard' => 'e837',
		'spell-check' => 'e838',
		'screen' => 'e839',
		'smartphone' => 'e83a',
		'tablet' => 'e83b',
		'laptop' => 'e83c',
		'laptop-phone' => 'e83d',
		'construction' => 'e841',
		'pie-chart' => 'e842',
		'gift' => 'e844',
		'diamond' => 'e845',
		'cup3' => 'e848',
		'leaf' => 'e849',
		'earth' => 'e853',
		'bullhorn' => 'e859',
		'hourglass' => 'e85f',
		'undo' => 'e860',
		'redo' => 'e861',
		'sync' => 'e862',
		'history' => 'e863',
		'download' => 'e865',
		'upload' => 'e866',
		'bug' => 'e869',
		'code' => 'e86a',
		'link2' => 'e86b',
		'unlink' => 'e86c',
		'thumbs-up' => 'e86d',
		'thumbs-down' => 'e86e',
		'magnifier' => 'e86f',
		'cross3' => 'e870',
		'menu' => 'e871',
		'list' => 'e872',
		'warning' => 'e87c',
		'question-circle' => 'e87d',
		'check' => 'e87f',
		'cross' => 'e880',
		'plus' => 'e881',
		'minus' => 'e882',
		'layers2' => 'e88e',
		'text-format' => 'e890',
		'text-size' => 'e892',
		'hand' => 'e8a5',
		'pointer-up' => 'e8a6',
		'pointer-right' => 'e8a7',
		'pointer-down' => 'e8a8',
		'pointer-left' => 'e8a9',
		'heart' => 'e930',
		'cloud' => 'e931',
		'trash' => 'e933',
		'user2' => 'e934',
		'key' => 'e935',
		'search' => 'e936',
		'settings2' => 'e937',
		'camera' => 'e938',
		'tag2' => 'e939',
		'bulb2' => 'e93a',
		'pencil' => 'e93b',
		'diamond2' => 'e93c',
		'location' => 'e93e',
		'eye' => 'e93f',
		'bubble' => 'e940',
		'stack' => 'e941',
		'cup' => 'e942',
		'phone' => 'e943',
		'news' => 'e944',
		'mail' => 'e945',
		'news2' => 'e948',
		'paperplane' => 'e949',
		'params2' => 'e94a',
		'data2' => 'e94b',
		'megaphone' => 'e94c',
		'study' => 'e94d',
		'chemistry2' => 'e94e',
		'fire2' => 'e94f',
		'paperclip2' => 'e950',
		'calendar2' => 'e951',
		'wallet' => 'e952',
		),

	'meta-icons' => array(
		'user-female' => "\e000",
		'screen-smartphone' => "\e010",
		'screen-desktop' => "\e011",
		'plane' => "\e012",
		'notebook' => "\e013",
		'moustache' => "\e014",
		'energy' => "\e020",
		'emoticon-smile' => "\e021",
		'disc' => "\e022",
		'credit-card' => "\e025",
		'chemistry' => "\e026",
		'user' => "\e005",
		'speedometer' => "\e007",
		'screen-tablet' => "\e00f",
		'magic-wand' => "\e017",
		'hourglass' => "\e018",
		'game-controller' => "\e01b",
		'fire' => "\e01c",
		'eyeglasses' => "\e01d",
		'envelope-open' => "\e01e",
		'bell' => "\e027",
		'badge' => "\e028",
		'wallet' => "\e02a",
		'vector' => "\e02b",
		'speech' => "\e02c",
		'puzzle' => "\e02d",
		'pin' => "\e031",
		'picture' => "\e032",
		'map' => "\e033",
		'layers' => "\e034",
		'handbag' => "\e035",
		'globe-alt' => "\e036",
		'globe' => "\e037",
		'frame' => "\e038",
		'folder-alt' => "\e039",
		'film' => "\e03a",
		'feed' => "\e03b",
		'earphones-alt' => "\e03c",
		'earphones' => "\e03d",
		'drop' => "\e03e",
		'drawer' => "\e03f",
		'docs' => "\e040",
		'directions' => "\e041",
		'direction' => "\e042",
		'diamond' => "\e043",
		'cup' => "\e044",
		'compass' => "\e045",
		'call-end' => "\e048",
		'calculator' => "\e049",
		'bubbles' => "\e04a",
		'briefcase' => "\e04b",
		'book-open' => "\e04c",
		'basket-loaded' => "\e04d",
		'basket' => "\e04e",
		'bag' => "\e04f",
		'action-undo' => "\e050",
		'action-redo' => "\e051",
		'trash' => "\e054",
		'tag' => "\e055",
		'support' => "\e056",
		'share-alt' => "\e05a",
		'share' => "\e05b",
		'question' => "\e05d",
		'pencil' => "\e05f",
		'note' => "\e060",
		'music-tone-alt' => "\e061",
		'music-tone' => "\e062",
		'microphone' => "\e063",
		'list' => "\e067",
		'home' => "\e069",
		'grid' => "\e06a",
		'graph' => "\e06b",
		'cursor' => "\e06e",
		'control-play' => "\e071",
		'calendar' => "\e075",
		'bulb' => "\e076",
		'bar-chart' => "\e077",
		'arrow-up' => "\e078",
		'arrow-right' => "\e079",
		'arrow-left' => "\e07a",
		'arrow-down' => "\e07b",
		'ban' => "\e07c",
		'bubble' => "\e07d",
		'camcorder' => "\e07e",
		'camera' => "\e07f",
		'check' => "\e080",
		'clock' => "\e081",
		'close' => "\e082",
		'envelope' => "\e086",
		'eye' => "\e087",
		'flag' => "\e088",
		'folder' => "\e089",
		'heart' => "\e08a",
		'info' => "\e08b",
		'key' => "\e08c",
		'link' => "\e08d",
		'lock' => "\e08e",
		'lock-open' => "\e08f",
		'magnifier' => "\e090",
		'magnifier-add' => "\e091",
		'magnifier-remove' => "\e092",
		'paper-clip' => "\e093",
		'paper-plane' => "\e094",
		'plus' => "\e095",
		'pointer' => "\e096",
		'power' => "\e097",
		'refresh' => "\e098",
		'reload' => "\e099",
		'settings' => "\e09a",
		'star' => "\e09b",
		'target' => "\e09e",
		'volume-1' => "\e09f",
		'volume-2' => "\e0a0",
		'volume-off' => "\e0a1",
		'users' => "\e001",
		'clock1' => "\e0a9",
		'search2' => "\e0a8",
		'head' => "\e0a7",
		'arrow-left1' => "\e0a2",
		'arrow-right1' => "\e0a3",
		'arrow-up1' => "\e0a4",
		'arrow-down1' => "\e0a5",
		'volume' => "\e0a6",
		'plus1' => "\e114",
		'minus' => "\e115",
		'check1' => "\e116",
		'cross' => "\e117",
		'menu2' => "\e120",
		'ellipsis' => "\e129",
		'search' => "\e618",
		'refresh1' => "\e61c",
		'close1' => "\e680",
		'angle-up' => "\e682",
		'angle-right' => "\e684",
		'angle-left' => "\e686",
		'angle-down' => "\e688",
		'refresh-2' => "\e6c2",
		'chevron-down' => "\e900",
		'chevron-left' => "\e901",
		'chevron-right' => "\e902",
		'chevron-small-down' => "\e903",
		'chevron-small-left' => "\e904",
		'chevron-small-right' => "\e905",
		'chevron-small-up' => "\e906",
		'chevron-thin-down' => "\e907",
		'chevron-thin-left' => "\e908",
		'chevron-thin-right' => "\e909",
		'chevron-thin-up' => "\e90a",
		'chevron-up' => "\e90b",
		'circular-graph' => "\e90c",
		'cross2' => "\e90d",
		'magnifying-glass' => "\e911",
		'menu3' => "\e912",
		'quote' => "\e915",
		'el-comment' => "\e800",
		'el-user' => "\e801",
		'el-tag' => "\e802",
		'el-down-dir' => "\e803",
		'el-edit' => "\e804",
		'el-category' => "\e805",
		'el-right-dir' => "\e806",
		'el-angle-left' => "\e807",
		'el-angle-right' => "\e808",
		'el-angle-up' => "\e809",
		'el-angle-down' => "\e80a",
		'el-minus' => "\e80b",
		'el-left-open' => "\e80c",
		'el-time' => "\e80d",
		'el-up' => "\e80e",
		'el-quote' => "\e80f",
		'el-bookmark' => "\e810",
		'el-left-dir' => "\e811",
		'el-up-open' => "\e812",
		'el-ok' => "\e813",
		'el-cancel' => "\e814",
		'el-comments' => "\e815",
		'el-search' => "\e816",
		'el-category2' => "\e817",
		'el-link' => "\e818",
		'el-up-dir' => "\e819",
		'el-info' => "\e81a",
		'el-share' => "\e81b",
		'el-folder-close' => "\e81c",
		'el-folder-open' => "\e81d",
		'el-right-open' => "\e81e",
		'el-home' => "\e81f",
		'el-menu' => "\e820",
		'el-plus' => "\e821",
		'el-down-open' => "\e822",
		'el-audio' => "\e823",
		'el-image' => "\e824",
		'el-camera' => "\e825",
		'el-down' => "\e826",
		'el-left' => "\e827",
		'el-right' => "\e828",
		'el-video' => "\e829",
		'el-aside' => "\e82a",
		'el-date' => "\e82b",
		'el-star-empty' => "\e82c",
		'el-star' => "\e82d",
		'el-mail' => "\e82e",
		'el-home-1' => "\e82f",
		'el-attach' => "\e830",
		'el-eye' => "\e831",
		'el-eye-off' => "\e832",
		'eye-on' => "\e831",
		'eye-off' => "\e832",
		'el-tags' => "\e833",
		'el-flag' => "\e834",
		'el-warning' => "\e835",
		'el-location' => "\e836",
		'el-trash' => "\e837",
		'el-doc' => "\e838",
		'el-phone' => "\e839",
		'el-cog' => "\e83a",
		'el-basket' => "\e83b",
		'el-basket-circled' => "\e83c",
		'el-wrench' => "\e83d",
		'el-wrench-circled' => "\e83e",
		'el-mic' => "\e83f",
		'el-volume' => "\e840",
		'el-volume-down' => "\e841",
		'el-volume-off' => "\e842",
		'el-headphones' => "\e843",
		'el-lightbulb' => "\e844",
		'el-resize-full' => "\e845",
		'el-resize-full-alt' => "\e846",
		'el-resize-small' => "\e847",
		'el-resize-vertical' => "\e848",
		'el-resize-horizontal' => "\e849",
		'el-move' => "\e84a",
		'el-zoom-in' => "\e84b",
		'el-zoom-out' => "\e84c",
		'el-arrows-cw' => "\e84d",
		'el-desktop' => "\e84e",
		'el-inbox' => "\e84f",
		'el-cloud' => "\e850",
		'el-book' => "\e851",
		'el-certificate' => "\e852",
		'el-tasks' => "\e853",
		'el-thumbs-up' => "\e854",
		'el-thumbs-down' => "\e855",
		'el-help-circled' => "\e856",
		'el-star-circled' => "\e857",
		'el-bell' => "\e858",
		'el-rss' => "\e859",
		'el-trash-circled' => "\e85a",
		'el-cogs' => "\e85b",
		'el-cog-circled' => "\e85c",
		'el-calendar-circled' => "\e85d",
		'el-mic-circled' => "\e85e",
		'el-volume-up' => "\e85f",
		'el-print' => "\e860",
		'el-edit-alt' => "\e861",
		'el-edit-2' => "\e862",
		'el-block' => "\e863",
	),

	'social-icons' => array(

		'duckduckgo' => 'e801',
		'aim' => 'e802',
		'delicious' => 'e803',
		'paypal' => 'e804',
		'flattr' => 'e805',
		'android' => 'e806',
		'eventful' => 'e807',
		'smashingmagazine' => 'e808',
		'googleplus' => 'e809',
		'wikipedia' => 'e80a',
		'lanyrd' => 'e80b',
		'calendar' => 'e80c',
		'stumbleupon' => 'e80d',
		'500px' => 'e80e',
		'pinterest' => 'e80f',
		'bitcoin' => 'e810',
		'firefox' => 'e811',
		'foursquare' => 'e812',
		'chrome' => 'e813',
		'internetexplorer' => 'e814',
		'phone' => 'e815',
		'grooveshark' => 'e816',
		'99designs' => 'e817',
		'code' => 'e818',
		'digg' => 'e819',
		'spotify' => 'e81a',
		'reddit' => 'e81b',
		'about' => 'e81c',
		'codeopen' => 'e81d',
		'appstore' => 'e81e',
		'creativecommons' => 'e820',
		'dribbble' => 'e821',
		'evernote' => 'e822',
		'flickr' => 'e823',
		'link2' => 'e824',
		'viadeo' => 'e825',
		'instapaper' => 'e826',
		'weibo' => 'e827',
		'klout' => 'e828',
		'linkedin' => 'e829',
		'meetup' => 'e82a',
		'vk' => 'e82b',
		'plancast' => 'e82c',
		'disqus' => 'e82d',
		'feed' => 'e82e',
		'skype' => 'e82f',
		'twitter' => 'e830',
		'youtube' => 'e831',
		'vimeo' => 'e832',
		'windows' => 'e833',
		'xing' => 'e834',
		'yahoo' => 'e835',
		'email' => 'e837',
		'cloud' => 'e838',
		'myspace' => 'e839',
		'podcast' => 'e83a',
		'amazon' => 'e83b',
		'steam' => 'e83c',
		'link' => 'e83d',
		'dropbox' => 'e83e',
		'ebay' => 'e83f',
		'facebook' => 'e840',
		'github2' => 'e841',
		'github' => 'e842',
		'googleplay' => 'e843',
		'itunes' => 'e844',
		'plurk' => 'e845',
		'songkick' => 'e846',
		'lastfm' => 'e847',
		'gmail' => 'e848',
		'pinboard' => 'e849',
		'openid' => 'e84a',
		'quora' => 'e84b',
		'soundcloud' => 'e84c',
		'tumblr' => 'e84d',
		'wordpress' => 'e84f',
		'yelp' => 'e850',
		'intensedebate' => 'e851',
		'eventbrite' => 'e852',
		'scribd' => 'e853',
		'stripe' => 'e855',
		'opentable' => 'e856',
		'cart' => 'e857',
		'opera' => 'e858',
		'angellist' => 'e859',
		'instagram' => 'e85a',
		'dwolla' => 'e85b',
		'appnet' => 'e85c',
		'drupal' => 'e85f',
		'buffer' => 'e860',
		'pocket' => 'e861',
		'bitbucket' => 'e862',
		'phone2' => 'e863',
		'stackoverflow' => 'e865',
		'hackernews' => 'e866',
		'lkdto' => 'e867',
		'twitter2' => 'e868',
		'phone3' => 'e869',
		'mobile' => 'e86a',
		'support' => 'e86b',
		'twitch' => 'e86c',
		'beer' => 'e86d',
	),

/*** ajax load more identifiers ***/
'theme_identifiers' => array(
	'load_more_optid' 			=> 'theme_lpposts_more',
	'content_css_selector' 		=> '#lp-posts .lp-posts-inside',
	'pagination_css_selector' 	=> '#lp-posts nav.navigation',
),

/************* widget areas *************/

'widget-areas' => array(
	'sidebar-2' => array(
		'name' => __( 'Sidebar Left', 'bravada' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'sidebar-1' => array(
		'name' => __( 'Sidebar Right', 'bravada' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'footer-widget-area' => array(
		'name' => __( 'Footer', 'bravada' ),
		'description' 	=> __('You can configure how many columns the footer displays from the theme options', 'bravada'),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s"><div class="footer-widget-inside">',
		'after_widget' => '</div></section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'content-widget-area-before' => array(
		'name' => __( 'Content Before', 'bravada' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'content-widget-area-after' => array(
		'name' => __( 'Content After', 'bravada' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'widget-area-header' => array(
		'name' => __( 'Header', 'bravada' ),
		'description' 	=> __('This widget area is displayed over the header image and requires an image to be set.', 'bravada'),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'widget-area-side-section' => array(
		'name' => __( 'Side Section', 'bravada' ),
		'description' 	=> __('This widget area is included below the main/side menu.', 'bravada'),
		'before_widget' => '<section id="%1$s" class="side-section-element %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<span class="side-section-element-title">',
		'after_title' => '</span>',
	),
), // widget-areas

'migration' => array(
/* 	'0.10' => array(
		//'theme_old_key' => 'theme_new_key',
	) // 0.1.0 */
),	// migration

); // $bravada_big

// sort block icons alphabetically
ksort( $bravada_big['block-icons'] );
$bravada_big['block-icons'] = array_merge( array( 'no-icon' => '&nbsp;') , $bravada_big['block-icons'] );

// FIN
