<?php
/****************************
*
* Mystic v1.0.1 - A Esotera Child Theme
* (c) 2021 Cryout Creations
* www.cryoutcreations.eu
*
*****************************/

/**
 * Load additional theme files
 */
require_once( get_stylesheet_directory() . '/includes/admin.php' );
require_once( get_stylesheet_directory() . '/includes/options.php' );
require_once( get_stylesheet_directory() . '/includes/notices.php' );
require_once( get_stylesheet_directory() . "/includes/custom-styles.php" );

/**
 * Enqueue parent styling
 */
function mystic_child_styling(){
	wp_enqueue_style( 'esotera-main', get_template_directory_uri() . '/style.css', array(), _CRYOUT_THEME_VERSION );  // restore correct parent stylesheet
	wp_enqueue_style( 'mystic', get_stylesheet_directory_uri() . '/style.css', array( 'esotera-main' ), _CRYOUT_THEME_VERSION  ); 		// enqueue child stylesheet
}
add_action( 'wp_enqueue_scripts', 'mystic_child_styling' );

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
function mystic_setup() {

	// Add support for flexible headers
	add_theme_support( 'custom-header', array(
		'default-image'	=> get_stylesheet_directory_uri() . '/resources/images/headers/mystic-flower.jpg',
	));

	// Default custom headers packaged with the theme.
	register_default_headers( array(
		'mystic-flower' => array(
			'url' => '%2$s/resources/images/headers/mystic-flower.jpg',
			'thumbnail_url' => '%2$s/resources/images/headers/mystic-flower.jpg',
			'description' => __( 'Mystic', 'mystic' )
		),
	) );

	// Filters
	add_filter( 'esotera_custom_styles', 'mystic_custom_styles' );
	add_filter( 'cryout_theme_description', 'mystic_custom_description' );
	add_filter( 'cryout_admin_version', 'mystic_admin_version_output' );

	// Initialize first time notice
	new Cryout_Notice( array(
		'slug' => 'mystic',
		'strings' => array(
			// translators: %1 is theme name, %2 is next string
			1 => esc_html__( 'It appears that you might have already configured %1$s. For best results it is recommended to %2$s upon child theme activation.', 'mystic' ),
			2 => esc_html__( 'reset the theme settings', 'mystic' ),
			3 => esc_html__( 'If you have already reset the options it is safe to dismiss this message.', 'mystic' ),
			4 => esc_html__( 'Do not display again', 'mystic' ),
		),
	) );

} // mystic_setup()
add_action( 'after_setup_theme', 'mystic_setup' );


/* FIN */
