<?php
/**
 * Master generated style function
 *
 * @package Mystic
 */

/**
 * Add body classes to identify the child theme
 */
function mystic_body_classes( $classes ) {
	$classes[] = strtolower( wp_get_theme() ) . '-child';
	return $classes;
}
add_filter( 'body_class', 'mystic_body_classes', 15 );

/**
 * Dynamic styles for the frontend
 */
function mystic_custom_styling() {
    $options = cryout_get_option();
    extract($options);

    ob_start(); ?>

    /* Mystic custom style */

	#access ul.sub-menu li a:hover,
	#access ul.children li a:hover {
		color: inherit;
		background: <?php echo esc_html( cryout_hexdiff( $theme_submenubackground, 16 ) ) ?>;
	}

	.single .author-info {
		border-color: <?php echo esc_html( $theme_accent1 ) ?>;
	}

	.main .entry-title,
	.main #content-masonry .format-image .entry-title,
	.main #content-masonry .format-audio .entry-title,
	.main #content-masonry .format-video .entry-title,
	.main #content-masonry [class*="post_format-"]:not(.format-gallery) .entry-title {
	    background-image: -webkit-linear-gradient(45deg, <?php echo esc_html( $theme_titletext ) ?> 25%, <?php echo esc_html( $theme_accent1 ) ?> 50%, <?php echo esc_html( $theme_titletext ) ?> 75%, <?php echo esc_html( $theme_accent1 ) ?>);
	    background-image: linear-gradient(45deg, <?php echo esc_html( $theme_titletext ) ?> 25%, <?php echo esc_html( $theme_accent1 ) ?> 50%, <?php echo esc_html( $theme_titletext ) ?> 75%, <?php echo esc_html( $theme_accent1 ) ?>);
	}

	.cryout .continue-reading-link span::before {
		background-color: <?php echo esc_html( $theme_accent1 ) ?>;
	}

	.cryout .continue-reading-link span::after {
		background-color: <?php echo esc_html( $theme_accent2 ) ?>;
	}

	.main #content-masonry .post-thumbnail-container + .entry-after-image {
		border-top: 2px solid <?php echo esc_html( $theme_accent1 ) ?>;
	}

	.lp-box-readmore::before,
	button,
	input[type="button"],
	input[type="submit"],
	input[type="reset"],
	.entry-meta .author-avatar {
		background-image: -webkit-linear-gradient(to right, <?php echo esc_html( $theme_accent1 ) ?> 50%, <?php echo esc_html( $theme_accent2 ) ?>);
		background-image: linear-gradient(to right, <?php echo esc_html( $theme_accent1 ) ?> 50%, <?php echo esc_html( $theme_accent2 ) ?>);
	}

	.single .entry-meta.aftertitle-meta {
		background-color: <?php echo esc_html( cryout_hexdiff( $theme_contentbackground, 10 ) ) ?>;
	}

	#colophon::before,
	#footer::before {
		background-color: <?php echo esc_html( $theme_footerbackground ) ?>;
	}

	.widget-title, #comments-title, #reply-title, .related-posts .related-main-title {
		color: <?php echo esc_html( $theme_headingstext ) ?>;
	}

	#colophon .widget-title {
		color: <?php echo esc_html( $theme_footertext ) ?>;
	}

	#container .searchform input[type="search"],
	#colophon .searchform input[type="search"] {
		border-color: <?php echo esc_html( $theme_accent1 ) ?>;
	}

	#access .menu-search-animated .s {
		border: 3px solid <?php echo esc_html( $theme_accent1 ) ?>;
	}

	.lp-staticslider .staticslider-caption-text,
	.seriousslider.seriousslider-theme .seriousslider-caption-text {
		font-family: <?php cryout_font_select( $theme_ftitles, $theme_ftitlesgoogle ) ?>;
	}

    /* end Mystic custom style */
    <?php
    return preg_replace( '/((background-)?color:\s*?)[;}]/i', '', ob_get_clean() );

} // mystic_custom_styling()


/**
 * Load custom styles
 */
function mystic_custom_styles( $style = '' ) {

	return $style . mystic_custom_styling();

} // mystic_custom_styles()
// this filer is applied in mystic_setup()


/* FIN */
