<?php

/**
 * Defaults
 */
function mystic_defaults( $defaults = array() ) {

	$mystic_defaults = array(

		"theme_sitelayout"			=> '1c',
		"theme_sitewidth"  			=> 1120,
		"theme_magazinelayout"		=> 2,
		"theme_headerheight"		=> 500,
		"theme_lpsliderimage"		=> esc_url( get_stylesheet_directory_uri() ) . '/resources/images/slider/mystic.jpg',
		"theme_menualignment"		=> 1,

		"theme_headeroverlap_pc"	=> 40, // %
		"theme_headeroverlap_px"	=> 100, // px

		"theme_sitebackground" 		=> "#F4F4F4",
		"theme_sitetext" 			=> "#6A6A6A",
		"theme_titletext"			=> "#23314c",
		"theme_headingstext"		=> "#23314c",
		"theme_contentbackground"	=> "#FFFFFF",
		"theme_accent1" 			=> "#6845AA",
		"theme_accent2" 			=> "#1EAE98",
		"theme_submenutext" 		=> "#ffffff",
		"theme_submenubackground"	=> "#24183A",

		"theme_overlaybackground1"  		=> "#6845AA",
		"theme_overlaybackgroundposition1"  => 25,
		"theme_overlaybackground2"  		=> "#1EAE98",
		"theme_overlaybackgroundposition2"  => 80,
		"theme_overlayangle"  				=> 90,
		"theme_overlayopacity"  			=> 85,

		"theme_footerbackground"	=> "#24183A",
		"theme_footertext"			=> "#EEEEEE",
		"theme_lpblocksbg"			=> "#fcf7f5",

		"theme_fgeneral" 			=> 'Poppins/gfont',
		//"theme_fgeneralgoogle"	=> 'Catamaran',
		"theme_fgeneralsize" 		=> '17',
		"theme_fgeneralweight" 		=> '400',

		"theme_fsitetitle"			=> 'inherit',
		//"theme_fsitetitlegoogle"	=> 'Catamaran',
		"theme_fsitetitlesize" 		=> 1.0,
		"theme_fsitetitleweight"	=> '700',
		"theme_fsitetitlevariant" 	=> 'none',

		"theme_fmenu" 			=> 'inherit',
		//"theme_fmenugoogle"	=> 'Catamaran',
		"theme_fmenusize" 		=> 0.85,
		"theme_fmenuweight"		=> '300',

		"theme_ftitles" 		=> 'inherit',
		//"theme_ftitlesgoogle"	=> 'Comfortaa',
		"theme_ftitlessize" 	=> 1.5,
		"theme_ftitlesweight"	=> '700',

		"theme_meta" 				=> 'inherit',
		//"theme_metatitlesgoogle"	=> 'Comfortaa',
		"theme_metatitlessize" 		=> 0.9,
		"theme_metatitlesweight"	=> '400',
		"theme_metatitlesvariant"	=> 'none',

		"theme_singletitle" 		=> 'inherit',
		//"theme_singletitlegoogle"	=> 'Comfortaa',
		"theme_singletitlesize" 	=> 3.6,
		"theme_singletitleweight"	=> '700',
		"theme_singletitlevariant"	=> '',

		"theme_singlemeta" 			=> 'inherit',
		//"theme_singlemetagoogle"	=> 'Comfortaa',
		"theme_singlemetasize" 		=> 1,
		"theme_singlemetaweight"	=> '300',
		"theme_singlemetavariant"	=> '',

		"theme_fheadings" 			=> 'inherit',
		//"theme_fheadingsgoogle"	=> 'Comfortaa',
		"theme_fheadingssize" 		=> 100,
		"theme_fheadingsweight"		=> '700',
		"theme_fheadingsvariant"	=> '',

		"theme_fwtitle" 			=> 'inherit',
		//"theme_fwtitlegoogle"		=> 'Comfortaa',
		"theme_fwtitlesize" 		=> 1.15,
		"theme_fwtitlelineheight" 	=> 1.6,
		"theme_fwtitleweight"		=> '700',

		"theme_fwcontent" 			=> 'inherit',
		//"theme_fwcontentgoogle"	=> 'Catamaran',
		"theme_fwcontentsize" 		=> 1,
		"theme_fwcontentweight"		=> '400',

		"theme_excerptlength"	=> 35,
		"theme_excerptcont"		=> 'Read more'

	); // mystic_defaults array

	$result = array_merge( $defaults, $mystic_defaults );

	return $result;

} // mystic_defaults()
add_filter( 'esotera_option_defaults_array', 'mystic_defaults' );

// needed? for the .org preview
function mystic_filter_defaults(){
	add_filter( 'esotera_option_defaults_array', 'mystic_defaults' );
} // mystic_filter_defaults()
add_action( 'customize_register', 'mystic_filter_defaults' );


/**
 * Handle theme labels in customize panels
 */
function mystic_about_theme_name( $initial ) {
	return __( 'About Mystic', 'mystic' );
} // mystic_about_theme_name()
add_filter( 'cryout_about_theme_name', 'mystic_about_theme_name' );

function mystic_about_theme_plus_desc( $initial ) {
	$theme = wp_get_theme();
	// translators: %1$s is the name of the child theme, %2$s is the name of the parent theme
	return '<h3>' . sprintf( esc_html__( '%1$s is a child theme of %2$s', 'mystic' ), esc_html( $theme->get( 'Name' ) ), ucwords( esc_html( $theme->get( 'Template' ) ) ) ) . '</h3>' . $initial;
} // mystic_about_theme_plus_desc()
add_filter( 'cryout_about_theme_plus_desc', 'mystic_about_theme_plus_desc' );

function mystic_about_theme_slug_swap( $initial ){
	return str_replace( array( 'esotera', 'Esotera' ), array( 'mystic', 'Mystic' ), $initial );
} // mystic_about_theme_slug_swap()
add_filter( 'cryout_about_theme_review_link', 'mystic_about_theme_slug_swap' );
add_filter( 'cryout_about_theme_manage_link', 'mystic_about_theme_slug_swap' );

// FIN
