<?php

/** 
  * Here be widgets
  *
  * @since Cryout 0.5.1
  */
  
// Used by add_action('widgets_init') in theme-setup.php
function cryout_widgets_init() {

	$areas = cryout_get_theme_structure('widget-areas');
	
	if (!empty( $areas )):
		foreach ($areas as $aid => $area):
			register_sidebar( array(
				'name' => $area['name'],
				'id' => $aid,
				'description' => ( isset($area['description'])?$area['description']:'' ),
				'before_widget' => $area['before_widget'],
				'after_widget' => $area['after_widget'],
				'before_title' => $area['before_title'],
				'after_title' => $area['after_title'],
			) );		
		endforeach; 		
	endif;
	
} // cryout_widgets_init()
  
  
/*  ! Theme widgets are disabled in this version of the framework ! */

function cryout_widget_scripts() {
	// For the WP uploader
    if(function_exists('wp_enqueue_media')) {
         wp_enqueue_media();
      }
      else {
         wp_enqueue_script('media-upload');
         wp_enqueue_script('thickbox');
         wp_enqueue_style('thickbox');
      }
	wp_register_script('admin', get_template_directory_uri().'/cryout/js/widgets.js');
	wp_enqueue_script('admin'); 
}

function cryout_widget_styles() {
	wp_register_style('admin', get_template_directory_uri().'/cryout/css/widgets.css');
	wp_enqueue_style('admin'); 
}


/*
 ************ PP COLUMN WIDGET ************
 */


// Counting the PP column widgets
global $cryout_column_counter;
$cryout_column_counter = 0;

class CryoutColumnWidget extends WP_Widget
{ 	
  private $opts; // theme options read in the constructor
  
  public function __construct() { 
    $widget_ops = array('classname' => 'CryoutColumnWidget', 'description' => __( 'Add columns to the presentation page','cryout' ) );
	$control_ops = array('width' => 350, 'height' => 350, 'classname' => 'cryout-widget'); // making widget window larger
	parent::__construct('cryout_columns_widget', __('Cryout Column', 'cryout' ), $widget_ops, $control_ops);
	$this->opts = cryout_get_theme_options(); // reading theme options
  } // constructor()
  
  public function CryoutColumnWidget() {
	self::__construct();
  } // PHP4 constructor

  public function form($instance) {
    $instance = wp_parse_args( (array) $instance, array( 'image' => '', 'title' => '' , 'text' => '',  'link' => '',  'blank' => '' ) );
    $image = $instance['image'];
	$title = $instance['title'];
	$text = $instance['text'];
	$link = $instance['link'];
	$blank = $instance['blank'];?>
	<div>
		<p><label for="<?php echo $this->get_field_id('image'); ?>"><?php _e('Image','cryout'); ?> <input class="widefat slideimages" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>" type="text" value="<?php echo esc_url($image); ?>" /> </label><a class="upload_image_button button" href="#"><?php _e('Select / Upload Image','cryout'); ?></a></p>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title','cryout'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />	</label></p>
		<p><label for="<?php echo $this->get_field_id('text'); ?>"><?php _e('Text','cryout'); ?> <textarea class="widefat" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" ><?php echo esc_attr($text); ?></textarea></label></p>
		<p><label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link','cryout'); ?> <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php echo esc_url($link); ?>" /></label></p>
		<p><label for="<?php echo $this->get_field_id('blank'); ?>"><input id="<?php echo $this->get_field_id('blank'); ?>" name="<?php echo $this->get_field_name('blank'); ?>" type="checkbox" <?php checked($blank, 1); ?> value="1" /> <?php _e('Open in new Window','cryout'); ?> </label></p>
	</div> <?php  
  } // form()

  public function update($new_instance, $old_instance) {
    $instance = $old_instance;
    $instance['image'] = $new_instance['image'];
	$instance['title'] = $new_instance['title'];
	$instance['text'] = $new_instance['text'];
	$instance['link'] = $new_instance['link'];
	$instance['blank'] = $new_instance['blank'];
    return $instance;
  } // update()
  
  function widget($args, $instance) { 
	$colcount = $this->opts[_THEME_NAME.'_nrcolumns']; // getting the number of columns setting
	global $cryout_column_counter; // global counter for incrementing further
	
	if($instance['image']) : 
		$cryout_column_counter++; // incrementing counter only if widget has image
		$counter = $cryout_column_counter; 
		$coldata = array(
			'colno' => (($counter%$colcount)?$counter%$colcount:$colcount),
			'counter' => $counter,
			'image' => esc_url($instance['image']),
			'link' => esc_url($instance['link']),
			'blank' => ($instance['blank']?'target="_blank"':''),
			'title' =>  $instance['title'],
			'text' => $instance['text'],
		);
		if ( function_exists(_THEME_NAME.'_singlecolumn_output') ) call_user_func( _THEME_NAME.'_singlecolumn_output', $coldata );
		//fluida_singlecolumn_output($coldata);		
	endif; 
  }// widget() 
  
}// CryoutColumnWidget


function cryout_register_widgets() { 
	register_widget('CryoutColumnWidget');
}

/*  ! Widgets are disabled in this version of the framework ! */

//add_action ('admin_print_scripts-widgets.php','cryout_widget_scripts');
//add_action( 'admin_print_scripts-widgets.php', 'cryout_widget_scripts' );
//add_action( 'admin_print_styles-widgets.php', 'cryout_widget_styles' );

//add_action( 'widgets_init', 'cryout_register_widgets' );
