<?php
/**
 * MASTER GENERATED STYLE FUNCTION
 *
 * @package Fluida
 */

function fluida_body_classes($classes) {
	$fluids = cryout_get_option( array(
		'fluida_image_style','fluida_magazinelayout','fluida_comclosed','fluida_contenttitles', 'fluida_caption_style',
		'fluida_elementborder', 'fluida_elementshadow', 'fluida_elementborderradius', 'fluida_totop', 'fluida_menustyle', 
		'fluida_comlabels',
	) );
	$classes[] = esc_html( $fluids['fluida_image_style'] );
	$classes[] = esc_html( $fluids['fluida_caption_style'] );
	$classes[] = esc_html( $fluids['fluida_totop'] );
	
	if ( $fluids['fluida_menustyle'] ) $classes[] = 'fluida-fixed-menu';

	if ( $fluids['fluida_magazinelayout'] ) {
		switch ( $fluids['fluida_magazinelayout'] ):
			case 1: $classes[] = 'magazine-one magazine-layout'; break;
			case 2: $classes[] = 'magazine-two magazine-layout'; break;
			case 3: $classes[] = 'magazine-three magazine-layout'; break;
		endswitch; 
	}
	switch ( $fluids['fluida_comclosed'] ) {
		case 2: $classes[] = 'comhide-in-posts'; break;
		case 3: $classes[] = 'comhide-in-pages'; break;
		case 0: $classes[] = 'comhide-in-posts'; $classes[] = 'comhide-in-pages'; break;
	}
	if ( $fluids['fluida_comlabels'] == 1 ) $classes[] = 'comment-placeholder'; 
	
	switch ( $fluids['fluida_contenttitles'] ) {
		case 2: $classes[] = 'hide-page-title'; break;
		case 3: $classes[] = 'hide-cat-title'; break; 
		case 0: $classes[] = 'hide-page-title'; $classes[] = 'hide-cat-title'; break;
	}
	
	if ( $fluids['fluida_elementborder'] ) $classes[] = 'fluida-elementborder'; 
	if ( $fluids['fluida_elementshadow'] ) $classes[] = 'fluida-elementshadow'; 
	if ( $fluids['fluida_elementborderradius'] ) $classes[] = 'fluida-elementradius'; 
	
	return $classes;
}
add_filter('body_class','fluida_body_classes');


/* 
 * Dynamic styles for the frontend
 */
function fluida_custom_styles() {
	$fluids = cryout_get_option();
	
	foreach ($fluids as $key => $value) { ${"$key"} = $value; }
	
	ob_start();

// <style> wrapping is handled by wp_add_inline_style()

/////////// LAYOUT DIMENSIONS. ///////////
?>

body, #header-container { max-width: <?php echo esc_html($fluida_sitewidth); ?>px; }

<?php
/////////// COLUMNS ///////////
$colPadding = 1; // percent
$sidebarP = $fluida_primarysidebar; 
$sidebarS = $fluida_secondarysidebar;
?>

#primary 									{ width: <?php echo $sidebarP; ?>px; }
#secondary 									{ width: <?php echo $sidebarS; ?>px; }

#container.one-column 						{ }
#container.two-columns-right #secondary 	{ float: right; }
#container.two-columns-right #main 			{ width: calc(<?php echo 100-(int)$colPadding ?>% - <?php echo $sidebarS; ?>px); float: left; }
#container.two-columns-left #primary 		{ float: left; }
#container.two-columns-left #main 			{ width: calc(<?php echo 100-(int)$colPadding ?>% - <?php echo $sidebarP; ?>px); float: right; } 

#container.three-columns-right #primary,
#container.three-columns-left #primary,
#container.three-columns-sided #primary		{ float: left; }

#container.three-columns-right #secondary,
#container.three-columns-left #secondary,
#container.three-columns-sided #secondary	{ float: left; }


#container.three-columns-right #primary,
#container.three-columns-left #secondary 	{ margin-left: <?php echo esc_html( $colPadding ) ?>%; margin-right: <?php echo esc_html($colPadding) ?>%; }
#container.three-columns-right #main 		{ width: calc(<?php echo 100-absint($colPadding) * 2 ?>% - <?php echo absint($sidebarS+$sidebarP); ?>px); float: left; }
#container.three-columns-left #main 		{ width: calc(<?php echo 100-absint($colPadding) * 2 ?>% - <?php echo absint($sidebarS+$sidebarP); ?>px); float: right; } 

#container.three-columns-sided #secondary 	{ float: right; }
#container.three-columns-sided #main 		{ width: calc(<?php echo 100-absint($colPadding) * 2 ?>% - <?php echo absint($sidebarS+$sidebarP); ?>px); float: right;
											  margin: 0 calc(<?php echo absint($colPadding) ?>% + <?php echo absint($sidebarS) ?>px)
											          0 -1920px; }

<?php
/////////// FONTS ///////////
?>
html
					{ font-family: <?php echo cryout_font_select( $fluida_fgeneral, $fluida_fgeneralgoogle ) ?>; 
					  font-size: <?php echo esc_html($fluida_fgeneralsize) ?>; font-weight: <?php echo esc_html($fluida_fgeneralweight) ?>; 
					  line-height: <?php echo esc_html( (float)$fluida_lineheight ) ?>; }

#site-title 		{ font-family: <?php echo cryout_font_select( $fluida_fsitetitle, $fluida_fsitetitlegoogle ) ?>; 
					  font-size: <?php echo esc_html($fluida_fsitetitlesize) ?>; font-weight: <?php echo esc_html($fluida_fsitetitleweight) ?>; }

#access ul li a 	{ font-family: <?php echo cryout_font_select( $fluida_fmenu, $fluida_fmenugoogle ) ?>; 
					  font-size: <?php echo esc_html($fluida_fmenusize) ?>; font-weight: <?php echo esc_html($fluida_fmenuweight) ?>; }

.widget-title 		{ font-family: <?php echo cryout_font_select( $fluida_fwtitle, $fluida_fwtitlegoogle ) ?>; 
					  font-size: <?php echo esc_html($fluida_fwtitlesize) ?>; font-weight: <?php echo esc_html($fluida_fwtitleweight) ?>; }
.widget-container 	{ font-family: <?php echo cryout_font_select( $fluida_fwcontent, $fluida_fwcontentgoogle ) ?>; 
				      font-size: <?php echo esc_html($fluida_fwcontentsize) ?>; font-weight: <?php echo esc_html($fluida_fwcontentweight) ?>; }
.entry-title, #reply-title 
					{ font-family: <?php echo cryout_font_select( $fluida_ftitles, $fluida_ftitlesgoogle ) ?>; 
					  font-size: <?php echo esc_html($fluida_ftitlessize) ?>; font-weight: <?php echo esc_html($fluida_ftitlesweight) ?>; }
<?php 
$font_root = 260; // headings font size root
for ( $i=1; $i<=6; $i++ ) {
		$size = round( ($font_root-(30*$i))/100 * (preg_replace("/[^\d]/","",esc_html($fluida_fheadingssize))/100), 5 ); ?> 
		h<?php echo $i ?> { font-size: <?php echo $size ?>em; } <?php 
} //for ?>
h1, h2, h3, h4, h5, h6 { font-family: <?php echo cryout_font_select( $fluida_fheadings, $fluida_fheadingsgoogle ) ?>; 
					     font-weight: <?php echo esc_html($fluida_fheadingsweight) ?>; }


<?php
/////////// COLORS /////////// 
?>
body 										{ color: <?php echo esc_html($fluida_sitetext); ?>; 
											  background-color: <?php echo esc_html($fluida_sitebackground) ?>; }
#branding, #header-container, #access ul li, #access ul ul, 
.menu-search-animated .searchform input[type="search"], #access::after 
											{ background-color: <?php echo esc_html($fluida_menubackground) ?>; }
#access .menu-main-search .searchform 				{ border-color: <?php echo esc_html($fluida_accent1) ?>; }
		
#header a, #access li 						{ color: <?php echo esc_html($fluida_accent1) ?>; }
#access ul.sub-menu li a, 
#access ul.children li a 					{ color: <?php echo esc_html($fluida_menutext) ?>; }
#access ul.sub-menu li:hover,
#access ul.children li:hover 				{ background-color: rgba(<?php echo cryout_hex2rgb( esc_html($fluida_menutext) ) ?>,0.5); }
#access ul li:hover > a 					{ color: <?php echo esc_html($fluida_menubackground) ?>; }
#access ul > li.current_page_item > a, 
#access ul > li.current-menu-item > a, 
#access ul > li.current_page_ancestor > a, 
#access ul > li.current-menu-ancestor > a,
#access .sub-menu, #access .children 		{ border-top-color: <?php echo esc_html($fluida_accent1) ?>; }
#access ul ul ul					 		{ border-left-color: rgba(<?php echo cryout_hex2rgb( esc_html($fluida_menutext) ) ?>,0.5); }

#access ul.children > li.current_page_item > a, 
#access ul.sub-menu > li.current-menu-item > a, 
#access ul.children > li.current_page_ancestor > a, 
#access ul.sub-menu > li.current-menu-ancestor > a 
											{ border-color: <?php echo esc_html($fluida_menutext) ?>; } 
.searchform .searchsubmit, .searchform:hover input[type="search"], .searchform input[type="search"]:focus
											{ color: <?php echo esc_html($fluida_contentbackground) ?>; background-color: transparent; }
#access > div > ul > li:hover, .searchform::after, .searchform input[type="search"]:focus, .searchform .searchsubmit:hover	
											{ background-color: <?php echo esc_html($fluida_accent1) ?>; }
	
article.post, article.page, #primary, .searchform, #main > div:not(#content-masonry), 
#main > header, #main > nav#nav-below, .pagination span, .pagination a, 
#nav-old-below .nav-previous, #nav-old-below .nav-next, #breadcrumbs		
											{ background-color: <?php echo esc_html($fluida_contentbackground) ?>; }
			
#secondary, #colophon 						{ background-color: <?php echo esc_html($fluida_contentbackground2) ?>; }

#colophon, #footer 							{ background-color: <?php echo esc_html($fluida_footerbackground) ?>; }
.entry-meta .author, footer.post-continue-container 	
											{ border-color: rgba(<?php echo esc_html($fluida_sitebackground) ?>,0.5); }
											
span.entry-format 							{ color: <?php echo esc_html($fluida_accent1) ?>; }
											  
.format-aside 								{ border-color: <?php echo esc_html($fluida_sitebackground) ?>; }

article.page .post-thumbnail-container, article.post .post-thumbnail-container 	
											{ background-color: rgba(<?php echo cryout_hex2rgb( esc_html($fluida_sitetext) ) ?>,0.15); } 
.entry-content blockquote::before, 
.entry-content blockquote::after 			{ color: rgba(<?php echo cryout_hex2rgb( esc_html($fluida_sitetext) ) ?>,0.1); }

a 											{ color: <?php echo esc_html($fluida_accent1); ?>; }
a:hover, .entry-meta span a:hover, 
.comments-link a:hover 						{ color: <?php echo esc_html($fluida_accent2); ?>; }

#footer a, .page-title strong 				{ color: <?php echo esc_html($fluida_accent1) ?>; }
#footer a:hover, #site-title a:hover span 	{ color: <?php echo esc_html($fluida_accent2) ?>; }
#access > div > ul > li.menu-search-animated:hover i 	
											{ color: <?php echo esc_html($fluida_menubackground) ?>; }
											
#respond .form-submit input[type="submit"], #respond .form-submit input[type="reset"] 
											{ background-color: <?php echo esc_html($fluida_accent1) ?>; 
											  color: <?php echo esc_html($fluida_contentbackground) ?>; }
											
header.pad-container						{ border-top-color: <?php echo esc_html($fluida_accent1) ?>; }		
article.sticky:after 						{ background-color: rgba(<?php echo cryout_hex2rgb( esc_html($fluida_accent1) ) ?>,1); }
.socials a:before 							{ color: <?php echo esc_html($fluida_accent1) ?>; }
.socials a:hover:before 					{ color: <?php echo esc_html($fluida_accent2) ?>; }

#toTop .icon-back2top:before 				{ color: <?php echo esc_html($fluida_accent1) ?>; }
#toTop:hover .icon-back2top:before 			{ color: <?php echo esc_html($fluida_accent2) ?>; }
.entry-meta .icon-metas:before				{ color: <?php echo esc_html($fluida_accent2) ?>; }
.page-link a:hover 							{ border-top-color: <?php echo esc_html($fluida_accent2) ?>; }

#site-title span a span:first-child 		{ background-color: <?php echo esc_html($fluida_accent2) ?>; 
											  color: <?php echo esc_html($fluida_menubackground) ?>; }

.fluida-caption-one #main .wp-caption .wp-caption-text 	{ border-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }
.fluida-caption-two #main .wp-caption .wp-caption-text 	{ background-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,10)) ?>; }

.fluida-image-one .entry-content img[class*="align"], 
.fluida-image-one .entry-summary img[class*="align"],
.fluida-image-two .entry-content img[class*='align'], 
.fluida-image-two .entry-summary img[class*='align'] 	{ border-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }
.fluida-image-five .entry-content img[class*='align'], 
.fluida-image-five .entry-summary img[class*='align'] 	{ border-color: <?php echo esc_html($fluida_accent1);?>; }

/* diffs */
span.edit-link a.post-edit-link, span.edit-link a.post-edit-link:hover, span.edit-link .icon-edit:before			
											{ color: <?php echo esc_html( cryout_hexdiff($fluida_sitetext, 69) ) ?>; } 

.searchform 								{ border-color: <?php echo esc_html( cryout_hexdiff($fluida_contentbackground, 20) ) ?>; }
.entry-meta span, .entry-utility span, .entry-meta time,
.comment-meta a, .footermenu ul li span.sep { color: <?php echo esc_html( cryout_hexdiff($fluida_sitetext, 69) ) ?>; }

code, .reply a:after,
#nav-below .nav-previous a:before, #nav-below .nav-next a:before, #colophon .widget-container:after,
.reply a:after 
											{ background-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }
pre, .entry-meta .author, nav.sidebarmenu, .page-link > span, #entry-author-info, #footer, .comment-author,
.commentlist .comment-body, .commentlist .pingback, nav.sidebarmenu li a
											{ border-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }

select, input[type], textarea 				{ color: <?php echo esc_html($fluida_sitetext); ?>; 
											  background-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,10)) ?>; }
#main select, #main input[type], #main textarea 
											{ border-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }
input[type]:hover, textarea:hover			{ background-color: rgba(<?php echo esc_html(cryout_hex2rgb(cryout_hexdiff($fluida_contentbackground,10))) ?>,0.65); }
  
#toTop 										{ background-color: rgba(<?php echo esc_html(cryout_hex2rgb(cryout_hexdiff($fluida_contentbackground,5))) ?>,0.8) }


<?php
/////////// LAYOUT /////////// 
/*if ($fluida_tables) { ?>
	#main table, #main tr, #main tr th, #main thead th, #main tr td, #main tr.even { background:none; border:none; color:inherit; }
<?php }*/ ?>
#main .entry-content, #main .entry-summary 	{ text-align: <?php echo esc_html($fluida_textalign) ?>; }
#main p, #main ul, #main ol, #main dd, #main pre, #main hr 
											{ margin-bottom: <?php echo esc_html($fluida_paragraphspace) ?>; }
#main p 									{ text-indent: <?php echo esc_html($fluida_parindent) ?>;}
#main a.post-featured-image 				{ background-position: <?php echo esc_html($fluida_falign) ?>; }

#content			 						{ margin-top: <?php echo esc_html($fluida_contentmargintop) ?>px; }
#content 									{ padding-left: <?php echo esc_html($fluida_contentpadding) ?>px; 
											  padding-right: <?php echo esc_html($fluida_contentpadding) ?>px; }
#header-widget-area 						{ width: <?php echo esc_html($fluida_headerwidgetwidth) ?>; }
<?php if ($fluida_fpost) { ?>
	#main .post-thumbnail-container 		{ height: <?php echo esc_html($fluida_fheight) ?>px; }
<?php } ?>

<?php 
/////////// SOME CONDITIONAL CLEANUP ///////////
if ( empty($fluida_contentbackground) ) {  ?> #primary, #colophon { border: 0; box-shadow: none; } <?php }
if ( empty($fluida_contentbackground2) ) { ?> #secondary { border: 0; box-shadow: none; } 
											 #primary + #secondary { padding-left: 1em; } <?php }

/////////// ELEMENTS PADDING ///////////
?>
article.post, article.page, #breadcrumbs,
.magazine-one #content-masonry article.post, .magazine-one #content-masonry article.page, .magazine-one .pad-container  {
		padding-left: <?php echo esc_html( $fluida_elementpadding ) ?>%; 
		padding-right: <?php echo esc_html( $fluida_elementpadding ) ?>%; }
.magazine-two #content-masonry article.post, .magazine-two #content-masonry article.page, .magazine-two .pad-container, .with-masonry.magazine-two #breadcrumbs {
		padding-left: <?php echo esc_html( round($fluida_elementpadding/2, 2) ) ?>%; 
		padding-right: <?php echo esc_html( round($fluida_elementpadding/2, 2) ) ?>%; }
.magazine-three #content-masonry article.post, .magazine-three #content-masonry article.page, .magazine-three .pad-container, .with-masonry.magazine-three #breadcrumbs {
		padding-left: <?php echo esc_html( round($fluida_elementpadding/3, 2) ) ?>%; 
		padding-right: <?php echo esc_html( round($fluida_elementpadding/3, 2) ) ?>%; }
article.post .post-thumbnail-container, article.page .post-thumbnail-container { 
		margin-left: -<?php echo esc_html( round($fluida_elementpadding * 1.5, 2) ) ?>%; 
		margin-right: -<?php echo esc_html( round($fluida_elementpadding * 1.5, 2) ) ?>%; 
		width: <?php echo esc_html( (100 + (int)$fluida_elementpadding * 3) ); ?>%; }

<?php
/////////// HEADER LAYOUT ///////////
?>
#header-container, #header-container .menu-search-animated, #sheader, .identity
											{ height:<?php echo esc_html($fluida_menuheight) ?>px; 
											  line-height:<?php echo esc_html($fluida_menuheight) ?>px; } 
#access div > ul > li > a 					{ line-height:<?php echo intval( (int)$fluida_menuheight - 2 ) ?>px; }
#site-title span a 							{ line-height:<?php echo $fluida_menuheight ?>px; }
#branding .header-image 					{ height: <?php echo esc_html($fluida_headerheight) ?>px; }
<?php if (! display_header_text() ) { ?> 
	#site-title 							{ display: none; } 
<?php }; ?>
<?php if ( esc_html($fluida_menustyle) ) { ?>
	#header-container 						{ position: fixed; top: 0; box-shadow: 0 0 3px rgba(0,0,0,0.2); }
	body 									{ margin-top: <?php echo esc_html($fluida_menuheight) ?>px; }
<?php }; 
	if ( is_admin_bar_showing() && esc_html($fluida_menustyle) ) { ?>
    #header-container 						{top: 32px; }
<?php }
 // end </style>

	$fluida_custom_styling = ob_get_contents();
	ob_end_clean();
	return $fluida_custom_styling;
} // fluida_custom_styles()


/* 
 * Dynamic styles for the admin MCE Editor 
 */
function fluida_custom_editor_styles() {
	header( 'Content-type: text/css' );
	$fluids = cryout_get_option();
	foreach ($fluids as $key => $value) { ${"$key"} = $value; }
		
	switch ($fluida_sitelayout) {
		case '1c':
			$fluida_primarysidebar = $fluida_secondarysidebar = 0;
			break;
		case '2cSl':
			$fluida_secondarysidebar = 0;
			break;
		case '2cSr':
			$fluida_primarysidebar = 0;
			break;
		default:
			break;
	}
	$content_body = floor( (int)$fluida_sitewidth - ((int)$fluida_primarysidebar + (int)$fluida_secondarysidebar));

	ob_start();
?>
body.mce-content-body { 
	max-width: <?php echo esc_html($content_body); ?>px; 
	font-family: <?php echo cryout_font_select( $fluida_fgeneral, $fluida_fgeneralgoogle ) ?>; 
	font-size: <?php echo esc_html($fluida_fgeneralsize) ?>; font-weight: <?php echo esc_html($fluida_fgeneralweight) ?>; 
	line-height: <?php echo esc_html( (float)$fluida_lineheight ) ?>;
	color: <?php echo esc_html($fluida_sitetext); ?>;
	background-color: <?php echo esc_html($fluida_contentbackground) ?>	}
<?php
$font_root = 260; // headings font size root
for ( $i=1; $i<=6; $i++ ) {
	$size = round( ($font_root-(30*$i))/100 * (preg_replace("/[^\d]/","",esc_html($fluida_fheadingssize))/100), 5 ); ?> 
.mce-content-body h<?php echo $i ?> { 
	font-size: <?php echo $size ?>em; } <?php 
} //for ?>
.mce-content-body h1, .mce-content-body h2, .mce-content-body h3, .mce-content-body h4, .mce-content-body h5, .mce-content-body h6 { 
	font-family: <?php echo cryout_font_select( $fluida_fheadings, $fluida_fheadingsgoogle ) ?>; 
	font-weight: <?php echo esc_html($fluida_fheadingsweight) ?>; }

.mce-content-body blockquote::before, .mce-content-body blockquote::after {
	color: rgba(<?php echo cryout_hex2rgb( esc_html($fluida_sitetext) ) ?>,0.1); }

.mce-content-body a 		{ color: <?php echo esc_html($fluida_accent1); ?>; }
.mce-content-body a:hover	{ color: <?php echo esc_html($fluida_accent2); ?>; }

.mce-content-body code	{ background-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }
.mce-content-body pre		{ border-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?>; }

.mce-content-body select, .mce-content-body input[type], .mce-content-body textarea {
	color: <?php echo esc_html($fluida_sitetext); ?>; 
	background-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,10)) ?>;
	border-color: <?php echo esc_html(cryout_hexdiff($fluida_contentbackground,17)) ?> }

.mce-content-body p, .mce-content-body ul, .mce-content-body ol, .mce-content-body dd,
.mce-content-body pre, .mce-content-body hr { margin-bottom: <?php echo esc_html($fluida_paragraphspace) ?>; }
.mce-content-body p { text-indent: <?php echo esc_html($fluida_parindent) ?>;}

<?php // end </style>
	$fluida_custom_styling = ob_get_contents();
	ob_end_clean();
	echo $fluida_custom_styling;
} // fluida_custom_editor_styles()


/* FIN */
