<?php
/**
 * The template for displaying Category Archive pages.
 *
 * @package Fluida
 */

get_header(); ?>

		<div id="container" class="<?php echo fluida_get_layout_class(); ?>">
			<main id="main" role="main" <?php cryout_schema_microdata('main'); ?>>
			<?php cryout_before_content_hook(); ?>
			
			<?php if ( have_posts() ) : ?>

				<header class="category-header pad-container" <?php cryout_schema_microdata('element'); ?>>
					<h1 class="page-title" <?php cryout_schema_microdata('entry-title'); ?>><?php
						printf( __( 'Category Archives: %s', 'fluida' ), '<strong>' . single_cat_title( '', false ) . '</strong>' );
					?></h1>

					<?php
						$category_description = category_description();
						if ( ! empty( $category_description ) )
							echo apply_filters( 'category_archive_meta', '<div class="category-archive-meta"' . cryout_schema_microdata('text', 0) . '>' . $category_description . '</div>' );
					?>
				</header>
				<div id="content-masonry">

				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php
						/* Include the Post-Format-specific template for the content.
						 * If you want to overload this in a child theme then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'content/content', get_post_format() );
					?>

				<?php endwhile; ?>
				</div><!--content-masonry-->
				<?php 
				fluida_pagination(); 

			else : 

				get_template_part( 'content/content', 'notfound' );
				?><div id="content-masonry"></div><?php
			
			endif; ?>
			
			<?php cryout_after_content_hook(); ?>
			</main><!-- #main -->
		<?php fluida_get_sidebar(); ?>
		</div><!-- #container -->

<?php get_footer(); ?>
