<?php
/**
 * The default template for displaying content
 *
 * @package Fluida
 */

$fluids = cryout_get_option( array('fluida_excerptarchive', 'fluida_excerptsticky', 'fluida_excerpthome') );

?><?php cryout_before_article_hook(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); cryout_schema_microdata('article'); ?>>
	<?php cryout_featured_hook(); ?>
	
	<header class="entry-header">	
	<?php cryout_post_title_hook(); ?>		
			
		<h2 class="entry-title"  <?php cryout_schema_microdata('entry-title'); ?>>
			<a href="<?php the_permalink(); ?>" rel="bookmark" <?php cryout_schema_microdata('url'); ?>>
				<?php the_title(); ?>
			</a>
		</h2>
		<div class="entry-meta">
			<?php cryout_post_meta_hook(); ?>
		</div><!-- .entry-meta -->	
			
	</header><!-- .entry-header -->
		
	<?php cryout_post_before_content_hook(); ?>
	<?php if ( is_archive() || is_search() ) : // Display excerpts for archives and search. ?>
			
		<?php if ($fluids['fluida_excerptarchive'] != "full" ){ ?>
						
			<div class="entry-summary" <?php cryout_schema_microdata('entry-summary'); ?>>
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
			
			<footer class="post-continue-container">
				<?php cryout_post_excerpt_hook(); ?>
			</footer>
						
		<?php } else { ?>
						
			<div class="entry-content" <?php cryout_schema_microdata('entry-content'); ?>>
				<?php the_content(); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'fluida' ), 'after' => '</div>' ) ); ?>
			</div><!-- .entry-content --> 
						
		<?php }   ?>
			
	<?php else :
		
			if (is_sticky() && $fluids['fluida_excerptsticky'] == "full") { $sticky_test = 1; } 
				else { $sticky_test = 0; }
			if ($fluids['fluida_excerpthome'] != "full" && $sticky_test == 0){ ?>
					
				<div class="entry-summary" <?php cryout_schema_microdata('entry-summary'); ?>>
					<?php the_excerpt(); ?>
				</div><!-- .entry-summary -->	
				<footer class="post-continue-container">
					<?php cryout_post_excerpt_hook(); ?>
				</footer>
						
			<?php } else { ?>
				
				<div class="entry-content" <?php cryout_schema_microdata('entry-content'); ?>>
					<?php the_content(); ?>
					<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'fluida' ), 'after' => '</div>' ) ); ?>
				</div><!-- .entry-content --> 
						
			<?php }  

	endif; ?>
					
<?php cryout_post_after_content_hook();  ?>	
</article><!-- #post-<?php the_ID(); ?> -->
	
<?php cryout_after_article_hook(); ?>