<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 *
 * @package Fluida
 */

get_header(); ?>

		<div id="container" class="<?php echo fluida_get_layout_class(); ?>">
			<main id="main" role="main" <?php cryout_schema_microdata('main'); ?>>
			<?php cryout_before_content_hook(); ?>
			
			<?php if ( have_posts() ) : ?>

				<header class="arhive-header pad-container" <?php cryout_schema_microdata('element'); ?>>
					<h1 class="page-title" <?php cryout_schema_microdata('entry-title'); ?>>
						<?php if ( is_day() ) : ?>
							<?php printf( __( 'Daily Archives: %s', 'fluida' ), '<strong>' . get_the_date() . '</strong>' ); ?>
						<?php elseif ( is_month() ) : ?>
							<?php printf( __( 'Monthly Archives: %s', 'fluida' ), '<strong>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'fluida' ) ) . '</strong>' ); ?>
						<?php elseif ( is_year() ) : ?>
							<?php printf( __( 'Yearly Archives: %s', 'fluida' ), '<strong>' . get_the_date( _x( 'Y', 'yearly archives date format', 'fluida' ) ) . '</strong>' ); ?>
						<?php else : ?>
							<?php _e( 'Blog Archives', 'fluida' ); ?>
						<?php endif; ?>
					</h1>
				</header>
				
				<div id="content-masonry">
				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php
						/* Include the Post-Format-specific template for the content.
						 * If you want to overload this in a child theme then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'content/content', get_post_format() );
					?>

				<?php endwhile; ?>
				</div><!--content-masonry-->
				<?php 
				fluida_pagination(); 

			else : 
			
				get_template_part( 'content/content', 'notfound' );
				?><div id="content-masonry"></div><?php
			
			endif; ?>
			
			<?php cryout_after_content_hook(); ?>
			</main><!-- #main -->
		<?php fluida_get_sidebar(); ?>
		</div><!-- #container -->


<?php get_footer(); ?>