<?php
/**
 * The Header
 *
 * Displays all of the <head> section and everything up till <main>
 *
 * @package Fluida
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<?php cryout_meta_hook(); ?>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php
		cryout_header_hook();
		wp_head();
	?>
</head>

<body <?php body_class(); cryout_schema_microdata('body');?>>
<?php cryout_body_hook(); ?>
	<header id="header" <?php cryout_schema_microdata('header') ?>>
		<nav id="mobile-menu"> 
			<span id="nav-cancel"><i class="icon-cancel"></i></span>
			<?php cryout_mobilemenu_hook(); ?>
		</nav>
		<div id="header-inside">
			<div id="branding" role="banner" >
				<div id="branding-inside">
					<div id="header-container">
					<?php cryout_branding_hook();?>
					
						<a id="nav-toggle"><span>&nbsp;</span></a>
						<nav id="access" role="navigation"  aria-label="Primary Menu" <?php cryout_schema_microdata('menu'); ?>>
							<?php cryout_access_hook();?>
						</nav><!-- #access -->
					
					</div><!-- #header-container -->
				</div><!-- #branding-inside -->
			<?php cryout_headerimage_hook(); ?>
			</div><!-- #branding -->
		</div><!-- #header-inside -->	
	</header><!-- #header -->

	<?php cryout_breadcrumbs_hook();?>

	<div id="content">
	<?php cryout_main_hook(); ?>
		