<?php
/**
 * Core theme functions
 *
 * @package Fluida
 */

/**
 * Header image handler (via div with background image)
 */
add_action ( 'cryout_headerimage_hook', 'fluida_header_image', 99 );
if ( ! function_exists( 'fluida_header_image' ) ) :
function fluida_header_image() {
	$limit = 0.75;
	$fluida_fheader = cryout_get_option( 'fluida_fheader' );
	$fluida_headerh = floor( cryout_get_option( 'fluida_headerheight' ) * $limit );
	$fluida_headerw = floor( cryout_get_option( 'fluida_sitewidth' ) * $limit );

	// Check if this is a post or page, if it has a thumbnail, and if it's a big one
	global $post;

	if ( get_header_image() != '' ) { $header_image = get_header_image(); }
	if ( is_singular() && has_post_thumbnail( $post->ID ) && $fluida_fheader &&
		( $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'fluida-header' ) )
		 ) :
			if ( ( absint($image[1]) >= $fluida_headerw ) && ( absint($image[2]) >= $fluida_headerh ) ) {
				// 'header' image is large enough
				$header_image = $image[0];
			} else {
				// 'header' image too small, try 'full' image instead
				$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
				if ( ( absint($image[1]) >= $fluida_headerw ) && ( absint($image[2]) >= $fluida_headerh ) ) {
					// 'full' image is large enough
					$header_image = $image[0];
				} else {
					// even 'full' image is too small, don't return an image
					//$header_image = false;
				}
			}
	endif;

	if ( ! empty( $header_image ) ):?>
			<div class="header-image" <?php echo cryout_echo_bgimage( $header_image ) ?>></div>
			<img class="header-image" alt="" src="<?php echo $header_image; ?>" />
			<?php cryout_header_widget_hook(); ?>
	<?php endif;
} // fluida_header_image()
endif;


/**
 * Adds title and description to header
 * Used in header.php
*/
if ( ! function_exists( 'fluida_title_and_description' ) ) :
function fluida_title_and_description() {

	$fluids = cryout_get_option( array( 'fluida_logoupload', 'fluida_siteheader' ) );

	if ( in_array( $fluids['fluida_siteheader'], array( 'logo', 'both' ) ) ) {
		echo fluida_logo_helper( $fluids['fluida_logoupload'] );
	}
	if ( in_array( $fluids['fluida_siteheader'], array( 'title', 'both' ) ) ) {
		$heading_tag = ( is_home() || is_front_page() ) ? 'h1' : 'div';
		echo '<div id="site-text">';
		echo '<' . $heading_tag . cryout_schema_microdata( 'site-title', 0 ) . ' id="site-title">';
		echo '<span> <a href="' . esc_url( home_url( '/' ) ) . '" title="' . esc_attr( get_bloginfo( 'description' ) ) . '" rel="home">' . get_bloginfo( 'name' ) . '</a> </span>';
		echo '</' . $heading_tag . '>';
		echo '<span id="site-description" ' . cryout_schema_microdata( 'site-description', 0 ) . ' >' . get_bloginfo( 'description' ) . '</span>';
		echo '</div>';
	}
} // fluida_title_and_description()
endif;
add_action ( 'cryout_branding_hook', 'fluida_title_and_description' );

function fluida_logo_helper( $fluida_logo ) {
	if ( function_exists( 'the_custom_logo' ) ) {
		// WP 4.5+
		$wp_logo = str_replace( 'class="custom-logo-link"', 'id="logo" class="custom-logo-link" alt="'.esc_attr( get_bloginfo( 'name', 'display' ) ).'" title="'.esc_attr( get_bloginfo( 'name', 'display' ) ).'"', get_custom_logo() );
		if ( ! empty( $wp_logo ) ) return '<div class="identity">' . $wp_logo . '</div>';
	} else {
		// older WP
		if ( ! empty( $fluida_logo ) ) :
			$img = wp_get_attachment_image_src( $fluida_logo, 'full' );
			return '<div class="identity"><a id="logo" href="'.esc_url( home_url( '/' ) ).'" ><img title="'.esc_attr( get_bloginfo( 'name', 'display' ) ).'" alt="'.esc_attr( get_bloginfo( 'name', 'display' ) ).'" src="' . $img[0] . '" /></a></div>';
		endif;
	}
	return '';
} // fluida_logo_helper()

/**
 * Fluida back to top button
 * Creates div for js
*/
if ( ! function_exists( 'fluida_back_top' ) ) :
function fluida_back_top() {
	echo '<div id="toTop"><i class="icon-back2top"></i> </div>';
} // fluida_back_top()
endif;
add_action ( 'cryout_footer_hook', 'fluida_back_top' );


/**
 * Creates pagination for blog pages.
 */
if ( ! function_exists( 'fluida_pagination' ) ) :
function fluida_pagination( $pages = '', $range = 2, $prefix ='' ) {
	$pagination = cryout_get_option( 'fluida_pagination' );
	if ( $pagination && function_exists( 'the_posts_pagination' ) ):
		the_posts_pagination( array(
			'prev_text' => '<i class="icon-left-dir"></i>',
			'next_text' => '<i class="icon-right-dir"></i>',
			'mid_size' => $range
		) );
	else:
		//posts_nav_link();
		fluida_content_nav( 'nav-old-below' );
	endif;

} // fluida_pagination()
endif;

/**
 *
 */
if ( ! function_exists( 'fluida_nextpage_links' ) ) :
function fluida_nextpage_links( $defaults ) {
	$args = array(
		'link_before'      => '<em>',
		'link_after'       => '</em>',
	);
	$r = wp_parse_args( $args, $defaults );
	return $r;
} // fluida_nextpage_links()
endif;
add_filter( 'wp_link_pages_args', 'fluida_nextpage_links' );


/**
 * Footer Hook
 */
add_action( 'cryout_master_footer_hook', 'fluida_master_footer' );
function fluida_master_footer() {
	$fluida_theme = wp_get_theme();
	do_action( 'cryout_footer_hook' );
	echo '<div id="site-copyright">' . cryout_get_option( 'fluida_copyright' ) . '</div>';
	echo '<div style="display:block;float:right;clear: right;font-size: .9em;">' . __( "Powered by", "fluida" ) .
		'<a target="_blank" href="' . esc_html( $fluida_theme->get( 'ThemeURI' ) ) . '" title="';
	echo 'Fluida WordPress Theme by ' . 'Cryout Creations"> ' . 'Fluida' .'</a> &amp; <a target="_blank" href="' . esc_url( "http://wordpress.org/ ");
	echo '" title="' . esc_attr( "Semantic Personal Publishing Platform", "fluida") . '"> ' . sprintf( " %s.", "WordPress" ) . '</a></div>';
}

/*
 * Sidebar handler
*/
if ( ! function_exists( 'fluida_get_sidebar' ) ) :
function fluida_get_sidebar() {
	$fluida_sitelayout = cryout_get_option( 'fluida_sitelayout' );
	switch($fluida_sitelayout) {

		case '2cSl':
			get_sidebar( 'left' );
		break;

		case '2cSr':
			get_sidebar( 'right' );
		break;

		case '3cSl' : case '3cSr' : case '3cSs' :
			get_sidebar( 'left' );
			get_sidebar( 'right' );
		break;

		default:
		break;
	}
} // fluida_get_sidebar()
endif;

/*
 * General layout class
 */
if ( ! function_exists( 'fluida_get_layout_class' ) ) :
function fluida_get_layout_class() {
	$fluida_sitelayout = cryout_get_option( 'fluida_sitelayout' );

	/*  If page template, return the page template's layout */
	global $fluida_template_layout;
	if ( isset( $fluida_template_layout ) ) return $fluida_template_layout;

	/*  If not, return the general layout */
	switch( $fluida_sitelayout ) {
		case '2cSl': return "two-columns-left"; break;
		case '2cSr': return "two-columns-right"; break;
		case '3cSl': return "three-columns-left"; break;
		case '3cSr' : return "three-columns-right"; break;
		case '3cSs' : return "three-columns-sided"; break;
		case '1c':
		default: return "one-column"; break;
	}
} // fluida_get_layout_class()
endif;

/**
* Checks the browser agent string for mobile ids and adds "mobile" class to body if true
* @return array list of classes.
*/
function fluida_mobile_body_class( $classes ){
	$browser = ( ! empty( $_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
	$keys = 'mobile|android|mobi|tablet|ipad|opera mini|series 60|s60|blackberry';
	if ( preg_match( "/($keys)/i", $browser ) ) : $classes[] = 'mobile'; endif; // mobile browser detected
	return $classes;
} // fluida_mobile_body_class()
add_filter( 'body_class', 'fluida_mobile_body_class');


/**
* Creates breadcrumbs with page sublevels and category sublevels.
* Hooked in master hook
*/
if ( ! function_exists( 'fluida_breadcrumbs' ) ) :
function fluida_breadcrumbs() {
	$fluids = cryout_get_option( 'fluida_frontpage' );

	$separator = '<i class="icon-angle-right"></i>'; 	// separator between crumbs
	$home = '<a href="' . home_url() . '" title="' . __( 'Home', 'fluida' ) . '"><i class="icon-homebread"></i></a>'; // text for the 'Home' link
	$showCurrent = 1; 									// whether to show current post/page title in breadcrumbs
	$before = '<span class="current">'; 				// tag before the current crumb
	$after = '</span>'; 								// tag after the current crumb

	global $post;
	$homeLink = home_url();
	if ( is_front_page() ) { return; }	// don't display breadcrumbs on the homepage (yet)

	// let's begin
	echo '<div id="breadcrumbs-container" class="' . fluida_get_layout_class() . '"><div id="breadcrumbs-container-inside"><div id="breadcrumbs"> <nav id="breadcrumbs-nav" ' . cryout_schema_microdata( 'breadcrumbs', 0 ) . '>' . $home . $separator . ' ';

    if ( is_category() ) {
		// category section
		$thisCat = get_category( get_query_var( 'cat' ), false );
		if ( ! empty( $thisCat->parent ) ) echo get_category_parents( $thisCat->parent, TRUE, ' ' . $separator . ' ' );
		echo $before . __( 'Archive for category', 'fluida' ) . ' "' . single_cat_title( '', false ) . '"' . $after;
    } elseif ( is_search() ) {
		// search section
		echo $before . __( 'Search results for', 'fluida' ).' "' . get_search_query() . '"' . $after;
    } elseif ( is_day() ) {
		// daily archive
		echo '<a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . '</a> ' . $separator . ' ';
		echo '<a href="' . get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) . '">' . get_the_time( 'F' ) . '</a> ' . $separator . ' ';
		echo $before . get_the_time( 'd' ) . $after;
    } elseif ( is_month() ) {
		// monthly archive
		echo '<a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . '</a> ' . $separator . ' ';
		echo $before . get_the_time( 'F' ) . $after;
    } elseif ( is_year() ) {
		// yearly archive
		echo $before . get_the_time( 'Y' ) . $after;
    } elseif ( is_single() && ! is_attachment() ) {
		// single post
		if ( get_post_type() != 'post' ) {
			$post_type = get_post_type_object( get_post_type() );
			$slug = $post_type->rewrite;
			echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';
			if ( $showCurrent ) echo ' ' . $separator . ' ' . $before . get_the_title() . $after;
		} else {
			$cat = get_the_category(); if ( isset( $cat[0] ) ) { $cat = $cat[0]; } else { $cat = false; }
			if ( $cat ) { $cats = get_category_parents( $cat, TRUE, ' ' . $separator . ' '); } else { $cats = false; }
			if ( ! $showCurrent && $cats ) $cats = preg_replace( "#^(.+)\s$separator\s$#", "$1", $cats );
			echo $cats;
			if ( $showCurrent ) echo $before . get_the_title() . $after;
		}
    } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' && ! is_404() ) {
		// some other single item
		$post_type = get_post_type_object( get_post_type() );
		echo $before . $post_type->labels->singular_name . $after;
	} elseif ( is_attachment() ) {
		// attachment section
		$parent = get_post( $post->post_parent );
		$cat = get_the_category( $parent->ID ); if ( isset( $cat[0] ) ) { $cat = $cat[0]; } else { $cat = false; }
		if ( $cat ) echo get_category_parents( $cat, TRUE, ' ' . $separator . ' ');
		echo '<a href="' . get_permalink( $parent ) . '">' . $parent->post_title . '</a>';
		if ( $showCurrent ) echo ' ' . $separator . ' ' . $before . get_the_title() . $after;
    } elseif ( is_page() && ! $post->post_parent ) {
		// parent page
		if ( $showCurrent ) echo $before . get_the_title() . $after;
    } elseif ( is_page() && $post->post_parent ) {
		// child page
		$parent_id  = $post->post_parent;
		$breadcrumbs = array();
		while ( $parent_id ) {
			$page = get_page( $parent_id );
			$breadcrumbs[] = '<a href="' . get_permalink( $page->ID ) . '">' . get_the_title( $page->ID ) . '</a>';
			$parent_id  = $page->post_parent;
		}
		$breadcrumbs = array_reverse( $breadcrumbs );
		for ( $i = 0; $i < count( $breadcrumbs ); $i++ ) {
			echo $breadcrumbs[$i];
			if ( $i != count( $breadcrumbs ) - 1 ) echo ' ' . $separator . ' ';
		}
		if ( $showCurrent ) echo ' ' . $separator . ' ' . $before . get_the_title() . $after;
    } elseif ( is_tag() ) {
		// tags archive
		echo $before . __( 'Posts tagged', 'fluida' ).' "' . single_tag_title( '', false ) . '"' . $after;
    } elseif ( is_author() ) {
		// author archive
		global $author;
		$userdata = get_userdata( $author );
		echo $before . __( 'Articles posted by', 'fluida' ). ' ' . $userdata->display_name . $after;
    } elseif ( is_404() ) {
		// 404
		echo $before . __( 'Not Found', 'fluida' ) . $after;
    } elseif ( get_post_format() ) {
		// post format
		echo $before . '"' . ucwords( get_post_format() ) . '" ' . __( 'Post format', 'fluida' ) . $after;
    }

    if ( get_query_var( 'paged' ) ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __( 'Page', 'fluida' ) . ' ' . get_query_var( 'paged' );
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }

    echo '</nav></div></div></div><!-- breadcrumbs -->';
} // fluida_breadcrumbs()
endif;


/**
 * Adds searchboxes to the appropriate menu location
 * Hooked in master hook
 */
if ( ! function_exists( 'cryout_search_menu' ) ) :
function cryout_search_menu( $items, $args ) {
$options = cryout_get_option( array( 'fluida_searchboxmain', 'fluida_searchboxfooter' ) );
	if( $args->theme_location == 'primary' && $options['fluida_searchboxmain'] ) {
		$container_class = 'menu-main-search';
		$items .= "<li class='" . $container_class . " menu-search-animated'><i class='search-icon'></i>" . get_search_form( false ) . " </li>";
	}
	if( $args->theme_location == 'footer' && $options['fluida_searchboxfooter'] ) {
		$container_class = 'menu-footer-search';
		$items .= "<li class='" . $container_class . "'>" . get_search_form( false ) . "</li>";
	}
	return $items;
} // cryout_search_mainmenu()
endif;

/* cryout_schema_microdata() moved to framework in 0.9.9/0.5.6 */

/* Normalizes tags widget font when needed */
function fluida_normalizetags( $tags_html ) {
	$fluida_normalizetags = cryout_get_option( 'fluida_normalizetags' );
	if ( $fluida_normalizetags ) return preg_replace( '/font-size:.*?;/i', '', $tags_html ); else return $tags_html;
};
add_filter( 'wp_generate_tag_cloud', 'fluida_normalizetags' );


/**
* Master hook to bypass customizer options
*/
if ( ! function_exists( 'fluida_master_hook' ) ) :
function fluida_master_hook() {
	$fluida_interim_options = cryout_get_option( array(
		'fluida_breadcrumbs',
		'fluida_searchboxmain',
		'fluida_searchboxfooter',
		'fluida_comlabels')
	);
	if ( $fluida_interim_options['fluida_breadcrumbs'] )  add_action( 'cryout_breadcrumbs_hook', 'fluida_breadcrumbs' );
	if ( $fluida_interim_options['fluida_searchboxmain'] || $fluida_interim_options['fluida_searchboxfooter'] ) add_filter( 'wp_nav_menu_items', 'cryout_search_menu', 10, 2);

	if ( $fluida_interim_options['fluida_comlabels'] == 1 ) {
		add_filter( 'comment_form_default_fields', 'fluida_comments_form' );
		add_filter( 'comment_form_field_comment', 'fluida_comments_form_textarea' );
	}

	if ( cryout_get_option( 'fluida_socials_header' ) ) 		add_action( 'cryout_header_socials_hook', 'fluida_socials_menu_header', 30 );
	if ( cryout_get_option( 'fluida_socials_footer' ) ) 		add_action( 'cryout_footer_hook', 'fluida_socials_menu_footer', 17 );
	if ( cryout_get_option( 'fluida_socials_left_sidebar' ) ) 	add_action( 'cryout_before_primary_widgets_hook', 'fluida_socials_menu_left', 5 );
	if ( cryout_get_option( 'fluida_socials_right_sidebar' ) ) 	add_action( 'cryout_before_secondary_widgets_hook', 'fluida_socials_menu_right', 5 );
};
endif;
add_action( 'wp', 'fluida_master_hook' );

/* FIN */
