<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Cryout Creations
 * @subpackage Mantra
 */
get_header();
if ($mantra_frontpage=="Enable" && is_front_page() ):
	mantra_frontpage_generator();
	if ($mantra_frontposts=="Enable"): get_template_part('content/content','frontpage'); endif;
else:
?>
		<section id="container">

			<div id="content" role="main">

<?php cryout_before_content_hook(); ?><?php if ( have_posts() ) : ?>

				<?php mantra_content_nav( 'nav-above' ); ?>

				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'content/content', get_post_format() ); ?>

				<?php endwhile; ?>

					<?php if($mantra_pagination=="Enable") mantra_pagination(); else mantra_content_nav( 'nav-below' ); ?>

			<?php else : ?>

				<article id="post-0" class="post no-results not-found">
					<header class="entry-header">
						<h1 class="entry-title"><?php _e( 'Nothing Found', 'mantra' ); ?></h1>
					</header><!-- .entry-header -->

					<div class="entry-content">
						<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'mantra' ); ?></p>
						<?php get_search_form(); ?>
					</div><!-- .entry-content -->
				</article><!-- #post-0 -->

			<?php endif; ?><?php cryout_after_content_hook(); ?>

			</div><!-- #content -->
	<?php get_sidebar(); ?>
		</section><!-- #container -->
<?php
endif;

get_footer(); 