<?php
/**
 * Customizer settings and other theme related settings (fonts arrays, widget areas)
 *
 * @package Roseta
 */

/* active_callback for controls that depend on other controls' values */
function roseta_conditionals( $control ) {

	$conditionals = array(
		array(
			'id'	=> 'theme_lpsliderimage',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidertitle',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidertext',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta1text',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta1link',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta2text',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidercta2link',
			'parent'=> 'theme_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpslidershortcode',
			'parent'=> 'theme_lpslider',
			'value'	=> 2,
		),
		array(
			'id'	=> 'theme_lpsliderserious',
			'parent'=> 'theme_lpslider',
			'value' => 4,
		),
		array(
			'id'	=> 'theme_lpposts',
			'parent'=> 'theme_landingpage',
			'value'	=> 1,
		),
		array(
			'id'	=> 'theme_lpposts_more',
			'parent'=> 'theme_lpposts',
			'value'	=> 1,
		),
		array(
			'id'    => 'theme_lppostslayout',
			'parent'=> 'theme_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'theme_lppostscount',
			'parent'=> 'theme_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'theme_lppostscat',
			'parent'=> 'theme_lpposts',
			'value' => 1,
		),
	);

	foreach ($conditionals as $elem) {
		if ( $control->id == sprintf( '%1$s_settings[%2$s]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), $elem['id'] ) && 
			$control->manager->get_setting( sprintf( '%1$s_settings[%2$s]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), $elem['parent'] ) )->value() == $elem['value'] 
		) return true;
	};

	// handle landing page hint
	if ( ( $control->id == sprintf( '%1$s_settings[%2$s_landingpage_notice]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) ) && 
		('posts' == get_option('show_on_front')) 
	) return true;
	
	// handle landing page slider banner hint
	if ( ( $control->id == sprintf( '%1$s_settings[%2$s_headerorbannerhint]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) ) && 
			( $control->manager->get_setting( sprintf( '%1$s_settings[%2$s_landingpage]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) )->value() == 1 ) && 
			( $control->manager->get_setting( sprintf( '%1$s_settings[%2$s_lpslider]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) )->value() == 1 ) 
	) return true;

    return false;

} // roseta_conditionals()

$roseta_big = array(

/************* general info ***************/

'info_sections' => array(
	'cryoutspecial-about-theme' => array(
		'title' => apply_filters( 'cryout_about_theme_name', sprintf( __( 'About %s', 'cryout' ), cryout_sanitize_tnl(_CRYOUT_THEME_NAME) ) ),
		'desc' => '<img src=" ' . get_template_directory_uri() . '/admin/images/logo-about-header.png" ><br>',
		'button' => TRUE,
		'button_label' => __( 'Get Plus', 'cryout' ),
	),
), // info_sections

'info_settings' => array(
	'plus_link' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_plus_link', sprintf( '<a class="customizer-plus-link" href="https://www.cryoutcreations.eu/wordpress-themes/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Upgrade to Plus', 'cryout' ) ) ),
		'desc' =>  apply_filters( 'cryout_about_theme_plus_desc', sprintf( __('Find out what features you\'re missing out on and how the Plus version of %1$s can improve your site.', 'cryout'), cryout_sanitize_tnl( _CRYOUT_THEME_NAME ) ) . '<br><br><img src=" ' . get_template_directory_uri() . '/admin/images/features.png" >' ),
		'section' => 'cryoutspecial-about-theme',
	),
	'support_link_faqs' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_docs_link', sprintf( '<a href="https://www.cryoutcreations.eu/wordpress-themes/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Read the Docs', 'cryout' ) ) ),
		'desc' =>  '',
		'section' => 'cryoutspecial-about-theme',
	),
	'support_link_forum' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_forum_link', sprintf( '<a href="https://www.cryoutcreations.eu/forums/f/wordpress/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Browse the Forum', 'cryout' ) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
/*	'premium_support_link' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_support_link', sprintf( '<a href="https://www.cryoutcreations.eu/priority-support" target="_blank">%s</a>', __( 'Priority Support', 'cryout' ) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),*/
	'rating_url' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_review_link', sprintf( '<a href="https://wordpress.org/support/view/theme-reviews/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '#postform" target="_blank">%s</a>', sprintf( __( 'Rate %s on WordPress.org', 'cryout' ) , cryout_sanitize_tnl(_CRYOUT_THEME_NAME) ) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
	'management' => array(
		'label' => '',
		'default' => apply_filters( 'cryout_about_theme_manage_link', sprintf( '<a href="themes.php?page=about-' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '-theme">%s</a>', __('Manage Theme Settings', 'cryout') ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
), // info_settings

'panel_overrides' => array(
	'background' => array(
        'title' => __( 'Background', 'cryout' ),
		'desc' => __( 'Background Settings.', 'cryout' ),
		'priority' => 50,
		'section' => 'cryoutoverride-theme_siteidentity',
		'replaces' => 'background_image',
		'type' => 'section',
	),
	'theme_header_section' => array(
		'title' => __( 'Header Image', 'cryout' ),
		'desc' => __( 'Header Image Settings.', 'cryout' ),
		'priority' => 50,
		'section' => 'cryoutoverride-theme_siteidentity',
		'replaces' => 'header_image',
		'type' => 'section',
	),
	'identity' => array(
		'title' => __( 'Site Identity', 'cryout' ),
		'desc' => '',
		'priority' => 50,
		'section' => 'cryoutoverride-theme_siteidentity',
		'replaces' => 'title_tagline',
		'type' => 'section',
	),
	'colors' => array(
		'section' => 'section',
		'replaces' => 'colors',
		'type' => 'remove',
	),

), // panel_overrides

/************* panels *************/

'panels' => array(

	array('id'=>'theme_siteidentity', 'title'=>__('Site Identity','roseta'), 'callback'=>'', 'identifier'=>'cryoutoverride-' ),
	array('id'=>'theme_layout_section', 'title'=>__('Layout','roseta'), 'callback'=>'' ),
	array('id'=>'theme_header_section', 'title'=>__('Header','roseta'), 'callback'=>'' ),
	array('id'=>'theme_landingpage', 'title'=>__('Landing Page','roseta'), 'callback'=>'' ),
	array('id'=>'theme_general_section', 'title'=>__('General','roseta') , 'callback'=>'' ),
	array('id'=>'theme_colors_section', 'title'=>__('Colors','roseta'), 'callback'=>'' ),
	array('id'=>'theme_text_section', 'title'=>__('Typography','roseta'), 'callback'=>'' ),
	array('id'=>'theme_post_section', 'title'=>__('Post Information','roseta') , 'callback'=>'' ),

), // panels

/************* sections *************/

'sections' => array(

	// layout
	array('id'=>'theme_generallayout', 'title'=>__('General Layout', 'roseta'), 'callback'=>'', 'sid'=>'theme_layout_section', 'priority'=>50 ),
	array('id'=>'theme_otherlayout', 'title'=>__('Other Layouts', 'roseta'), 'callback'=>'', 'sid'=>'theme_layout_section', 'priority'=>60 ),
	// header
	//array('id'=>'theme_siteheader', 'title'=>__('Header','roseta'), 'callback'=>'', 'sid'=> '', 'priority'=>52 ),
	array('id'=>'theme_headermenu', 'title'=>__('Menu','roseta'), 'callback'=>'', 'sid'=> 'theme_header_section', 'priority'=>10 ),
	array('id'=>'theme_headercontent', 'title'=>__('Content','roseta'), 'callback'=>'', 'sid'=> 'theme_header_section', 'priority'=>12 ),
	// landing page
	array('id'=>'theme_lpgeneral', 'title'=>__('Settings','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 10),
	array('id'=>'theme_lpslider', 'title'=>__('Slider','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 20),
	array('id'=>'theme_lpblocks1', 'title'=>__('Featured Icon Blocks','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 30 ),
	array('id'=>'theme_lpboxes1', 'title'=>__('Featured Boxes','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 40),
	array('id'=>'theme_lpboxes2', 'title'=>__('Featured Boxes 2','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 50),
	array('id'=>'theme_lptexts', 'title'=>__('Text Areas','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 60),
	array('id'=>'theme_lpfcontent', 'title'=>__('Featured Content','roseta'), 'callback'=>'', 'sid'=>'theme_landingpage', 'priority' => 70),
	// text
	array('id'=>'theme_fontfamily', 'title'=>__('General Font','roseta'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_fontheader', 'title'=>__('Header Fonts','roseta'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_fontcontent', 'title'=>__('Content Fonts','roseta'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_fontwidget', 'title'=>__('Widget Fonts','roseta'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	array('id'=>'theme_textformatting', 'title'=>__('Formatting','roseta'), 'callback'=>'', 'sid'=> 'theme_text_section'),
	// general
	array('id'=>'theme_contentstructure', 'title'=>__('Structure','roseta'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_contentgraphics', 'title'=>__('Decorations','roseta'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_headertitles', 'title'=>__('Header Titles','roseta'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_postimage', 'title'=>__('Content Images','roseta'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_searchbox', 'title'=>__('Search Box Locations','roseta'), 'callback'=>'', 'sid'=> 'theme_general_section'),
	array('id'=>'theme_socials', 'title'=>__('Social Icons','roseta'), 'callback'=>'', 'sid'=>'theme_general_section'),
	// colors
	array('id'=>'theme_colors', 'title'=>__('Content','roseta'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	array('id'=>'theme_colors_header', 'title'=>__('Header','roseta'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	array('id'=>'theme_colors_footer', 'title'=>__('Footer','roseta'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	array('id'=>'theme_colors_lp', 'title'=>__('Landing Page','roseta'), 'callback'=>'', 'sid'=> 'theme_colors_section'),
	// post info
	array('id'=>'theme_featured', 'title'=>__('Featured Image', 'roseta'), 'callback'=>'', 'sid'=>'theme_post_section', 'priority' => 10),
	array('id'=>'theme_metas_blog', 'title'=>__('Blog Metas','roseta'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 20),
	array('id'=>'theme_metas_single', 'title'=>__('Single Metas','roseta'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 20),
	array('id'=>'theme_excerpts', 'title'=>__('Excerpts','roseta'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 30),
	array('id'=>'theme_comments', 'title'=>__('Comments','roseta'), 'callback'=>'', 'sid'=> 'theme_post_section', 'priority' => 40),
	// misc
	array('id'=>'theme_misc', 'title'=>__('Miscellaneous','roseta'), 'callback'=>'', 'sid'=>'', 'priority' => 92 ),

	/*** developer options ***/
	//array('id'=>'theme_developer', 'title'=>__('[ Developer Options ]','roseta'), 'callback'=>'', 'sid'=>'', 'priority'=>101 ),

), // sections

/************ clone options *********/
'clones' => array (
	'theme_lpboxes' => 2,
),

/************* settings *************/

'options' => array (
	//////////////////////////////////////////////////// Layout ////////////////////////////////////////////////////
	array(
	// this option needs to always be first; its index is used in the page/post meta option !!!
	'id' => 'theme_sitelayout',
		'type' => 'radioimage',
		'label' => __('Main Layout','roseta'),
		'choices' => array(
			'1c' => array(
				'label' => __("One column (no sidebars)","roseta"),
				'url'   => '%s/admin/images/1c.png'
			),
			'2cSr' => array(
				'label' => __("Two columns, sidebar on the right","roseta"),
				'url'   => '%s/admin/images/2cSr.png'
			),
			'2cSl' => array(
				'label' => __("Two columns, sidebar on the left","roseta"),
				'url'   => '%s/admin/images/2cSl.png'
			),
			'3cSr' => array(
				'label' => __("Three columns, sidebars on the right","roseta"),
				'url'   => '%s/admin/images/3cSr.png'
			),
			'3cSl' => array(
				'label' => __("Three columns, sidebars on the left","roseta"),
				'url'   => '%s/admin/images/3cSl.png'
			),
			'3cSs' => array(
				'label' => __("Three columns, one sidebar on each side","roseta"),
				'url'   => '%s/admin/images/3cSs.png'
			),
		),
		'desc' => '',
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_layoutalign',
		'type' => 'select',
		'label' => __('Theme alignment','roseta'),
		'values' => array( 0, 1 ),
		'labels' => array( __('Wide','roseta'), __('Boxed','roseta') ),
		'desc' => "",
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_sitewidth',
		'type' => 'numberslider',
		'label' => __('Site Width','roseta'),
		'min' => 960, 'max' => 1920, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_primarysidebar',
		'type' => 'numberslider',
		'label' => __('Left Sidebar Width','roseta'),
		'min' => 200, 'max' => 600, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'theme_generallayout' ),
	array(
	'id' => 'theme_secondarysidebar',
		'type' => 'numberslider',
		'label' => __('Right Sidebar Width','roseta'),
		'min' => 200, 'max' => 600, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'theme_generallayout' ),

	// the other layouts
	array(
	'id' => 'theme_magazinelayout',
		'type' => 'radioimage',
		'label' => __('Posts Layout','roseta'),
		'choices' => array(
			1 => array(
				'label' => __("One column","roseta"),
				'url'   => '%s/admin/images/magazine-1col.png'
			),
			2 => array(
				'label' => __("Two columns","roseta"),
				'url'   => '%s/admin/images/magazine-2col.png'
			),
			3 => array(
				'label' => __("Three columns","roseta"),
				'url'   => '%s/admin/images/magazine-3col.png'
			),
		),
		'desc' => '',
	'section' => 'theme_otherlayout' ),
	array(
	'id' => 'theme_elementpadding',
		'type' => 'numberslider',
		'label' => __('Post/page padding','roseta'),
		'min' => 0,
		'max' => 10,
		'step' => 1,
		'um' => '%',
		'desc' => '',
	'section' => 'theme_otherlayout' ),

	array(
	'id' => 'theme_footercols',
		'type' => 'select',
		'label' => __("Footer Widgets Columns","roseta"),
		'values' => array(0, 1, 2, 3, 4),
		'labels' => array(
			__('All in a row','roseta'),
			__('1 Column','roseta'),
			__('2 Columns','roseta'),
			__('3 Columns','roseta'),
			__('4 Columns','roseta')
		),
		'desc' => '',
	'section' => 'theme_otherlayout' ),
	array(
	'id' => 'theme_footeralign',
		'type' => 'select',
		'values' => array( 0 , 1 ),
		'labels' => array( __("Default","roseta"), __("Center","roseta") ),
		'label' => __('Footer Widgets Alignment','roseta'),
		'desc' => "",
	'section' => 'theme_otherlayout' ),

	// Header-related hint to WP's Site Identity
	array(
	'id' => 'theme_headerhints',
		'type' => 'notice',
		'label' => '',
		'desc' => sprintf( __( 'Fine tune the visibility of these elements from the theme\'s %s','roseta' ), '<a data-type="section" data-id="cryout-theme_headercontent" class="cryout-customizer-focus"><strong>' . __('Header options', 'roseta') . ' &raquo;</strong></a>' ),
		'input_attrs' => array( 'class' => '' ),
		'priority' => 55,
		'addon' => TRUE, // this option gets added to built-in WordPress section
	'section' => 'title_tagline' ),
	array(
	'id' => 'theme_headerorbannerhint',
		'type' => 'notice',
		'label' => '',
		'desc' => sprintf( __( 'Configure the image currently visible on the homepage from the theme\'s options under %s','roseta' ), '<a data-type="section" data-id="cryout-theme_lpslider" class="cryout-customizer-focus"><strong>' . __('Landing Page > Slider > Banner Image', 'roseta') . ' &raquo;</strong></a>' ),
		'input_attrs' => array( 'class' => '' ),
		'priority' => 9,
		'active_callback' => 'roseta_conditionals',
		'addon' => TRUE, // this option gets added to built-in WordPress section
	'section' => 'header_image' ),

	// Header
	array(
	'id' => 'theme_menustyle',
		'type' => 'toggle',
		'values' => array( 0, 1 ),
		'label' => __('Fixed Menu','roseta'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menuheight',
		'type' => 'numberslider',
		'min' => 45,
		'max' => 200,
		'step' => 1,
		'um' => 'px',
		'label' => __('Menu Height','roseta'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menuposition',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Normal","roseta"), __("Over header image","roseta") ),
		'label' => __('Menu Position','roseta'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menualignment',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Boxed","roseta"), __("Wide","roseta") ),
		'label' => __('Menu Layout','roseta'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_menulayout',
		'type' => 'select',
		'values' => array( 0, 1, 2 ),
		'labels' => array( __("Left", "roseta"), __("Right","roseta"), __("Center","roseta") ),
		'label' => __('Menu Alignment','roseta'),
		'desc' => "",
	'section' => 'theme_headermenu' ),
	array(
	'id' => 'theme_siteheader',
		'type' => 'select',
		'label' => __('Site Header Content','roseta'),
		'values' => array( 'title', 'logo' , 'both' , 'empty' ),
		'labels' => array( __("Site Title","roseta"), __("Logo","roseta"), __("Logo & Site Title","roseta"), __("Empty","roseta") ),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_sitetagline',
		'type' => 'checkbox',
		'label' => __('Show Tagline','roseta'),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_identityhints',
		'type' => 'notice',
		'input_attrs' => array( 'class' => '' ),
		'label' => '',
		'desc' => sprintf( __( 'Edit the site\'s title, tagline and logo from the %s panel','roseta' ), '<a data-type="section" data-id="title_tagline" class="cryout-customizer-focus"><strong>' . __('Site Identity', 'roseta') . ' </strong></a>' ),
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_topsection',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Normal", "roseta"), __("Reversed","roseta"), ),
		'label' => __('Top Sections Order','roseta'),
		'desc' => "",
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerheight',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 800,
		'um' => 'px',
		'label' => __('Header Image Height','roseta'),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerheight_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","roseta"),
		//'active_callback' => 'roseta_conditionals',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerresponsive',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Cropped","roseta"), __("Contained","roseta") ),
		'label' => __('Header Image Behaviour','roseta'),
		'desc' => "",
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headercontentspacer2',
		'type' => 'spacer',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerwidgetwidth',
		'type' => 'select',
		'label' => __("Header Widget Width","roseta"),
		'values' => array( "100%" , "60%" , "50%" , "33%" , "25%" ),
		'desc' => '',
	'section' => 'theme_headercontent' ),
	array(
	'id' => 'theme_headerwidgetalign',
		'type' => 'select',
		'label' => __("Header Widget Alignment","roseta"),
		'values' => array( 'left' , 'center' , 'right' ),
		'labels' => array( __("Left","roseta"), __("Center","roseta"), __("Right","roseta") ),
		'desc' => '',
	'section' => 'theme_headercontent' ),

	//////////////////////////////////////////////////// Landing Page ////////////////////////////////////////////////////
	array(
	'id' => 'theme_landingpage',
		'type' => 'select',
		'label' => __('Landing Page','roseta'),
		'values' => array( 1, 0 ),
		'labels' => array( __("Enabled","roseta"), __("Disabled (use WordPress homepage)","roseta") ),
		'desc' => '',
	'section' => 'theme_lpgeneral' ),
	array(
	'id' => 'theme_landingpage_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => sprintf( __( "To activate the Landing Page, make sure to set the WordPress <strong>Front Page displays</strong> option to %s","roseta" ), "<a data-type='section' data-id='static_front_page' class='cryout-customizer-focus'><strong>" . __("use a static page", "roseta") . " &raquo;</strong></a>" ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpgeneral' ),
	array(
	'id' => 'theme_lpposts',
		'type' => 'select',
		'label' => __('Featured Content','roseta'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Static Page", "roseta"), __("Posts", "roseta"), __("Disabled", "roseta") ),
		'desc' => '',
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpfcontent' ),
	array(
	'id' => 'theme_lpposts_more',
		'type' => 'text',
		'label' => __( 'More Posts Label', 'roseta' ),
		'desc' => '',
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpfcontent' ),

	// slider
	array(
	'id' => 'theme_lpslider',
		'type' => 'select',
		'label' => __('Slider','roseta'),
		'values' => array( 4, 2, 1, 3, 0 ),
		'labels' => array(
			__("Serious Slider", "roseta"),
			__("Use Shortcode","roseta"),
			__("Banner Image","roseta"),
			__("Header Image","roseta"),
			__("Disabled","roseta")
		),
		'desc' => sprintf( __("To create an advanced slider, use our <a href='%s' target='_blank'>Serious Slider</a> plugin or any other slider plugin.","roseta"), 'https://wordpress.org/plugins/cryout-serious-slider/' ),
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpsliderimage',
		'type' => 'media-image',
		'label' => __('Banner Image','roseta'),
		'desc' => __('The default image can be replaced by setting a new banner image.', 'roseta'),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpsliderlink',
		'type' => 'url',
		'label' => __('Slider Link','roseta'),
		'desc' => '',
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidershortcode',
		'type' => 'text',
		'label' => __('Shortcode','roseta'),
		'desc' => __('Enter shortcode provided by slider plugin. The plugin will be responsible for the slider\'s appearance.','roseta'),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpsliderserious',
		'type' => 'select',
		'label' => __('Serious Slider','roseta'),
		'values' => cryout_serious_slides_for_customizer(1, 0),
		'labels' => cryout_serious_slides_for_customizer(2, __(' - Please install, activate or update Serious Slider plugin - ', 'roseta'), __(' - No sliders defined - ', 'roseta') ),
		'desc' => __('Select the desired slider from the list. Sliders can be administered in the dashboard.','roseta'),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidertitle',
		'type' => 'text',
		'label' => __('Caption','roseta'),
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Title', 'roseta') ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidertext',
		'type' => 'textarea',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'roseta') ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta1text',
		'type' => 'text',
		'label' => __('CTA Button','roseta') . ' #1',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'roseta') ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta1link',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Link', 'roseta') ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta2text',
		'type' => 'text',
		'label' => __('CTA Button','roseta') . ' #2',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'roseta') ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),
	array(
	'id' => 'theme_lpslidercta2link',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Link', 'roseta') ),
		'active_callback' => 'roseta_conditionals',
	'section' => 'theme_lpslider' ),

	// blocks
	array(
	'id' => 'theme_lpblockmaintitle#',
		'type' => 'text',
		'label' => __('Section Title','roseta'),
		'desc' => '',
		'priority' => 10,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockmaindesc#',
		'type' => 'textarea',
		'label' => __( 'Section Description', 'roseta' ),
		'desc' => '',
		'priority' => 15,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockspacer1#',
		'type' => 'spacer',
		'priority' => 15,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockscontent#',
		'type' => 'select',
		'label' => __('Blocks Content','roseta'),
		'values' => array( -1, 0, 1, 2 ),
		'labels' => array( __("Disabled","roseta"), __("No Text","roseta"), __("Excerpt","roseta"), __("Full Content","roseta") ),
		'desc' => '',
		'priority' => 20,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblocksreadmore#',
		'type' => 'text',
		'label' => __('Read More Button','roseta'),
		'desc' => __("Configure the 'Read More' link text.","roseta"),
		'priority' => 22,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblocksclick#',
		'type' => 'checkbox',
		'label' => __('Make icons clickable (linking to their respective pages).','roseta'),
		'desc' => '',
		'priority' => 23,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockspacer2#',
		'type' => 'spacer',
		'priority' => 23,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockoneicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','roseta'), 1),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 25,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockone#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'desc' => '&nbsp;',
		'priority' => 26,
	'section' => 'theme_lpblocks#' ),

	array(
	'id' => 'theme_lpblocktwoicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','roseta'), 2),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 27,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblocktwo#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'desc' => '&nbsp;',
		'priority' => 28,
	'section' => 'theme_lpblocks#' ),

	array(
	'id' => 'theme_lpblockthreeicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','roseta'), 3),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 29,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockthree#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'desc' => '&nbsp;',
		'priority' => 30,
	'section' => 'theme_lpblocks#' ),

	array(
	'id' => 'theme_lpblockfouricon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','roseta'), 4),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 31,
	'section' => 'theme_lpblocks#' ),
	array(
	'id' => 'theme_lpblockfour#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'desc' => '&nbsp;',
		'priority' => 32,
	'section' => 'theme_lpblocks#' ),


	// boxes #cloned#
	array(
	'id' => 'theme_lpboxmaintitle#',
		'type' => 'text',
		'label' => __('Section Title','roseta'),
		'desc' => '',
		'priority' => 10,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxmaindesc#',
		'type' => 'textarea',
		'label' => __( 'Section Description', 'roseta' ),
		'desc' => '',
		'priority' => 20,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxspacer1#',
		'type' => 'spacer',
		'priority' => 20,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxcat#',
		'type' => 'select',
		'label' => __('Boxes Content','roseta'),
		'values' => cryout_categories_for_customizer(1, __('All Categories', 'roseta'), sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'labels' => cryout_categories_for_customizer(2, __('All Categories', 'roseta'), sprintf( '- %s -', __('Disabled', 'roseta') ) ),
		'desc' => '',
		'priority' => 30,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxcount#',
		'type' => 'numberslider',
		'min' => 1,
		'max' => 30,
		'step' => 1,
		'input_attrs' => array(
			'min' => 1,
			'max' => 100,
		),
		'label' => __('Number of Boxes','roseta'),
		'desc' => '',
		'priority' => 40,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxrow#',
		'type' => 'select',
		'label' => __('Boxes Per Row','roseta'),
		'values' => array( 1, 2, 3, 4 ),
		'desc' => '',
		'priority' => 50,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxheight#',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 600,
		'step' => 1,
		'um' => 'px',
		'input_attrs' => array(
			'min' => 1,
			'max' => 2000,
		),
		'label' => __('Box Height','roseta'),
		'desc' => __("The width is a percentage dependent on total site width and number of columns per row.","roseta"),
		'priority' => 60,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxspacer2#',
		'type' => 'spacer',
		'priority' => 60,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxlayout#',
		'type' => 'select',
		'label' => __('Box Layout','roseta'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Full width","roseta"), __("Boxed","roseta") ),
		'desc' => '',
		'priority' => 70,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxmargins#',
		'type' => 'select',
		'label' => __('Box Stacking','roseta'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Joined","roseta"), __("Apart","roseta") ),
		'desc' => '',
		'priority' => 80,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxanimation#',
		'type' => 'select',
		'label' => __('Box Appearance','roseta'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Animated","roseta"), __("Static","roseta") ),
		'desc' => '',
		'priority' => 90,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxspacer3#',
		'type' => 'spacer',
		'priority' => 91,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxreadmore#',
		'type' => 'text',
		'label' => __('Read More Button','roseta'),
		'desc' => '',
		'priority' => 100,
	'section' => 'theme_lpboxes#' ),
	array(
	'id' => 'theme_lpboxlength#',
		'type' => 'numberslider',
		'min' => 1,
		'max' => 100,
		'step' => 1,
		'label' => __('Content Length (words)','roseta'),
		'desc' => '',
		'priority' => 110,
	'section' => 'theme_lpboxes#' ),

	// texts
	array(
	'id' => 'theme_lptextone',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','roseta'), 1),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'roseta') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'roseta') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),
	array(
	'id' => 'theme_lptexttwo',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','roseta'), 2),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'roseta') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'roseta') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),
	array(
	'id' => 'theme_lptextthree',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','roseta'), 3),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'roseta') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'roseta') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),
	array(
	'id' => 'theme_lptextfour',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','roseta'), 4),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'roseta') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'roseta') ),
		'desc' => '',
	'section' => 'theme_lptexts' ),

	array(
	'id' => 'theme_lptexthint',
		'type' => 'hint',
		'label' => '',
		'desc' => __("Page properties that will be used:<br>- page title as text title<br>- page content as text content<br>- page featured image as text area background image","roseta"),
		'priority' => 99,
	'section' => 'theme_lptexts' ),

	//////////////////////////////////////////////////// Colors ////////////////////////////////////////////////////

	array(
	'id' => 'theme_sitebackground',
		'type' => 'color',
		'label' => __('Site Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_sitetext',
		'type' => 'color',
		'label' => __('Site Text','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_headingstext',
		'type' => 'color',
		'label' => __('Content Headings','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_contentbackground',
		'type' => 'color',
		'label' => __('Content Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_primarybackground',
		'type' => 'color',
		'label' => __('Left Sidebar Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_secondarybackground',
		'type' => 'color',
		'label' => __('Right Sidebar Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_colorsspacer2',
		'type' => 'spacer',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_accent1',
		'type' => 'color',
		'label' => __('Primary Accent','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),
	array(
	'id' => 'theme_accent2',
		'type' => 'color',
		'label' => __('Secondary Accent','roseta'),
		'desc' => '',
	'section' => 'theme_colors' ),

	array(
	'id' => 'theme_menubackground',
		'type' => 'color',
		'label' => __('Header Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_menutext',
		'type' => 'color',
		'label' => __('Menu Text','roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_submenutext',
		'type' => 'color',
		'label' => __('Submenu Text','roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_submenubackground',
		'type' => 'color',
		'label' => __('Submenu Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_colorsspacer1',
		'type' => 'spacer',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaycolors',
		'type' => 'hint',
		'label' => __('Overlay', 'roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaybackground',
		'type' => 'color',
		'label' => __('Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlaytext',
		'type' => 'color',
		'label' => __('Text','roseta'),
		'desc' => '',
	'section' => 'theme_colors_header' ),
	array(
	'id' => 'theme_overlayopacity',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'um' => '%',
		'readonly' => true,
		'label' => __('Opacity','roseta'),
		'desc' => "",
	'section' => 'theme_colors_header' ),

	array(
	'id' => 'theme_footerbackground',
		'type' => 'color',
		'label' => __('Footer Background','roseta'),
		'desc' => '',
	'section' => 'theme_colors_footer' ),
	array(
	'id' => 'theme_footertext',
		'type' => 'color',
		'label' => __('Footer Text','roseta'),
		'desc' => '',
	'section' => 'theme_colors_footer' ),

	array(
	'id' => 'theme_lpblocksbg',
		'type' => 'color',
		'label' => __('Blocks','roseta'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),
	array(
	'id' => 'theme_lpboxesbg',
		'type' => 'color',
		'label' => __('Boxes','roseta'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),
	array(
	'id' => 'theme_lptextsbg',
		'type' => 'color',
		'label' => __('Text Areas','roseta'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),
	array(
	'id' => 'theme_lppostsbg',
		'type' => 'color',
		'label' => __('Featured Content','roseta'),
		'desc' => '',
	'section' => 'theme_colors_lp' ),

	//////////////////////////////////////////////////// Fonts ////////////////////////////////////////////////////
	// general font
	array(
	'id' => 'theme_fgeneral',
		'type' => 'font',
		'label' => __('General Font','roseta'),
		'desc' => '',
		'no_inherit' => TRUE,
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralsize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 12, 'max' => 20, 'step' => 1, 'um' => 'px',
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneralgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_lineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','roseta'),
		'min' => 1, 'max' => 3, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontfamily' ),
 	array(
	'id' => 'theme_paragraphspace',
		'type' => 'numberslider',
		'label' => __('Spacing','roseta'),
		'min' => 0, 'max' => 3, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontfamily' ),
	array(
	'id' => 'theme_fgeneraldesc',
		'type' => 'description',
		'label' => '',
		'desc' => __("The fonts under the <em>Preferred Theme Fonts</em> list are recommended because they have all the font weights used throughout the theme.","roseta"),
	'section' => 'theme_fontfamily' ),

	// header fonts
	array( // site title
	'id' => 'theme_fsitetitle',
		'type' => 'font',
		'label' => __('Site Title','roseta'),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitlesize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.9, 'max' => 3.0, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitleweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitlevariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fsitetitlegoogle',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontheader' ),

	array(
	'id' => 'theme_headerspacer1',
		'type' => 'spacer',
	'section' => 'theme_fontheader' ),

	array( // menu
	'id' => 'theme_fmenu',
		'type' => 'font',
		'label' => __('Main Menu','roseta'),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenusize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.8, 'max' => 2.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenuweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenuvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fmenugoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontheader' ),

	array(
	'id' => 'theme_headerspacer2',
		'type' => 'spacer',
	'section' => 'theme_fontheader' ),

	array( // header title
	'id' => 'theme_fht_title',
		'type' => 'font',
		'label' => __('Header Titles Title','roseta'),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_titlesize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 1.4, 'max' => 4.0, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_titleweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_titlevariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_titlegoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_titlelineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','roseta'),
		'min' => 1, 'max' => 3, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),

	array(
	'id' => 'theme_headerspacer3',
		'type' => 'spacer',
	'section' => 'theme_fontheader' ),

	array( // header title meta
	'id' => 'theme_fht_meta',
		'type' => 'font',
		'label' => __('Header Titles Metas','roseta'),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_metasize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.7, 'max' => 2.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_metaweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_metavariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontheader' ),
	array(
	'id' => 'theme_fht_metagoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontheader' ),

	// widget fonts
	array( // widget title
	'id' => 'theme_fwtitle',
		'type' => 'font',
		'label' => __('Widget Title','roseta'),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlesize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.7, 'max' => 2.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitleweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlevariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlegoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwtitlelineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','roseta'),
		'min' => 1, 'max' => 3, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),
 	array(
	'id' => 'theme_fwtitlespace',
		'type' => 'numberslider',
		'label' => __('Spacing','roseta'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),

	array(
	'id' => 'theme_fwspacer1',
		'type' => 'spacer',
	'section' => 'theme_fontwidget' ),

	array( // widget content
	'id' => 'theme_fwcontent',
		'type' => 'font',
		'label' => __('Widget Content','roseta'),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentsize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.8, 'max' => 1.6, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontwidget' ),
	array(
	'id' => 'theme_fwcontentlineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','roseta'),
		'min' => 1, 'max' => 3, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontwidget' ),

	// content fonts
	array( // post/page
	'id' => 'theme_ftitles',
		'type' => 'font',
		'label' => __('Post/Page Titles','roseta'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlessize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 1.0, 'max' => 3.0, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlesweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlesvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_ftitlesgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontcontent' ),

	array(
	'id' => 'theme_fcontentspacer1',
		'type' => 'spacer',
	'section' => 'theme_fontcontent' ),

	array( // metas
	'id' => 'theme_metatitles',
		'type' => 'font',
		'label' => __('Post metas','roseta'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlessize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 0.7, 'max' => 1.6, 'step' => 0.05, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlesweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlesvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_metatitlesgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontcontent' ),

	array(
	'id' => 'theme_fcontentspacer2',
		'type' => 'spacer',
	'section' => 'theme_fontcontent' ),

	array( // headings
	'id' => 'theme_fheadings',
		'type' => 'font',
		'label' => __('Headings','roseta'),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingssize',
		'type' => 'numberslider',
		'label' => '',
		'min' => 80, 'max' => 200, 'step' => 10, 'um' => '%',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingsweight',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','roseta'), __('200 extra-light','roseta'), __('300 lighter','roseta'), __('400 regular','roseta'), __('500 medium','roseta'), __('600 semi-bold','roseta'), __('700 bold','roseta'), __('800 extra-bold','roseta'), __('900 black','roseta') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingsvariant',
		'type' => 'selecthalf',
		'label' => '',
		'values' => array( '', 'capitalize', 'uppercase', 'lowercase' ),
		'labels' => array( __('None','roseta'), __('Capitalize','roseta'), __('Uppercase','roseta'), __('Lowercase','roseta') ),
		'desc' => '',
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingsgoogle',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Google/Custom Font Override','roseta') ),
	'section' => 'theme_fontcontent' ),
	array(
	'id' => 'theme_fheadingslineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','roseta'),
		'min' => 1, 'max' => 3, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),
 	array(
	'id' => 'theme_fheadingsspace',
		'type' => 'numberslider',
		'label' => __('Spacing','roseta'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_fontcontent' ),

	// formatting
	array(
	'id' => 'theme_textalign',
		'type' => 'select',
		'label' => __('Text Alignment','roseta'),
		'values' => array( "inherit" , "left" , "right" , "justify" , "center" ),
		'labels' => array( __("Default","roseta"), __("Left","roseta"), __("Right","roseta"), __("Justify","roseta"), __("Center","roseta") ),
		'desc' => '',
	'section' => 'theme_textformatting' ),
	array(
	'id' => 'theme_parindent',
		'type' => 'numberslider',
		'label' => __('Paragraph Indentation','roseta'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'theme_textformatting' ),

	//////////////////////////////////////////////////// Structure ////////////////////////////////////////////////////

	array(
	'id' => 'theme_breadcrumbs',
		'type' => 'toggle',
		'label' => __('Breadcrumbs','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_pagination',
		'type' => 'toggle',
		'label' => __('Numbered Pagination','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_singlenav',
		'type' => 'select',
		'label' => __('Single Post Prev/Next Navigation','roseta'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Absolute","roseta"), __("Static", "roseta"), __("Disable","roseta") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_contenttitles',
		'type' => 'select',
		'label' => __('Page/Category Titles','roseta'),
		'values' => array( 1, 2, 3, 0 ),
		'labels' => array( __('Always Visible','roseta'), __('Hide on Pages','roseta'), __('Hide on Categories','roseta'), __('Always Hidden','roseta') ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_totop',
		'type' => 'select',
		'label' => __('Back to Top Button','roseta'),
		'values' => array( 'roseta-totop-normal', 'roseta-totop-fixed', 'roseta-totop-disabled' ),
		'labels' => array( __("Bottom of page","roseta"), __("In footer","roseta"), __("Disabled","roseta") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_tables',
		'type' => 'select',
		'label' => __('Tables Style','roseta'),
		'values' => array( 'roseta-no-table', 'roseta-clean-table', 'roseta-stripped-table', 'roseta-bordered-table' ),
		'labels' => array( __("No border","roseta"), __("Clean","roseta"), __("Stripped","roseta"), __("Bordered","roseta") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
	'id' => 'theme_normalizetags',
		'type' => 'select',
		'label' => __('Tags Cloud Appearance','roseta'),
		'values' => array( 0, 1 ),
		'labels' => array( __("Size Emphasis","roseta"), __("Uniform Boxes","roseta") ),
		'desc' => '',
	'section' => 'theme_contentstructure' ),
	array(
		'id' => 'theme_copyright',
		'type' => 'textarea',
		'label' => __( 'Custom Footer Text', 'roseta' ),
		'desc' => __("Insert custom text or basic HTML code that will appear in your footer. <br /> You can use HTML to insert links, images and special characters.","roseta"),
		'section' => 'theme_contentstructure' ),

	//////////////////////////////////////////////////// Graphics ////////////////////////////////////////////////////

	array(
	'id' => 'theme_articleanimation',
		'type' => 'select',
		'label' => __('Article Animation on Scroll','roseta'),
		'values' => array( 'none', 'fade', 'slide', 'flipLeft', 'flipRight'),
		'labels' => array( __("None","roseta"), __("Fade","roseta"), __("Slide","roseta"), __("Flip Left","roseta"), __("Flip Right","roseta") ),
		'desc' => '',
	'section' => 'theme_contentgraphics' ),

	//////////////////////////////////////////////////// Search Box ////////////////////////////////////////////////////

	array(
	'id' => 'theme_searchboxmain',
		'type' => 'checkbox',
		'label' => __('Add Search to Main Menu','roseta'),
		'desc' => '',
	'section' => 'theme_searchbox' ),
	array(
	'id' => 'theme_searchboxfooter',
		'type' => 'checkbox',
		'label' => __('Add Search to Footer Menu','roseta'),
		'desc' => '',
	'section' => 'theme_searchbox' ),

	//////////////////////////////////////////////////// Content Image ////////////////////////////////////////////////////

	array(
	'id' => 'theme_image_style',
		'type' => 'radioimage',
		'label' => __('Post Images','roseta'),
		'choices' => array(
			'roseta-image-none' => array(
				'label' => __("No Styling","roseta"),
				'url'   => '%s/admin/images/image-style-0.png'
			),
			'roseta-image-one' => array(
				'label' => sprintf( __("Style %d","roseta"), 1),
				'url'   => '%s/admin/images/image-style-1.png'
			),
			'roseta-image-two' => array(
				'label' => sprintf( __("Style %d","roseta"), 2),
				'url'   => '%s/admin/images/image-style-2.png'
			),
			'roseta-image-three' => array(
				'label' => sprintf( __("Style %d","roseta"), 3),
				'url'   => '%s/admin/images/image-style-3.png'
			),
			'roseta-image-four' => array(
				'label' => sprintf( __("Style %d","roseta"), 4),
				'url'   => '%s/admin/images/image-style-4.png'
			),
			'roseta-image-five' => array(
				'label' => sprintf( __("Style %d","roseta"), 5),
				'url'   => '%s/admin/images/image-style-5.png'
			),
		),
		'desc' => '',
	'section' => 'theme_postimage' ),
	array(
	'id' => 'theme_caption_style',
		'type' => 'select',
		'label' => __('Post Captions','roseta'),
		'values' => array( 'roseta-caption-zero', 'roseta-caption-one', 'roseta-caption-two' ),
		'labels' => array( __('Plain','roseta'), __('With Border','roseta'), __('With Background','roseta') ),
		'desc' => '',
	'section' => 'theme_postimage' ),


	//////////////////////////////////////////////////// Post Information ////////////////////////////////////////////////////

	array( // blog metas
	'id' => 'theme_meta_blog_author',
		'type' => 'checkbox',
		'label' => __("Display Author","roseta"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_date',
		'type' => 'checkbox',
		'label' => __("Display Date","roseta"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_time',
		'type' => 'checkbox',
		'label' => __("Display Time","roseta"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_category',
		'type' => 'checkbox',
		'label' => __("Display Category","roseta"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_tag',
		'type' => 'checkbox',
		'label' => __("Display Tags","roseta"),
		'desc' => '',
	'section' => 'theme_metas_blog' ),
	array(
	'id' => 'theme_meta_blog_comment',
		'type' => 'checkbox',
		'label' => __("Display Comments","roseta"),
		'desc' => __("Choose meta information to show on posts.","roseta"),
	'section' => 'theme_metas_blog' ),

	// single meta
	array(
	'id' => 'theme_meta_single_author',
		'type' => 'checkbox',
		'label' => __("Display Author","roseta"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_date',
		'type' => 'checkbox',
		'label' => __("Display Date","roseta"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_time',
		'type' => 'checkbox',
		'label' => __("Display Time","roseta"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_category',
		'type' => 'checkbox',
		'label' => __("Display Category","roseta"),
		'desc' => '',
	'section' => 'theme_metas_single' ),
	array(
	'id' => 'theme_meta_single_tag',
		'type' => 'checkbox',
		'label' => __("Display Tags","roseta"),
		'desc' => '',
	'section' => 'theme_metas_single' ),

	// header titles
	array(
	'id' => 'theme_headertitles_posts',
		'type' => 'checkbox',
		'label' => __("Posts","roseta"),
		'desc' => '',
	'section' => 'theme_headertitles' ),
	array(
	'id' => 'theme_headertitles_pages',
		'type' => 'checkbox',
		'label' => __("Pages","roseta"),
		'desc' => '',
	'section' => 'theme_headertitles' ),
	array(
	'id' => 'theme_headertitles_archives',
		'type' => 'checkbox',
		'label' => __("Archive pages","roseta"),
		'desc' => '',
	'section' => 'theme_headertitles' ),
	array(
	'id' => 'theme_headertitles_home',
		'type' => 'checkbox',
		'label' => __("Home page","roseta"),
		'desc' => '',
	'section' => 'theme_headertitles' ),

	// excerpts
	array(
	'id' => 'theme_excerpthome',
		'type' => 'select',
		'label' => __( 'Standard Posts On Homepage', 'roseta' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Excerpt","roseta"), __("Full Post","roseta") ),
		'desc' => __("Post formats always display full posts.","roseta"),
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptsticky',
		'type' => 'select',
		'label' => __( 'Sticky Posts on Homepage', 'roseta' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Inherit","roseta"), __("Full Post","roseta") ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptarchive',
		'type' => 'select',
		'label' => __( 'Standard Posts in Categories/Archives', 'roseta' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Excerpt","roseta"), __("Full Post","roseta") ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptlength',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'label' => __( 'Excerpt Length (words)' , 'roseta' ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptdots',
		'type' => 'text',
		'label' => __( 'Excerpt Suffix', 'roseta' ),
		'desc' => '',
	'section' => 'theme_excerpts' ),
	array(
	'id' => 'theme_excerptcont',
		'type' => 'text',
		'label' => __( 'Continue Reading Label', 'roseta' ),
		'desc' => '',
	'section' => 'theme_excerpts' ),

	// comments
	array(
	'id' => 'theme_comclosed',
		'type' => 'select',
		'label' => __("'Comments Are Closed' Text",'roseta'),
		'values' => array( 1, 2, 3, 0 ), // "Show" , "Hide in posts", "Hide in pages", "Hide everywhere"
		'labels' => array( __("Show","roseta"), __("Hide in posts","roseta"), __("Hide in pages","roseta"), __("Hide everywhere","roseta") ),
		'desc' => '',
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comdate',
		'type' => 'select',
		'label' => __('Comment Date Format','roseta'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Specific","roseta"), __("Relative","roseta") ),
		'desc' => '',
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comlabels',
		'type' => 'select',
		'label' => __('Comment Field Label','roseta'),
		'values' => array( 1, 3, 2 ),
		'labels' => array( __("Placeholders","roseta"), __("Optimized Labels","roseta"), __("Labels","roseta") ),
		'desc' => __("Change to labels for better compatibility with comment-related plugins.","roseta"),
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comicons',
		'type' => 'checkbox',
		'label' => __("Show Icons in Comment Fields","roseta"),
		'desc' => '',
	'section' => 'theme_comments' ),
	array(
	'id' => 'theme_comformwidth',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 1000,
		'step' => 10,
		'um' => 'px',
		'label' => __('Comment Form Width','roseta'),
		'desc' => '',
	'section' => 'theme_comments' ),

	//////////////////////////////////////////////////// Featured Images ////////////////////////////////////////////////////
	array(
	'id' => 'theme_fpost',
		'type' => 'toggle',
		'label' => __( 'Featured Images', 'roseta' ),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fauto',
		'type' => 'toggle',
		'label' => __( 'Auto Select Image From Content', 'roseta' ),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fheight',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 800,
		'step' => 10,
		'um' => 'px',
		'label' => __( 'Featured Image Height', 'roseta' ),
		'desc' => __( 'Set to 0 to disable image processing', 'roseta' ),
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fheight_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","roseta"),
		//'active_callback' => 'roseta_conditionals',
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_fresponsive',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Cropped","roseta"), __("Contained","roseta") ),
		'label' => __('Featured Image Behaviour','roseta'),
		'desc' => __("<strong>Contained</strong> will scale depending on the viewed resolution<br><strong>Cropped</strong> will try to keep the configured height.","roseta"),
	'section' => 'theme_featured' ),
	array(
	'id' => 'theme_falign',
		'type' => 'select',
		'label' => __( 'Featured Image Crop Position', 'roseta' ),
		'values' => array( false, "left top" , "left center", "left bottom", "right top", "right center", "right bottom", "center top", "center center", "center bottom" ),
		'labels' => array( __("No Crop","roseta"), __("Left Top","roseta"), __("Left Center","roseta"), __("Left Bottom","roseta"), __("Right Top","roseta"), __("Right Center","roseta"), __("Right Bottom","roseta"), __("Center Top","roseta"), __("Center Center","roseta"), __("Center Bottom","roseta") ),
		'desc' => '',
	'section' => 'theme_featured' ),

	array(
	'id' => 'theme_falign_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","roseta"),
		//'active_callback' => 'roseta_conditionals',
	'section' => 'theme_featured' ),

	array(
	'id' => 'theme_fheader',
		'type' => 'toggle',
		'label' => __('Use Featured Images in Header','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'theme_featured' ),

	//////////////////////////////////////////////////// Social Positions ////////////////////////////////////////////////////

	array(
	'id' => 'theme_socials_header',
		'type' => 'checkbox',
		'label' => __( 'Display in Header', 'roseta' ),
		'desc' => '',
	'section' => 'theme_socials' ),
	array(
	'id' => 'theme_socials_footer',
		'type' => 'checkbox',
		'label' => __( 'Display in Footer', 'roseta' ),
		'desc' => '',
	'section' => 'theme_socials' ),
	array(
	'id' => 'theme_socials_left_sidebar',
		'type' => 'checkbox',
		'label' => __( 'Display in Left Sidebar', 'roseta' ),
		'desc' => '',
	'section' => 'theme_socials' ),
	array(
	'id' => 'theme_socials_right_sidebar',
		'type' => 'checkbox',
		'label' => __( 'Display in Right Sidebar', 'roseta' ),
		'desc' => sprintf( __( 'Select where social icons should be displayed.<br><br><strong>Social Icons are defined using the <a href="%1$s" target="_blank">socials menu</a></strong>. Read the <a href="%2$s" target="_blank">theme documentation</a> for detailed information.', 'roseta' ), 'nav-menus.php?action=locations', 'http://www.cryoutcreations.eu/wordpress-tutorials/use-new-social-menu' ),
	'section' => 'theme_socials' ),

	//////////////////////////////////////////////////// Miscellaneous ////////////////////////////////////////////////////

	array(
	'id' => 'theme_pagesmenu',
		'type' => 'toggle',
		'label' => __( 'Default Pages Menu', 'roseta' ),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_masonry',
		'type' => 'toggle',
		'label' => __('Masonry','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_defer',
		'type' => 'toggle',
		'label' => __('JS Defer loading','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'theme_misc' ),

	array(
	'id' => 'theme_autoscroll',
		'type' => 'toggle',
		'label' => __('Autoscroll','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_headerlimits',
		'type' => 'toggle',
		'label' => __('Header image size requirements','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_mobileonios',
		'type' => 'toggle',
		'label' => __( 'Force mobile menu on iOS mobile devices', 'roseta' ),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_editorstyles',
		'type' => 'toggle',
		'label' => __('Editor Styles','roseta'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_lazyimages',
		'type' => 'select',
		'label' => __('Lazy load images','roseta'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Animated","roseta"), __("Static","roseta") ),
		'desc' => '',
		'priority' => 6,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_fitvids',
		'type' => 'select',
		'label' => __('FitVids','roseta'),
		'values' => array( 1, 2, 0 ),
		'labels' => array( __("Enable","roseta"), __("Enable on mobiles","roseta"), __("Disable","roseta") ),
		'desc' => '',
		'priority' => 6,
	'section' => 'theme_misc' ),
	array(
	'id' => 'theme_preloader',
		'type' => 'select',
		'label' => __('Preloader','roseta'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Front Page Only","roseta"), __("Enable","roseta"), __("Disable","roseta") ),
		'desc' => __("<br>Only use these options to troubleshoot issues.","roseta"),
		'priority' => 6,
	'section' => 'theme_misc' ),
	//////////////////////////////////////////////////// !!! DEVELOPER !!! ////////////////////////////////////////////////////
	// nothing for now

), // options

/* option=array(
	type: checkbox, select, textarea, input, function
	id: field_name or custom_function_name
	values: value_0, value_1, value_2 | true/false | number
	labels: __('Label 0','context'), ... | __('Enabled','context')/... |  number/__('Once','context')/...
	desc: html to be displayed at the question mark
	section: section_id

	array(
	'id' => '',
		'type' => '',
		'label' => '',
		'values' => array(  ),
		'labels' => array(  ),
		'desc' => '',
		'input_attrs' => array(  ),
		// conditionals
		'disable_if' => 'function_name',
		'require_fn' => 'function_name',
		// extra
		'addon' => TRUE, // option gets added to core sections
		'display_width' => '?????',
	'section' => '' ),

*/

/*** fonts ***/
'fonts' => array(

	'Inherit' => array( // capitalization matters
		'Inherit General Font',
	),
	'Preferred Theme Fonts'=> array(
					"System Fonts, -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen-Sans, Ubuntu, Cantarell, Helvetica Neue, sans-serif",
					"Oswald/gfont",
					"Great Vibes/gfont",
					"Open Sans/gfont",
					"Roboto/gfont",
					"Raleway/gfont",
					"Ubuntu/gfont",
					"Droid Sans/gfont",
					),
	'Recommended Google Fonts' => array(
					"Alegreya/gfont",
					"Alegreya Sans/gfont",
					"Arvo/gfont",
					"Cormorant/gfont",
					"Droid Sans/gfont",
					"Fira Sans/gfont",
					"Fjalla One/gfont",
					"Karla/gfont",
					"Josefin Sans/gfont",
					"Lato/gfont",
					"Lora/gfont",
					"Libre Franklin/gfont",
					"Merriweather/gfont",
					"Montserrat/gfont",
					"Noto Sans/gfont",
					"Noto Serif/gfont",
					"Nunito/gfont",
					"Open Sans/gfont",
					"Open Sans Condensed/gfont",
					"Oswald/gfont",
					"Oxygen/gfont",
					"Playfair Display/gfont",
					"Poppins/gfont",
					"PT Sans/gfont",
					"PT Serif/gfont",
					"Raleway/gfont",
					"Roboto/gfont",
					"Roboto Slab/gfont",
					"Rubik/gfont",
					"Spectral/gfont",
					"Source Sans Pro/gfont",
					"Source Serif Pro/gfont",
					"Ubuntu/gfont",
					"Ubuntu Condensed/gfont",
					"Work Sans Condensed/gfont",
					"Yanone Kaffeesatz/gfont",
					),
	'Sans-Serif' => array(
					"Verdana, Geneva, sans-serif" ,
					"Geneva, sans-serif",
					"Helvetica Neue, Arial, Helvetica, sans-serif",
					"Helvetica, sans-serif" ,
					"Calibri, Arian, sans-serif",
				    	"Myriad Pro, Myriad,Arial, sans-serif",
					"Gill Sans, Calibri, Trebuchet MS, sans-serif",
					"Arial, Helvetica, sans-serif" ,
					),
	'Serif' => array(
					"Georgia, Times New Roman, Times, serif",
					"Times New Roman, Times, serif",
					"Cambria, Georgia, Times, Times New Roman, serif",
					"Palatino Linotype, Book Antiqua, Palatino, serif",
					"Palatino, serif",
				    	"Baskerville, Times New Roman, Times, serif",
					"Garamond, Times New Roman, Times, serif"
					),
	'Advanced' => array(
					"* Local Font *",
					),
	), // fonts

	/*** google font option fields ***/
	'google-font-enabled-fields' => array(
		'theme_fgeneral',
		'theme_fsitetitle',
		'theme_fmenu',
		'theme_fwtitle',
		'theme_fwcontent',
		'theme_ftitles',
		'theme_metatitles',
		'theme_fheadings',
		'theme_fht_title',
		'theme_fht_meta',
		),

	// ! The icons lists are reused in multiple locations; make sure to update all when needed !

	/*** landing page blocks icons ***/
	'block-icons' => array(
		'toggle' => 'e003',
		'layout' => 'e004',
		'lock' => 'e007',
		'unlock' => 'e008',
		'target' => 'e012',
		'disc' => 'e019',
		'microphone' => 'e048',
		'play' => 'e052',
		'cloud2' => 'e065',
		'cloud-upload' => 'e066',
		'cloud-download' => 'e067',
		'plus2' => 'e114',
		'minus2' => 'e115',
		'check2' => 'e116',
		'cross2' => 'e117',
		'users2' => 'e00a',
		'user' => 'e00b',
		'trophy' => 'e00c',
		'speedometer' => 'e00d',
		'screen-tablet' => 'e00f',
		'screen-smartphone' => 'e01a',
		'screen-desktop' => 'e01b',
		'plane' => 'e01c',
		'notebook' => 'e01d',
		'magic-wand' => 'e01e',
		'hourglass2' => 'e01f',
		'graduation' => 'e02a',
		'fire' => 'e02b',
		'eyeglass' => 'e02c',
		'energy' => 'e02d',
		'chemistry' => 'e02e',
		'bell' => 'e02f',
		'badge' => 'e03a',
		'speech' => 'e03b',
		'puzzle' => 'e03c',
		'printer' => 'e03d',
		'present' => 'e03e',
		'pin' => 'e03f',
		'picture2' => 'e04a',
		'map' => 'e04b',
		'layers' => 'e04c',
		'globe' => 'e04d',
		'globe2' => 'e04e',
		'folder' => 'e04f',
		'feed' => 'e05a',
		'drop' => 'e05b',
		'drawar' => 'e05c',
		'docs' => 'e05d',
		'directions' => 'e05e',
		'direction' => 'e05f',
		'cup2' => 'e06b',
		'compass' => 'e06c',
		'calculator' => 'e06d',
		'bubbles' => 'e06e',
		'briefcase' => 'e06f',
		'book-open' => 'e07a',
		'basket' => 'e07b',
		'bag' => 'e07c',
		'wrench' => 'e07f',
		'umbrella' => 'e08a',
		'tag' => 'e08c',
		'support' => 'e08d',
		'share' => 'e08e',
		'share2' => 'e08f',
		'rocket' => 'e09a',
		'question' => 'e09b',
		'pie-chart2' => 'e09c',
		'pencil2' => 'e09d',
		'note' => 'e09e',
		'music-tone-alt' => 'e09f',
		'list2' => 'e0a0',
		'like' => 'e0a1',
		'home2' => 'e0a2',
		'grid' => 'e0a3',
		'graph' => 'e0a4',
		'equalizer' => 'e0a5',
		'dislike' => 'e0a6',
		'calender' => 'e0a7',
		'bulb' => 'e0a8',
		'chart' => 'e0a9',
		'clock' => 'e0af',
		'envolope' => 'e0b1',
		'flag' => 'e0b3',
		'folder2' => 'e0b4',
		'heart2' => 'e0b5',
		'info' => 'e0b6',
		'link' => 'e0b7',
		'refresh' => 'e0bc',
		'reload' => 'e0bd',
		'settings' => 'e0be',
		'arrow-down' => 'e604',
		'arrow-left' => 'e605',
		'arrow-right' => 'e606',
		'arrow-up' => 'e607',
		'paypal' => 'e608',
		'home' => 'e800',
		'apartment' => 'e801',
		'data' => 'e80e',
		'cog' => 'e810',
		'star' => 'e814',
		'star-half' => 'e815',
		'star-empty' => 'e816',
		'paperclip' => 'e819',
		'eye2' => 'e81b',
		'license' => 'e822',
		'picture' => 'e827',
		'book' => 'e828',
		'bookmark' => 'e829',
		'users' => 'e82b',
		'store' => 'e82d',
		'calendar' => 'e836',
		'keyboard' => 'e837',
		'spell-check' => 'e838',
		'screen' => 'e839',
		'smartphone' => 'e83a',
		'tablet' => 'e83b',
		'laptop' => 'e83c',
		'laptop-phone' => 'e83d',
		'construction' => 'e841',
		'pie-chart' => 'e842',
		'gift' => 'e844',
		'diamond' => 'e845',
		'cup3' => 'e848',
		'leaf' => 'e849',
		'earth' => 'e853',
		'bullhorn' => 'e859',
		'hourglass' => 'e85f',
		'undo' => 'e860',
		'redo' => 'e861',
		'sync' => 'e862',
		'history' => 'e863',
		'download' => 'e865',
		'upload' => 'e866',
		'bug' => 'e869',
		'code' => 'e86a',
		'link2' => 'e86b',
		'unlink' => 'e86c',
		'thumbs-up' => 'e86d',
		'thumbs-down' => 'e86e',
		'magnifier' => 'e86f',
		'cross3' => 'e870',
		'menu' => 'e871',
		'list' => 'e872',
		'warning' => 'e87c',
		'question-circle' => 'e87d',
		'check' => 'e87f',
		'cross' => 'e880',
		'plus' => 'e881',
		'minus' => 'e882',
		'layers2' => 'e88e',
		'text-format' => 'e890',
		'text-size' => 'e892',
		'hand' => 'e8a5',
		'pointer-up' => 'e8a6',
		'pointer-right' => 'e8a7',
		'pointer-down' => 'e8a8',
		'pointer-left' => 'e8a9',
		'heart' => 'e930',
		'cloud' => 'e931',
		'trash' => 'e933',
		'user2' => 'e934',
		'key' => 'e935',
		'search' => 'e936',
		'settings2' => 'e937',
		'camera' => 'e938',
		'tag2' => 'e939',
		'bulb2' => 'e93a',
		'pencil' => 'e93b',
		'diamond2' => 'e93c',
		'location' => 'e93e',
		'eye' => 'e93f',
		'bubble' => 'e940',
		'stack' => 'e941',
		'cup' => 'e942',
		'phone' => 'e943',
		'news' => 'e944',
		'mail' => 'e945',
		'news2' => 'e948',
		'paperplane' => 'e949',
		'params2' => 'e94a',
		'data2' => 'e94b',
		'megaphone' => 'e94c',
		'study' => 'e94d',
		'chemistry2' => 'e94e',
		'fire2' => 'e94f',
		'paperclip2' => 'e950',
		'calendar2' => 'e951',
		'wallet' => 'e952',
		),

	'meta-icons' => array(
		'user-female' => "\e000",
		'screen-smartphone' => "\e010",
		'screen-desktop' => "\e011",
		'plane' => "\e012",
		'notebook' => "\e013",
		'moustache' => "\e014",
		'energy' => "\e020",
		'emoticon-smile' => "\e021",
		'disc' => "\e022",
		'credit-card' => "\e025",
		'chemistry' => "\e026",
		'user' => "\e005",
		'speedometer' => "\e007",
		'screen-tablet' => "\e00f",
		'magic-wand' => "\e017",
		'hourglass' => "\e018",
		'game-controller' => "\e01b",
		'fire' => "\e01c",
		'eyeglasses' => "\e01d",
		'envelope-open' => "\e01e",
		'bell' => "\e027",
		'badge' => "\e028",
		'wallet' => "\e02a",
		'vector' => "\e02b",
		'speech' => "\e02c",
		'puzzle' => "\e02d",
		'pin' => "\e031",
		'picture' => "\e032",
		'map' => "\e033",
		'layers' => "\e034",
		'handbag' => "\e035",
		'globe-alt' => "\e036",
		'globe' => "\e037",
		'frame' => "\e038",
		'folder-alt' => "\e039",
		'film' => "\e03a",
		'feed' => "\e03b",
		'earphones-alt' => "\e03c",
		'earphones' => "\e03d",
		'drop' => "\e03e",
		'drawer' => "\e03f",
		'docs' => "\e040",
		'directions' => "\e041",
		'direction' => "\e042",
		'diamond' => "\e043",
		'cup' => "\e044",
		'compass' => "\e045",
		'call-end' => "\e048",
		'calculator' => "\e049",
		'bubbles' => "\e04a",
		'briefcase' => "\e04b",
		'book-open' => "\e04c",
		'basket-loaded' => "\e04d",
		'basket' => "\e04e",
		'bag' => "\e04f",
		'action-undo' => "\e050",
		'action-redo' => "\e051",
		'trash' => "\e054",
		'tag' => "\e055",
		'support' => "\e056",
		'share-alt' => "\e05a",
		'share' => "\e05b",
		'question' => "\e05d",
		'pencil' => "\e05f",
		'note' => "\e060",
		'music-tone-alt' => "\e061",
		'music-tone' => "\e062",
		'microphone' => "\e063",
		'list' => "\e067",
		'home' => "\e069",
		'grid' => "\e06a",
		'graph' => "\e06b",
		'cursor' => "\e06e",
		'control-play' => "\e071",
		'calendar' => "\e075",
		'bulb' => "\e076",
		'bar-chart' => "\e077",
		'arrow-up' => "\e078",
		'arrow-right' => "\e079",
		'arrow-left' => "\e07a",
		'arrow-down' => "\e07b",
		'ban' => "\e07c",
		'bubble' => "\e07d",
		'camcorder' => "\e07e",
		'camera' => "\e07f",
		'check' => "\e080",
		'clock' => "\e081",
		'close' => "\e082",
		'envelope' => "\e086",
		'eye' => "\e087",
		'flag' => "\e088",
		'folder' => "\e089",
		'heart' => "\e08a",
		'info' => "\e08b",
		'key' => "\e08c",
		'link' => "\e08d",
		'lock' => "\e08e",
		'lock-open' => "\e08f",
		'magnifier' => "\e090",
		'magnifier-add' => "\e091",
		'magnifier-remove' => "\e092",
		'paper-clip' => "\e093",
		'paper-plane' => "\e094",
		'plus' => "\e095",
		'pointer' => "\e096",
		'power' => "\e097",
		'refresh' => "\e098",
		'reload' => "\e099",
		'settings' => "\e09a",
		'star' => "\e09b",
		'target' => "\e09e",
		'volume-1' => "\e09f",
		'volume-2' => "\e0a0",
		'volume-off' => "\e0a1",
		'users' => "\e001",
		'clock1' => "\e0a9",
		'search2' => "\e0a8",
		'head' => "\e0a7",
		'arrow-left1' => "\e0a2",
		'arrow-right1' => "\e0a3",
		'arrow-up1' => "\e0a4",
		'arrow-down1' => "\e0a5",
		'volume' => "\e0a6",
		'plus1' => "\e114",
		'minus' => "\e115",
		'check1' => "\e116",
		'cross' => "\e117",
		'menu2' => "\e120",
		'ellipsis' => "\e129",
		'search' => "\e618",
		'refresh1' => "\e61c",
		'close1' => "\e680",
		'angle-up' => "\e682",
		'angle-right' => "\e684",
		'angle-left' => "\e686",
		'angle-down' => "\e688",
		'refresh-2' => "\e6c2",
		'chevron-down' => "\e900",
		'chevron-left' => "\e901",
		'chevron-right' => "\e902",
		'chevron-small-down' => "\e903",
		'chevron-small-left' => "\e904",
		'chevron-small-right' => "\e905",
		'chevron-small-up' => "\e906",
		'chevron-thin-down' => "\e907",
		'chevron-thin-left' => "\e908",
		'chevron-thin-right' => "\e909",
		'chevron-thin-up' => "\e90a",
		'chevron-up' => "\e90b",
		'circular-graph' => "\e90c",
		'cross2' => "\e90d",
		'magnifying-glass' => "\e911",
		'menu3' => "\e912",
		'quote' => "\e915",
		'el-comment' => "\e800",
		'el-user' => "\e801",
		'el-tag' => "\e802",
		'el-down-dir' => "\e803",
		'el-edit' => "\e804",
		'el-category' => "\e805",
		'el-right-dir' => "\e806",
		'el-angle-left' => "\e807",
		'el-angle-right' => "\e808",
		'el-angle-up' => "\e809",
		'el-angle-down' => "\e80a",
		'el-minus' => "\e80b",
		'el-left-open' => "\e80c",
		'el-time' => "\e80d",
		'el-up' => "\e80e",
		'el-quote' => "\e80f",
		'el-bookmark' => "\e810",
		'el-left-dir' => "\e811",
		'el-up-open' => "\e812",
		'el-ok' => "\e813",
		'el-cancel' => "\e814",
		'el-comments' => "\e815",
		'el-search' => "\e816",
		'el-category2' => "\e817",
		'el-link' => "\e818",
		'el-up-dir' => "\e819",
		'el-info' => "\e81a",
		'el-share' => "\e81b",
		'el-folder-close' => "\e81c",
		'el-folder-open' => "\e81d",
		'el-right-open' => "\e81e",
		'el-home' => "\e81f",
		'el-menu' => "\e820",
		'el-plus' => "\e821",
		'el-down-open' => "\e822",
		'el-audio' => "\e823",
		'el-image' => "\e824",
		'el-camera' => "\e825",
		'el-down' => "\e826",
		'el-left' => "\e827",
		'el-right' => "\e828",
		'el-video' => "\e829",
		'el-aside' => "\e82a",
		'el-date' => "\e82b",
		'el-star-empty' => "\e82c",
		'el-star' => "\e82d",
		'el-mail' => "\e82e",
		'el-home-1' => "\e82f",
		'el-attach' => "\e830",
		'el-eye' => "\e831",
		'el-eye-off' => "\e832",
		'eye-on' => "\e831",
		'eye-off' => "\e832",
		'el-tags' => "\e833",
		'el-flag' => "\e834",
		'el-warning' => "\e835",
		'el-location' => "\e836",
		'el-trash' => "\e837",
		'el-doc' => "\e838",
		'el-phone' => "\e839",
		'el-cog' => "\e83a",
		'el-basket' => "\e83b",
		'el-basket-circled' => "\e83c",
		'el-wrench' => "\e83d",
		'el-wrench-circled' => "\e83e",
		'el-mic' => "\e83f",
		'el-volume' => "\e840",
		'el-volume-down' => "\e841",
		'el-volume-off' => "\e842",
		'el-headphones' => "\e843",
		'el-lightbulb' => "\e844",
		'el-resize-full' => "\e845",
		'el-resize-full-alt' => "\e846",
		'el-resize-small' => "\e847",
		'el-resize-vertical' => "\e848",
		'el-resize-horizontal' => "\e849",
		'el-move' => "\e84a",
		'el-zoom-in' => "\e84b",
		'el-zoom-out' => "\e84c",
		'el-arrows-cw' => "\e84d",
		'el-desktop' => "\e84e",
		'el-inbox' => "\e84f",
		'el-cloud' => "\e850",
		'el-book' => "\e851",
		'el-certificate' => "\e852",
		'el-tasks' => "\e853",
		'el-thumbs-up' => "\e854",
		'el-thumbs-down' => "\e855",
		'el-help-circled' => "\e856",
		'el-star-circled' => "\e857",
		'el-bell' => "\e858",
		'el-rss' => "\e859",
		'el-trash-circled' => "\e85a",
		'el-cogs' => "\e85b",
		'el-cog-circled' => "\e85c",
		'el-calendar-circled' => "\e85d",
		'el-mic-circled' => "\e85e",
		'el-volume-up' => "\e85f",
		'el-print' => "\e860",
		'el-edit-alt' => "\e861",
		'el-edit-2' => "\e862",
		'el-block' => "\e863",
	),

	'social-icons' => array(

		'duckduckgo' => 'e801',
		'aim' => 'e802',
		'delicious' => 'e803',
		'paypal' => 'e804',
		'flattr' => 'e805',
		'android' => 'e806',
		'eventful' => 'e807',
		'smashingmagazine' => 'e808',
		'googleplus' => 'e809',
		'wikipedia' => 'e80a',
		'lanyrd' => 'e80b',
		'calendar' => 'e80c',
		'stumbleupon' => 'e80d',
		'500px' => 'e80e',
		'pinterest' => 'e80f',
		'bitcoin' => 'e810',
		'firefox' => 'e811',
		'foursquare' => 'e812',
		'chrome' => 'e813',
		'internetexplorer' => 'e814',
		'phone' => 'e815',
		'grooveshark' => 'e816',
		'99designs' => 'e817',
		'code' => 'e818',
		'digg' => 'e819',
		'spotify' => 'e81a',
		'reddit' => 'e81b',
		'about' => 'e81c',
		'codeopen' => 'e81d',
		'appstore' => 'e81e',
		'creativecommons' => 'e820',
		'dribbble' => 'e821',
		'evernote' => 'e822',
		'flickr' => 'e823',
		'link2' => 'e824',
		'viadeo' => 'e825',
		'instapaper' => 'e826',
		'weibo' => 'e827',
		'klout' => 'e828',
		'linkedin' => 'e829',
		'meetup' => 'e82a',
		'vk' => 'e82b',
		'plancast' => 'e82c',
		'disqus' => 'e82d',
		'feed' => 'e82e',
		'skype' => 'e82f',
		'twitter' => 'e830',
		'youtube' => 'e831',
		'vimeo' => 'e832',
		'windows' => 'e833',
		'xing' => 'e834',
		'yahoo' => 'e835',
		'email' => 'e837',
		'cloud' => 'e838',
		'myspace' => 'e839',
		'podcast' => 'e83a',
		'amazon' => 'e83b',
		'steam' => 'e83c',
		'link' => 'e83d',
		'dropbox' => 'e83e',
		'ebay' => 'e83f',
		'facebook' => 'e840',
		'github2' => 'e841',
		'github' => 'e842',
		'googleplay' => 'e843',
		'itunes' => 'e844',
		'plurk' => 'e845',
		'songkick' => 'e846',
		'lastfm' => 'e847',
		'gmail' => 'e848',
		'pinboard' => 'e849',
		'openid' => 'e84a',
		'quora' => 'e84b',
		'soundcloud' => 'e84c',
		'tumblr' => 'e84d',
		'wordpress' => 'e84f',
		'yelp' => 'e850',
		'intensedebate' => 'e851',
		'eventbrite' => 'e852',
		'scribd' => 'e853',
		'stripe' => 'e855',
		'opentable' => 'e856',
		'cart' => 'e857',
		'opera' => 'e858',
		'angellist' => 'e859',
		'instagram' => 'e85a',
		'dwolla' => 'e85b',
		'appnet' => 'e85c',
		'drupal' => 'e85f',
		'buffer' => 'e860',
		'pocket' => 'e861',
		'bitbucket' => 'e862',
		'phone2' => 'e863',
		'stackoverflow' => 'e865',
		'hackernews' => 'e866',
		'lkdto' => 'e867',
		'twitter2' => 'e868',
		'phone3' => 'e869',
		'mobile' => 'e86a',
		'support' => 'e86b',
		'twitch' => 'e86c',
		'beer' => 'e86d',
	),

/*** ajax load more identifiers ***/
'theme_identifiers' => array(
	'load_more_optid' 			=> 'theme_lpposts_more',
	'content_css_selector' 		=> '#lp-posts .lp-posts-inside',
	'pagination_css_selector' 	=> '#lp-posts nav.navigation',
),

/************* widget areas *************/

'widget-areas' => array(
	'sidebar-2' => array(
		'name' => __( 'Sidebar Left', 'roseta' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'sidebar-1' => array(
		'name' => __( 'Sidebar Right', 'roseta' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'footer-widget-area' => array(
		'name' => __( 'Footer', 'roseta' ),
		'description' 	=> __('You can configure how many columns the footer displays from the theme options', 'roseta'),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s"><div class="footer-widget-inside">',
		'after_widget' => '</div></section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'content-widget-area-before' => array(
		'name' => __( 'Content Before', 'roseta' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'content-widget-area-after' => array(
		'name' => __( 'Content After', 'roseta' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2 class="widget-title"><span>',
		'after_title' => '</span></h2>',
	),
	'widget-area-header' => array(
		'name' => __( 'Header', 'roseta' ),
		'description' 	=> __('This widget area is displayed over the header image and requires an image to be set.', 'roseta'),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
	'widget-area-top-section' => array(
		'name' => __( 'Top Section', 'roseta' ),
		'description' 	=> __('This widget area is interchangeable with the Top Menu through the theme options.', 'roseta'),
		'before_widget' => '<section id="%1$s" class="top-section-element %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<span class="top-section-element-title">',
		'after_title' => '</span>',
	),
), // widget-areas

'migration' => array(
/* 	'0.10' => array(
		//'theme_old_key' => 'theme_new_key',
	) // 0.1.0 */
),	// migration

); // $roseta_big

// sort block icons alphabetically
ksort( $roseta_big['block-icons'] );
$roseta_big['block-icons'] = array_merge( array( 'no-icon' => '&nbsp;') , $roseta_big['block-icons'] );

// FIN
