<?php
/**
 * The template for displaying the landing page/blog posts
 * The functions used here can be found in includes/landing-page.php
 *
 * @package Septera
 */

if ( is_page() ) {
	include( get_page_template() );
	return true;
}

get_header();

function septera_lp_layoutclass () {
	$lp = cryout_get_option ('septera_landingpage');
	if ( $lp && 'page' !== get_option('show_on_front') ) {
		echo 'septera-landing-page one-column';
	} else {
		echo septera_get_layout_class();
	}
} // septera_lp_layoutclass()
?>

<div id="container" class="<?php septera_lp_layoutclass() ?>">
	<main id="main" role="main" class="main">
	<?php

	$septera_landingpage = cryout_get_option ('septera_landingpage');

	if ( $septera_landingpage ) {
		septera_lpslider();
		septera_lpblocks();
		septera_lptext('one');
		septera_lpboxes(1);
		septera_lptext('two');
		septera_lpboxes(2);
		septera_lptext('three');
		septera_lpindex();
		septera_lptext('four');
	} else {
		septera_lpindex();
	}

	?>
	</main><!-- #main -->
	<?php if ( ! $septera_landingpage ) { septera_get_sidebar(); } ?>
</div><!-- #container -->

<?php get_footer();
