<?php
/**
 * Customizer settings and other theme related settings (fonts arrays, widget areas)
 *
 * @package Septera
 */

/* active_callback for controls that depend on other controls' values */
function septera_conditionals( $control ) {

	$conditionals = array(
		array(
			'id'	=> 'septera_lpsliderimage',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpslidertitle',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpslidertext',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpslidershortcode',
			'parent'=> 'septera_lpslider',
			'value'	=> 2,
		),
		array(
			'id'	=> 'septera_lpslidercta1text',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpslidercta1link',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpslidercta2text',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpslidercta2link',
			'parent'=> 'septera_lpslider',
			'value'	=> 1,
		),
		array(
			'id'	=> 'septera_lpsliderserious',
			'parent'=> 'septera_lpslider',
			'value' => 4,
		),
		array(
			'id'	=> 'septera_lpposts',
			'parent'=> 'septera_landingpage',
			'value' => 1,
		),
		array(
			'id'	=> 'septera_lpposts_more',
			'parent'=> 'septera_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'septera_lppostslayout',
			'parent'=> 'septera_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'septera_lppostscount',
			'parent'=> 'septera_lpposts',
			'value' => 1,
		),
		array(
			'id'    => 'septera_lppostscat',
			'parent'=> 'septera_lpposts',
			'value' => 1,
		),
	);

	foreach ($conditionals as $elem) {
		if ( $control->id == sprintf( '%1$s_settings[%2$s]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), $elem['id'] ) && 
			$control->manager->get_setting( sprintf( '%1$s_settings[%2$s]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), $elem['parent'] ) )->value() == $elem['value'] 
		) return true;
	};

	// handle landing page hint
	if ( ( $control->id == sprintf( '%1$s_settings[%2$s_landingpage_notice]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) ) && 
		('posts' == get_option('show_on_front')) 
	) return true;
	
	// handle landing page slider banner hint
	if ( ( $control->id == sprintf( '%1$s_settings[%2$s_headerorbannerhint]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) ) && 
			( $control->manager->get_setting( sprintf( '%1$s_settings[%2$s_landingpage]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) )->value() == 1 ) && 
			( $control->manager->get_setting( sprintf( '%1$s_settings[%2$s_lpslider]', cryout_sanitize_tn(_CRYOUT_THEME_NAME), _CRYOUT_THEME_PREFIX ) )->value() == 1 ) 
	) return true;

    return false;

} // septera_conditionals()

$septera_big = array(

/************* general info ***************/

'info_sections' => array(
	'cryoutspecial-about-theme' => array(
		'title' => __( 'About', 'cryout' ) . ' ' . cryout_sanitize_tnl(_CRYOUT_THEME_NAME),
		'desc' => '<img src=" ' . get_template_directory_uri() . '/admin/images/logo-about-header.png" ><br>',
		'button' => TRUE,
		'button_label' => __( 'Get Plus', 'cryout' ),
	),
), // info_sections

'info_settings' => array(
	'plus_link' => array(
		'label' => '',
		'default' => sprintf( '<a class="customizer-plus-link" href="https://www.cryoutcreations.eu/wordpress-themes/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Upgrade to PLUS', 'cryout' ) ),
		'desc' =>  sprintf( __('Find out what features you\'re missing out on and how the Plus version of %1$s can improve your site.', 'cryout'), cryout_sanitize_tnl(_CRYOUT_THEME_NAME) ),
		'section' => 'cryoutspecial-about-theme',
	),
	'support_link_faqs' => array(
		'label' => '',
		'default' => sprintf( '<a href="https://www.cryoutcreations.eu/wordpress-themes/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Read the Docs', 'cryout' ) ),
		'desc' =>  '',
		'section' => 'cryoutspecial-about-theme',
	),
	'support_link_forum' => array(
		'label' => '',
		'default' => sprintf( '<a href="https://www.cryoutcreations.eu/forums/f/wordpress/' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '" target="_blank">%s</a>', __( 'Browse the Forum', 'cryout' ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
	'premium_support_link' => array(
		'label' => '',
		'default' => sprintf( '<a href="https://www.cryoutcreations.eu/priority-support" target="_blank">%s</a>', __( 'Priority Support', 'cryout' ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
	'rating_url' => array(
		'label' => '&nbsp;',
		'default' => sprintf( '<a href="https://wordpress.org/support/view/theme-reviews/'. cryout_sanitize_tn( _CRYOUT_THEME_NAME ).'#postform" target="_blank">%s</a>', sprintf( __( 'Rate %s on WordPress.org', 'cryout' ) , cryout_sanitize_tnl(_CRYOUT_THEME_NAME) ) ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
	'management' => array(
		'label' => '&nbsp;',
		'default' => sprintf( '<a href="themes.php?page=about-' . cryout_sanitize_tn( _CRYOUT_THEME_NAME ) . '-theme">%s</a>', __('Manage Theme Settings', 'cryout') ),
		'desc' => '',
		'section' => 'cryoutspecial-about-theme',
	),
), // info_settings

'panel_overrides' => array(
	'background' => array(
        'title' => __( 'Background', 'cryout' ),
		'desc' => __( 'Background Settings.', 'cryout' ),
		'priority' => 50,
		'section' => 'cryoutoverride-septera_siteidentity',
		'replaces' => 'background_image',
		'type' => 'section',
	),
	'septera_header_section' => array(
		'title' => __( 'Header Image', 'cryout' ),
		'desc' => __( 'Header Image Settings.', 'cryout' ),
		'priority' => 50,
		'section' => 'cryoutoverride-septera_siteidentity',
		'replaces' => 'header_image',
		'type' => 'section',
	),
	'identity' => array(
		'title' => __( 'Site Identity', 'cryout' ),
		'desc' => '',
		'priority' => 50,
		'section' => 'cryoutoverride-septera_siteidentity',
		'replaces' => 'title_tagline',
		'type' => 'section',
	),
	'colors' => array(
		'section' => 'section',
		'replaces' => 'colors',
		'type' => 'remove',
	),

), // panel_overrides

/************* panels *************/

'panels' => array(

	array('id'=>'septera_siteidentity', 'title'=>__('Site Identity','septera'), 'callback'=>'', 'identifier'=>'cryoutoverride-' ),
	array('id'=>'septera_layout_section', 'title'=>__('Layout','septera'), 'callback'=>'' ),
	array('id'=>'septera_header_section', 'title'=>__('Header','septera'), 'callback'=>'' ),
	array('id'=>'septera_landingpage', 'title'=>__('Landing Page','septera'), 'callback'=>'' ),
	array('id'=>'septera_general_section', 'title'=>__('General','septera') , 'callback'=>'' ),
	array('id'=>'septera_colors_section', 'title'=>__('Colors','septera'), 'callback'=>'' ),
	array('id'=>'septera_text_section', 'title'=>__('Typography','septera'), 'callback'=>'' ),
	array('id'=>'septera_post_section', 'title'=>__('Post Information','septera') , 'callback'=>'' ),

), // panels

/************* sections *************/

'sections' => array(

	// layout
	array('id'=>'septera_generallayout', 'title'=>__('General Layout', 'septera'), 'callback'=>'', 'sid'=>'septera_layout_section', 'priority'=>50 ),
	array('id'=>'septera_otherlayout', 'title'=>__('Other Layouts', 'septera'), 'callback'=>'', 'sid'=>'septera_layout_section', 'priority'=>60 ),
	// header
	//array('id'=>'septera_siteheader', 'title'=>__('Header','septera'), 'callback'=>'', 'sid'=> '', 'priority'=>52 ),
	array('id'=>'septera_headermenu', 'title'=>__('Menu','septera'), 'callback'=>'', 'sid'=> 'septera_header_section', 'priority'=>10 ),
	array('id'=>'septera_headercontent', 'title'=>__('Content','septera'), 'callback'=>'', 'sid'=> 'septera_header_section', 'priority'=>12 ),
	// landing page
	array('id'=>'septera_lpgeneral', 'title'=>__('Settings','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 10),
	array('id'=>'septera_lpslider', 'title'=>__('Slider','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 20),
	array('id'=>'septera_lpblocks1', 'title'=>__('Featured Icon Blocks','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 30 ),
	array('id'=>'septera_lpboxes1', 'title'=>__('Featured Boxes','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 40),
	array('id'=>'septera_lpboxes2', 'title'=>__('Featured Boxes 2','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 50),
	array('id'=>'septera_lptexts', 'title'=>__('Text Areas','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 60),
	array('id'=>'septera_lpfcontent', 'title'=>__('Featured Content','septera'), 'callback'=>'', 'sid'=>'septera_landingpage', 'priority' => 70),
	// text
	array('id'=>'septera_fontfamily', 'title'=>__('General Font','septera'), 'callback'=>'', 'sid'=> 'septera_text_section'),
	array('id'=>'septera_fontheader', 'title'=>__('Header Fonts','septera'), 'callback'=>'', 'sid'=> 'septera_text_section'),
	array('id'=>'septera_fontwidget', 'title'=>__('Widget Fonts','septera'), 'callback'=>'', 'sid'=> 'septera_text_section'),
	array('id'=>'septera_fontcontent', 'title'=>__('Content Fonts','septera'), 'callback'=>'', 'sid'=> 'septera_text_section'),
	array('id'=>'septera_textformatting', 'title'=>__('Formatting','septera'), 'callback'=>'', 'sid'=> 'septera_text_section'),
	// general
	array('id'=>'septera_contentstructure', 'title'=>__('Structure','septera'), 'callback'=>'', 'sid'=> 'septera_general_section'),
	array('id'=>'septera_contentgraphics', 'title'=>__('Decorations','septera'), 'callback'=>'', 'sid'=> 'septera_general_section'),
	array('id'=>'septera_postimage', 'title'=>__('Content Images','septera'), 'callback'=>'', 'sid'=> 'septera_general_section'),
	array('id'=>'septera_searchbox', 'title'=>__('Search Box Locations','septera'), 'callback'=>'', 'sid'=> 'septera_general_section'),
	array('id'=>'septera_socials', 'title'=>__('Social Icons','septera'), 'callback'=>'', 'sid'=>'septera_general_section'),
	// colors
	array('id'=>'septera_colors', 'title'=>__('Content','septera'), 'callback'=>'', 'sid'=> 'septera_colors_section'),
	array('id'=>'septera_colors_header', 'title'=>__('Header','septera'), 'callback'=>'', 'sid'=> 'septera_colors_section'),
	array('id'=>'septera_colors_footer', 'title'=>__('Footer','septera'), 'callback'=>'', 'sid'=> 'septera_colors_section'),
	array('id'=>'septera_colors_lp', 'title'=>__('Landing Page','septera'), 'callback'=>'', 'sid'=> 'septera_colors_section'),
	// post info
	array('id'=>'septera_featured', 'title'=>__('Featured Image', 'septera'), 'callback'=>'', 'sid'=>'septera_post_section', 'priority' => 10),
	array('id'=>'septera_metas', 'title'=>__('Meta Information','septera'), 'callback'=>'', 'sid'=> 'septera_post_section', 'priority' => 20),
	array('id'=>'septera_excerpts', 'title'=>__('Excerpts','septera'), 'callback'=>'', 'sid'=> 'septera_post_section', 'priority' => 30),
	array('id'=>'septera_comments', 'title'=>__('Comments','septera'), 'callback'=>'', 'sid'=> 'septera_post_section', 'priority' => 40),
	// misc
	array('id'=>'septera_misc', 'title'=>__('Miscellaneous','septera'), 'callback'=>'', 'sid'=>'', 'priority' => 92 ),

	/*** developer options ***/
	//array('id'=>'septera_developer', 'title'=>__('[ Developer Options ]','septera'), 'callback'=>'', 'sid'=>'', 'priority'=>101 ),

), // sections

/************ clone options *********/
'clones' => array (
	'septera_lpboxes' => 2,
),

/************* settings *************/

'options' => array (
	//////////////////////////////////////////////////// Layout ////////////////////////////////////////////////////
	array(
	// this option needs to always be first; its index is used in the page/post meta option !!!
	'id' => 'septera_sitelayout',
		'type' => 'radioimage',
		'label' => __('Main Layout','septera'),
		'choices' => array(
			'1c' => array(
				'label' => __("One column (no sidebars)","septera"),
				'url'   => '%s/admin/images/1c.png'
			),
			'2cSr' => array(
				'label' => __("Two columns, sidebar on the right","septera"),
				'url'   => '%s/admin/images/2cSr.png'
			),
			'2cSl' => array(
				'label' => __("Two columns, sidebar on the left","septera"),
				'url'   => '%s/admin/images/2cSl.png'
			),
			'3cSr' => array(
				'label' => __("Three columns, sidebars on the right","septera"),
				'url'   => '%s/admin/images/3cSr.png'
			),
			'3cSl' => array(
				'label' => __("Three columns, sidebars on the left","septera"),
				'url'   => '%s/admin/images/3cSl.png'
			),
			'3cSs' => array(
				'label' => __("Three columns, one sidebar on each side","septera"),
				'url'   => '%s/admin/images/3cSs.png'
			),
		),
		'desc' => '',
	'section' => 'septera_generallayout' ),
	array(
	'id' => 'septera_layoutalign',
		'type' => 'select',
		'label' => __('Theme alignment','septera'),
		'values' => array( 0, 1 ),
		'labels' => array( __('Wide','septera'), __('Boxed','septera') ),
		'desc' => "",
	'section' => 'septera_generallayout' ),
	array(
	'id' => 'septera_sitewidth',
		'type' => 'numberslider',
		'label' => __('Site Width','septera'),
		'min' => 960, 'max' => 1920, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'septera_generallayout' ),
	array(
	'id' => 'septera_primarysidebar',
		'type' => 'numberslider',
		'label' => __('Left Sidebar Width','septera'),
		'min' => 200, 'max' => 600, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'septera_generallayout' ),
	array(
	'id' => 'septera_secondarysidebar',
		'type' => 'numberslider',
		'label' => __('Right Sidebar Width','septera'),
		'min' => 200, 'max' => 600, 'step' => 10, 'um' => 'px',
		'desc' => "",
	'section' => 'septera_generallayout' ),

	// the other layouts
	array(
	'id' => 'septera_magazinelayout',
		'type' => 'radioimage',
		'label' => __('Posts Layout','septera'),
		'choices' => array(
			1 => array(
				'label' => __("One column","septera"),
				'url'   => '%s/admin/images/magazine-1col.png'
			),
			2 => array(
				'label' => __("Two columns","septera"),
				'url'   => '%s/admin/images/magazine-2col.png'
			),
			3 => array(
				'label' => __("Three columns","septera"),
				'url'   => '%s/admin/images/magazine-3col.png'
			),
		),
		'desc' => '',
	'section' => 'septera_otherlayout' ),
	array(
	'id' => 'septera_elementpadding',
		'type' => 'numberslider',
		'label' => __('Post/page padding','septera'),
		'min' => 1,
		'max' => 10,
		'step' => 1,
		'um' => '%',
		'desc' => '',
	'section' => 'septera_otherlayout' ),

	array(
	'id' => 'septera_footercols',
		'type' => 'select',
		'label' => __("Footer Widgets Columns","septera"),
		'values' => array(0, 1, 2, 3, 4),
		'labels' => array(
			__( 'All in a row', 'septera' ),
			__( '1 Column', 'septera' ),
			__( '2 Columns', 'septera' ),
			__( '3 Columns', 'septera' ),
			__( '4 Columns', 'septera' ),
		),
		'desc' => '',
	'section' => 'septera_otherlayout' ),
	array(
	'id' => 'septera_footeralign',
		'type' => 'select',
		'values' => array( 0 , 1 ),
		'labels' => array( __("Default","septera"), __("Center","septera") ),
		'label' => __('Footer Widgets Alignment','septera'),
		'desc' => "",
	'section' => 'septera_otherlayout' ),

	// Header-related hint to WP's Site Identity
	array(
	'id' => 'septera_headerhints',
		'type' => 'notice',
		'label' => '',
		'desc' => sprintf( __( 'Fine tune the visibility of these elements from the theme\'s %s','septera' ), '<a data-type="section" data-id="cryout-septera_headercontent" class="cryout-customizer-focus"><strong>' . __('Header options', 'septera') . ' &raquo;</strong></a>' ),
		'input_attrs' => array( 'class' => '' ),
		'priority' => 55,
		'addon' => TRUE, // this option gets added to built-in WordPress section
	'section' => 'title_tagline' ),
	array(
	'id' => 'septera_headerorbannerhint',
		'type' => 'notice',
		'label' => '',
		'desc' => sprintf( __( 'Configure the image currently visible on the homepage from the theme\'s options under %s','septera' ), '<a data-type="section" data-id="cryout-theme_lpslider" class="cryout-customizer-focus"><strong>' . __('Landing Page > Slider > Banner Image', 'septera') . ' &raquo;</strong></a>' ),
		'input_attrs' => array( 'class' => '' ),
		'priority' => 9,
		'active_callback' => 'septera_conditionals',
		'addon' => TRUE, // this option gets added to built-in WordPress section
	'section' => 'header_image' ),

	// Header
	array(
	'id' => 'septera_menustyle',
		'type' => 'toggle',
		'values' => array( 0, 1 ),
		'label' => __('Fixed Menu','septera'),
		'desc' => "",
	'section' => 'septera_headermenu' ),
	array(
	'id' => 'septera_menuheight',
		'type' => 'numberslider',
		'min' => 45,
		'max' => 200,
		'step' => 1,
		'um' => 'px',
		'label' => __('Header/Menu Height','septera'),
		'desc' => "",
	'section' => 'septera_headermenu' ),
	array(
	'id' => 'septera_menuposition',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Normal","septera"), __("Over header image","septera") ),
		'label' => __('Menu Position','septera'),
		'desc' => "",
	'section' => 'septera_headermenu' ),
	array(
	'id' => 'septera_menulayout',
		'type' => 'select',
		'values' => array( 0, 1, 2 ),
		'labels' => array( __("Left", "septera"), __("Right","septera"), __("Center","septera") ),
		'label' => __('Menu Alignment','septera'),
		'desc' => "",
	'section' => 'septera_headermenu' ),
	array(
	'id' => 'septera_siteheader',
		'type' => 'select',
		'label' => __('Site Header Content','septera'),
		'values' => array( 'title' , 'logo' , 'both' , 'empty' ),
		'labels' => array( __("Site Title","septera"), __("Logo","septera"), __("Logo & Site Title","septera"), __("Empty","septera") ),
		'desc' => '',
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_sitetagline',
		'type' => 'checkbox',
		'label' => __('Show Tagline','septera'),
		'desc' => '',
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_logoupload',
		'type' => 'media-image',
		'label' => __('Logo Image','septera'),
		'desc' => '',
		'disable_if' => 'the_custom_logo',
	'section' => 'septera_siteheader' ),
	array(
	'id' => 'septera_identityhints',
		'type' => 'notice',
		'input_attrs' => array( 'class' => '' ),
		'label' => '',
		'desc' => sprintf( __( 'Edit the site\'s title, tagline and logo from the %s panel','septera' ), '<a data-type="section" data-id="title_tagline" class="cryout-customizer-focus"><strong>' . __('Site Identity', 'septera') . ' </strong></a>' ),
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_headerheight',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 800,
		'um' => 'px',
		'label' => __('Header Image Height','septera'),
		'desc' => '',
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_headerheight_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","septera"),
		//'active_callback' => 'septera_conditionals',
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_headerresponsive',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Cropped","septera"), __("Contained","septera") ),
		'label' => __('Header Image Behaviour','septera'),
		'desc' => "",
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_headerwidgetwidth',
		'type' => 'select',
		'label' => __("Header Widget Width","septera"),
		'values' => array( "100%" , "60%" , "50%" , "33%" , "25%" ),
		'desc' => '',
	'section' => 'septera_headercontent' ),
	array(
	'id' => 'septera_headerwidgetalign',
		'type' => 'select',
		'label' => __("Header Widget Alignment","septera"),
		'values' => array( 'left' , 'center' , 'right' ),
		'labels' => array( __("Left","septera"), __("Center","septera"), __("Right","septera") ),
		'desc' => '',
	'section' => 'septera_headercontent' ),

	//////////////////////////////////////////////////// Landing Page ////////////////////////////////////////////////////
	array(
	'id' => 'septera_landingpage',
		'type' => 'select',
		'label' => __('Landing Page','septera'),
		'values' => array( 1, 0 ),
		'labels' => array( __("Enabled","septera"), __("Disabled (use WordPress homepage)","septera") ),
		'desc' => '',
	'section' => 'septera_lpgeneral' ),
	array(
	'id' => 'septera_landingpage_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => sprintf( __( "To activate the Landing Page, make sure to set the WordPress <strong>Front Page displays</strong> option to %s","septera" ), "<a data-type='section' data-id='static_front_page' class='cryout-customizer-focus'><strong>" . __("use a static page", "septera") . " &raquo;</strong></a>" ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpgeneral' ),
	array(
	'id' => 'septera_lpposts',
		'type' => 'select',
		'label' => __('Featured Content','septera'),
		'values' => array( 2, 1, 0 ),
		'labels' => array( __("Static Page", "septera"), __("Posts", "septera"), __("Disabled", "septera") ),
		'desc' => '',
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpfcontent' ),
	array(
	'id' => 'septera_lpposts_more',
		'type' => 'text',
		'label' => __( 'More Posts Label', 'septera' ),
		'desc' => '',
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpfcontent' ),

	// slider
	array(
	'id' => 'septera_lpslider',
		'type' => 'select',
		'label' => __('Slider','septera'),
		'values' => array( 4, 2, 1, 3, 0 ),
		'labels' => array(
			__("Serious Slider", "septera"),
			__("Use Shortcode","septera"),
			__("Banner Image","septera"),
			__("Header Image","septera"),
			__("Disabled","septera")
		),
		'desc' => sprintf( __("To create an advanced slider, use our <a href='%s' target='_blank'>Serious Slider</a> plugin or any other slider plugin.","septera"), 'https://wordpress.org/plugins/cryout-serious-slider/' ),
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpsliderimage',
		'type' => 'media-image',
		'label' => __('Banner Image','septera'),
		'desc' => __('The default image can be replaced by setting a new banner image.', 'septera'),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpsliderlink',
		'type' => 'url',
		'label' => __('Banner Link','septera'),
		'desc' => '',
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidershortcode',
		'type' => 'text',
		'label' => __('Shortcode','septera'),
		'desc' => __('Enter shortcode provided by slider plugin. The plugin will be responsible for the slider\'s appearance.','septera'),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpsliderserious',
		'type' => 'select',
		'label' => __('Serious Slider','septera'),
		'values' => cryout_serious_slides_for_customizer(1, 0),
		'labels' => cryout_serious_slides_for_customizer(2, __(' - Please install, activate or update Serious Slider plugin - ', 'septera'), __(' - No sliders defined - ', 'septera') ),
		'desc' => __('Select the desired slider from the list. Sliders can be administered in the dashboard.','septera'),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidertitle',
		'type' => 'text',
		'label' => __('Caption','septera'),
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Title', 'septera') ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidertext',
		'type' => 'textarea',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'septera') ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidercta1text',
		'type' => 'text',
		'label' => __('CTA Button','septera') . ' #1',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'septera') ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidercta1link',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Link', 'septera') ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidercta2text',
		'type' => 'text',
		'label' => __('CTA Button','septera') . ' #2',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Text', 'septera') ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),
	array(
	'id' => 'septera_lpslidercta2link',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('Link', 'septera') ),
		'active_callback' => 'septera_conditionals',
	'section' => 'septera_lpslider' ),

	// blocks
	array(
	'id' => 'septera_lpblockmaintitle#',
		'type' => 'text',
		'label' => __('Section Title','septera'),
		'desc' => '',
		'priority' => 10,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockmaindesc#',
		'type' => 'textarea',
		'label' => __( 'Section Description', 'septera' ),
		'desc' => '',
		'priority' => 15,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockspacer1#',
		'type' => 'spacer',
		'priority' => 15,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockscontent#',
		'type' => 'select',
		'label' => __('Blocks Content','septera'),
		'values' => array( -1, 0, 1, 2 ),
		'labels' => array( __("Disabled","septera"), __("No Text","septera"), __("Excerpt","septera"), __("Full Content","septera") ),
		'desc' => '',
		'priority' => 20,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblocksreadmore#',
		'type' => 'text',
		'label' => __('Read More Button','septera'),
		'desc' => __("Configure the 'Read More' link text.","septera"),
		'priority' => 22,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblocksclick#',
		'type' => 'checkbox',
		'label' => __('Make icons clickable (linking to their respective pages).','septera'),
		'desc' => '',
		'priority' => 23,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockspacer2#',
		'type' => 'spacer',
		'priority' => 23,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockoneicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','septera'), 1),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 25,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockone#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'desc' => '&nbsp;',
		'priority' => 26,
	'section' => 'septera_lpblocks#' ),

	array(
	'id' => 'septera_lpblocktwoicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','septera'), 2),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 27,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblocktwo#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'desc' => '&nbsp;',
		'priority' => 28,
	'section' => 'septera_lpblocks#' ),

	array(
	'id' => 'septera_lpblockthreeicon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','septera'), 3),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 29,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockthree#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'desc' => '&nbsp;',
		'priority' => 30,
	'section' => 'septera_lpblocks#' ),

	array(
	'id' => 'septera_lpblockfouricon#',
		'type' => 'iconselect',
		'label' => sprintf( __('Block %d','septera'), 4),
		'values' => array(),
		'labels' => array(),
		'desc' => '',
		'priority' => 31,
	'section' => 'septera_lpblocks#' ),
	array(
	'id' => 'septera_lpblockfour#',
		'type' => 'select',
		'label' => '',
		'values' => cryout_pages_for_customizer(1, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'labels' => cryout_pages_for_customizer(2, sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'desc' => '&nbsp;',
		'priority' => 32,
	'section' => 'septera_lpblocks#' ),


	// boxes #cloned#
	array(
	'id' => 'septera_lpboxmaintitle#',
		'type' => 'text',
		'label' => __('Section Title','septera'),
		'desc' => '',
		'priority' => 10,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxmaindesc#',
		'type' => 'textarea',
		'label' => __( 'Section Description', 'septera' ),
		'desc' => '',
		'priority' => 20,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxspacer1#',
		'type' => 'spacer',
		'priority' => 20,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxcat#',
		'type' => 'select',
		'label' => __('Boxes Content','septera'),
		'values' => cryout_categories_for_customizer(1, __('All Categories', 'septera'), sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'labels' => cryout_categories_for_customizer(2, __('All Categories', 'septera'), sprintf( '- %s -', __('Disabled', 'septera') ) ),
		'desc' => '',
		'priority' => 30,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxcount#',
		'type' => 'numberslider',
		'min' => 1,
		'max' => 30,
		'step' => 1,
		'input_attrs' => array(
			'min' => 1,
			'max' => 100,
		),
		'label' => __('Number of Boxes','septera'),
		'desc' => '',
		'priority' => 40,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxrow#',
		'type' => 'select',
		'label' => __('Boxes Per Row','septera'),
		'values' => array( 1, 2, 3, 4 ),
		'desc' => '',
		'priority' => 50,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxheight#',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 600,
		'step' => 1,
		'um' => 'px',
		'input_attrs' => array(
			'min' => 1,
			'max' => 2000,
		),
		'label' => __('Box Height','septera'),
		'desc' => __("The width is a percentage dependent on total site width and number of columns per row.","septera"),
		'priority' => 60,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxspacer2#',
		'type' => 'spacer',
		'priority' => 60,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxlayout#',
		'type' => 'select',
		'label' => __('Box Layout','septera'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Full width","septera"), __("Boxed","septera") ),
		'desc' => '',
		'priority' => 70,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxmargins#',
		'type' => 'select',
		'label' => __('Box Stacking','septera'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Joined","septera"), __("Apart","septera") ),
		'desc' => '',
		'priority' => 80,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxanimation#',
		'type' => 'select',
		'label' => __('Box Appearance','septera'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Animated","septera"), __("Static","septera") ),
		'desc' => '',
		'priority' => 90,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxspacer3#',
		'type' => 'spacer',
		'priority' => 91,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxreadmore#',
		'type' => 'text',
		'label' => __('Read More Button','septera'),
		'desc' => '',
		'priority' => 100,
	'section' => 'septera_lpboxes#' ),
	array(
	'id' => 'septera_lpboxlength#',
		'type' => 'numberslider',
		'min' => 1,
		'max' => 100,
		'step' => 1,
		'label' => __('Content Length (words)','septera'),
		'desc' => '',
		'priority' => 110,
	'section' => 'septera_lpboxes#' ),

	// texts
	array(
	'id' => 'septera_lptextone',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','septera'), 1),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'septera') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'septera') ),
		'desc' => '',
	'section' => 'septera_lptexts' ),
	array(
	'id' => 'septera_lptexttwo',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','septera'), 2),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'septera') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'septera') ),
		'desc' => '',
	'section' => 'septera_lptexts' ),
	array(
	'id' => 'septera_lptextthree',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','septera'), 3),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'septera') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'septera') ),
		'desc' => '',
	'section' => 'septera_lptexts' ),
	array(
	'id' => 'septera_lptextfour',
		'type' => 'select',
		'label' => sprintf( __('Text Area %d','septera'), 4),
		'values' => cryout_pages_for_customizer(1, __('Disabled', 'septera') ),
		'labels' => cryout_pages_for_customizer(2, __('Disabled', 'septera') ),
		'desc' => '',
	'section' => 'septera_lptexts' ),

	array(
	'id' => 'septera_lptexthint',
		'type' => 'hint',
		'label' => '',
		'desc' => __("Page properties that will be used:<br>- page title as text title<br>- page content as text content<br>- page featured image as text area background image","septera"),
		'priority' => 99,
	'section' => 'septera_lptexts' ),

	//////////////////////////////////////////////////// Colors ////////////////////////////////////////////////////

	array(
	'id' => 'septera_sitebackground',
		'type' => 'color',
		'label' => __('Site Background','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_sitetext',
		'type' => 'color',
		'label' => __('Site Text','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_headingstext',
		'type' => 'color',
		'label' => __('Content Headings','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_contentbackground',
		'type' => 'color',
		'label' => __('Content Background','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_primarybackground',
		'type' => 'color',
		'label' => __('Left Sidebar Background','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_secondarybackground',
		'type' => 'color',
		'label' => __('Right Sidebar Background','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_colorsspacer1',
		'type' => 'spacer',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_headeroverlay',
		'type' => 'color',
		'label' => __('Overlay Color','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_headeroverlayopacity',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'um' => '%',
		'readonly' => true,
		'label' => __('Overlay Opacity','septera'),
		'desc' => "",
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_colorsspacer2',
		'type' => 'spacer',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_accent1',
		'type' => 'color',
		'label' => __('Primary Accent','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),
	array(
	'id' => 'septera_accent2',
		'type' => 'color',
		'label' => __('Secondary Accent','septera'),
		'desc' => '',
	'section' => 'septera_colors' ),

	array(
	'id' => 'septera_menubackground',
		'type' => 'color',
		'label' => __('Header Background','septera'),
		'desc' => '',
	'section' => 'septera_colors_header' ),
	array(
	'id' => 'septera_menutext',
		'type' => 'color',
		'label' => __('Menu Text','septera'),
		'desc' => '',
	'section' => 'septera_colors_header' ),
	array(
	'id' => 'septera_menutextoverlay',
		'type' => 'color',
		'label' => __('Text on header overlay','septera'),
		'desc' => '',
	'section' => 'septera_colors_header' ),
	array(
	'id' => 'septera_submenutext',
		'type' => 'color',
		'label' => __('Submenu Text','septera'),
		'desc' => '',
	'section' => 'septera_colors_header' ),
	array(
	'id' => 'septera_submenubackground',
		'type' => 'color',
		'label' => __('Submenu Background','septera'),
		'desc' => '',
	'section' => 'septera_colors_header' ),
	array(
	'id' => 'septera_footerbackground',
		'type' => 'color',
		'label' => __('Footer Background','septera'),
		'desc' => '',
	'section' => 'septera_colors_footer' ),
	array(
	'id' => 'septera_footertext',
		'type' => 'color',
		'label' => __('Footer Text','septera'),
		'desc' => '',
	'section' => 'septera_colors_footer' ),
	array(
	'id' => 'septera_lpsliderbg',
		'type' => 'color',
		'label' => __('Slider Background','septera'),
		'desc' => '',
	'section' => 'septera_colors_lp' ),
	array(
	'id' => 'septera_lpblocksbg',
		'type' => 'color',
		'label' => __('Blocks','septera'),
		'desc' => '',
	'section' => 'septera_colors_lp' ),
	array(
	'id' => 'septera_lpboxesbg',
		'type' => 'color',
		'label' => __('Boxes','septera'),
		'desc' => '',
	'section' => 'septera_colors_lp' ),
	array(
	'id' => 'septera_lptextsbg',
		'type' => 'color',
		'label' => __('Text Areas','septera'),
		'desc' => '',
	'section' => 'septera_colors_lp' ),

	//////////////////////////////////////////////////// Fonts ////////////////////////////////////////////////////
	// general font
	array(
	'id' => 'septera_fgeneralsize',
		'type' => 'select',
		'label' => __('General Font','septera'),
		'values' => cryout_gen_values( 12, 20, 1, array('um'=>'px') ),
		'desc' => '',
	'section' => 'septera_fontfamily' ),
	array(
	'id' => 'septera_fgeneralweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontfamily' ),
	array(
	'id' => 'septera_fgeneral',
		'type' => 'font',
		'label' => '',
		'desc' => '',
		'no_inherit' => TRUE,
	'section' => 'septera_fontfamily' ),
	array(
	'id' => 'septera_fgeneralgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => __("The fonts under the <em>Preferred Theme Fonts</em> list are recommended because they have all the font weights used throughout the theme.","septera"),
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontfamily' ),

	// header fonts
	array( // site title
	'id' => 'septera_fsitetitlesize',
		'type' => 'select',
		'label' => __('Site Title','septera'),
		'values' => cryout_gen_values( 90, 250, 10, array('um'=>'%') ),
		'desc' => '',
	'section' => 'septera_fontheader' ),
	array(
	'id' => 'septera_fsitetitleweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontheader' ),
	array(
	'id' => 'septera_fsitetitle',
		'type' => 'font',
		'label' => '',
		'desc' => '',
	'section' => 'septera_fontheader' ),
	array(
	'id' => 'septera_fsitetitlegoogle',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontheader' ),

	array( // menu
	'id' => 'septera_fmenusize',
		'type' => 'select',
		'label' => __('Main Menu','septera'),
		'values' => cryout_gen_values( 80, 140, 5, array('um'=>'%') ),
		'desc' => '',
	'section' => 'septera_fontheader' ),
	array(
	'id' => 'septera_fmenuweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontheader' ),
	array(
	'id' => 'septera_fmenu',
		'type' => 'font',
		'label' => '',
		'desc' => '',
	'section' => 'septera_fontheader' ),
	array(
	'id' => 'septera_fmenugoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontheader' ),

	// widget fonts
	array( // widget title
	'id' => 'septera_fwtitlesize',
		'type' => 'select',
		'label' => __('Widget Title','septera'),
		'values' => cryout_gen_values( 80, 120, 10, array('um'=>'%') ),
		'desc' => '',
	'section' => 'septera_fontwidget' ),
	array(
	'id' => 'septera_fwtitleweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontwidget' ),
	array(
	'id' => 'septera_fwtitle',
		'type' => 'font',
		'label' => '',
		'desc' => '',
	'section' => 'septera_fontwidget' ),
	array(
	'id' => 'septera_fwtitlegoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontwidget' ),

	array(
	'id' => 'septera_fwcontentsize',
		'type' => 'select',
		'label' => __('Widget Content','septera'),
		'values' => cryout_gen_values( 80, 120, 10, array('um'=>'%') ),
		'desc' => '',
	'section' => 'septera_fontwidget' ),
	array(
	'id' => 'septera_fwcontentweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontwidget' ),
	array(
	'id' => 'septera_fwcontent',
		'type' => 'font',
		'label' => '',
		'desc' => '',
	'section' => 'septera_fontwidget' ),
	array(
	'id' => 'septera_fwcontentgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontwidget' ),

	// content fonts
	array( // post/page
	'id' => 'septera_ftitlessize',
		'type' => 'select',
		'label' => __('Post/Page Titles','septera'),
		'values' => cryout_gen_values( 130, 300, 10, array('um'=>'%') ),
		'desc' => '',
	'section' => 'septera_fontcontent' ),
	array(
	'id' => 'septera_ftitlesweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontcontent' ),
	array(
	'id' => 'septera_ftitles',
		'type' => 'font',
		'label' => '',
		'desc' => '',
	'section' => 'septera_fontcontent' ),
	array(
	'id' => 'septera_ftitlesgoogle',
		'type' => 'googlefont',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontcontent' ),

	array( // headings
	'id' => 'septera_fheadingssize',
		'type' => 'select',
		'label' => __('Headings','septera'),
		'values' => cryout_gen_values( 100, 150, 10, array('um'=>'%') ),
		'desc' => '',
	'section' => 'septera_fontcontent' ),
	array(
	'id' => 'septera_fheadingsweight',
		'type' => 'select',
		'label' => '',
		'values' => array('100', '200', '300', '400', '500', '600', '700', '800', '900'),
		'labels' => array( __('100 thin','septera'), __('200 extra-light','septera'), __('300 ligher','septera'), __('400 regular','septera'), __('500 medium','septera'), __('600 semi-bold','septera'), __('700 bold','septera'), __('800 extra-bold','septera'), __('900 black','septera') ),
		'desc' => '',
	'section' => 'septera_fontcontent' ),
	array(
	'id' => 'septera_fheadings',
		'type' => 'font',
		'label' => '',
		'desc' => '',
	'section' => 'septera_fontcontent' ),
	array(
	'id' => 'septera_fheadingsgoogle',
		'type' => 'text',
		'label' => '',
		'desc' => '',
		'input_attrs' => array( 'placeholder' => __('or enter Google Font Identifier','septera') ),
	'section' => 'septera_fontcontent' ),

	// formatting
	array(
	'id' => 'septera_lineheight',
		'type' => 'numberslider',
		'label' => __('Line Height','septera'),
		'min' => 1.0, 'max' => 2.4, 'step' => 0.2, 'um' => 'em',
		'desc' => '',
	'section' => 'septera_textformatting' ),
	array(
	'id' => 'septera_textalign',
		'type' => 'select',
		'label' => __('Text Alignment','septera'),
		'values' => array( "inherit" , "left" , "right" , "justify" , "center" ),
		'labels' => array( __("Default","septera"), __("Left","septera"), __("Right","septera"), __("Justify","septera"), __("Center","septera") ),
		'desc' => '',
	'section' => 'septera_textformatting' ),
	array(
	'id' => 'septera_paragraphspace',
		'type' => 'numberslider',
		'label' => __('Paragraph Spacing','septera'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'septera_textformatting' ),
	array(
	'id' => 'septera_parindent',
		'type' => 'numberslider',
		'label' => __('Paragraph Indentation','septera'),
		'min' => 0, 'max' => 2, 'step' => 0.1, 'um' => 'em',
		'desc' => '',
	'section' => 'septera_textformatting' ),

	//////////////////////////////////////////////////// Structure ////////////////////////////////////////////////////

	array(
	'id' => 'septera_breadcrumbs',
		'type' => 'toggle',
		'label' => __('Breadcrumbs','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'septera_contentstructure' ),
	array(
	'id' => 'septera_pagination',
		'type' => 'toggle',
		'label' => __('Numbered Pagination','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'septera_contentstructure' ),
	array(
	'id' => 'septera_contenttitles',
		'type' => 'select',
		'label' => __('Page/Category Titles','septera'),
		'values' => array( 1, 2, 3, 0 ),
		'labels' => array( __('Always Visible','septera'), __('Hide on Pages','septera'), __('Hide on Categories','septera'), __('Always Hidden','septera') ),
		'desc' => '',
	'section' => 'septera_contentstructure' ),
	array(
	'id' => 'septera_totop',
		'type' => 'select',
		'label' => __('Back to Top Button','septera'),
		'values' => array( 'septera-totop-normal', 'septera-totop-fixed', 'septera-totop-disabled' ),
		'labels' => array( __("Bottom of page","septera"), __("In footer","septera"), __("Disabled","septera") ),
		'desc' => '',
	'section' => 'septera_contentstructure' ),
	array(
	'id' => 'septera_tables',
		'type' => 'select',
		'label' => __('Tables Style','septera'),
		'values' => array( 'septera-no-table', 'septera-clean-table', 'septera-stripped-table', 'septera-bordered-table' ),
		'labels' => array( __("No border","septera"), __("Clean","septera"), __("Stripped","septera"), __("Bordered","septera") ),
		'desc' => '',
	'section' => 'septera_contentstructure' ),
	array(
	'id' => 'septera_normalizetags',
		'type' => 'select',
		'label' => __('Tags Cloud Appearance','septera'),
		'values' => array( 0, 1 ),
		'labels' => array( __("Size Emphasis","septera"), __("Uniform Boxes","septera") ),
		'desc' => '',
	'section' => 'septera_contentstructure' ),
	array(
		'id' => 'septera_copyright',
		'type' => 'textarea',
		'label' => __( 'Custom Footer Text', 'septera' ),
		'desc' => __("Insert custom text or basic HTML code that will appear in your footer. <br /> You can use HTML to insert links, images and special characters.","septera"),
		'section' => 'septera_contentstructure' ),

	//////////////////////////////////////////////////// Graphics ////////////////////////////////////////////////////

	array(
	'id' => 'septera_elementborder',
		'type' => 'checkbox',
		'label' => __('Border','septera'),
		'desc' => '',
	'section' => 'septera_contentgraphics' ),
	array(
	'id' => 'septera_elementshadow',
		'type' => 'checkbox',
		'label' => __('Shadow','septera'),
		'desc' => '',
	'section' => 'septera_contentgraphics' ),
	array(
	'id' => 'septera_elementborderradius',
		'type' => 'checkbox',
		'label' => __('Rounded Corners','septera'),
		'desc' => __('These decorations apply to certain theme elements.','septera'),
	'section' => 'septera_contentgraphics' ),
	array(
	'id' => 'septera_articleanimation',
		'type' => 'select',
		'label' => __('Article Animation on Scroll','septera'),
		'values' => array( 'none', 'fade', 'slide', 'grow'),
		'labels' => array( __("None","septera"), __("Fade","septera"), __("Slide","septera"), __("Grow","septera") ),
		'desc' => '',
	'section' => 'septera_contentgraphics' ),

	//////////////////////////////////////////////////// Search Box ////////////////////////////////////////////////////

	array(
	'id' => 'septera_searchboxmain',
		'type' => 'checkbox',
		'label' => __('Add Search to Main Menu','septera'),
		'desc' => '',
	'section' => 'septera_searchbox' ),
	array(
	'id' => 'septera_searchboxfooter',
		'type' => 'checkbox',
		'label' => __('Add Search to Footer Menu','septera'),
		'desc' => '',
	'section' => 'septera_searchbox' ),

	//////////////////////////////////////////////////// Content Image ////////////////////////////////////////////////////

	array(
	'id' => 'septera_image_style',
		'type' => 'radioimage',
		'label' => __('Post Images','septera'),
		'choices' => array(
			'septera-image-none' => array(
				'label' => __("No Styling","septera"),
				'url'   => '%s/admin/images/image-style-0.png'
			),
			'septera-image-one' => array(
				'label' => sprintf( __("Style %d","septera"), 1),
				'url'   => '%s/admin/images/image-style-1.png'
			),
			'septera-image-two' => array(
				'label' => sprintf( __("Style %d","septera"), 2),
				'url'   => '%s/admin/images/image-style-2.png'
			),
			'septera-image-three' => array(
				'label' => sprintf( __("Style %d","septera"), 3),
				'url'   => '%s/admin/images/image-style-3.png'
			),
			'septera-image-four' => array(
				'label' => sprintf( __("Style %d","septera"), 4),
				'url'   => '%s/admin/images/image-style-4.png'
			),
			'septera-image-five' => array(
				'label' => sprintf( __("Style %d","septera"), 5),
				'url'   => '%s/admin/images/image-style-5.png'
			),
		),
		'desc' => '',
	'section' => 'septera_postimage' ),
	array(
	'id' => 'septera_caption_style',
		'type' => 'select',
		'label' => __('Post Captions','septera'),
		'values' => array( 'septera-caption-zero', 'septera-caption-one', 'septera-caption-two' ),
		'labels' => array( __('Plain','septera'), __('With Border','septera'), __('With Background','septera') ),
		'desc' => '',
	'section' => 'septera_postimage' ),


	//////////////////////////////////////////////////// Post Information ////////////////////////////////////////////////////

	array( // meta
	'id' => 'septera_meta_author',
		'type' => 'checkbox',
		'label' => __("Display Author","septera"),
		'desc' => '',
	'section' => 'septera_metas' ),
	array(
	'id' => 'septera_meta_date',
		'type' => 'checkbox',
		'label' => __("Display Date","septera"),
		'desc' => '',
	'section' => 'septera_metas' ),
	array(
	'id' => 'septera_meta_time',
		'type' => 'checkbox',
		'label' => __("Display Time","septera"),
		'desc' => '',
	'section' => 'septera_metas' ),
	array(
	'id' => 'septera_meta_category',
		'type' => 'checkbox',
		'label' => __("Display Category","septera"),
		'desc' => '',
	'section' => 'septera_metas' ),
	array(
	'id' => 'septera_meta_tag',
		'type' => 'checkbox',
		'label' => __("Display Tags","septera"),
		'desc' => '',
	'section' => 'septera_metas' ),
	array(
	'id' => 'septera_meta_comment',
		'type' => 'checkbox',
		'label' => __("Display Comments","septera"),
		'desc' => __("Choose meta information to show on posts.","septera"),
	'section' => 'septera_metas' ),

	// excerpts
	array(
	'id' => 'septera_excerpthome',
		'type' => 'select',
		'label' => __( 'Standard Posts On Homepage', 'septera' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Excerpt","septera"), __("Full Post","septera") ),
		'desc' => __("Post formats always display full posts.","septera"),
	'section' => 'septera_excerpts' ),
	array(
	'id' => 'septera_excerptsticky',
		'type' => 'select',
		'label' => __( 'Sticky Posts on Homepage', 'septera' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Inherit","septera"), __("Full Post","septera") ),
		'desc' => '',
	'section' => 'septera_excerpts' ),
	array(
	'id' => 'septera_excerptarchive',
		'type' => 'select',
		'label' => __( 'Standard Posts in Categories/Archives', 'septera' ),
		'values' => array( 'excerpt', 'full' ),
		'labels' => array( __("Excerpt","septera"), __("Full Post","septera") ),
		'desc' => '',
	'section' => 'septera_excerpts' ),
	array(
	'id' => 'septera_excerptlength',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 100,
		'step' => 1,
		'label' => __( 'Excerpt Length (words)' , 'septera' ),
		'desc' => '',
	'section' => 'septera_excerpts' ),
	array(
	'id' => 'septera_excerptdots',
		'type' => 'text',
		'label' => __( 'Excerpt Suffix', 'septera' ),
		'desc' => '',
	'section' => 'septera_excerpts' ),
	array(
	'id' => 'septera_excerptcont',
		'type' => 'text',
		'label' => __( 'Continue Reading Label', 'septera' ),
		'desc' => '',
	'section' => 'septera_excerpts' ),

	// comments
	array(
	'id' => 'septera_comclosed',
		'type' => 'select',
		'label' => __("'Comments Are Closed' Text",'septera'),
		'values' => array( 1, 2, 3, 0 ), // "Show" , "Hide in posts", "Hide in pages", "Hide everywhere"
		'labels' => array( __("Show","septera"), __("Hide in posts","septera"), __("Hide in pages","septera"), __("Hide everywhere","septera") ),
		'desc' => '',
	'section' => 'septera_comments' ),
	array(
	'id' => 'septera_comdate',
		'type' => 'select',
		'label' => __('Comment Date Format','septera'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Specific","septera"), __("Relative","septera") ),
		'desc' => '',
	'section' => 'septera_comments' ),
	array(
	'id' => 'septera_comlabels',
		'type' => 'select',
		'label' => __('Comment Field Label','septera'),
		'values' => array( 1, 2 ),
		'labels' => array( __("Placeholders","septera"), __("Labels","septera") ),
		'desc' => __("Change to labels for better compatibility with comment-related plugins.","septera"),
	'section' => 'septera_comments' ),
	array(
	'id' => 'septera_comformwidth',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 1000,
		'step' => 10,
		'um' => 'px',
		'label' => __('Comment Form Width','septera'),
		'desc' => '',
	'section' => 'septera_comments' ),

	//////////////////////////////////////////////////// Featured Images ////////////////////////////////////////////////////
	array(
	'id' => 'septera_fpost',
		'type' => 'toggle',
		'label' => __( 'Featured Images', 'septera' ),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'septera_featured' ),
	array(
	'id' => 'septera_fauto',
		'type' => 'toggle',
		'label' => __( 'Auto Select Image From Content', 'septera' ),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'septera_featured' ),
	array(
	'id' => 'septera_fheight',
		'type' => 'numberslider',
		'min' => 0,
		'max' => 800,
		'step' => 10,
		'um' => 'px',
		'label' => __( 'Featured Image Height', 'septera' ),
		'desc' => __( 'Set to 0 to disable image processing', 'septera' ),
	'section' => 'septera_featured' ),
	array(
	'id' => 'septera_fheight_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","septera"),
		//'active_callback' => 'septera_conditionals',
	'section' => 'septera_featured' ),
	array(
	'id' => 'septera_fresponsive',
		'type' => 'select',
		'values' => array( 0, 1 ),
		'labels' => array( __("Cropped","septera"), __("Contained","septera") ),
		'label' => __('Featured Image Behaviour','septera'),
		'desc' => __("<strong>Contained</strong> will scale depending on the viewed resolution<br><strong>Cropped</strong> will try to keep the configured height.","septera"),
	'section' => 'septera_featured' ),
	array(
	'id' => 'septera_falign',
		'type' => 'select',
		'label' => __( 'Featured Image Crop Position', 'septera' ),
		'values' => array( "left top" , "left center", "left bottom", "right top", "right center", "right bottom", "center top", "center center", "center bottom" ),
		'labels' => array( __("Left Top","septera"), __("Left Center","septera"), __("Left Bottom","septera"), __("Right Top","septera"), __("Right Center","septera"), __("Right Bottom","septera"), __("Center Top","septera"), __("Center Center","septera"), __("Center Bottom","septera") ),
		'desc' => '',
	'section' => 'septera_featured' ),

	array(
	'id' => 'septera_falign_notice',
		'type' => 'notice',
		'label' => '',
		'input_attrs' => array( 'class' => 'warning' ),
		'desc' => __("Changing this value may require to recreate your thumbnails.","septera"),
		//'active_callback' => 'septera_conditionals',
	'section' => 'septera_featured' ),

	array(
	'id' => 'septera_fheader',
		'type' => 'toggle',
		'label' => __('Use Featured Images in Header','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
	'section' => 'septera_featured' ),

	//////////////////////////////////////////////////// Social Positions ////////////////////////////////////////////////////

	array(
	'id' => 'septera_socials_header',
		'type' => 'checkbox',
		'label' => __( 'Display in Header', 'septera' ),
		'desc' => '',
	'section' => 'septera_socials' ),
	array(
	'id' => 'septera_socials_footer',
		'type' => 'checkbox',
		'label' => __( 'Display in Footer', 'septera' ),
		'desc' => '',
	'section' => 'septera_socials' ),
	array(
	'id' => 'septera_socials_left_sidebar',
		'type' => 'checkbox',
		'label' => __( 'Display in Left Sidebar', 'septera' ),
		'desc' => '',
	'section' => 'septera_socials' ),
	array(
	'id' => 'septera_socials_right_sidebar',
		'type' => 'checkbox',
		'label' => __( 'Display in Right Sidebar', 'septera' ),
		'desc' => sprintf( __( 'Select where social icons should be visible in.<br><br><strong>Social Icons are defined using the <a href="%1$s" target="_blank">social icons menu</a></strong>. Read the <a href="%2$s" target="_blank">theme documentation</a> on how to create a social menu.', 'septera' ), 'nav-menus.php?action=locations', 'http://www.cryoutcreations.eu/wordpress-tutorials/use-new-social-menu' ),
	'section' => 'septera_socials' ),

	//////////////////////////////////////////////////// Miscellaneous ////////////////////////////////////////////////////

	array(
	'id' => 'septera_masonry',
		'type' => 'toggle',
		'label' => __('Masonry','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'septera_misc' ),
	array(
	'id' => 'septera_defer',
		'type' => 'toggle',
		'label' => __('JS Defer loading','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 3,
	'section' => 'septera_misc' ),

	array(
	'id' => 'septera_autoscroll',
		'type' => 'toggle',
		'label' => __('Autoscroll','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'septera_misc' ),
	array(
	'id' => 'septera_headerlimits',
		'type' => 'toggle',
		'label' => __('Header image size requirements','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'septera_misc' ),
	array(
	'id' => 'septera_editorstyles',
		'type' => 'toggle',
		'label' => __('Editor Styles','septera'),
		'values' => array( 1, 0 ),
		'desc' => '',
		'priority' => 4,
	'section' => 'septera_misc' ),
	array(
	'id' => 'septera_fitvids',
		'type' => 'select',
		'label' => __('FitVids','septera'),
		'values' => array( 1, 2, 0 ),
		'labels' => array( __("Enable","septera"), __("Enable on mobiles","septera"), __("Disable","septera") ),
		'desc' => __("<br>Only use these options to troubleshoot issues.","septera"),
		'priority' => 6,
	'section' => 'septera_misc' ),
	//////////////////////////////////////////////////// !!! DEVELOPER !!! ////////////////////////////////////////////////////
	// nothing for now

), // options

/* option=array(
	type: checkbox, select, textarea, input, function
	id: field_name or custom_function_name
	values: value_0, value_1, value_2 | true/false | number
	labels: __('Label 0','context'), ... | __('Enabled','context')/... |  number/__('Once','context')/...
	desc: html to be displayed at the question mark
	section: section_id

	array(
	'id' => '',
		'type' => '',
		'label' => '',
		'values' => array(  ),
		'labels' => array(  ),
		'desc' => '',
		'input_attrs' => array(  ),
		// conditionals
		'disable_if' => 'function_name',
		'require_fn' => 'function_name',
		// extra
		'addon' => TRUE, // option gets added to core sections
		'display_width' => '?????',
	'section' => '' ),

*/

/*** fonts ***/
'fonts' => array(

	'Preferred Theme Fonts'=> array(
					"Source Sans Pro/gfont",
					"Ubuntu/gfont",
					"Ubuntu Condensed/gfont",
					"Open Sans/gfont",
					"Open Sans Condensed:300/gfont",
					"Droid Sans/gfont",
					"Oswald/gfont",
					"Yanone Kaffeesatz/gfont",
					),
	'Sans-Serif' => array(
					"Segoe UI, Arial, sans-serif",
					"Verdana, Geneva, sans-serif" ,
					"Geneva, sans-serif",
					"Helvetica Neue, Arial, Helvetica, sans-serif",
					"Helvetica, sans-serif" ,
					"Century Gothic, AppleGothic, sans-serif",
				    "Futura, Century Gothic, AppleGothic, sans-serif",
					"Calibri, Arian, sans-serif",
				    "Myriad Pro, Myriad,Arial, sans-serif",
					"Trebuchet MS, Arial, Helvetica, sans-serif" ,
					"Gill Sans, Calibri, Trebuchet MS, sans-serif",
					"Impact, Haettenschweiler, Arial Narrow Bold, sans-serif",
					"Tahoma, Geneva, sans-serif" ,
					"Arial, Helvetica, sans-serif" ,
					"Arial Black, Gadget, sans-serif",
					"Lucida Sans Unicode, Lucida Grande, sans-serif"
					),
	'Serif' => array(
					"Georgia, Times New Roman, Times, serif",
					"Times New Roman, Times, serif",
					"Cambria, Georgia, Times, Times New Roman, serif",
					"Palatino Linotype, Book Antiqua, Palatino, serif",
					"Book Antiqua, Palatino, serif",
					"Palatino, serif",
				    "Baskerville, Times New Roman, Times, serif",
 					"Bodoni MT, serif",
					"Copperplate Light, Copperplate Gothic Light, serif",
					"Garamond, Times New Roman, Times, serif"
					),
	'MonoSpace' => array(
					"Courier New, Courier, monospace" ,
					"Lucida Console, Monaco, monospace",
					"Consolas, Lucida Console, Monaco, monospace",
					"Monaco, monospace"
					),
	'Cursive' => array(
					"Lucida Casual, Comic Sans MS, cursive",
				    "Brush Script MT, Phyllis, Lucida Handwriting, cursive",
					"Phyllis, Lucida Handwriting, cursive",
					"Lucida Handwriting, cursive",
					"Comic Sans MS, cursive"
					),
	'Advanced' => array(
					"* Custom Font *",
					),
	), // fonts

/*** google font option fields ***/
'google-font-enabled-fields' => array(
	'septera_fgeneral',
	'septera_fsitetitle',
	'septera_fmenu',
	'septera_fwtitle',
	'septera_fwcontent',
	'septera_ftitles',
	'septera_fheadings',
	),

	// ! The icons lists are reused in multiple locations; make sure to update all when needed !

	/*** landing page blocks icons ***/
	'block-icons' => array(
	'toggle' => 'e003',
	'layout' => 'e004',
	'lock' => 'e007',
	'unlock' => 'e008',
	'target' => 'e012',
	'disc' => 'e019',
	'microphone' => 'e048',
	'play' => 'e052',
	'cloud2' => 'e065',
	'cloud-upload' => 'e066',
	'cloud-download' => 'e067',
	'plus2' => 'e114',
	'minus2' => 'e115',
	'check2' => 'e116',
	'cross2' => 'e117',
	'users2' => 'e00a',
	'user' => 'e00b',
	'trophy' => 'e00c',
	'speedometer' => 'e00d',
	'screen-tablet' => 'e00f',
	'screen-smartphone' => 'e01a',
	'screen-desktop' => 'e01b',
	'plane' => 'e01c',
	'notebook' => 'e01d',
	'magic-wand' => 'e01e',
	'hourglass2' => 'e01f',
	'graduation' => 'e02a',
	'fire' => 'e02b',
	'eyeglass' => 'e02c',
	'energy' => 'e02d',
	'chemistry' => 'e02e',
	'bell' => 'e02f',
	'badge' => 'e03a',
	'speech' => 'e03b',
	'puzzle' => 'e03c',
	'printer' => 'e03d',
	'present' => 'e03e',
	'pin' => 'e03f',
	'picture2' => 'e04a',
	'map' => 'e04b',
	'layers' => 'e04c',
	'globe' => 'e04d',
	'globe2' => 'e04e',
	'folder' => 'e04f',
	'feed' => 'e05a',
	'drop' => 'e05b',
	'drawar' => 'e05c',
	'docs' => 'e05d',
	'directions' => 'e05e',
	'direction' => 'e05f',
	'cup2' => 'e06b',
	'compass' => 'e06c',
	'calculator' => 'e06d',
	'bubbles' => 'e06e',
	'briefcase' => 'e06f',
	'book-open' => 'e07a',
	'basket' => 'e07b',
	'bag' => 'e07c',
	'wrench' => 'e07f',
	'umbrella' => 'e08a',
	'tag' => 'e08c',
	'support' => 'e08d',
	'share' => 'e08e',
	'share2' => 'e08f',
	'rocket' => 'e09a',
	'question' => 'e09b',
	'pie-chart2' => 'e09c',
	'pencil2' => 'e09d',
	'note' => 'e09e',
	'music-tone-alt' => 'e09f',
	'list2' => 'e0a0',
	'like' => 'e0a1',
	'home2' => 'e0a2',
	'grid' => 'e0a3',
	'graph' => 'e0a4',
	'equalizer' => 'e0a5',
	'dislike' => 'e0a6',
	'calender' => 'e0a7',
	'bulb' => 'e0a8',
	'chart' => 'e0a9',
	'clock' => 'e0af',
	'envolope' => 'e0b1',
	'flag' => 'e0b3',
	'folder2' => 'e0b4',
	'heart2' => 'e0b5',
	'info' => 'e0b6',
	'link' => 'e0b7',
	'refresh' => 'e0bc',
	'reload' => 'e0bd',
	'settings' => 'e0be',
	'arrow-down' => 'e604',
	'arrow-left' => 'e605',
	'arrow-right' => 'e606',
	'arrow-up' => 'e607',
	'paypal' => 'e608',
	'home' => 'e800',
	'apartment' => 'e801',
	'data' => 'e80e',
	'cog' => 'e810',
	'star' => 'e814',
	'star-half' => 'e815',
	'star-empty' => 'e816',
	'paperclip' => 'e819',
	'eye2' => 'e81b',
	'license' => 'e822',
	'picture' => 'e827',
	'book' => 'e828',
	'bookmark' => 'e829',
	'users' => 'e82b',
	'store' => 'e82d',
	'calendar' => 'e836',
	'keyboard' => 'e837',
	'spell-check' => 'e838',
	'screen' => 'e839',
	'smartphone' => 'e83a',
	'tablet' => 'e83b',
	'laptop' => 'e83c',
	'laptop-phone' => 'e83d',
	'construction' => 'e841',
	'pie-chart' => 'e842',
	'gift' => 'e844',
	'diamond' => 'e845',
	'cup3' => 'e848',
	'leaf' => 'e849',
	'earth' => 'e853',
	'bullhorn' => 'e859',
	'hourglass' => 'e85f',
	'undo' => 'e860',
	'redo' => 'e861',
	'sync' => 'e862',
	'history' => 'e863',
	'download' => 'e865',
	'upload' => 'e866',
	'bug' => 'e869',
	'code' => 'e86a',
	'link2' => 'e86b',
	'unlink' => 'e86c',
	'thumbs-up' => 'e86d',
	'thumbs-down' => 'e86e',
	'magnifier' => 'e86f',
	'cross3' => 'e870',
	'menu' => 'e871',
	'list' => 'e872',
	'warning' => 'e87c',
	'question-circle' => 'e87d',
	'check' => 'e87f',
	'cross' => 'e880',
	'plus' => 'e881',
	'minus' => 'e882',
	'layers2' => 'e88e',
	'text-format' => 'e890',
	'text-size' => 'e892',
	'hand' => 'e8a5',
	'pointer-up' => 'e8a6',
	'pointer-right' => 'e8a7',
	'pointer-down' => 'e8a8',
	'pointer-left' => 'e8a9',
	'heart' => 'e930',
	'cloud' => 'e931',
	'trash' => 'e933',
	'user2' => 'e934',
	'key' => 'e935',
	'search' => 'e936',
	'settings2' => 'e937',
	'camera' => 'e938',
	'tag2' => 'e939',
	'bulb2' => 'e93a',
	'pencil' => 'e93b',
	'diamond2' => 'e93c',
	'location' => 'e93e',
	'eye' => 'e93f',
	'bubble' => 'e940',
	'stack' => 'e941',
	'cup' => 'e942',
	'phone' => 'e943',
	'news' => 'e944',
	'mail' => 'e945',
	'news2' => 'e948',
	'paperplane' => 'e949',
	'params2' => 'e94a',
	'data2' => 'e94b',
	'megaphone' => 'e94c',
	'study' => 'e94d',
	'chemistry2' => 'e94e',
	'fire2' => 'e94f',
	'paperclip2' => 'e950',
	'calendar2' => 'e951',
	'wallet' => 'e952',
	),

	'meta-icons' => array(
		'chevron-down' => 'e900',
		'chevron-left' => 'e901',
		'chevron-right' => 'e902',
		'chevron-small-down' => 'e903',
		'chevron-small-left' => 'e904',
		'chevron-small-right' => 'e905',
		'chevron-small-up' => 'e906',
		'chevron-thin-down' => 'e907',
		'chevron-thin-left' => 'e908',
		'chevron-thin-right' => 'e909',
		'chevron-thin-up' => 'e90a',
		'chevron-up' => 'e90b',
		'circular-graph' => 'e90c',
		'cross2' => 'e90d',
		'edit2' => 'e90e',
		'home2' => 'e90f',
		'info' => 'e910',
		'magnifying-glass' => 'e911',
		'menu3' => 'e912',
		'pencil' => 'e913',
		'plus2' => 'e914',
		'quote' => 'e915',
		'refresh-2' => 'e6c2',
		'close' => 'e680',
		'angle-up' => 'e682',
		'angle-right' => 'e684',
		'angle-left' => 'e686',
		'angle-down' => 'e688',
		'search3' => 'e618',
		'refresh' => 'e61c',
		'menu2' => 'e636',
		'home' => 'e648',
		'eye' => 'e000',
		'link' => 'e005',
		'ribbon' => 'e009',
		'image' => 'e010',
		'clock' => 'e014',
		'watch' => 'e015',
		'camera' => 'e017',
		'video' => 'e018',
		'disc' => 'e019',
		'heart' => 'e024',
		'book' => 'e030',
		'open-book' => 'e916',
		'layers' => 'e031',
		'paper' => 'e034',
		'search2' => 'e036',
		'zoom-in' => 'e037',
		'zoom-out' => 'e038',
		'reply' => 'e039',
		'circle-plus' => 'e040',
		'square-plus' => 'e044',
		'microphone' => 'e048',
		'record' => 'e049',
		'rewind' => 'e051',
		'play' => 'e052',
		'stop' => 'e054',
		'fast-forward' => 'e055',
		'repeat' => 'e058',
		'folder' => 'e059',
		'head' => 'e074',
		'speech-bubble' => 'e076',
		'reload' => 'e080',
		'tag' => 'e085',
		'pie-graph' => 'e092',
		'star' => 'e093',
		'arrow-left' => 'e094',
		'arrow-right' => 'e095',
		'arrow-up' => 'e096',
		'arrow-down' => 'e097',
		'volume' => 'e098',
		'plus' => 'e114',
		'minus' => 'e115',
		'check' => 'e116',
		'cross' => 'e117',
		'menu' => 'e120',
		'ellipsis' => 'e129',
		'office' => 'e990',
		'library' => 'e991',
		'location2' => 'e992',
		'compass' => 'e993',
		'printer' => 'e994',
		'display' => 'e995',
		'mobile' => 'e996',
		'mobile2' => 'e997',
		'tablet' => 'e998',
		'hour-glass' => 'e999',
		'sphere' => 'e99a',
		'earth' => 'e99b',
		'attachment' => 'e99c',
		'el-comment' => 'e800',
		'el-user' => 'e801',
		'el-tag' => 'e802',
		'el-down-dir' => 'e803',
		'el-edit' => 'e804',
		'el-category' => 'e805',
		'el-right-dir' => 'e806',
		'el-angle-left' => 'e807',
		'el-angle-right' => 'e808',
		'el-angle-up' => 'e809',
		'el-angle-down' => 'e80a',
		'el-minus' => 'e80b',
		'el-left-open' => 'e80c',
		'el-time' => 'e80d',
		'el-up' => 'e80e',
		'el-quote' => 'e80f',
		'el-bookmark' => 'e810',
		'el-left-dir' => 'e811',
		'el-up-open' => 'e812',
		'el-ok' => 'e813',
		'el-cancel' => 'e814',
		'el-comments' => 'e815',
		'el-search' => 'e816',
		'el-category2' => 'e817',
		'el-link' => 'e818',
		'el-up-dir' => 'e819',
		'el-info' => 'e81a',
		'el-share' => 'e81b',
		'el-folder-close' => 'e81c',
		'el-folder-open' => 'e81d',
		'el-right-open' => 'e81e',
		'el-home' => 'e81f',
		'el-menu' => 'e820',
		'el-plus' => 'e821',
		'el-down-open' => 'e822',
		'el-audio' => 'e823',
		'el-image' => 'e824',
		'el-camera' => 'e825',
		'el-down' => 'e826',
		'el-left' => 'e827',
		'el-right' => 'e828',
		'el-video' => 'e829',
		'el-aside' => 'e82a',
		'el-date' => 'e82b',
		'el-star-empty' => 'e82c',
		'el-star' => 'e82d',
		'el-mail' => 'e82e',
		'el-home-1' => 'e82f',
		'el-attach' => 'e830',
		'el-eye' => 'e831',
		'el-eye-off' => 'e832',
		'el-tags' => 'e833',
		'el-flag' => 'e834',
		'el-warning' => 'e835',
		'el-location' => 'e836',
		'el-trash' => 'e837',
		'el-doc' => 'e838',
		'el-phone' => 'e839',
		'el-cog' => 'e83a',
		'el-basket' => 'e83b',
		'el-basket-circled' => 'e83c',
		'el-wrench' => 'e83d',
		'el-wrench-circled' => 'e83e',
		'el-mic' => 'e83f',
		'el-volume' => 'e840',
		'el-volume-down' => 'e841',
		'el-volume-off' => 'e842',
		'el-headphones' => 'e843',
		'el-lightbulb' => 'e844',
		'el-resize-full' => 'e845',
		'el-resize-full-alt' => 'e846',
		'el-resize-small' => 'e847',
		'el-resize-vertical' => 'e848',
		'el-resize-horizontal' => 'e849',
		'el-move' => 'e84a',
		'el-zoom-in' => 'e84b',
		'el-zoom-out' => 'e84c',
		'el-arrows-cw' => 'e84d',
		'el-desktop' => 'e84e',
		'el-inbox' => 'e84f',
		'el-cloud' => 'e850',
		'el-book' => 'e851',
		'el-certificate' => 'e852',
		'el-tasks' => 'e853',
		'el-thumbs-up' => 'e854',
		'el-thumbs-down' => 'e855',
		'el-help-circled' => 'e856',
		'el-star-circled' => 'e857',
		'el-bell' => 'e858',
		'el-rss' => 'e859',
		'el-trash-circled' => 'e85a',
		'el-cogs' => 'e85b',
		'el-cog-circled' => 'e85c',
		'el-calendar-circled' => 'e85d',
		'el-mic-circled' => 'e85e',
		'el-volume-up' => 'e85f',
		'el-print' => 'e860',
		'el-edit-alt' => 'e861',
		'el-edit-2' => 'e862',
		'el-block' => 'e863',
	),

	'social-icons' => array(

		'duckduckgo' => 'e801',
		'aim' => 'e802',
		'delicious' => 'e803',
		'paypal' => 'e804',
		'flattr' => 'e805',
		'android' => 'e806',
		'eventful' => 'e807',
		'smashingmagazine' => 'e808',
		'googleplus' => 'e809',
		'wikipedia' => 'e80a',
		'lanyrd' => 'e80b',
		'calendar' => 'e80c',
		'stumbleupon' => 'e80d',
		'500px' => 'e80e',
		'pinterest' => 'e80f',
		'bitcoin' => 'e810',
		'firefox' => 'e811',
		'foursquare' => 'e812',
		'chrome' => 'e813',
		'internetexplorer' => 'e814',
		'phone' => 'e815',
		'grooveshark' => 'e816',
		'99designs' => 'e817',
		'code' => 'e818',
		'digg' => 'e819',
		'spotify' => 'e81a',
		'reddit' => 'e81b',
		'about' => 'e81c',
		'codeopen' => 'e81d',
		'appstore' => 'e81e',
		'creativecommons' => 'e820',
		'dribbble' => 'e821',
		'evernote' => 'e822',
		'flickr' => 'e823',
		'link2' => 'e824',
		'viadeo' => 'e825',
		'instapaper' => 'e826',
		'weibo' => 'e827',
		'klout' => 'e828',
		'linkedin' => 'e829',
		'meetup' => 'e82a',
		'vk' => 'e82b',
		'plancast' => 'e82c',
		'disqus' => 'e82d',
		'feed' => 'e82e',
		'skype' => 'e82f',
		'twitter' => 'e830',
		'youtube' => 'e831',
		'vimeo' => 'e832',
		'windows' => 'e833',
		'xing' => 'e834',
		'yahoo' => 'e835',
		'email' => 'e837',
		'cloud' => 'e838',
		'myspace' => 'e839',
		'podcast' => 'e83a',
		'amazon' => 'e83b',
		'steam' => 'e83c',
		'link' => 'e83d',
		'dropbox' => 'e83e',
		'ebay' => 'e83f',
		'facebook' => 'e840',
		'github2' => 'e841',
		'github' => 'e842',
		'googleplay' => 'e843',
		'itunes' => 'e844',
		'plurk' => 'e845',
		'songkick' => 'e846',
		'lastfm' => 'e847',
		'gmail' => 'e848',
		'pinboard' => 'e849',
		'openid' => 'e84a',
		'quora' => 'e84b',
		'soundcloud' => 'e84c',
		'tumblr' => 'e84d',
		'wordpress' => 'e84f',
		'yelp' => 'e850',
		'intensedebate' => 'e851',
		'eventbrite' => 'e852',
		'scribd' => 'e853',
		'stripe' => 'e855',
		'opentable' => 'e856',
		'cart' => 'e857',
		'opera' => 'e858',
		'angellist' => 'e859',
		'instagram' => 'e85a',
		'dwolla' => 'e85b',
		'appnet' => 'e85c',
		'drupal' => 'e85f',
		'buffer' => 'e860',
		'pocket' => 'e861',
		'bitbucket' => 'e862',
		'phone2' => 'e863',
		'stackoverflow' => 'e865',
		'hackernews' => 'e866',
		'lkdto' => 'e867',
		'twitter2' => 'e868',
		'phone3' => 'e869',
		'mobile' => 'e86a',
		'support' => 'e86b',
		'twitch' => 'e86c',
		'beer' => 'e86d',
	),

/*** ajax load more identifiers ***/
'theme_identifiers' => array(
	'load_more_optid' 			=> 'septera_lpposts_more',
	'content_css_selector' 		=> '#lp-posts .lp-posts-inside',
	'pagination_css_selector' 	=> '#lp-posts nav.navigation',
),

/************* widget areas *************/

'widget-areas' => array(
	'sidebar-2' => array(
		'name' => __( 'Sidebar Left', 'septera' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
	'sidebar-1' => array(
		'name' => __( 'Sidebar Right', 'septera' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
	'footer-widget-area' => array(
		'name' => __( 'Footer', 'septera' ),
		'description' 	=> __('You can configure how many columns the footer displays from the theme options', 'septera'),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s"><div class="footer-widget-inside">',
		'after_widget' => '</div></section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
	'content-widget-area-before' => array(
		'name' => __( 'Content Before', 'septera' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
	'content-widget-area-after' => array(
		'name' => __( 'Content After', 'septera' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
	'widget-area-header' => array(
		'name' => __( 'Header', 'septera' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	),
), // widget-areas

'migration' => array(
	'1.31' => array(
		//'septera_old_key' => 'septera_new_key',
		'septera_lpblockmaintitle'	=> 'septera_lpblockmaintitle1', // icon blocks
		'septera_lpblockmaindesc'		=> 'septera_lpblockmaindesc1',
		'septera_lpblockscontent' 	=> 'septera_lpblockscontent1',
		'septera_lpblocksclick' 		=> 'septera_lpblocksclick1',
		'septera_lpblocksreadmore' 	=> 'septera_lpblocksreadmore1',
		'septera_lpblockoneicon' 		=> 'septera_lpblockoneicon1',
		'septera_lpblockone' 			=> 'septera_lpblockone1',
		'septera_lpblocktwoicon' 		=> 'septera_lpblocktwoicon1',
		'septera_lpblocktwo' 			=> 'septera_lpblocktwo1',
		'septera_lpblockthreeicon' 	=> 'septera_lpblockthreeicon1',
		'septera_lpblockthree' 		=> 'septera_lpblockthree1',
		'septera_lpblockfouricon' 	=> 'septera_lpblockfouricon1',
		'septera_lpblockfour' 		=> 'septera_lpblockfour1',
	) // 1.31
),	// migration

); // $septera_big

// sort block icons alphabetically
ksort( $septera_big['block-icons'] );
$septera_big['block-icons'] = array_merge( array( 'no-icon' => '&nbsp;') , $septera_big['block-icons'] );

// FIN
