<?php
/*************************************************
 * 
 *
 *
 ************************************************/

// TEMP: Enable update check on every request. Normally you don't need this! This is for testing only!
//set_site_transient('update_themes', null);

// NOTE: All variables and functions will need to be prefixed properly to allow multiple items to be updated

/************************************************/
$cryout_api_url = 'http://archive.cryout.eu/api/';
/************************************************/

/***********************Parent Theme**************/
if(function_exists('wp_get_theme')){
    $cryout_theme_data = wp_get_theme(get_option('template'));
    $cryout_theme_version = $cryout_theme_data->Version;  
}    
$cryout_theme_base = get_option('template');
/**************************************************/

//Uncomment below to find the theme slug that will need to be setup on the api server
//var_dump($cryout_theme_base);

add_filter('pre_set_site_transient_update_themes', 'cryout_check_for_update');

function cryout_check_for_update($cryout_checked_data) {
	global $cryout_wp_version, $cryout_theme_version, $cryout_theme_base, $cryout_api_url;

	$cryout_request = array(
		'slug' => $cryout_theme_base,
		'version' => $cryout_theme_version 
	);
	// Start checking for an update
	$cryout_send_for_check = array(
		'body' => array(
			'action' => 'theme_update', 
			'request' => serialize($cryout_request),
			'api-key' => md5(esc_url( home_url() ) )
		),
		'user-agent' => 'WordPress/' . $cryout_wp_version . '; ' . esc_url( home_url() ) 
	);
	$cryout_raw_response = wp_remote_post($cryout_api_url, $cryout_send_for_check);
	if (!is_wp_error($cryout_raw_response) && ($cryout_raw_response['response']['code'] == 200))
		$cryout_response = unserialize($cryout_raw_response['body']);

	// Feed the update data into WP updater
	if (!empty($cryout_response)) 
		$cryout_checked_data->response[$cryout_theme_base] = $cryout_response;

	return $cryout_checked_data;
}

// Take over the Theme info screen on WP multisite
add_filter('themes_api', 'cryout_theme_api_call', 10, 3);

function cryout_theme_api_call($cryout_def, $cryout_action, $cryout_args) {
	global $cryout_theme_base, $cryout_api_url, $cryout_theme_version, $cryout_api_url;
	
	if ($cryout_args->slug != $cryout_theme_base)
		return false;
	
	// Get the current version

	$cryout_args->version = $cryout_theme_version;
	$cryout_request_string = prepare_request($cryout_action, $cryout_args);
	$cryout_request = wp_remote_post($cryout_api_url, $cryout_request_string);

	if (is_wp_error($cryout_request)) {
		$cryout_res = new WP_Error('themes_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>', 'cryout'), $cryout_request->get_error_message());
	} else {
		$cryout_res = unserialize($cryout_request['body']);
		
		if ($cryout_res === false)
			$cryout_res = new WP_Error('themes_api_failed', __('An unknown error occurred', 'cryout'), $cryout_request['body']);
	}
	
	return $cryout_res;
}

if (is_admin())
	$cryout_current = get_transient('update_themes');
?>