<?php
/**
 * Core theme functions
 *
 * @package Verbosa
 */

/**
 * Header image handler (via div with background image)
 */
add_action ('cryout_headerimage_hook', 'verbosa_header_image', 99);
if ( ! function_exists( 'verbosa_header_image' ) ) :
function verbosa_header_image() {
	if (get_header_image() != '') { 
		$header_image = get_header_image();
	}
	
	if ( !empty($header_image) ):?>
		<?php cryout_header_widget_hook(); ?>
		<img class="header-image" alt="" src="<?php echo $header_image; ?>" />
	<?php endif;
} // verbosa_header_image()
endif;

/**
 * Adds title and description to header
 * Used in header.php
*/
if ( ! function_exists( 'verbosa_title_and_description' ) ) :
function verbosa_title_and_description() { 

	$verbosas = cryout_get_option( array('verbosa_logoupload','verbosa_siteheader') );
	echo '<div class="identity">';
	if ( in_array($verbosas['verbosa_siteheader'], array( 'logo', 'both' ) ) ) {
		if ( !empty($verbosas['verbosa_logoupload']) ) :
			$img = wp_get_attachment_image_src($verbosas['verbosa_logoupload'], 'full');
			echo '<a id="logo" href="'.esc_url( home_url( '/' ) ).'" ><img title="" alt="" src="' . $img[0] . '" /></a>';
		endif;
	}
	if ( in_array($verbosas['verbosa_siteheader'], array('title', 'both') ) ) {
		$heading_tag = ( is_home() || is_front_page() ) ? 'h1' : 'div';
		echo '<' . $heading_tag . cryout_schema_microdata('site-title', 0) . ' id="site-title">';
		echo '<span> <a href="' . esc_url( home_url( '/' ) ) . '"  rel="home">' . get_bloginfo( 'name' ) . '</a> </span>';
		echo '</' . $heading_tag . '>';
		echo '<span id="site-description" ' . cryout_schema_microdata('site-description', 0) . ' >' . get_bloginfo( 'description' ) . '</span>';
	}
	
	echo '</div>';
} // verbosa_title_and_description()
endif;
add_action ('cryout_branding_hook', 'verbosa_title_and_description');


/**
 * Verbosa back to top button
 * Creates div for js
*/
if ( ! function_exists( 'verbosa_back_top' ) ) :
function verbosa_back_top() {
	echo '<div id="toTop"><i class="icon-back2top"></i> </div>';
} // verbosa_back_top()
endif; 
add_action ('cryout_footer_hook', 'verbosa_back_top');


/**
 * Creates pagination for blog pages.
 */
if ( ! function_exists( 'verbosa_pagination' ) ) :
function verbosa_pagination($pages = '', $range = 2, $prefix ='')
{
	$pagination = cryout_get_option('verbosa_pagination');
	if ($pagination && function_exists( 'the_posts_pagination' ) ):
		the_posts_pagination( array( 
			'prev_text' => '<i class="icon-arrow-left2"></i>', 
			'next_text' => '<i class="icon-arrow-right2"></i>',
			'mid_size' => $range
		) );     
	else:
		//posts_nav_link();
		verbosa_content_nav( 'nav-old-below' );
	endif;
     
} // verbosa_pagination()
endif;

/**
 * 
 */
if ( ! function_exists( 'verbosa_nextpage_links' ) ) :
function verbosa_nextpage_links($defaults) {
	$args = array(
		'link_before'      => '<em>',
		'link_after'       => '</em>',
	);
	$r = wp_parse_args($args, $defaults);
	return $r;
} // verbosa_nextpage_links()
endif;
add_filter('wp_link_pages_args','verbosa_nextpage_links');


/**
 * Footer Hook
 */
add_action('cryout_footer_hook', function() {  
	echo '<div id="site-copyright">' . cryout_get_option( 'verbosa_copyright' ) . '</div>';
	echo '<div style="display:block;float:none;clear: both;font-size:.85em; text-align: center;">' . __("Powered by","verbosa") . 
		'<a target="_blank" href="' . esc_url("http://www.cryoutcreations.eu") . '" title="';
	echo 'Verbosa Theme by ' . 'Cryout Creations"> ' . 'Verbosa' .'</a> &amp; <a target="_blank" href="' . esc_url("http://wordpress.org/");
	echo '" title="' . esc_attr("Semantic Personal Publishing Platform", "verbosa") . '"> ' . sprintf( " %s.", "WordPress" ) . '</a></div>';
}, 20 );


add_action('wp_ajax_nopriv_do_ajax', 'verbosa_ajax_function');
add_action('wp_ajax_do_ajax', 'verbosa_ajax_function');

if ( ! function_exists( 'verbosa_ajax_function' ) ) :
function verbosa_ajax_function(){
	ob_clean();

   // the first part is a SWITCHBOARD that fires specific functions
   // according to the value of Query Var 'fn'

	switch($_REQUEST['fn']){
		case 'get_latest_posts':
			$output = verbosa_ajax_get_latest_posts($_REQUEST['count'],$_REQUEST['categName']);
		break;
		default:
			$output = 'No function specified, check your jQuery.ajax() call';
		break;
	}

	// at this point, $output contains some sort of valuable data!
	// Now, convert $output to JSON and echo it to the browser
	// That way, we can recapture it with jQuery and run our success function

	$output=json_encode($output);
	if(is_array($output)) { print_r($output); }
	                 else { echo $output; }
	die;
} // verbosa_ajax_function()
endif;

if ( ! function_exists( 'verbosa_ajax_get_latest_posts' ) ) :
function verbosa_ajax_get_latest_posts($count,$categName){
	$testVar='';
	// The Query
	$the_query = new WP_Query( 'category_name='.$categName);
	// The Loop
	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) : $the_query->the_post();
			$testVar .= the_title("<option>","</option>",0);
		endwhile;
	endif;
	return $testVar;
} // verbosa_ajax_get_latest_posts()
endif;

if ( ! function_exists( 'verbosa_header_section' ) ) :
function verbosa_header_section() { ?>
	<div id="sidebar">
		
		<header id="header" <?php cryout_schema_microdata('header') ?>>
			<nav id="mobile-menu"> 
				<span id="nav-cancel"><i class="icon-cross"></i></span>
				<?php cryout_mobilemenu_hook(); ?>
			</nav>
			<div id="branding" role="banner">
			<?php cryout_branding_hook();?>
			<?php cryout_headerimage_hook(); ?>
			<?php get_sidebar('left'); ?>
				<a id="nav-toggle"><span>&nbsp;</span></a>
				<nav id="access" role="navigation"  aria-label="Primary Menu" <?php cryout_schema_microdata('menu'); ?>>
				<h3 class="widget-title menu-title"><span><?php _e("Menu", "verbosa");?></span></h3>
					<?php cryout_access_hook();?>
				</nav><!-- #access -->
				
			</div><!-- #branding -->
		</header><!-- #header -->
		
		<?php get_sidebar('right'); ?>
		<?php cryout_footer_hook(); ?>
		
		</div><!--sidebar-->
		<div id="sidebar-back"></div>
<?php }// verbosa_header_section
endif;

if ( ! function_exists( 'verbosa_get_layout_class' ) ) :
function verbosa_get_layout_class() {
	$verbosa_sitelayout = cryout_get_option( 'verbosa_sitelayout' );
	
	/*  If page template, return the page template's layout */
	global $verbosa_template_layout;
	if (isset($verbosa_template_layout)) return $verbosa_template_layout;
	
	/*  If not, return the general layout */
	switch($verbosa_sitelayout) {
		case '2cSl': return "two-columns-left"; break;
		case '2cSr': return "two-columns-right"; break;
		case '1c':
		default: return "one-column"; break;
	}
} // verbosa_get_layout_class()
endif;


/** 
* Checks the browser agent string for mobile ids and adds "mobile" class to body if true 
* @return array list of classes. 
*/ 
function verbosa_mobile_body_class($classes){ 
	$browser = (!empty($_SERVER['HTTP_USER_AGENT'])?$_SERVER['HTTP_USER_AGENT']:''); 
	$keys = 'mobile|android|mobi|tablet|ipad|opera mini|series 60|s60|blackberry'; 
	if (preg_match("/($keys)/i",$browser)): $classes[] = 'mobile'; endif; // mobile browser detected 
	return $classes; 
} // verbosa_mobile_body_class()
add_filter('body_class', 'verbosa_mobile_body_class');


/**
* Creates breadcrumbs with page sublevels and category sublevels.
* Hooked in master hook
*/
if ( ! function_exists( 'verbosa_breadcrumbs' ) ) :
function verbosa_breadcrumbs() {

	$verbosas = cryout_get_option( 'verbosa_frontpage' );
	
	$separator = '<i class="icon-ctrl-right"></i>'; 	// separator between crumbs
	$home = '<a href="'.home_url().'" title="'.__('Home','verbosa').'"><i class="icon-home"></i></a>'; // text for the 'Home' link
	$showCurrent = 1; 									// whether to show current post/page title in breadcrumbs
	$before = '<span class="current">'; 				// tag before the current crumb
	$after = '</span>'; 								// tag after the current crumb
  
	global $post;
	$homeLink = home_url();
	if ( is_front_page() ) { return; }	// don't display breadcrumbs on the homepage (yet)
  
	// let's begin
	echo '<div id="breadcrumbs-container" class="' . verbosa_get_layout_class() . '"><div id="breadcrumbs"> <nav id="breadcrumbs-nav" ' . cryout_schema_microdata('breadcrumbs', 0) . '>' . $home . $separator . ' ';
  
    if ( is_category() ) {
		// category section
		$thisCat = get_category(get_query_var('cat'), false);
		if (!empty($thisCat->parent)) echo get_category_parents($thisCat->parent, TRUE, ' ' . $separator . ' ');
		echo $before . __('Archive for category','verbosa').' "' . single_cat_title('', false) . '"' . $after;
    } elseif ( is_search() ) {
		// search section
		echo $before . __('Search results for','verbosa').' "' . get_search_query() . '"' . $after;
    } elseif ( is_day() ) {
		// daily archive
		echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $separator . ' ';
		echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $separator . ' ';
		echo $before . get_the_time('d') . $after;
    } elseif ( is_month() ) {
		// monthly archive
		echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $separator . ' ';
		echo $before . get_the_time('F') . $after;
    } elseif ( is_year() ) {
		// yearly archive
		echo $before . get_the_time('Y') . $after;
    } elseif ( is_single() && !is_attachment() ) {
		// single post or page
		if ( get_post_type() != 'post' ) {
			$post_type = get_post_type_object(get_post_type());
			$slug = $post_type->rewrite;
			echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';
			if ($showCurrent) echo ' ' . $separator . ' ' . $before . get_the_title() . $after;
		} else {
			$cat = get_the_category(); if (isset($cat[0])) {$cat = $cat[0];} else {$cat = false;}
			if ($cat) {$cats = get_category_parents($cat, TRUE, ' ' . $separator . ' ');} else {$cats=false;}
			if (!$showCurrent && $cats) $cats = preg_replace("#^(.+)\s$separator\s$#", "$1", $cats);
			echo $cats;
			if ($showCurrent) echo $before . get_the_title() . $after;
		}
    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
		// some other single item
		$post_type = get_post_type_object(get_post_type());
		echo $before . $post_type->labels->singular_name . $after;
	} elseif ( is_attachment() ) {
		// attachment section
		$parent = get_post($post->post_parent);
		$cat = get_the_category($parent->ID); if (isset($cat[0])) {$cat = $cat[0];} else {$cat=false;}
		if ($cat) echo get_category_parents($cat, TRUE, ' ' . $separator . ' ');
		echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a>';
		if ($showCurrent) echo ' ' . $separator . ' ' . $before . get_the_title() . $after;
    } elseif ( is_page() && !$post->post_parent ) {
		// parent page
		if ($showCurrent) echo $before . get_the_title() . $after;
    } elseif ( is_page() && $post->post_parent ) {
		// child page
		$parent_id  = $post->post_parent;
		$breadcrumbs = array();
		while ($parent_id) {
			$page = get_page($parent_id);
			$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
			$parent_id  = $page->post_parent;
		}
		$breadcrumbs = array_reverse($breadcrumbs);
		for ($i = 0; $i < count($breadcrumbs); $i++) {
			echo $breadcrumbs[$i];
			if ($i != count($breadcrumbs)-1) echo ' ' . $separator . ' ';
		}
		if ($showCurrent) echo ' ' . $separator . ' ' . $before . get_the_title() . $after;
    } elseif ( is_tag() ) {
		// tags archive
		echo $before . __('Posts tagged','verbosa').' "' . single_tag_title('', false) . '"' . $after;
    } elseif ( is_author() ) {
		// author archive 
		global $author;
		$userdata = get_userdata($author);
		echo $before . __('Articles posted by','verbosa'). ' ' . $userdata->display_name . $after;
    } elseif ( is_404() ) {
		// 404
		echo $before . __('Not Found','verbosa') . $after;
    }
  
    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page','verbosa') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }
  
    echo '</nav></div></div><!-- breadcrumbs -->';
} // verbosa_breadcrumbs()
endif; 


/**
 * Adds Schema.org structured data (microdata) to the HTML markup
 * More details at http://schema.org
 * Testing tools at https://developers.google.com/structured-data/testing-tool/
 */
if ( ! function_exists( 'cryout_schema_microdata' ) ) :
function cryout_schema_microdata($location = '', $echo = 1) {
	
	$output = '';
	
	switch ($location) {
	
		case 'body':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/WebPage"';
		break;
		
		case 'header':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/WPHeader"';
		break;
		
		case 'main':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/Blog"';
		break;
		
		case 'element':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/WebPageElement"';
		break;
		
		case 'sidebar':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/WPSideBar"';
		break;
		
		case 'footer':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/WPFooter"';
		break;
		
		case 'breadcrumbs':
			$output = 'itemprop="breadcrumb"';
		break;
		
		case 'menu':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement"';
		break;
		
		
		/* SITE HEADER */		
		case 'site-title':
			$output = 'itemprop="headline"';
		break;
		
		case 'site-description':
			$output = 'itemprop="description"';
		break;
		
		
		/* MAIN CONTENT - BLOG */		
		case 'article':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/BlogPosting" itemprop="blogPost"';
		break;
		
		case 'page':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/CreativeWork"';
		break;
		
		case 'entry-title':
			$output = 'itemprop="headline"';
		break;
		
		case 'url':
			$output = 'itemprop="url"';
		break;
		
		case 'entry-summary':
			$output = 'itemprop="description"';
		break;
		
		case 'entry-content':
			$output = 'itemprop="articleBody"';
		break;
		
		case 'text':
			$output = 'itemprop="text"';
		break;
		
		case 'comment':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/Comment"';
		break;
		
		case 'comment-author':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/Person" itemprop="creator"';
		break;
		
		
		/* POST META */		
		case 'author':
			$output = 'itemscope="itemscope" itemtype="http://schema.org/Person" itemprop="author"';
		break;
		
		case 'author-url':
			$output = 'itemprop="url"';
		break;
		
		case 'author-name':
			$output = 'itemprop="name"';
		break;
		
		case 'author-description':
			$output = 'itemprop="description"';
		break;
		
		case 'time':
			$output = 'itemprop="datePublished"';
		break;
		
		case 'time-modified':
			$output = 'itemprop="dateModified"';
		break;
		
		case 'category':
			$output = '';
		break;
		
		case 'tags':
			$output = 'itemprop="keywords"';
		break;
		
		case 'comment-meta':
			$output = 'itemprop="discussionURL"';
		break;
		
		case 'image':
			$output = 'itemprop="image"';
		break;
		
	} // switch
	
	$output = ' ' . $output;
	if ($echo) echo $output; 		
		else return $output; 
		
} // cryout_schema_microdata
endif; 

/** 
* Master hook to bypass customizer options
*/ 
if ( ! function_exists( 'cryout_master_hook' ) ) :
function cryout_master_hook(){
	$verbosa_interim_options = cryout_get_option( array(
		'verbosa_breadcrumbs',
		'verbosa_searchboxmain',
		'verbosa_searchboxfooter',
		'verbosa_comlabels')
	);
	if ( $verbosa_interim_options['verbosa_breadcrumbs'] )  add_action('cryout_before_content_hook', 'verbosa_breadcrumbs');
	
	if ( $verbosa_interim_options['verbosa_comlabels'] == 1) {
		add_filter('comment_form_default_fields', 'verbosa_comments_form');
		add_filter('comment_form_field_comment', 'verbosa_comments_form_textarea');
	}
}; 
endif;
add_action('wp', 'cryout_master_hook');
