<?php
/**
 * The template used to display Tag Archive pages
 *
 * @package Verbosa
 */

get_header(); ?>

		<div id="container" class="<?php echo verbosa_get_layout_class(); ?>">
			<?php verbosa_header_section() ?>
			<main id="main" role="main" <?php cryout_schema_microdata('main'); ?>>
			<?php cryout_before_content_hook(); ?>
			
			<?php if ( have_posts() ) : ?>

				<header class="tag-header pad-container" <?php cryout_schema_microdata('element'); ?>>
					<h1 class="page-title" <?php cryout_schema_microdata('entry-title'); ?>><?php
						printf( __( 'Tag Archives: %s', 'verbosa' ), '<strong>' . single_tag_title( '', false ) . '</strong>' );
					?></h1>

					<?php
						$tag_description = tag_description();
						if ( ! empty( $tag_description ) )
							echo apply_filters( 'tag_archive_meta', '<div class="tag-archive-meta"' . cryout_schema_microdata('text') .'>' . $tag_description . '</div>' );
					?>
				</header>
				<div id="content-masonry">

				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php
						/* Include the Post-Format-specific template for the content.
						 * If you want to overload this in a child theme then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'content/content', get_post_format() );
					

				 endwhile; ?>
				 </div><!--content-masonry-->

				 <?php 
				 verbosa_pagination();

			else : 

				get_template_part( 'content/content', 'notfound' );
				?><div id="content-masonry"></div><?php

			endif; 

			cryout_after_content_hook(); 
			?>
			</main><!-- #main -->
		</div><!-- #container -->

<?php get_footer(); ?>
