<?php 
/**
 * Template Name: Blog Template (Posts Page)
 *
 * A custom page template for showing blog posts.
 *
 * The "Template Name:" bit above allows this to be selectable
 * from a dropdown menu on the edit page screen.
 *
 * @package Verbosa
 */ 

get_header(); ?>

<div id="container" class="<?php echo verbosa_get_layout_class(); ?>">
	<?php verbosa_header_section() ?>
	<main id="main" role="main" <?php cryout_schema_microdata('main'); ?>>
	<?php cryout_before_content_hook(); ?>

		<div id="content-masonry">
			<?php 
			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			$the_query = new WP_Query( 'post_status=publish&orderby=date&order=desc&posts_per_page='.get_option('posts_per_page').'&paged=' . $paged);?>

			<?php if ( $the_query->have_posts() ) : 

					 /* Start the Loop */ 
					 while ( $the_query->have_posts() ) : $the_query->the_post(); 
						 global $more; $more=0; 
						 get_template_part( 'content/content', get_post_format() ); 

					 endwhile; 

					 verbosa_pagination();

				 else : 

					get_template_part( 'content/content', 'notfound' );
				 
				 endif; ?>
		</div> <!-- content-masonry -->

	<?php cryout_after_content_hook(); ?>
	</main><!-- #main -->
</div><!-- #container -->

<?php get_footer(); ?>
