<?php
$themename = "Zombie Apocalypse";
$shortname = "zmb";

$options = array (
			
	
	array(	"name" => "Layout Settings",
			"type" => "title"),
	

	array(  "name" => "Sidemenu",
			"desc" => "You can disable the sidemenu and have only one column for a presentation-like design. Disabling the sidemenu also disables the Content/Sidemenu Width option.",
            "id" => $shortname."_side",
            "type" => "select",
			"options" => array ("Enable" , "Disable"),
            "std" => "Enable"),

	array(  "name" => "Content / Sidemenu Width",
			"desc" => "Select the width of your content and sidemenu (Values range from 500px to 750px for the content, and from 150px to 400px for the sidemenu).",
            "id" => $shortname."_sidewidth",
            "type" => "slider",
            "std" => "650"),

	array(	"name" => "Text Settings",
			"type" => "title"),


	array(  "name" => "Select Font Size",
			"desc" => "Select the font size you'll use in your blog. Pages, posts and comments will be affected. Buttons, Headers and Side menus will remain the same.",
            "id" => $shortname."_fontsize",
            "type" => "select",
			"options" => array ("12px" , "13px" , "14px" , "15px" , "16px" , "17px" ,"18px"),
            "std" => "15px"),

	array(  "name" => "Select Font Type",
			"desc" => "Select the font family you'll use in your blog. All text will be affected (including header text, menu buttons, side menu text etc.).",
            "id" => $shortname."_fontfamily",
            "type" => "select",
			"options" => array ("Verdana, Geneva, sans-serif (Default)" , "Georgia, 'Times New Roman', Times, serif" , "Tahoma, Geneva, sans-serif" , "'Trebuchet MS', Arial, Helvetica, sans-serif" , "'Courier New', Courier, monospace" , "'Comic Sans MS', cursive"),
            "std" => "Verdana, Geneva, sans-serif (Default)"),

	array(  "name" => "Force Text Align",
			"desc" => "This overwrites the text alignment in posts and pages. Leave 'Default' for normal settings (alignment will remain as declared in posts, comments etc.). ",
            "id" => $shortname."_textalign",
            "type" => "select",
			"options" => array ("Default" , "Left" , "Right" , "Justify" , "Center"),
            "std" => "Default"),

	array(	"name" => "Graphics Settings",
			"type" => "title"),	
	
    array(  "name" => "Caption Border",
			"desc" => "This setting changes the look of your captions. All images that are not inserted through captions will not be affected. ",
            "id" => $shortname."_caption",
            "type" => "select",
			"options" => array ("Light Gray" , "Gray" , "Bloody" , "Light Bloody" , "Paper" , "Black"),
            "std" => "Light Gray"),

	array(  "name" => "Hide Zombie Hand",
			"desc" => "Hide the zombie hand image in the right corner of the header.",
            "id" => $shortname."_hand",
            "type" => "checkbox",
            "std" => "false"),

	array(  "name" => "Hide blood splash",
			"desc" => "Hide the blood splash and claw marks in the background",
            "id" => $shortname."_splash",
            "type" => "checkbox",
            "std" => "false"),

	array(  "name" => "Hide blood dripping",
			"desc" => "Hide the blood drippings in the right top corner",
            "id" => $shortname."_drips",
            "type" => "checkbox",
            "std" => "false"),

	array(  "name" => "Hide bloody footer",
			"desc" => "Hide the bloody hand and the blood puddle in the footer area",
            "id" => $shortname."_puddle",
            "type" => "checkbox",
            "std" => "false"),

	array(  "name" => "Hide the bullets in the footer ",
			"desc" => "Hide the image with bulelts in the footer. ",
            "id" => $shortname."_info",
            "type" => "checkbox",
            "std" => "false"),

	array(  "name" => "Disable menu animation",
			"desc" => "Disable the drop down menu's animation effect",
            "id" => $shortname."_menu",
            "type" => "checkbox",
            "std" => "false"),
	
	array(  "name" => "Insert footer copyright",
			"desc" => "Insert custom text that will appear on the left side of the footer. Leave blank if that's not necessary.",
            "id" => $shortname."_copyright",
            "type" => "text",
            "std" => ""),
	
	
);


function mytheme_add_admin() {

global $themename, $shortname, $options;

                $optionvar = array();

    if ( isset($_GET['page']) && $_GET['page'] == basename(__FILE__) )  {

        if ( isset($_REQUEST['action']) && 'save' == $_REQUEST['action'] ) {

                foreach ($options as $value) {

                    update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

                foreach ($options as $value) {

                            if( isset( $_REQUEST[ $value['id'] ] ) ) {

                                                        $optionvar[$value['id']] = $_REQUEST[ $value['id']];

                                                } else {

                                                        $optionvar[$value['id']] = false;

                                                }

                                        }

                                update_option( $shortname."_options", $optionvar  );

                                header("Location: themes.php?page=functions.php&saved=true");

                die;


        } else if( isset($_REQUEST['action']) && 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {

                delete_option( $value['id'] ); }

 
            header("Location: themes.php?page=functions.php&reset=true");

            die;

        }

    }
 
    add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}
 

function mytheme_admin() {

    global $themename, $shortname, $options, $option_values;

    if ( isset($_REQUEST['saved']) &&  $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';

    if ( isset($_REQUEST['reset']) &&  $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';

?>

<style>
h3 {
margin:0;
padding-bottom:10px;
margin-top:20px;
font-family:Georgia,'Times New Roman',Times,serif;
clear:both;
display:block;
float:none;
color:#990022;
border-bottom:1px solid #CCC;
}

.div_option {
display:block;
float:none;
width:100%;
clear:both;
padding:5px;
border-bottom:1px solid #CCC;
overflow:hidden;
}

.div_option:hover {
background-color:#FEE;
}

.left_option {
display:block;
float:left;
width:20%;
padding-top:10px;
}
.right_option{
display:block;
float:left;
width:80%;
}

input[type="text"] , select {
border:1px solid #AAA !important;
border-radius:5px;
-moz-border-radius:5px;
}

 div.slider { width:450px; margin:10px 0; height:20px; position: relative;background:url(<?php bloginfo('template_directory') ?>/images/admin/slider_back.png) no-repeat center left; }
  div.slider div.handle { height:18px;width:18px; cursor:move; position: absolute;background:url(<?php bloginfo('template_directory') ?>/images/admin/slider_knob.png) no-repeat center left; margin-top:2px;}
	p.numbers {display:block;float:left;text-align:center;margin:0 auto;margin-top:-10px;}
	#side_value {float:right;}

.hideSlider { display:block;height:0px;padding:0px;overflow:hidden;}
.showSlider {display:block;height:auto;padding:5px;}
</style>

<div class="wrap">
<h2><?php echo $themename; ?> Theme settings</h2>
<form method="post">
<?php foreach ($options as $value) { 
    
	switch ( $value['type'] ) {
				
		case "title":
		?>	
        	<h3><?php echo $value['name']; ?></h3>
                       
		<?php break;

		case 'slider':
		?>
	
		<div class="div_option" id="slider_div" >
            	<div  class="left_option"><strong><?php echo $value['name']; ?></strong></div>
            
			<div class="right_option">
							<div id="zoom_slider" class="slider">
    								<div class="handle"></div>
									<div style="display:block;float:none;width:450px;">
  										<p id="cont_value" style="width:<?php if ( get_option( $value['id'] ) != "") { echo (get_option( $value['id'])/2 - 2); } else { echo $value['std']/2 -2; } ?>px;" class="numbers"><?php if ( get_option( $value['id'] ) != "") { echo get_option( $value['id'] ); } else { echo $value['std']; } ?>px</p>
  										<p id="side_value" style="width:<?php if ( get_option( $value['id'] ) != "") { echo (896 - get_option($value['id']))/2; } else { echo (896-$value['std'])/2; } ?>px;" class="numbers"><?php if ( get_option( $value['id'] ) != "") { echo 900-get_option($value['id'] ); } else { echo 900-$value['std']; } ?>px</p>
									</div>	
							</div>
			<input style="display:none;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if ( get_option( $value['id'] ) != "") { echo get_option( $value['id']); } else { echo $value['std']; } ?>" />
				  <div><small><?php echo $value['desc']; ?></small></div>
       		</div>
		</div>


		<?php 
		break;

		case 'text':
		?>
		
		<div class="div_option">
            	<div  class="left_option"><strong><?php echo $value['name']; ?></strong></div>
            
			<div class="right_option">
				<div> <input style="width:400px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo htmlentities(stripslashes(get_option( $value['id'] ))); } else { echo htmlentities(stripslashes($value['std'])); } ?>" /> </div>
           		 <div><small><?php echo $value['desc']; ?></small></div>
       		</div>
		</div>

		<?php 
		break;
		
		case 'textarea':
		?>

		<div class="div_option">
            	<div  class="left_option"><strong><?php echo $value['name']; ?></strong></div>
            
			<div class="right_option">
				 <div><textarea name="<?php echo $value['id']; ?>" style="width:400px; height:200px;" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo get_option( $value['id'] ); } else { echo $value['std']; } ?></textarea></div>
            	 <div><small><?php echo $value['desc']; ?></small></div>
       		</div>
		</div>        

		<?php 
		break;
		
		case 'select':
		?>
        <div class="div_option">
            	<div  class="left_option"><strong><?php echo $value['name']; ?></strong></div>
            
			<div class="right_option">

				<div><select <?php if($value['id']=='zmb_fontfamily') { ?> onchange="this.style.fontFamily=this.value;" <?php } ?><?php if($value['id']=='zmb_side') { ?> onchange="if (this.value == 'Disable') {document.getElementById('slider_div').className='hideSlider';} else if (this.value == 'Enable') document.getElementById('slider_div').className='showSlider';"<?php } ?> style="padding-left:5px;width:auto;<?php if($value['name']=='Select Font Type') { echo 'font-family:'.stripslashes( get_option($value['id']));} ?>	" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
						<?php foreach ($value['options'] as $option) { ?><option value="<?php echo $option ?>" <?php if (stripslashes( get_option($value['id'])) == stripslashes($option)) { echo ' selected="selected"'; } elseif ( !get_option( $value['id'] ) && $option == $value['std']) { echo ' selected="selected"'; };  ?><?php if($value['name']=='Select Font Type') {echo ' style="font-family:'.$option.';"';} echo '>'.$option; ?></option><?php } ?></select></div>         
       
           		 <div><small><?php echo $value['desc']; ?></small></div>
       		</div>
		</div>
		
		<?php
        break;
            
		case "checkbox":
		?>
         <div class="div_option">
            <div class="left_option"><strong><?php echo $value['name']; ?></strong></div>

                <div class="right_option">
						<div><?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = ""; } ?>
                        <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
                        
            			</div>
                        
            
                <div><small><?php echo $value['desc']; ?></small></div>
				</div>
           </div>
            
        <?php 		break;	
 
} 
}
?>
<!-- JS libraries for the slider-->
	<script> if (document.getElementById('zmb_side').value=='Disable') document.getElementById('slider_div').className="hideSlider"; </script>
<script src=" <?php bloginfo('url'); ?>/wp-includes/js/prototype.js"></script>
<script src=" <?php bloginfo('url'); ?>/wp-includes/js/scriptaculous/slider.js"></script>
<!-- slider script-->
<script type="text/javascript">
  (function() {
    var zoom_slider = $('zoom_slider'),
        cont = $('cont_value');
		side = $('side_value');
		sw = $('zmb_sidewidth');

    new Control.Slider(zoom_slider.down('.handle'), zoom_slider, {
    range: $R(0, 900),
    sliderValue: cont.innerHTML,
   	values :[500,510,520,530,540,550,560,570,580,590,600,610,620,630,640,650,660,670,680,690,700,710,720,730,740,750],

    onSlide: function(value) {   
		cont.innerHTML = value + " px";cont.style.width = (value/2 -2)+"px";
		side.innerHTML= (900 - value) + " px" ;side.style.width = (896-value)/2+"px";	
		sw.value = value;cont.style.width = (value/2 -2);
      },
      onChange: function(value) {       
		cont.innerHTML = value + " px";cont.style.width = (value/2 -2)+"px";
		side.innerHTML= (900 - value) + " px" ;side.style.width = (896-value)/2+"px";
		sw.value = value;cont.style.width = (value/2 -2);	
      }
    });  
  })();

</script>


<!-- end of options-->

<div class="submit" style="margin-left:50px;display:block;float:left;clear:left;">
<input name="save" type="submit" value="Save changes" />    
<input type="hidden" name="action" value="save" />
</div>
</form>
<form method="post">
<div class="submit" style="display:block;float:left;margin-left:50px;">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</div>
</form>

<div style="clear:both;">
<p> For more information about the Zombie Apocalypse theme, comments, issues or suggestions please visit <a target="_blank" href="http://www.flashrats.com" title="Zombie Apocalypse Wordpress Theme">the theme's homepage</a>.</p>
</div>

<?php
}

add_action('admin_menu', 'mytheme_add_admin'); 
?><?php
if ( function_exists('register_sidebar') )
	register_sidebar(array(
        'before_widget' => '<li id="%1$s" class="widget %2$s">',
        'after_widget' => '</li>',
        'before_title' => '',
        'after_title' => '',
    ));
?><?php
/**

 *
 * @package Cryout Creations
 * @subpackage Zombie Apocalypse
 * @since Zombie Apocalypse 0.5
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * Used to set the width of images and content. Should be equal to the width the theme
 * is designed for, generally via the style.css stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 640;

/** Tell WordPress to run zombie_setup() when the 'after_setup_theme' hook is run. */
add_action( 'after_setup_theme', 'zombie_setup' );

if ( ! function_exists( 'zombie_setup' ) ):
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *
 * To override zombie_setup() in a child theme, add your own zombie_setup to your child theme's
 * functions.php file.
 *
 * @uses add_theme_support() To add support for post thumbnails and automatic feed links.
 * @uses register_nav_menus() To add support for navigation menus.
 * @uses add_custom_background() To add support for a custom background.
 * @uses add_editor_style() To style the visual editor.
 * @uses load_theme_textdomain() For translation/localization support.
 * @uses add_custom_image_header() To add support for a custom header.
 * @uses register_default_headers() To register the default custom header images provided with the theme.
 * @uses set_post_thumbnail_size() To set a custom post thumbnail size.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_setup() {

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );

	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );

	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'zombie', TEMPLATEPATH . '/languages' );

	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'zombie' ),
	) );

	// This theme allows users to set a custom background
	add_custom_background();

	// Your changeable header business starts here
	define( 'HEADER_TEXTCOLOR', '' );
	// No CSS, just IMG call. The %s is a placeholder for the theme template directory URI.
	define( 'HEADER_IMAGE', '' );

	// The height and width of your custom header. You can hook into the theme's own filters to change these values.
	// Add a filter to zombie_header_image_width and zombie_header_image_height to change these values.
	define( 'HEADER_IMAGE_WIDTH', apply_filters( 'zombie_header_image_width', 700 ) );
	define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'zombie_header_image_height', 200 ) );

	// We'll be using post thumbnails for custom header images on posts and pages.
	// We want them to be 700 pixels wide by 200 pixels tall.
	// Larger images will be auto-cropped to fit, smaller ones will be ignored. See header.php.
	set_post_thumbnail_size( HEADER_IMAGE_WIDTH, HEADER_IMAGE_HEIGHT, true );

	// Don't support text inside the header image.
	define( 'NO_HEADER_TEXT', true );

	// Add a way for the custom header to be styled in the admin panel that controls
	// custom headers. See zombie_admin_header_style(), below.
	add_custom_image_header( '', 'zombie_admin_header_style' );

	// ... and thus ends the changeable header business.

	// Default custom headers packaged with the theme. %s is a placeholder for the theme template directory URI.
	register_default_headers( array(	
		'blood' => array(
			'url' => '%s/images/headers/blood.jpg',
			'thumbnail_url' => '%s/images/headers/blood-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'Zombie blood', 'Zombie Apocalypse' )
		),

		'red' => array(
			'url' => '%s/images/headers/red.jpg',
			'thumbnail_url' => '%s/images/headers/red-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'Zombie Red', 'Zombie Apocalypse' )
		),
	
		'door' => array(
			'url' => '%s/images/headers/door.jpg',
			'thumbnail_url' => '%s/images/headers/door-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'Zombie Door', 'Zombie Apocalypse' )
		)
	) );
}
endif;

if ( ! function_exists( 'zombie_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * Referenced via add_custom_image_header() in zombie_setup().
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_admin_header_style() {
?>
<style type="text/css">
/* Shows the same border as on front end */
#headimg {
	border-bottom: 1px solid #000;
	border-top: 4px solid #000;
}
/* If NO_HEADER_TEXT is false, you would style the text with these selectors:
	#headimg #name { }
	#headimg #desc { }
*/
</style>
<?php
}
endif;

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * To override this in a child theme, remove the filter and optionally add
 * your own function tied to the wp_page_menu_args filter hook.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'zombie_page_menu_args' );

/**
 * Sets the post excerpt length to 40 characters.
 *
 * To override this length in a child theme, remove the filter and add your own
 * function tied to the excerpt_length filter hook.
 *
 * @since Twenty Ten 1.0
 * @return int
 */
function zombie_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'zombie_excerpt_length' );

/**
 * Returns a "Continue Reading" link for excerpts
 *
 * @since Zombie Apocalypse 0.5
 * @return string "Continue Reading" link
 */
function zombie_continue_reading_link() {
	return ' <a href="'. get_permalink() . '">' . __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'zombie' ) . '</a>';
}

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with an ellipsis and zombie_continue_reading_link().
 *
 * To override this in a child theme, remove the filter and add your own
 * function tied to the excerpt_more filter hook.
 *
 * @since Zombie Apocalypse 0.5
 * @return string An ellipsis
 */
function zombie_auto_excerpt_more( $more ) {
	return ' &hellip;' . zombie_continue_reading_link();
}
add_filter( 'excerpt_more', 'zombie_auto_excerpt_more' );

/**
 * Adds a pretty "Continue Reading" link to custom post excerpts.
 *
 * To override this link in a child theme, remove the filter and add your own
 * function tied to the get_the_excerpt filter hook.
 *
 * @since Zombie Apocalypse 0.5
 * @return string Excerpt with a pretty "Continue Reading" link
 */
function zombie_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= zombie_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'zombie_custom_excerpt_more' );

/**
 * Remove inline styles printed when the gallery shortcode is used.
 *
 * Galleries are styled by the theme in Twenty Ten's style.css.
 *
 * @since Zombie Apocalypse 0.5
 * @return string The gallery style filter, with the styles themselves removed.
 */
function zombie_remove_gallery_css( $css ) {
	return preg_replace( "#<style type='text/css'>(.*?)</style>#s", '', $css );
}
add_filter( 'gallery_style', 'zombie_remove_gallery_css' );

if ( ! function_exists( 'zombie_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own zombie_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo get_avatar( $comment, 40 ); 
		?><?php printf( __( '%s <span class="says">says:</span>', 'zombie' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'zombie' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'zombie' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'zombie' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'zombie' ); ?><?php comment_author_link(); ?><?php edit_comment_link( __('(Edit)', 'zombie'), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif;

/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 * To override zombie_widgets_init() in a child theme, remove the action hook and add your own
 * function tied to the init hook.
 *
 * @since Zombie Apocalypse 0.5
 * @uses register_sidebar
 */
function zombie_widgets_init() {
	// Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => __( 'Primary Widget Area', 'zombie' ),
		'id' => 'primary-widget-area',
		'description' => __( 'The primary widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 2, located below the Primary Widget Area in the sidebar. Empty by default.
	register_sidebar( array(
		'name' => __( 'Secondary Widget Area', 'zombie' ),
		'id' => 'secondary-widget-area',
		'description' => __( 'The secondary widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 3, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'First Footer Widget Area', 'zombie' ),
		'id' => 'first-footer-widget-area',
		'description' => __( 'The first footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 4, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Second Footer Widget Area', 'zombie' ),
		'id' => 'second-footer-widget-area',
		'description' => __( 'The second footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 5, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Third Footer Widget Area', 'zombie' ),
		'id' => 'third-footer-widget-area',
		'description' => __( 'The third footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 6, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Fourth Footer Widget Area', 'zombie' ),
		'id' => 'fourth-footer-widget-area',
		'description' => __( 'The fourth footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
/** Register sidebars by running zombie_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'zombie_widgets_init' );

/**
 * Removes the default styles that are packaged with the Recent Comments widget.
 *
 * To override this in a child theme, remove the filter and optionally add your own
 * function tied to the widgets_init action hook.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_remove_recent_comments_style() {
	global $wp_widget_factory;
	remove_action( 'wp_head', array( $wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style' ) );
}
add_action( 'widgets_init', 'zombie_remove_recent_comments_style' );

if ( ! function_exists( 'zombie_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post—date/time and author.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_posted_on() {
	printf( __( '<span class="%1$s">Posted on</span> %2$s <span class="meta-sep">by</span> %3$s', 'zombie' ),
		'meta-prep meta-prep-author',
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date">%3$s</span></a>',
			get_permalink(),
			esc_attr( get_the_time() ),
			get_the_date()
		),
		sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
			get_author_posts_url( get_the_author_meta( 'ID' ) ),
			sprintf( esc_attr__( 'View all posts by %s', 'zombie' ), get_the_author() ),
			get_the_author()
		)
	);
}
endif;

if ( ! function_exists( 'zombie_posted_in' ) ) :
/**
 * Prints HTML with meta information for the current post (category, tags and permalink).
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_posted_in() {
	// Retrieves tag list of current post, separated by commas.
	$tag_list = get_the_tag_list( '', ', ' );
	if ( $tag_list ) {
		$posted_in = __( 'This entry was posted in %1$s and tagged %2$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'zombie' );
	} elseif ( is_object_in_taxonomy( get_post_type(), 'category' ) ) {
		$posted_in = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'zombie' );
	} else {
		$posted_in = __( 'Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'zombie' );
	}
	// Prints the string, replacing the placeholders.
	printf(
		$posted_in,
		get_the_category_list( ', ' ),
		$tag_list,
		get_permalink(),
		the_title_attribute( 'echo=0' )
	);
}
endif;