<?php

//  Hooks/Filters
add_action('admin_init', 'zombie_init_fn' );
add_action('admin_menu', 'zombie_add_page_fn');

add_action('init', 'slider_method');
function slider_method() {
	wp_enqueue_script("prototype");
	wp_enqueue_script("slider",home_url()."wp-includes/js/scriptaculous/slider.js",array('scriptaculous'));
}



// The settings
function zombie_init_fn(){
	wp_register_style( 'zombie',get_bloginfo('template_url') . '/zombie.css' );

	register_setting('za_options', 'za_options', 'za_options_validate' );
	add_settings_section('layout_section', 'Layout Settings', 'section_layout_fn', __FILE__);
	add_settings_section('text_section', 'Text Settings', 'section_text_fn', __FILE__);
	add_settings_section('graphics_section', 'Graphics Settings', 'section_graphics_fn', __FILE__);
	add_settings_section('post_section', 'Post Information Settings', 'section_post_fn', __FILE__);

	add_settings_field('zmb_side', 'Sidemenu Position', 'setting_side_fn', __FILE__, 'layout_section');
	add_settings_field('zmb_sidewidth', 'Content / Sidemenu Width', 'setting_sidewidth_fn', __FILE__, 'layout_section');
	add_settings_field('zmb_colpad', 'Select Padding between Columns', 'setting_colpad_fn', __FILE__, 'layout_section');

	add_settings_field('zmb_fontsize', 'Select Font Size', 'setting_fontsize_fn', __FILE__, 'text_section');
	add_settings_field('zmb_fontfamily', 'Select Font Type', 'setting_fontfamily_fn', __FILE__, 'text_section');
	add_settings_field('zmb_textalign', 'Force Text Align', 'setting_textalign_fn', __FILE__, 'text_section');
	add_settings_field('zmb_parindent', 'Paragraph indent', 'setting_parindent_fn', __FILE__, 'text_section');

	add_settings_field('zmb_caption', 'Caption Border', 'setting_caption_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_title', 'Title and Description', 'setting_title_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_hand', 'Zombie Hand', 'setting_hand_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_top', 'Header Background', 'setting_top_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_splash', 'Blood Splash', 'setting_splash_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_drips', 'Blood Dripping', 'setting_drips_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_puddle', 'Bloody Footer', 'setting_puddle_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_info', ' The Bullets in the Footer', 'setting_info_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_menu', 'The Menu Animation', 'setting_menu_fn', __FILE__, 'graphics_section');
	add_settings_field('zmb_copyright', 'Insert footer copyright', 'setting_copyright_fn', __FILE__, 'graphics_section');

	add_settings_field('zmb_postdate', 'Post Date', 'setting_postdate_fn', __FILE__, 'post_section');
	add_settings_field('zmb_posttime', 'Post Time', 'setting_posttime_fn', __FILE__, 'post_section');
	add_settings_field('zmb_postauthor', 'Post Author', 'setting_postauthor_fn', __FILE__, 'post_section');
	add_settings_field('zmb_postcateg', 'Post Category', 'setting_postcateg_fn', __FILE__, 'post_section');
	add_settings_field('zmb_postbook', 'Post Permalink', 'setting_postbook_fn', __FILE__, 'post_section');


}

// Adding the zombie subpage
function zombie_add_page_fn() {
$page = add_theme_page('Zombie Apocalypse Settings', 'Zombie Apocalypse Settings', 'administrator', 'zombie-page', 'zombie_page_fn');
	add_action( 'admin_print_styles-'.$page, 'zombie_admin_styles' );

}
function zombie_admin_styles() {

	wp_enqueue_style( 'zombie' );
}



// ************************************************************************************************************

// Callback functions

// General suboptions description

function  section_layout_fn() {
	echo "<p>Settings for adjusting your blog's layout .</p>";
}
function  section_text_fn() {
	echo '<p>All text realted customization options.</p>';
}

function  section_graphics_fn() {
	echo '<p>Settings for hiding or showinng different graphics.</p>';
}

function  section_post_fn() {
	echo '<p>Settings for hiding or showinng different post tags.</p>';
}

 //SELECT - Name: za_options[side]
function  setting_side_fn() {
$options = get_option('za_options');
	if (!isset($options['zmb_side'])) { $options['zmb_side'] ="Right";	}

$items = array("Left", "Right", "Disable");
echo "<select id='zmb_side' name='za_options[zmb_side]'>";
foreach($items as $item) {
	$selected = ($options['zmb_side']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
echo "</select>";

echo "<div><small>Select the side on which to display the sidebar or disable it altogether and have only one column for a presentation-like design.
			Disabling the sidemenu also disables the Content/Sidemenu Width option.</small></div>";

}



 //SLIDER - Name: za_options[sidewidth]
function setting_sidewidth_fn()
   {
   $options = get_option('za_options');
	if (!isset($options['zmb_sidewidth'])) { $options['zmb_sidewidth'] =650;
	 }

   ?>
   <div id="zoom_slider" class="slider">
   <div class="handle"></div>
   <div style="display:block;float:none;width:450px;">
   <p id="cont_value" style="width:<?php  echo ($options['zmb_sidewidth']/2 - 2);  ?>px;" class="numbers"><?php  echo $options['zmb_sidewidth'];  ?>px</p>
   <p id="side_value" style="width:<?php echo ((896 - $options['zmb_sidewidth'])/2); ?>px;" class="numbers"><?php echo (900-$options['zmb_sidewidth']);  ?>px</p>
   </div>
   </div>
   <?php echo  "<input   name='za_options[zmb_sidewidth]' id='zmb_sidewidth' type='hidden' value='".$options['zmb_sidewidth']."' />";?>

   <!-- JS libraries for the slider-->
	<script> if (document.getElementById('zmb_side').value=='Disable') document.getElementById('slider_div').className="hideSlider"; </script>
<!-- slider script-->
<script type="text/javascript">
  (function() {
    var zoom_slider = $('zoom_slider'),
        cont = $('cont_value');
		side = $('side_value');
		sw = $('zmb_sidewidth');

    new Control.Slider(zoom_slider.down('.handle'), zoom_slider, {
    range: $R(0, 900),
    sliderValue: cont.innerHTML,
   	values :[500,510,520,530,540,550,560,570,580,590,600,610,620,630,640,650,660,670,680,690,700,710,720,730,740,750],

    onSlide: function(value) {
		cont.innerHTML = value + " px";cont.style.width = (value/2 -2)+"px";
		side.innerHTML= (900 - value) + " px" ;side.style.width = (896-value)/2+"px";
		sw.value = value;cont.style.width = (value/2 -2);
      },
      onChange: function(value) {
		cont.innerHTML = value + " px";cont.style.width = (value/2 -2)+"px";
		side.innerHTML= (900 - value) + " px" ;side.style.width = (896-value)/2+"px";
		sw.value = value;cont.style.width = (value/2 -2);
      }
    });
  })();

</script>


   <?php
   echo "<div><small>Select the width of your content and sidemenu (Values range from 500px to 750px for the content, and from 150px to 400px for the sidemenu).</small></div>";

   }

 //SELECT - Name: za_options[colpad]
function  setting_colpad_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_colpad'])) { $options['zmb_colpad'] ="10px";	}

	$items =array ("0", "10px" , "15px" , "20px" , "25px", "30px");
	echo "<select id='zmb_colpad' name='za_options[zmb_colpad]'>";
foreach($items as $item) {
	$selected = ($options['zmb_colpad']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";

echo "<div><small>Select the padding between the content and the sidebar.</small></div>";

}

//SELECT - Name: za_options[fontsize]
function  setting_fontsize_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_fontsize'])) { $options['zmb_fontsize'] ="15px";	}
	$items =array ("12px", "13px" , "14px" , "15px" , "16px", "17px", "18px");
	echo "<select id='zmb_fontsize' name='za_options[zmb_fontsize]'>";
foreach($items as $item) {
	$selected = ($options['zmb_fontsize']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";

	echo "<div><small>Select the font size you'll use in your blog. Pages, posts and comments will be affected. Buttons, Headers and Side menus will remain the same.</small></div>";

}


//SELECT - Name: za_options[fontfamily]
function  setting_fontfamily_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_fontfamily'])) { $options['zmb_fontfamily'] ="Verdana, Geneva, sans-serif (Default)";	}
	$items = array("Verdana, Geneva, sans-serif (Default)" ,"\"Segoe UI\", Arial, sans-serif","Calibri, Arian, sans-serif","\"Myriad Pro\",Myriad,Arial, sans-serif", "Georgia, \"Times New Roman\", Times, serif" , "Tahoma, Geneva, sans-serif" , "\"Trebuchet MS\", Arial, Helvetica, sans-serif" , "\"Courier New\", Courier, monospace" , "\"Comic Sans MS\", cursive");
	echo "<select id='zmb_fontfamily' name='za_options[zmb_fontfamily]'>";
foreach($items as $item) {
	$selected = ( $options['zmb_fontfamily']==$item) ? 'selected="selected"' : '';
	echo "<option style='font-family:$item;' value='$item' $selected>$item</option>";
}
	echo "</select>";

	echo "<div><small>Select the font family you'll use in your blog. All text will be affected (including header text, menu buttons, side menu text etc.).</small></div>";

}

//SELECT - Name: za_options[textalign]
function  setting_textalign_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_textalign'])) { $options['zmb_textalign'] ="Default";	}
	$items = array ("Default" , "Left" , "Right" , "Justify" , "Center");
	echo "<select id='zmb_textalign' name='za_options[zmb_textalign]'>";
foreach($items as $item) {
	$selected = ($options['zmb_textalign']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";

	echo "<div><small>This overwrites the text alignment in posts and pages. Leave 'Default' for normal settings (alignment will remain as declared in posts, comments etc.).</small></div>";

}

//SELECT - Name: za_options[parindent]
function  setting_parindent_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_parindent'])) { $options['zmb_parindent'] ="10px";	}
	$items = array ("0px" , "5px" , "10px" , "15px" , "20px");
	echo "<select id='zmb_parindent' name='za_options[zmb_parindent]'>";
foreach($items as $item) {
	$selected = ($options['zmb_parindent']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";

	echo "<div><small>Choose the indent for your paragraphs.</small></div>";

}

//SELECT - Name: za_options[caption]
function  setting_caption_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_caption'])) { $options['zmb_caption'] ="Light Gray";	}
	$items = array ("Light Gray" , "Gray" , "Bloody" , "Light Bloody" , "Paper" , "Black");
	echo "<select id='zmb_caption' name='za_options[zmb_caption]'>";
foreach($items as $item) {
	$selected = ($options['zmb_caption']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";

	echo "<div><small>This setting changes the look of your captions. All images that are not inserted through captions will not be affected.</small></div>";

}

//CHECKBOX - Name: za_options[title]
function setting_title_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_caption'])) { $options['zmb_caption'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_title' name='za_options[zmb_title]'>";
foreach($items as $item) {
	$selected = ($options['zmb_title']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show your blog's Title and Description in the header (recommended if you have a custom header image with text).</small></div>";
}

//CHECKBOX - Name: za_options[hand]
function setting_hand_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_hand'])) { $options['zmb_hand'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_hand' name='za_options[zmb_hand]'>";
foreach($items as $item) {
	$selected = ($options['zmb_hand']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the zombie hand image in the right corner of the header. You'll most likely want to do this when you upload your own header image that will cover most of the hand.</small></div>";
}

//CHECKBOX - Name: za_options[top]
function setting_top_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_top'])) { $options['zmb_top'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_top' name='za_options[zmb_top]'>";
foreach($items as $item) {
	$selected = ($options['zmb_top']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the grunge background in the header.</small></div>";
}

//CHECKBOX - Name: za_options[splash]
function setting_splash_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_splash'])) { $options['zmb_splash'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_splash' name='za_options[zmb_splash]'>";
foreach($items as $item) {
	$selected = ($options['zmb_splash']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the blood splash and claw marks in the background.</small></div>";

}

//CHECKBOX - Name: za_options[drips]
function setting_drips_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_drips'])) { $options['zmb_drips'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_drips' name='za_options[zmb_drips]'>";
foreach($items as $item) {
	$selected = ($options['zmb_drips']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the blood drippings in the sidebar's top corner.</small></div>";
}

//CHECKBOX - Name: za_options[puddle]
function setting_puddle_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_puddle'])) { $options['zmb_puddle'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_puddle' name='za_options[zmb_puddle]'>";
foreach($items as $item) {
	$selected = ($options['zmb_puddle']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the bloody hand and the blood puddle in the footer area.</small></div>";
}

//CHECKBOX - Name: za_options[info]
function setting_info_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_info'])) { $options['zmb_info'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_info' name='za_options[zmb_info]'>";
foreach($items as $item) {
	$selected = ($options['zmb_info']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the image with bulelts in the footer.</small></div>";
}

//CHECKBOX - Name: za_options[menu]
function setting_menu_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_menu'])) { $options['zmb_menu'] ="Enable";	}
	$items = array ("Enable" , "Disable");
	echo "<select id='zmb_menu' name='za_options[zmb_menu]'>";
foreach($items as $item) {
	$selected = ($options['zmb_menu']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Disable or enable the drop down menu's animation effect.</small></div>";
}

// TEXTBOX - Name: za_options[copyright]
function setting_copyright_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_copyright'])) { $options['zmb_copyright'] ="";	}
	echo "<input id='zmb_copyright' name='za_options[zmb_copyright]' size='40' type='text' value='{$options['zmb_copyright']}' />";
	echo "<div><small>Insert custom text that will appear on the left side of the footer. Leave blank if that's not necessary.<br /> You can use HTML tags and any special characters like &copy or @.</small></div>";
}

//CHECKBOX - Name: za_options[postdate]
function setting_postdate_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_postdate'])) { $options['zmb_postdate'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_postdate' name='za_options[zmb_postdate]'>";
foreach($items as $item) {
	$selected = ($options['zmb_postdate']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the post date.</small></div>";
}

//CHECKBOX - Name: za_options[posttime]
function setting_posttime_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_posttime'])) { $options['zmb_posttime'] ="Hide";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_posttime' name='za_options[zmb_posttime]'>";
foreach($items as $item) {
	$selected = ($options['zmb_posttime']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Show the post time with the date. Time will not be visible if the Post Date is hidden.</small></div>";
}

//CHECKBOX - Name: za_options[postauthor]
function setting_postauthor_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_postauthor'])) { $options['zmb_postauthor'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_postauthor' name='za_options[zmb_postauthor]'>";
foreach($items as $item) {
	$selected = ($options['zmb_postauthor']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide or show the post author.</small></div>";
}

//CHECKBOX - Name: za_options[postcateg]
function setting_postcateg_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_postcateg'])) { $options['zmb_postcateg'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_postcateg' name='za_options[zmb_postcateg]'>";
foreach($items as $item) {
	$selected = ($options['zmb_postcateg']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide the post category (and tags if available).</small></div>";
}

//CHECKBOX - Name: za_options[postbook]
function setting_postbook_fn() {
	$options = get_option('za_options');
	if (!isset($options['zmb_postbook'])) { $options['zmb_postbook'] ="Show";	}
	$items = array ("Show" , "Hide");
	echo "<select id='zmb_postbook' name='za_options[zmb_postbook]'>";
foreach($items as $item) {
	$selected = ($options['zmb_postbook']==$item) ? 'selected="selected"' : '';
	echo "<option value='$item' $selected>$item</option>";
}
	echo "</select>";
	echo "<div><small>Hide the 'Bookmark permalink'.</small></div>";
}



// FOR FURTHER
// DROP-DOWN-BOX - Name: za_options[dropdown1]
function  setting_dropdown_fn() {
	$options = get_option('za_options');
	$items = array("Red", "Green", "Blue", "Orange", "White", "Violet", "Yellow");
	echo "<select id='drop_down1' name='za_options[dropdown1]'>";
	foreach($items as $item) {
		$selected = ($options['dropdown1']==$item) ? 'selected="selected"' : '';
		echo "<option value='$item' $selected>$item</option>";
	}
	echo "</select>";
}

// TEXTAREA - Name: za_options[text_area]
function setting_textarea_fn() {
	$options = get_option('za_options');
	echo "<textarea id='za_textarea_string' name='za_options[text_area]' rows='7' cols='50' type='textarea'>{$options['text_area']}</textarea>";
}

// TEXTBOX - Name: za_options[text_string]
function setting_string_fn() {
	$options = get_option('za_options');
	echo "<input id='za_text_string' name='za_options[text_string]' size='40' type='text' value='{$options['text_string']}' />";
}

// PASSWORD-TEXTBOX - Name: za_options[pass_string]
function setting_pass_fn() {
	$options = get_option('za_options');
	echo "<input id='za_text_pass' name='za_options[pass_string]' size='40' type='password' value='{$options['pass_string']}' />";
}

// CHECKBOX - Name: za_options[chkbox1]
function setting_chk1_fn() {
	$options = get_option('za_options'); $checked ="";
	if(isset($options['chkbox1'])&& $options['chkbox1']) { $checked = ' checked="checked" '; }
	echo "<input ".$checked." id='za_chk1' name='za_options[chkbox1]' type='checkbox' />";
}

// CHECKBOX - Name: za_options[chkbox2]
function setting_chk2_fn() {
	$options = get_option('za_options');$checked ="";
	if(isset($options['chkbox2'])&&$options['chkbox2']) { $checked = ' checked="checked" '; }
	echo "<input ".$checked." id='za_chk2' name='za_options[chkbox2]' type='checkbox' />";
}

// RADIO-BUTTON - Name: za_options[option_set1]
function setting_radio_fn() {
	$options = get_option('za_options');
	$items = array("Square", "Triangle", "Circle");
	foreach($items as $item) {
		$checked = ($options['option_set1']==$item) ? ' checked="checked" ' : '';
		echo "<label><input ".$checked." value='$item' name='za_options[option_set1]' type='radio' /> $item</label><br />";
	}
}


// Display the admin options page
function zombie_page_fn() {
?>
	<div class="wrap">
		<div class="icon32" id="icon-options-general"><br></div>
		<h2>My Example Options Page</h2>
		Some optional text here explaining the overall purpose of the options and what they relate to etc.
		<form action="options.php" method="post">
		<?php settings_fields('za_options'); ?>
		<?php do_settings_sections(__FILE__); ?>
		<p class="submit">
			<input name="Submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save Changes'); ?>" />
		</p>
		</form>

	</div>
<?php
}

// Validate user data
function za_options_validate($input) {
	// Check our textbox option field contains no HTML tags - if so strip them out
	$input['zmb_copyright'] =  wp_kses($input['zmb_copyright']);
	return $input; // return validated input

}


/**

 *
 * @package Cryout Creations
 * @subpackage Zombie Apocalypse
 * @since Zombie Apocalypse 0.5
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * Used to set the width of images and content. Should be equal to the width the theme
 * is designed for, generally via the style.css stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 640;

/** Tell WordPress to run zombie_setup() when the 'after_setup_theme' hook is run. */
add_action( 'after_setup_theme', 'zombie_setup' );

if ( ! function_exists( 'zombie_setup' ) ):
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *
 * To override zombie_setup() in a child theme, add your own zombie_setup to your child theme's
 * functions.php file.
 *
 * @uses add_theme_support() To add support for post thumbnails and automatic feed links.
 * @uses register_nav_menus() To add support for navigation menus.
 * @uses add_custom_background() To add support for a custom background.
 * @uses add_editor_style() To style the visual editor.
 * @uses load_theme_textdomain() For translation/localization support.
 * @uses add_custom_image_header() To add support for a custom header.
 * @uses register_default_headers() To register the default custom header images provided with the theme.
 * @uses set_post_thumbnail_size() To set a custom post thumbnail size.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_setup() {

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );

	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );

	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'zombie', TEMPLATEPATH . '/languages' );

	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'zombie' ),
	) );

	// This theme allows users to set a custom background
	add_custom_background();

	// Your changeable header business starts here
	define( 'HEADER_TEXTCOLOR', '' );
	// No CSS, just IMG call. The %s is a placeholder for the theme template directory URI.
	define( 'HEADER_IMAGE', '' );

	// The height and width of your custom header. You can hook into the theme's own filters to change these values.
	// Add a filter to zombie_header_image_width and zombie_header_image_height to change these values.
	define( 'HEADER_IMAGE_WIDTH', apply_filters( 'zombie_header_image_width', 900 ) );
	define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'zombie_header_image_height', 200 ) );

	// We'll be using post thumbnails for custom header images on posts and pages.
	// We want them to be 900 pixels wide by 200 pixels tall.
	// Larger images will be auto-cropped to fit, smaller ones will be ignored. See header.php.
	set_post_thumbnail_size( HEADER_IMAGE_WIDTH, HEADER_IMAGE_HEIGHT, true );

	// Don't support text inside the header image.
	define( 'NO_HEADER_TEXT', true );

	// Add a way for the custom header to be styled in the admin panel that controls
	// custom headers. See zombie_admin_header_style(), below.
	add_custom_image_header( '', 'zombie_admin_header_style' );

	// ... and thus ends the changeable header business.

	// Default custom headers packaged with the theme. %s is a placeholder for the theme template directory URI.
	register_default_headers( array(
		'blood' => array(
			'url' => '%s/images/headers/blood.jpg',
			'thumbnail_url' => '%s/images/headers/blood-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'Zombie blood', 'Zombie Apocalypse' )
		),

		'red' => array(
			'url' => '%s/images/headers/red.jpg',
			'thumbnail_url' => '%s/images/headers/red-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'Zombie Red', 'Zombie Apocalypse' )
		),

		'door' => array(
			'url' => '%s/images/headers/door.jpg',
			'thumbnail_url' => '%s/images/headers/door-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'Zombie Door', 'Zombie Apocalypse' )
		)
	) );
}
endif;

if ( ! function_exists( 'zombie_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * Referenced via add_custom_image_header() in zombie_setup().
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_admin_header_style() {
?>
<style type="text/css">
/* Shows the same border as on front end */
#headimg {
	border-bottom: 1px solid #000;
	border-top: 4px solid #000;
}
/* If NO_HEADER_TEXT is false, you would style the text with these selectors:
	#headimg #name { }
	#headimg #desc { }
*/
</style>
<?php
}
endif;

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * To override this in a child theme, remove the filter and optionally add
 * your own function tied to the wp_page_menu_args filter hook.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'zombie_page_menu_args' );

/**
 * Sets the post excerpt length to 40 characters.
 *
 * To override this length in a child theme, remove the filter and add your own
 * function tied to the excerpt_length filter hook.
 *
 * @since Twenty Ten 1.0
 * @return int
 */
function zombie_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'zombie_excerpt_length' );

/**
 * Returns a "Continue Reading" link for excerpts
 *
 * @since Zombie Apocalypse 0.5
 * @return string "Continue Reading" link
 */
function zombie_continue_reading_link() {
	return ' <a href="'. get_permalink() . '">' . __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'zombie' ) . '</a>';
}

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with an ellipsis and zombie_continue_reading_link().
 *
 * To override this in a child theme, remove the filter and add your own
 * function tied to the excerpt_more filter hook.
 *
 * @since Zombie Apocalypse 0.5
 * @return string An ellipsis
 */
function zombie_auto_excerpt_more( $more ) {
	return ' &hellip;' . zombie_continue_reading_link();
}
add_filter( 'excerpt_more', 'zombie_auto_excerpt_more' );

/**
 * Adds a pretty "Continue Reading" link to custom post excerpts.
 *
 * To override this link in a child theme, remove the filter and add your own
 * function tied to the get_the_excerpt filter hook.
 *
 * @since Zombie Apocalypse 0.5
 * @return string Excerpt with a pretty "Continue Reading" link
 */
function zombie_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= zombie_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'zombie_custom_excerpt_more' );

/**
 * Remove inline styles printed when the gallery shortcode is used.
 *
 * Galleries are styled by the theme in Twenty Ten's style.css.
 *
 * @since Zombie Apocalypse 0.5
 * @return string The gallery style filter, with the styles themselves removed.
 */
function zombie_remove_gallery_css( $css ) {
	return preg_replace( "#<style type='text/css'>(.*?)</style>#s", '', $css );
}
add_filter( 'gallery_style', 'zombie_remove_gallery_css' );

if ( ! function_exists( 'zombie_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own zombie_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo get_avatar( $comment, 40 );
		?><?php printf( __( '%s <span class="says">says:</span>', 'zombie' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'zombie' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'zombie' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'zombie' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'zombie' ); ?><?php comment_author_link(); ?><?php edit_comment_link( __('(Edit)', 'zombie'), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif;

/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 * To override zombie_widgets_init() in a child theme, remove the action hook and add your own
 * function tied to the init hook.
 *
 * @since Zombie Apocalypse 0.5
 * @uses register_sidebar
 */
function zombie_widgets_init() {
	// Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => __( 'Primary Widget Area', 'zombie' ),
		'id' => 'primary-widget-area',
		'description' => __( 'The primary widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 2, located below the Primary Widget Area in the sidebar. Empty by default.
	register_sidebar( array(
		'name' => __( 'Secondary Widget Area', 'zombie' ),
		'id' => 'secondary-widget-area',
		'description' => __( 'The secondary widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 3, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'First Footer Widget Area', 'zombie' ),
		'id' => 'first-footer-widget-area',
		'description' => __( 'The first footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 4, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Second Footer Widget Area', 'zombie' ),
		'id' => 'second-footer-widget-area',
		'description' => __( 'The second footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 5, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Third Footer Widget Area', 'zombie' ),
		'id' => 'third-footer-widget-area',
		'description' => __( 'The third footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 6, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Fourth Footer Widget Area', 'zombie' ),
		'id' => 'fourth-footer-widget-area',
		'description' => __( 'The fourth footer widget area', 'zombie' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
/** Register sidebars by running zombie_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'zombie_widgets_init' );

/**
 * Removes the default styles that are packaged with the Recent Comments widget.
 *
 * To override this in a child theme, remove the filter and optionally add your own
 * function tied to the widgets_init action hook.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_remove_recent_comments_style() {
	global $wp_widget_factory;
	remove_action( 'wp_head', array( $wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style' ) );
}
add_action( 'widgets_init', 'zombie_remove_recent_comments_style' );

if ( ! function_exists( 'zombie_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post—date/time and author.
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_posted_on() {
	printf( __( '<span class="%1$s">Posted </span><span class="onDate">on </span> %2$s <span class="meta-sep">by</span> %3$s', 'zombie' ),
		'meta-prep meta-prep-author',
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date">%3$s</span> <span class="entry-time"> at %2$s</span></a>',
			get_permalink(),
			esc_attr( get_the_time() ),
			get_the_date()
		),
		sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
			get_author_posts_url( get_the_author_meta( 'ID' ) ),
			sprintf( esc_attr__( 'View all posts by %s', 'zombie' ), get_the_author() ),
			get_the_author()
		)
	);
}
endif;

if ( ! function_exists( 'zombie_posted_in' ) ) :
/**
 * Prints HTML with meta information for the current post (category, tags and permalink).
 *
 * @since Zombie Apocalypse 0.5
 */
function zombie_posted_in() {
	// Retrieves tag list of current post, separated by commas.
	$tag_list = get_the_tag_list( '', ', ' );
	if ( $tag_list ) {
		$posted_in = __( '<span class="bl_posted"> This entry was posted in %1$s and tagged %2$s.</span><span class="bl_bookmark"> Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.</span>', 'zombie' );
	} elseif ( is_object_in_taxonomy( get_post_type(), 'category' ) ) {
		$posted_in = __( '<span class="bl_posted">This entry was posted in %1$s.</span> <span class="bl_bookmark">Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.</span>', 'zombie' );
	} else {
		$posted_in = __( '<span class="bl_bookmark">Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.</span>', 'zombie' );
	}
	// Prints the string, replacing the placeholders.
	printf(
		$posted_in,
		get_the_category_list( ', ' ),
		$tag_list,
		get_permalink(),
		the_title_attribute( 'echo=0' )
	);
}
endif;